/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.services.resourceadapters;

import jakarta.resource.spi.TransactionSupport;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jboss.as.connector.logging.ConnectorLogger;
import org.jboss.as.connector.metadata.common.SecurityImpl;
import org.jboss.as.connector.services.mdr.AS7MetadataRepository;
import org.jboss.as.connector.services.resourceadapters.ResourceAdapterActivatorService;
import org.jboss.as.connector.services.resourceadapters.deployment.registry.ResourceAdapterDeploymentRegistry;
import org.jboss.as.connector.subsystems.jca.JcaSubsystemConfiguration;
import org.jboss.as.connector.util.ConnectorServices;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.jca.common.api.metadata.Defaults;
import org.jboss.jca.common.api.metadata.common.Pool;
import org.jboss.jca.common.api.metadata.common.Security;
import org.jboss.jca.common.api.metadata.common.TransactionSupportEnum;
import org.jboss.jca.common.api.metadata.resourceadapter.Activation;
import org.jboss.jca.common.api.metadata.spec.ConnectionDefinition;
import org.jboss.jca.common.api.metadata.spec.Connector;
import org.jboss.jca.common.api.metadata.spec.ResourceAdapter;
import org.jboss.jca.common.metadata.common.PoolImpl;
import org.jboss.jca.common.metadata.common.XaPoolImpl;
import org.jboss.jca.common.metadata.resourceadapter.ActivationImpl;
import org.jboss.jca.common.metadata.resourceadapter.ConnectionDefinitionImpl;
import org.jboss.jca.core.api.connectionmanager.ccm.CachedConnectionManager;
import org.jboss.jca.core.api.management.ManagementRepository;
import org.jboss.jca.core.spi.rar.ResourceAdapterRepository;
import org.jboss.jca.core.spi.transaction.TransactionIntegration;
import org.jboss.modules.Module;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class DirectConnectionFactoryActivatorService
implements Service<ContextNames.BindInfo> {
    private static final ServiceName SECURITY_MANAGER_SERVICE = ServiceName.JBOSS.append(new String[]{"security", "simple-security-manager"});
    private static final ServiceName SUBJECT_FACTORY_SERVICE = ServiceName.JBOSS.append(new String[]{"security", "subject-factory"});
    public static final ServiceName SERVICE_NAME_BASE = ServiceName.JBOSS.append(new String[]{"connector"}).append(new String[]{"direct-connection-factory-activator"});
    protected final InjectedValue<AS7MetadataRepository> mdr = new InjectedValue();
    private final String jndiName;
    private final String interfaceName;
    private final String resourceAdapter;
    private final String raId;
    private final int maxPoolSize;
    private final int minPoolSize;
    private final Map<String, String> properties;
    private final TransactionSupport.TransactionSupportLevel transactionSupport;
    private final Module module;
    private final ContextNames.BindInfo bindInfo;

    public DirectConnectionFactoryActivatorService(String jndiName, String interfaceName, String resourceAdapter, String raId, int maxPoolSize, int minPoolSize, Map<String, String> properties, TransactionSupport.TransactionSupportLevel transactionSupport, Module module, ContextNames.BindInfo bindInfo) {
        this.jndiName = jndiName;
        this.interfaceName = interfaceName;
        this.resourceAdapter = resourceAdapter;
        this.raId = raId;
        this.maxPoolSize = maxPoolSize;
        this.minPoolSize = minPoolSize;
        this.properties = properties;
        if (transactionSupport == null) {
            transactionSupport = TransactionSupport.TransactionSupportLevel.NoTransaction;
        }
        this.transactionSupport = transactionSupport;
        this.module = module;
        this.bindInfo = bindInfo;
    }

    public ContextNames.BindInfo getValue() throws IllegalStateException, IllegalArgumentException {
        return this.bindInfo;
    }

    /*
     * WARNING - void declaration
     */
    public void start(StartContext context) throws StartException {
        ConnectorLogger.ROOT_LOGGER.debugf("started DirectConnectionFactoryActivatorService %s", context.getController().getName());
        String cfInterface = null;
        try {
            void var10_17;
            Connector cmd = ((AS7MetadataRepository)this.mdr.getValue()).getResourceAdapter(this.raId);
            ResourceAdapter ra = cmd.getResourceadapter();
            if (ra.getOutboundResourceadapter() != null) {
                for (ConnectionDefinition cd : ra.getOutboundResourceadapter().getConnectionDefinitions()) {
                    if (!cd.getConnectionFactoryInterface().getValue().equals(this.interfaceName)) continue;
                    cfInterface = cd.getConnectionFactoryInterface().getValue();
                }
            }
            if (cfInterface == null || !cfInterface.equals(this.interfaceName)) {
                throw ConnectorLogger.ROOT_LOGGER.invalidConnectionFactory(cfInterface, this.resourceAdapter, this.jndiName);
            }
            HashMap<String, String> raConfigProperties = new HashMap<String, String>();
            HashMap<String, String> mcfConfigProperties = new HashMap<String, String>();
            String securitySetting = null;
            String securitySettingDomain = null;
            if (this.properties != null) {
                for (Map.Entry<String, String> entry : this.properties.entrySet()) {
                    String key = entry.getKey();
                    String value = entry.getValue();
                    if (key.equals("ironjacamar.security")) {
                        securitySetting = value;
                        continue;
                    }
                    if (key.equals("ironjacamar.security.elytron-authentication-context")) {
                        securitySettingDomain = value;
                        continue;
                    }
                    if (key.equals("ironjacamar.security.domain")) {
                        throw new StartException(ConnectorLogger.SUBSYSTEM_RA_LOGGER.legacySecurityNotSupported());
                    }
                    if (key.startsWith("ra.")) {
                        raConfigProperties.put(key.substring(3), value);
                        continue;
                    }
                    if (key.startsWith("mcf.")) {
                        mcfConfigProperties.put(key.substring(4), value);
                        continue;
                    }
                    mcfConfigProperties.put(key, value);
                }
            }
            String mcfClass = null;
            if (ra.getOutboundResourceadapter() != null) {
                for (ConnectionDefinition cd : ra.getOutboundResourceadapter().getConnectionDefinitions()) {
                    if (!cd.getConnectionFactoryInterface().getValue().equals(cfInterface)) continue;
                    mcfClass = cd.getManagedConnectionFactoryClass().getValue();
                }
            }
            Object var10_14 = null;
            if (securitySetting != null) {
                if ("".equals(securitySetting) || "application".equals(securitySetting)) {
                    throw new StartException(ConnectorLogger.SUBSYSTEM_RA_LOGGER.legacySecurityNotSupported());
                }
                if ("domain".equals(securitySetting) && securitySettingDomain != null) {
                    SecurityImpl securityImpl = new SecurityImpl(securitySettingDomain, null, false);
                } else if ("domain-and-application".equals(securitySetting) && securitySettingDomain != null) {
                    SecurityImpl securityImpl = new SecurityImpl(null, securitySettingDomain, false);
                }
            }
            if (var10_17 == null) {
                ConnectorLogger.SUBSYSTEM_RA_LOGGER.noSecurityDefined(this.jndiName);
            }
            PoolImpl pool = null;
            Boolean isXA = Boolean.FALSE;
            if (this.transactionSupport == TransactionSupport.TransactionSupportLevel.XATransaction) {
                pool = new XaPoolImpl(Integer.valueOf(this.minPoolSize < 0 ? Defaults.MIN_POOL_SIZE : this.minPoolSize), Defaults.INITIAL_POOL_SIZE, Integer.valueOf(this.maxPoolSize < 0 ? Defaults.MAX_POOL_SIZE : this.maxPoolSize), Defaults.PREFILL, Defaults.USE_STRICT_MIN, Defaults.FLUSH_STRATEGY, null, Defaults.FAIR, Defaults.IS_SAME_RM_OVERRIDE, Defaults.INTERLEAVING, Defaults.PAD_XID, Defaults.WRAP_XA_RESOURCE, Defaults.NO_TX_SEPARATE_POOL);
                isXA = Boolean.TRUE;
            } else {
                pool = new PoolImpl(Integer.valueOf(this.minPoolSize < 0 ? Defaults.MIN_POOL_SIZE : this.minPoolSize), Defaults.INITIAL_POOL_SIZE, Integer.valueOf(this.maxPoolSize < 0 ? Defaults.MAX_POOL_SIZE : this.maxPoolSize), Defaults.PREFILL, Defaults.USE_STRICT_MIN, Defaults.FLUSH_STRATEGY, null, Defaults.FAIR);
            }
            TransactionSupportEnum transactionSupportValue = TransactionSupportEnum.NoTransaction;
            if (this.transactionSupport == TransactionSupport.TransactionSupportLevel.XATransaction) {
                transactionSupportValue = TransactionSupportEnum.XATransaction;
            } else if (this.transactionSupport == TransactionSupport.TransactionSupportLevel.LocalTransaction) {
                transactionSupportValue = TransactionSupportEnum.LocalTransaction;
            }
            ConnectionDefinitionImpl cd = new ConnectionDefinitionImpl(mcfConfigProperties, mcfClass, this.jndiName, this.poolName(cfInterface), Boolean.TRUE, Boolean.TRUE, Boolean.TRUE, Boolean.TRUE, Boolean.TRUE, Defaults.CONNECTABLE, Defaults.TRACKING, Defaults.MCP, Defaults.ENLISTMENT_TRACE, (Pool)pool, null, null, (Security)var10_17, null, isXA);
            ActivationImpl activation = new ActivationImpl(null, null, transactionSupportValue, Collections.singletonList(cd), Collections.emptyList(), raConfigProperties, Collections.emptyList(), null, null);
            String serviceName = this.jndiName;
            serviceName = serviceName.replace(':', '_');
            serviceName = serviceName.replace('/', '_');
            ResourceAdapterActivatorService activator = new ResourceAdapterActivatorService(cmd, (Activation)activation, (ClassLoader)this.module.getClassLoader(), serviceName);
            activator.setCreateBinderService(false);
            activator.setBindInfo(this.bindInfo);
            ServiceTarget serviceTarget = context.getChildTarget();
            ServiceName activatorServiceName = ConnectorServices.RESOURCE_ADAPTER_ACTIVATOR_SERVICE.append(new String[]{serviceName});
            ServiceBuilder connectionFactoryServiceBuilder = serviceTarget.addService(activatorServiceName, (Service)activator).addDependency(ConnectorServices.IRONJACAMAR_MDR, AS7MetadataRepository.class, activator.getMdrInjector()).addDependency(ConnectorServices.RA_REPOSITORY_SERVICE, ResourceAdapterRepository.class, activator.getRaRepositoryInjector()).addDependency(ConnectorServices.MANAGEMENT_REPOSITORY_SERVICE, ManagementRepository.class, activator.getManagementRepositoryInjector()).addDependency(ConnectorServices.RESOURCE_ADAPTER_REGISTRY_SERVICE, ResourceAdapterDeploymentRegistry.class, activator.getRegistryInjector()).addDependency(ConnectorServices.CONNECTOR_CONFIG_SERVICE, JcaSubsystemConfiguration.class, activator.getConfigInjector()).addDependency(ConnectorServices.CCM_SERVICE, CachedConnectionManager.class, activator.getCcmInjector()).addDependency(ConnectorServices.getCachedCapabilityServiceName("org.wildfly.jca.transaction-integration"), TransactionIntegration.class, activator.getTxIntegrationInjector());
            connectionFactoryServiceBuilder.requires(ConnectorServices.getCachedCapabilityServiceName("org.wildfly.naming"));
            connectionFactoryServiceBuilder.requires(ConnectorServices.getCachedCapabilityServiceName("org.wildfly.transactions.global-default-local-provider"));
            connectionFactoryServiceBuilder.requires(ConnectorServices.BOOTSTRAP_CONTEXT_SERVICE.append(new String[]{"default"}));
            connectionFactoryServiceBuilder.setInitialMode(ServiceController.Mode.ACTIVE).install();
        }
        catch (Exception e) {
            throw new StartException((Throwable)e);
        }
    }

    public Injector<AS7MetadataRepository> getMdrInjector() {
        return this.mdr;
    }

    public void stop(StopContext context) {
        ConnectorLogger.ROOT_LOGGER.debugf("stopped DirectConnectionFactoryActivatorService %s", context.getController().getName());
    }

    private String poolName(String cfInterface) {
        if (cfInterface.indexOf(".") != -1) {
            return cfInterface.substring(cfInterface.lastIndexOf(".") + 1);
        }
        return cfInterface;
    }
}

