/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.elytron.web.undertow.server;

import org.wildfly.common.Assert;

class UriPartialEncoder {
    UriPartialEncoder() {
    }

    static String partialEncode(String value, Component component) {
        Assert.checkNotNullParam((String)"value", (Object)value);
        Assert.checkNotNullParam((String)"component", (Object)((Object)component));
        StringBuilder sb = new StringBuilder();
        int length = value.length();
        for (int i = 0; i < length; ++i) {
            char c = value.charAt(i);
            if ((c != '%' || i >= length - 2 || !UriPartialEncoder.testPercentEncoded(value.substring(i, i + 3))) && !component.isAllowed(c) && UriPartialEncoder.percentEncode(c, sb)) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    private static boolean percentEncode(char current, StringBuilder destination) {
        if (!UriPartialEncoder.canEncode(current)) {
            return false;
        }
        destination.append('%');
        destination.append(Integer.toHexString(current).toUpperCase());
        return true;
    }

    private static boolean canEncode(char candidate) {
        return candidate <= '\u00ff';
    }

    private static boolean isUnreserved(char candidate) {
        if (candidate >= 'A' && candidate <= 'Z' || candidate >= 'a' && candidate <= 'z' || candidate >= '0' && candidate <= '9') {
            return true;
        }
        switch (candidate) {
            case '!': 
            case '\'': 
            case '(': 
            case ')': 
            case '*': 
            case '-': 
            case '.': 
            case '_': 
            case '~': {
                return true;
            }
        }
        return false;
    }

    private static boolean isPunct(char candidate) {
        switch (candidate) {
            case '$': 
            case '&': 
            case '+': 
            case ',': 
            case ':': 
            case ';': 
            case '=': {
                return true;
            }
        }
        return false;
    }

    private static boolean isReserved(char candidate) {
        if (UriPartialEncoder.isPunct(candidate)) {
            return true;
        }
        switch (candidate) {
            case '/': 
            case '?': 
            case '@': 
            case '[': 
            case ']': {
                return true;
            }
        }
        return false;
    }

    private static boolean isOther(char candidate) {
        return Character.isSpaceChar(candidate) && Character.isISOControl(candidate);
    }

    private static boolean isPathAllowed(char candidate) {
        return candidate == '/' || candidate == '@';
    }

    private static boolean pathIsAllowed(char candidate) {
        return (UriPartialEncoder.isUnreserved(candidate) || UriPartialEncoder.isPunct(candidate) || UriPartialEncoder.isPathAllowed(candidate)) && !UriPartialEncoder.isOther(candidate);
    }

    private static boolean queryIsAllowed(char candidate) {
        return (UriPartialEncoder.isUnreserved(candidate) || UriPartialEncoder.isReserved(candidate)) && !UriPartialEncoder.isOther(candidate);
    }

    private static boolean testPercentEncoded(String value) {
        if (value.length() == 3) {
            return UriPartialEncoder.isHex(value.charAt(1)) && UriPartialEncoder.isHex(value.charAt(2));
        }
        return false;
    }

    private static boolean isHex(char value) {
        return value >= '0' && value <= '9' || value >= 'A' && value <= 'F' || value >= 'a' && value <= 'f';
    }

    static interface CharPredicate {
        public boolean test(char var1);
    }

    static enum Component {
        PATH(x$0 -> UriPartialEncoder.access$100(x$0)),
        QUERY(x$0 -> UriPartialEncoder.access$000(x$0));

        private final CharPredicate predicate;

        private Component(CharPredicate predicate) {
            this.predicate = predicate;
        }

        boolean isAllowed(char candidate) {
            return this.predicate.test(candidate);
        }
    }
}

