/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.core.jar.runtime;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.jboss.as.controller.persistence.ConfigurationExtensionFactory;
import org.wildfly.core.jar.runtime.BootableEnvironment;
import org.wildfly.core.jar.runtime._private.BootableJarLogger;

final class Arguments {
    private Boolean isHelp;
    private Boolean isVersion;
    private final List<String> serverArguments = new ArrayList<String>();
    private final BootableEnvironment environment;
    private Path deployment;
    private Path cliScript;

    private Arguments(BootableEnvironment environment) {
        this.environment = environment;
    }

    static Arguments parseArguments(List<String> args, BootableEnvironment environment) throws Exception {
        Objects.requireNonNull(args);
        Arguments arguments = new Arguments(environment);
        arguments.handleArguments(args);
        return arguments;
    }

    private void handleArguments(List<String> args) throws Exception {
        HashMap<String, String> systemProperties = new HashMap<String, String>();
        Iterator<String> iter = args.iterator();
        while (iter.hasNext()) {
            String urlSpec;
            String a = iter.next();
            if (a.startsWith("--deployment")) {
                this.deployment = this.checkPath(Arguments.getValue(a));
                continue;
            }
            if (a.startsWith("-b")) {
                this.serverArguments.add(a);
                continue;
            }
            if ("--properties".equals(a)) {
                this.serverArguments.add(a);
                if (iter.hasNext()) {
                    urlSpec = iter.next();
                    this.serverArguments.add(urlSpec);
                    Arguments.addSystemProperties(Arguments.makeUrl(urlSpec), systemProperties);
                    continue;
                }
                throw BootableJarLogger.ROOT_LOGGER.invalidArgument(a);
            }
            if (a.startsWith("--properties")) {
                this.serverArguments.add(a);
                urlSpec = Arguments.parseValue(a, "--properties");
                Arguments.addSystemProperties(Arguments.makeUrl(urlSpec), systemProperties);
                continue;
            }
            if (a.startsWith("-S")) {
                this.serverArguments.add(a);
                continue;
            }
            if (a.startsWith("-D")) {
                this.serverArguments.add(a);
                Arguments.addSystemProperty(a, systemProperties);
                continue;
            }
            if (a.startsWith("--start-mode")) {
                this.serverArguments.add(a);
                continue;
            }
            if (a.startsWith("-u")) {
                this.serverArguments.add(a);
                continue;
            }
            if ("--version".equals(a)) {
                this.isVersion = true;
                this.serverArguments.add(a);
                continue;
            }
            if ("--help".equals(a)) {
                this.isHelp = true;
                continue;
            }
            if (a.startsWith("--cli-script")) {
                this.cliScript = Paths.get(Arguments.getValue(a), new String[0]);
                if (Files.exists(this.cliScript, new LinkOption[0]) && Files.isReadable(this.cliScript)) continue;
                throw new Exception("File doesn't exist or is not readable: " + this.cliScript);
            }
            if (ConfigurationExtensionFactory.isConfigurationExtensionSupported() && ConfigurationExtensionFactory.commandLineContainsArgument((String)a)) {
                this.serverArguments.add(a);
                continue;
            }
            if (a.startsWith("--stability")) {
                this.serverArguments.add(a);
                continue;
            }
            throw BootableJarLogger.ROOT_LOGGER.unknownArgument(a);
        }
        this.environment.setSystemProperties(systemProperties);
    }

    private Path checkPath(String path) {
        Path filePath = Paths.get(path, new String[0]);
        if (!Files.exists(filePath, new LinkOption[0])) {
            throw BootableJarLogger.ROOT_LOGGER.notExistingFile(path);
        }
        return filePath;
    }

    private static String getValue(String arg) {
        int sep = arg.indexOf("=");
        if (sep == -1 || sep == arg.length() - 1) {
            throw BootableJarLogger.ROOT_LOGGER.invalidArgument(arg);
        }
        return arg.substring(sep + 1);
    }

    public Boolean isHelp() {
        return this.isHelp == null ? false : this.isHelp;
    }

    public Boolean isVersion() {
        return this.isVersion == null ? false : this.isVersion;
    }

    public List<String> getServerArguments() {
        return Collections.unmodifiableList(this.serverArguments);
    }

    public Path getDeployment() {
        return this.deployment;
    }

    public Path getCLIScript() {
        return this.cliScript;
    }

    private static void addSystemProperty(String arg, Map<String, String> properties) {
        String key;
        int i = arg.indexOf(61);
        if (i > 2) {
            key = arg.substring(2, i);
        } else if (i == -1 && arg.length() > 2) {
            key = arg.substring(2);
        } else {
            throw BootableJarLogger.ROOT_LOGGER.invalidArgument(arg);
        }
        String value = i == -1 || i + 1 == arg.length() ? "" : arg.substring(i + 1);
        properties.put(key, value);
    }

    private static void addSystemProperties(URL url, Map<String, String> properties) throws IOException {
        Properties parsed = new Properties();
        try (InputStream in = url.openConnection().getInputStream();){
            parsed.load(in);
        }
        for (String key : parsed.stringPropertyNames()) {
            properties.put(key, parsed.getProperty(key));
        }
    }

    private static String parseValue(String arg, String key) {
        int splitPos = key.length();
        if (arg.length() <= splitPos + 1 || arg.charAt(splitPos) != '=') {
            throw BootableJarLogger.ROOT_LOGGER.invalidArgument(arg);
        }
        String value = arg.substring(splitPos + 1);
        return value;
    }

    private static URL makeUrl(String urlSpec) throws MalformedURLException {
        URL url;
        String trimmed = urlSpec.trim();
        try {
            url = new URL(trimmed);
            if ("file".equals(url.getProtocol())) {
                url = Paths.get(url.toURI()).toRealPath(new LinkOption[0]).toUri().toURL();
            }
        }
        catch (Exception e) {
            try {
                url = Paths.get(trimmed, new String[0]).toRealPath(new LinkOption[0]).toUri().toURL();
            }
            catch (Exception n) {
                throw new MalformedURLException(n.toString());
            }
        }
        return url;
    }
}

