/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.core.launcher;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.wildfly.core.launcher.CommandBuilder;
import org.wildfly.core.launcher.Environment;

public class Launcher {
    private final CommandBuilder builder;
    private boolean redirectErrorStream;
    private ProcessBuilder.Redirect outputDestination;
    private ProcessBuilder.Redirect errorDestination;
    private File workingDirectory;
    private final Map<String, String> env;

    public Launcher(CommandBuilder builder) {
        this.builder = builder;
        this.redirectErrorStream = false;
        this.outputDestination = null;
        this.errorDestination = null;
        this.env = new HashMap<String, String>();
    }

    public static Launcher of(CommandBuilder builder) {
        return new Launcher(builder);
    }

    public Launcher inherit() {
        this.outputDestination = ProcessBuilder.Redirect.INHERIT;
        this.errorDestination = ProcessBuilder.Redirect.INHERIT;
        return this;
    }

    public Launcher setRedirectErrorStream(boolean redirectErrorStream) {
        this.redirectErrorStream = redirectErrorStream;
        return this;
    }

    public Launcher redirectOutput(File file) {
        this.outputDestination = ProcessBuilder.Redirect.to(file);
        return this;
    }

    public Launcher redirectOutput(Path path) {
        return this.redirectOutput(path.toFile());
    }

    public Launcher redirectOutput(ProcessBuilder.Redirect destination) {
        this.outputDestination = destination;
        return this;
    }

    public Launcher redirectError(File file) {
        this.errorDestination = ProcessBuilder.Redirect.to(file);
        return this;
    }

    public Launcher redirectError(ProcessBuilder.Redirect destination) {
        this.errorDestination = destination;
        return this;
    }

    public Launcher setDirectory(Path path) {
        this.workingDirectory = path.toFile();
        return this;
    }

    public Launcher setDirectory(File dir) {
        this.workingDirectory = dir;
        return this;
    }

    public Launcher setDirectory(String dir) {
        return this.setDirectory(Environment.validateAndNormalizeDir(dir, true));
    }

    public Launcher addEnvironmentVariable(String key, String value) {
        if (key != null && value != null) {
            this.env.put(key, value);
        }
        return this;
    }

    public Launcher addEnvironmentVariables(Map<String, String> env) {
        env.forEach((key, value) -> {
            if (key != null && value != null) {
                this.addEnvironmentVariable((String)key, (String)value);
            }
        });
        return this;
    }

    public Process launch() throws IOException {
        ProcessBuilder processBuilder = new ProcessBuilder(this.builder.build());
        if (this.outputDestination != null) {
            processBuilder.redirectOutput(this.outputDestination);
        }
        if (this.errorDestination != null) {
            processBuilder.redirectError(this.errorDestination);
        }
        if (this.workingDirectory != null) {
            processBuilder.directory(this.workingDirectory);
        }
        if (!this.env.isEmpty()) {
            processBuilder.environment().putAll(this.env);
        }
        processBuilder.redirectErrorStream(this.redirectErrorStream);
        return processBuilder.start();
    }
}

