/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.projection.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Optional;
import java.util.Set;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonArrayAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonObjectAccessor;
import org.hibernate.search.backend.elasticsearch.search.common.impl.AbstractElasticsearchValueFieldSearchQueryElementFactory;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexScope;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexValueFieldContext;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexValueFieldTypeContext;
import org.hibernate.search.backend.elasticsearch.search.highlighter.impl.ElasticsearchSearchHighlighter;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchSearchProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ProjectionExtractContext;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ProjectionRequestContext;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ProjectionTransformContext;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.engine.search.highlighter.spi.SearchHighlighterType;
import org.hibernate.search.engine.search.loading.spi.LoadingResult;
import org.hibernate.search.engine.search.loading.spi.ProjectionHitMapper;
import org.hibernate.search.engine.search.projection.SearchProjection;
import org.hibernate.search.engine.search.projection.dsl.spi.HighlightProjectionBuilder;
import org.hibernate.search.engine.search.projection.spi.ProjectionAccumulator;

public class ElasticsearchFieldHighlightProjection<T>
implements ElasticsearchSearchProjection<T> {
    private static final JsonObjectAccessor REQUEST_HIGHLIGHT_FIELDS_ACCESSOR = JsonAccessor.root().property("highlight").asObject().property("fields").asObject();
    private final Set<String> indexNames;
    private final String absoluteFieldPath;
    private final String[] absoluteFieldPathComponents;
    private final String highlighterName;
    private final ElasticsearchSearchIndexValueFieldTypeContext<?> typeContext;
    private final ProjectionAccumulator.Provider<String, T> accumulatorProvider;

    private ElasticsearchFieldHighlightProjection(Builder builder, ProjectionAccumulator.Provider<String, T> accumulatorProvider) {
        this(builder.scope, builder.field, builder.highlighterName(), accumulatorProvider);
    }

    private ElasticsearchFieldHighlightProjection(ElasticsearchSearchIndexScope<?> scope, ElasticsearchSearchIndexValueFieldContext<?> field, String highlighterName, ProjectionAccumulator.Provider<String, T> accumulatorProvider) {
        this.indexNames = scope.hibernateSearchIndexNames();
        this.absoluteFieldPath = field.absolutePath();
        this.absoluteFieldPathComponents = field.absolutePathComponents();
        this.highlighterName = highlighterName;
        this.typeContext = field.type();
        this.accumulatorProvider = accumulatorProvider;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[absoluteFieldPath=" + this.absoluteFieldPath + "highlighterName=" + this.highlighterName + "]";
    }

    @Override
    public Set<String> indexNames() {
        return this.indexNames;
    }

    @Override
    public ElasticsearchSearchProjection.Extractor<?, T> request(JsonObject requestBody, ProjectionRequestContext context) {
        if (context.absoluteCurrentFieldPath() != null) {
            throw log.cannotHighlightInNestedContext(context.absoluteCurrentFieldPath(), EventContexts.fromIndexFieldAbsolutePath((String)this.absoluteFieldPath));
        }
        ProjectionRequestContext innerContext = context.forField(this.absoluteFieldPath, this.absoluteFieldPathComponents);
        ElasticsearchSearchHighlighter highlighter = context.root().highlighter(this.highlighterName);
        SearchHighlighterType highlighterType = highlighter.type();
        if (highlighterType == null) {
            ElasticsearchSearchHighlighter queryHighlighter = context.root().queryHighlighter();
            highlighterType = queryHighlighter != null ? queryHighlighter.type() : null;
            SearchHighlighterType searchHighlighterType = highlighterType = highlighterType == null ? SearchHighlighterType.UNIFIED : highlighterType;
        }
        if (!this.typeContext.highlighterTypeSupported(highlighterType)) {
            throw log.highlighterTypeNotSupported(highlighterType, this.absoluteFieldPath);
        }
        if (!context.root().isCompatibleHighlighter(this.highlighterName, this.accumulatorProvider)) {
            throw log.highlighterIncompatibleCardinality();
        }
        highlighter.applyToField(this.absoluteFieldPath, REQUEST_HIGHLIGHT_FIELDS_ACCESSOR.getOrCreate(requestBody, JsonObject::new));
        return new FieldHighlightExtractor(innerContext.absoluteCurrentFieldPath(), this.accumulatorProvider.get());
    }

    public static class Builder
    extends HighlightProjectionBuilder {
        private final ElasticsearchSearchIndexScope<?> scope;
        private final ElasticsearchSearchIndexValueFieldContext<?> field;

        public Builder(ElasticsearchSearchIndexScope<?> scope, ElasticsearchSearchIndexValueFieldContext<?> field) {
            super(field.absolutePath());
            this.scope = scope;
            this.field = field;
        }

        protected String highlighterName() {
            return this.highlighterName;
        }

        public <V> SearchProjection<V> build(ProjectionAccumulator.Provider<String, V> accumulatorProvider) {
            return new ElasticsearchFieldHighlightProjection<V>(this, accumulatorProvider);
        }
    }

    private class FieldHighlightExtractor<A>
    implements ElasticsearchSearchProjection.Extractor<A, T> {
        private final JsonArrayAccessor highlightAccessor;
        private final ProjectionAccumulator<String, String, A, T> accumulator;

        private FieldHighlightExtractor(String fieldPath, ProjectionAccumulator<String, String, A, T> accumulator) {
            this.highlightAccessor = JsonAccessor.root().property("highlight").property(fieldPath).asArray();
            this.accumulator = accumulator;
        }

        @Override
        public A extract(ProjectionHitMapper<?> projectionHitMapper, JsonObject hit, JsonObject source, ProjectionExtractContext context) {
            Object initial = this.accumulator.createInitial();
            Optional highlights = this.highlightAccessor.get(hit);
            if (highlights.isPresent()) {
                for (JsonElement element : (JsonArray)highlights.get()) {
                    initial = this.accumulator.accumulate(initial, (Object)element.getAsString());
                }
            }
            return (A)initial;
        }

        @Override
        public T transform(LoadingResult<?> loadingResult, A extractedData, ProjectionTransformContext context) {
            return this.accumulator.finish(extractedData);
        }
    }

    public static class Factory<F>
    extends AbstractElasticsearchValueFieldSearchQueryElementFactory<HighlightProjectionBuilder, F> {
        @Override
        public HighlightProjectionBuilder create(ElasticsearchSearchIndexScope<?> scope, ElasticsearchSearchIndexValueFieldContext<F> field) {
            if (field.nestedDocumentPath() != null) {
                throw ElasticsearchSearchProjection.log.cannotHighlightFieldFromNestedObjectStructure(EventContexts.fromIndexFieldAbsolutePath((String)field.absolutePath()));
            }
            return new Builder(scope, field);
        }
    }
}

