/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.jgroups;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.OptionalInt;
import org.jboss.marshalling.Externalizer;
import org.jgroups.Address;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.UUID;
import org.jgroups.util.Util;
import org.wildfly.clustering.marshalling.Serializer;
import org.wildfly.clustering.marshalling.jboss.ExternalizerProvider;
import org.wildfly.clustering.marshalling.jboss.SerializerExternalizer;

public enum AddressSerializer implements Serializer<Address>
{
    INSTANCE;


    public Address read(DataInput input) throws IOException {
        try {
            return Util.readAddress((DataInput)input);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    public void write(DataOutput output, Address address) throws IOException {
        Util.writeAddress((Address)address, (DataOutput)output);
    }

    public OptionalInt size(Address address) {
        return OptionalInt.of(Util.size((Address)address));
    }

    public static class IpAddressExternalizerProvider
    extends AddressExternalizerProvider<IpAddress> {
        public IpAddressExternalizerProvider() {
            super(IpAddress.class);
        }
    }

    public static class UUIDExternalizerProvider
    extends AddressExternalizerProvider<UUID> {
        public UUIDExternalizerProvider() {
            super(UUID.class);
        }
    }

    static class AddressExternalizerProvider<A extends Address>
    implements ExternalizerProvider {
        private static final Externalizer EXTERNALIZER = new SerializerExternalizer((Serializer)INSTANCE);
        private final Class<?> type;

        AddressExternalizerProvider(Class<A> type) {
            this.type = type;
        }

        public Class<?> getType() {
            return this.type;
        }

        public Externalizer getExternalizer() {
            return EXTERNALIZER;
        }
    }
}

