/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.adapter.jms.util;

import jakarta.transaction.TransactionSynchronizationRegistry;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class TransactionUtils {
    private static final String TRANSACTION_SYNCHRONIZATION_REGISTRY_LOOKUP = "java:comp/TransactionSynchronizationRegistry";
    private static volatile transient TransactionSynchronizationRegistry transactionSynchronizationRegistry;

    public static boolean isInTransaction() {
        TransactionSynchronizationRegistry tsr = TransactionUtils.getTransactionSynchronizationRegistry();
        boolean inTx = tsr.getTransactionStatus() == 0;
        return inTx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static TransactionSynchronizationRegistry getTransactionSynchronizationRegistry() {
        TransactionSynchronizationRegistry cachedTSR = transactionSynchronizationRegistry;
        if (cachedTSR != null) return cachedTSR;
        Class<TransactionUtils> clazz = TransactionUtils.class;
        synchronized (TransactionUtils.class) {
            cachedTSR = transactionSynchronizationRegistry;
            if (cachedTSR != null) return cachedTSR;
            transactionSynchronizationRegistry = cachedTSR = (TransactionSynchronizationRegistry)TransactionUtils.lookup(TRANSACTION_SYNCHRONIZATION_REGISTRY_LOOKUP);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return cachedTSR;
        }
    }

    private static Object lookup(String name) {
        InitialContext ctx = null;
        try {
            ctx = new InitialContext();
            Object object = ctx.lookup(name);
            return object;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException namingException) {}
            }
        }
    }
}

