/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.tests.integration.amqp.AmqpClientTestSupport;
import org.apache.activemq.transport.amqp.client.AmqpClient;
import org.apache.activemq.transport.amqp.client.AmqpConnection;
import org.apache.activemq.transport.amqp.client.AmqpMessage;
import org.apache.activemq.transport.amqp.client.AmqpReceiver;
import org.apache.activemq.transport.amqp.client.AmqpSession;
import org.apache.qpid.proton.message.Message;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class AmqpReceiverDispositionRejectAsUnmodifiedModeTests
extends AmqpClientTestSupport {
    @Override
    protected void configureAMQPAcceptorParameters(Map<String, Object> params) {
        params.put("amqpTreatRejectAsUnmodifiedDeliveryFailed", true);
    }

    @Test
    @Timeout(value=30L)
    public void testRejectedDisposition() throws Exception {
        this.sendMessages(this.getQueueName(), 1);
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpReceiver receiver1 = session.createReceiver(this.getQueueName());
        receiver1.flow(1);
        AmqpMessage message = receiver1.receive(5L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)message, (String)"did not receive message first time");
        Assertions.assertEquals((Object)"MessageID:0", (Object)message.getMessageId());
        Message protonMessage = message.getWrappedMessage();
        Assertions.assertNotNull((Object)protonMessage);
        Assertions.assertEquals((long)0L, (long)protonMessage.getDeliveryCount(), (String)"Unexpected initial value for AMQP delivery-count");
        message.reject();
        receiver1.flow(1);
        message = receiver1.receive(5L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)message, (String)"did not receive message after reject");
        Assertions.assertEquals((Object)"MessageID:0", (Object)message.getMessageId());
        protonMessage = message.getWrappedMessage();
        Assertions.assertNotNull((Object)protonMessage);
        Assertions.assertEquals((long)1L, (long)protonMessage.getDeliveryCount(), (String)"Unexpected value for AMQP delivery-count after redelivery");
        connection.close();
    }
}

