/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp.connect;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.CoreAddressConfiguration;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPBrokerConnectConfiguration;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPBrokerConnectionAddressType;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPBrokerConnectionElement;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.tests.integration.amqp.AmqpClientTestSupport;
import org.apache.activemq.artemis.tests.util.CFUtil;
import org.apache.activemq.artemis.utils.Wait;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AMQPBridgeTest
extends AmqpClientTestSupport {
    protected static final int AMQP_PORT_2 = 5673;
    ActiveMQServer server_2;

    @Override
    protected ActiveMQServer createServer() throws Exception {
        return this.createServer(5672, false);
    }

    @Test
    public void testsSimpleConnect() throws Exception {
        this.server.start();
        this.server_2 = this.createServer(5673, false);
        AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration("test", "tcp://localhost:5672");
        this.server_2.getConfiguration().addAMQPConnection(amqpConnection);
        this.server_2.start();
    }

    @Test
    public void testSimpleTransferPush() throws Exception {
        this.internalTransferPush("TEST", false, false);
    }

    @Test
    public void testSimpleTransferPushRestartBC() throws Exception {
        this.internalTransferPush("TEST", false, true);
    }

    @Test
    public void testSimpleTransferPushDeferredCreation() throws Exception {
        this.internalTransferPush("TEST", true, false);
    }

    @Test
    public void testSimpleTransferPushDeferredCreationRestartBC() throws Exception {
        this.internalTransferPush("TEST", true, true);
    }

    public void internalTransferPush(String queueName, boolean deferCreation, boolean restartBC) throws Exception {
        this.server.setIdentity("targetServer");
        this.server.start();
        this.server.addAddressInfo(new AddressInfo(SimpleString.of((String)queueName), RoutingType.ANYCAST));
        this.server.createQueue(QueueConfiguration.of((String)queueName).setRoutingType(RoutingType.ANYCAST));
        this.server_2 = this.createServer(5673, false);
        AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration("test", "tcp://localhost:5672");
        amqpConnection.addElement(new AMQPBrokerConnectionElement().setMatchAddress(queueName).setType(AMQPBrokerConnectionAddressType.SENDER));
        this.server_2.getConfiguration().addAMQPConnection(amqpConnection);
        if (!deferCreation) {
            this.server_2.getConfiguration().addAddressConfiguration(new CoreAddressConfiguration().setName(queueName).addRoutingType(RoutingType.ANYCAST));
            this.server_2.getConfiguration().addQueueConfiguration(QueueConfiguration.of((String)queueName).setRoutingType(RoutingType.ANYCAST));
        }
        this.server_2.setIdentity("serverWithBridge");
        this.server_2.start();
        Wait.assertTrue(() -> ((ActiveMQServer)this.server_2).isStarted());
        if (deferCreation) {
            this.server_2.addAddressInfo(new AddressInfo(queueName).addRoutingType(RoutingType.ANYCAST));
            this.server_2.createQueue(QueueConfiguration.of((String)queueName).setRoutingType(RoutingType.ANYCAST));
        }
        if (restartBC) {
            this.server_2.stopBrokerConnection("test");
            Thread.sleep(1000L);
            this.server_2.startBrokerConnection("test");
        }
        ConnectionFactory factory = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5673");
        Connection connection = factory.createConnection();
        Session session = connection.createSession(false, 1);
        MessageProducer producer = session.createProducer((Destination)session.createQueue(queueName));
        producer.setDeliveryMode(2);
        String largeMessageBody = null;
        for (int i = 0; i < 30; ++i) {
            if (i == 0) {
                StringBuffer buffer = new StringBuffer();
                for (int s = 0; s < 10024; ++s) {
                    buffer.append("*******************************************************************************************************************************");
                }
                largeMessageBody = buffer.toString();
                TextMessage message = session.createTextMessage(buffer.toString());
                producer.send((Message)message);
                continue;
            }
            producer.send(session.createMessage());
        }
        Queue testQueueOnServer2 = this.server_2.locateQueue(queueName);
        Assertions.assertNotNull((Object)testQueueOnServer2);
        Wait.assertEquals((long)0L, () -> ((Queue)testQueueOnServer2).getMessageCount());
        ConnectionFactory factory2 = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5672");
        Connection connection2 = factory2.createConnection();
        Session session2 = connection2.createSession(false, 1);
        connection2.start();
        MessageConsumer consumer = session2.createConsumer((Destination)session2.createQueue(queueName));
        for (int i = 0; i < 30; ++i) {
            Message message = consumer.receive(5000L);
            if (!(message instanceof TextMessage)) continue;
            if (message instanceof TextMessage) {
                Assertions.assertEquals((Object)largeMessageBody, (Object)((TextMessage)message).getText());
                continue;
            }
            System.out.println("i = " + i);
        }
        Assertions.assertNull((Object)consumer.receiveNoWait());
    }

    @Test
    public void testSimpleTransferPull() throws Exception {
        this.internaltestSimpleTransferPull(false);
    }

    @Test
    public void testSimpleTransferPullSecurity() throws Exception {
        this.internaltestSimpleTransferPull(true);
    }

    public void internaltestSimpleTransferPull(boolean security) throws Exception {
        this.server.setIdentity("targetServer");
        if (security) {
            this.enableSecurity(this.server, "#");
        }
        this.server.start();
        this.server.addAddressInfo(new AddressInfo(SimpleString.of((String)"TEST"), RoutingType.ANYCAST));
        this.server.createQueue(QueueConfiguration.of((String)"TEST").setRoutingType(RoutingType.ANYCAST));
        this.server_2 = this.createServer(5673, false);
        AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration("test", "tcp://localhost:5672").setRetryInterval(10);
        if (security) {
            amqpConnection.setUser(this.fullUser).setPassword("wrongPassword");
        }
        amqpConnection.addElement(new AMQPBrokerConnectionElement().setMatchAddress("TEST").setType(AMQPBrokerConnectionAddressType.RECEIVER));
        this.server_2.getConfiguration().addAMQPConnection(amqpConnection);
        this.server_2.getConfiguration().addAddressConfiguration(new CoreAddressConfiguration().setName("TEST").addRoutingType(RoutingType.ANYCAST));
        this.server_2.getConfiguration().addQueueConfiguration(QueueConfiguration.of((String)"TEST").setRoutingType(RoutingType.ANYCAST));
        this.server_2.setIdentity("serverWithBridge");
        this.server_2.start();
        Wait.assertTrue(() -> ((ActiveMQServer)this.server_2).isStarted());
        ConnectionFactory factory = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5672");
        Connection connection = factory.createConnection(this.fullUser, this.fullPass);
        Session session = connection.createSession(false, 1);
        MessageProducer producer = session.createProducer((Destination)session.createQueue("TEST"));
        producer.setDeliveryMode(2);
        String largeMessageBody = null;
        for (int i = 0; i < 30; ++i) {
            if (i == 0) {
                StringBuffer buffer = new StringBuffer();
                for (int s = 0; s < 10024; ++s) {
                    buffer.append("*******************************************************************************************************************************");
                }
                largeMessageBody = buffer.toString();
                TextMessage message = session.createTextMessage(buffer.toString());
                producer.send((Message)message);
                continue;
            }
            producer.send(session.createMessage());
        }
        ConnectionFactory factory2 = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5673");
        Connection connection2 = factory2.createConnection();
        Session session2 = connection2.createSession(false, 1);
        connection2.start();
        MessageConsumer consumer = session2.createConsumer((Destination)session2.createQueue("TEST"));
        if (security) {
            Thread.sleep(500L);
            Assertions.assertNull((Object)consumer.receiveNoWait());
            amqpConnection.setUser(this.fullUser).setPassword(this.fullPass);
        }
        for (int i = 0; i < 30; ++i) {
            Message message = consumer.receive(5000L);
            if (!(message instanceof TextMessage)) continue;
            if (message instanceof TextMessage) {
                Assertions.assertEquals((Object)largeMessageBody, (Object)((TextMessage)message).getText());
                continue;
            }
            System.out.println("i = " + i);
        }
        Assertions.assertNull((Object)consumer.receiveNoWait());
    }
}

