/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.jms.multiprotocol;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.tests.integration.jms.multiprotocol.MultiprotocolJMSClientTestSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class JMSConsumerDelayDispatchTest
extends MultiprotocolJMSClientTestSupport {
    private SimpleString queueName = SimpleString.of((String)"jms.consumer.delay.queue");
    private SimpleString normalQueueName = SimpleString.of((String)"jms.normal.queue");
    private static final long DELAY_BEFORE_DISPATCH = 2000L;

    @Override
    protected void createAddressAndQueues(ActiveMQServer server) throws Exception {
        super.createAddressAndQueues(server);
        server.createQueue(QueueConfiguration.of((SimpleString)this.queueName).setRoutingType(RoutingType.ANYCAST).setExclusive(Boolean.valueOf(true)).setConsumersBeforeDispatch(Integer.valueOf(2)).setDelayBeforeDispatch(Long.valueOf(2000L)));
        server.createQueue(QueueConfiguration.of((SimpleString)this.normalQueueName).setRoutingType(RoutingType.ANYCAST).setExclusive(Boolean.valueOf(true)));
    }

    @Test
    public void testNoDelayOnDefaultAMQP() throws Exception {
        this.testNoDelayOnDefault(this.AMQPConnection);
    }

    @Test
    public void testNoDelayOnDefaultOpenWire() throws Exception {
        this.testNoDelayOnDefault(this.OpenWireConnection);
    }

    @Test
    public void testNoDelayOnDefaultCore() throws Exception {
        this.testNoDelayOnDefault(this.CoreConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testNoDelayOnDefault(MultiprotocolJMSClientTestSupport.ConnectionSupplier supplier) throws Exception {
        this.sendMessage(this.normalQueueName, supplier);
        try (Connection connection = supplier.createConnection();){
            Session session = connection.createSession(false, 2);
            connection.start();
            Queue queue = session.createQueue(this.normalQueueName.toString());
            MessageConsumer consumer = session.createConsumer((Destination)queue);
            Assertions.assertNotNull((Object)consumer.receive(1000L));
        }
    }

    @Test
    public void testDelayBeforeDispatchAMQP() throws Exception {
        this.testDelayBeforeDispatch(this.AMQPConnection);
    }

    @Test
    public void testDelayBeforeDispatchOpenWire() throws Exception {
        this.testDelayBeforeDispatch(this.OpenWireConnection);
    }

    @Test
    public void testDelayBeforeDispatchCore() throws Exception {
        this.testDelayBeforeDispatch(this.CoreConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testDelayBeforeDispatch(MultiprotocolJMSClientTestSupport.ConnectionSupplier supplier) throws Exception {
        this.sendMessage(this.queueName, supplier);
        try (Connection connection = supplier.createConnection();){
            Session session = connection.createSession(false, 2);
            connection.start();
            Queue queue = session.createQueue(this.queueName.toString());
            MessageConsumer consumer = session.createConsumer((Destination)queue);
            Assertions.assertNull((Object)consumer.receiveNoWait());
            Thread.sleep(2000L);
            Assertions.assertNotNull((Object)consumer.receive(2000L));
        }
    }

    @Test
    public void testConsumersBeforeDispatchAMQP() throws Exception {
        this.testConsumersBeforeDispatch(this.AMQPConnection);
    }

    @Test
    public void testConsumersBeforeDispatchOpenWire() throws Exception {
        this.testConsumersBeforeDispatch(this.OpenWireConnection);
    }

    @Test
    public void testConsumersBeforeDispatchCore() throws Exception {
        this.testConsumersBeforeDispatch(this.CoreConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testConsumersBeforeDispatch(MultiprotocolJMSClientTestSupport.ConnectionSupplier supplier) throws Exception {
        this.sendMessage(this.queueName, supplier);
        try (Connection connection = supplier.createConnection();){
            Session session = connection.createSession(false, 2);
            connection.start();
            Queue queue = session.createQueue(this.queueName.toString());
            MessageConsumer consumer1 = session.createConsumer((Destination)queue);
            Assertions.assertNull((Object)consumer1.receiveNoWait());
            MessageConsumer consumer2 = session.createConsumer((Destination)queue);
            Assertions.assertTrue((consumer1.receive(1000L) != null || consumer2.receive(1000L) != null ? 1 : 0) != 0);
        }
    }

    @Test
    public void testContinueAndResetConsumerAMQP() throws Exception {
        this.testContinueAndResetConsumer(this.AMQPConnection);
    }

    @Test
    public void testContinueAndResetConsumerOpenWire() throws Exception {
        this.testContinueAndResetConsumer(this.OpenWireConnection);
    }

    @Test
    public void testContinueAndResetConsumerCore() throws Exception {
        this.testContinueAndResetConsumer(this.CoreConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testContinueAndResetConsumer(MultiprotocolJMSClientTestSupport.ConnectionSupplier supplier) throws Exception {
        this.sendMessage(this.queueName, supplier);
        try (Connection connection = supplier.createConnection();){
            Session session = connection.createSession(false, 2);
            connection.start();
            Queue queue = session.createQueue(this.queueName.toString());
            MessageConsumer consumer1 = session.createConsumer((Destination)queue);
            Assertions.assertNull((Object)consumer1.receiveNoWait());
            MessageConsumer consumer2 = session.createConsumer((Destination)queue);
            Assertions.assertTrue((consumer1.receive(1000L) != null || consumer2.receive(1000L) != null ? 1 : 0) != 0);
            consumer2.close();
            this.sendMessage(this.queueName, supplier);
            Assertions.assertNotNull((Object)consumer1.receiveNoWait());
            consumer1.close();
            session.close();
            session = connection.createSession(false, 2);
            this.sendMessage(this.queueName, supplier);
            MessageConsumer consumer3 = session.createConsumer((Destination)queue);
            Assertions.assertNull((Object)consumer3.receiveNoWait());
            MessageConsumer consumer4 = session.createConsumer((Destination)queue);
            Assertions.assertTrue((consumer3.receive(1000L) != null || consumer4.receive(1000L) != null ? 1 : 0) != 0);
            consumer3.close();
            consumer4.close();
            session.close();
            session = connection.createSession(false, 2);
            this.sendMessage(this.queueName, supplier);
            MessageConsumer consumer5 = session.createConsumer((Destination)queue);
            Assertions.assertNull((Object)consumer5.receiveNoWait());
            Thread.sleep(2000L);
            Assertions.assertNotNull((Object)consumer5.receive(2000L));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(SimpleString queue, MultiprotocolJMSClientTestSupport.ConnectionSupplier supplier) throws Exception {
        try (Connection connection = supplier.createConnection();){
            Session session = connection.createSession(false, 2);
            connection.start();
            Queue destination = session.createQueue(queue.toString());
            MessageProducer producer = session.createProducer((Destination)destination);
            TextMessage message = session.createTextMessage();
            message.setText("Message");
            producer.send((Message)message);
        }
    }
}

