/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.jms.server;

import jakarta.jms.Queue;
import jakarta.jms.Topic;
import javax.naming.Context;
import org.apache.activemq.artemis.api.core.BroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.DiscoveryGroupConfiguration;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.UDPBroadcastEndpointFactory;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.registry.JndiBindingRegistry;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyConnectorFactory;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.jms.server.JMSServerManager;
import org.apache.activemq.artemis.jms.server.impl.JMSServerManagerImpl;
import org.apache.activemq.artemis.spi.core.naming.BindingRegistry;
import org.apache.activemq.artemis.tests.unit.util.InVMNamingContext;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class JMSServerDeployerTest
extends ActiveMQTestBase {
    private JMSServerManager jmsServer;
    private Context context;
    private Configuration config;

    @Test
    public void testDeployUnusualQueueNames() throws Exception {
        this.doTestDeployQueuesWithUnusualNames("/myqueue", "queue.with.dots.in.name");
        this.doTestDeployQueuesWithUnusualNames("/myqueue2", "queue with spaces in name");
        this.doTestDeployQueuesWithUnusualNames("/myqueue3", "queue/with/slashes/in/name");
        this.doTestDeployQueuesWithUnusualNames("/myqueue4", "queue\\with\\backslashes\\in\\name");
        this.doTestDeployQueuesWithUnusualNames("/myqueue5", "queue with # chars and * chars in name");
    }

    @Test
    public void testDeployUnusualTopicNames() throws Exception {
        this.doTestDeployTopicsWithUnusualNames("/mytopic", "topic.with.dots.in.name");
        this.doTestDeployTopicsWithUnusualNames("/mytopic2", "topic with spaces in name");
        this.doTestDeployTopicsWithUnusualNames("/mytopic3", "topic/with/slashes/in/name");
        this.doTestDeployTopicsWithUnusualNames("/mytopic4", "topic\\with\\backslashes\\in\\name");
        this.doTestDeployTopicsWithUnusualNames("/mytopic5", "topic with # chars and * chars in name");
        this.doTestDeployTopicsWithUnusualNames("/mytopic6", "myTopic", "jms.topic.myTopic");
    }

    private void doTestDeployQueuesWithUnusualNames(String queueName, String jndiName) throws Exception {
        this.jmsServer.createQueue(false, queueName, null, false, new String[]{jndiName});
        Queue queue = (Queue)this.context.lookup(jndiName);
        Assertions.assertNotNull((Object)queue);
        Assertions.assertEquals((Object)queueName, (Object)queue.getQueueName());
    }

    private void doTestDeployTopicsWithUnusualNames(String topicName, String jndiName) throws Exception {
        this.jmsServer.createTopic(false, topicName, new String[]{jndiName});
        Topic topic = (Topic)this.context.lookup(jndiName);
        Assertions.assertNotNull((Object)topic);
        Assertions.assertEquals((Object)topicName, (Object)topic.getTopicName());
    }

    private void doTestDeployTopicsWithUnusualNames(String topicName, String jndiName, String jmsTopicName) throws Exception {
        this.jmsServer.createTopic(topicName, false, jmsTopicName, new String[]{jndiName});
        Topic topic = (Topic)this.context.lookup(jndiName);
        Assertions.assertNotNull((Object)topic);
        Assertions.assertEquals((Object)jmsTopicName, (Object)topic.getTopicName());
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        DiscoveryGroupConfiguration dcg = new DiscoveryGroupConfiguration().setName("mygroup").setRefreshTimeout(5432L).setDiscoveryInitialWaitTimeout(5432L).setBroadcastEndpointFactory((BroadcastEndpointFactory)new UDPBroadcastEndpointFactory().setGroupAddress(JMSServerDeployerTest.getUDPDiscoveryAddress()).setGroupPort(JMSServerDeployerTest.getUDPDiscoveryPort()).setLocalBindAddress("172.16.8.10"));
        this.config = this.createBasicConfig().addConnectorConfiguration("netty", new TransportConfiguration(NettyConnectorFactory.class.getName())).addDiscoveryGroupConfiguration("mygroup", dcg);
        ActiveMQServer server = this.createServer(false, this.config);
        this.jmsServer = new JMSServerManagerImpl(server);
        this.context = new InVMNamingContext();
        this.jmsServer.setRegistry((BindingRegistry)new JndiBindingRegistry(this.context));
        this.jmsServer.start();
    }
}

