/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.mqtt5.spec;

import java.util.EnumSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.tests.integration.mqtt5.MQTT5TestSupport;
import org.eclipse.paho.mqttv5.client.MqttCallback;
import org.eclipse.paho.mqttv5.client.MqttClient;
import org.eclipse.paho.mqttv5.common.MqttMessage;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class TopicNameAndFilterTests
extends MQTT5TestSupport {
    @Test
    @Timeout(value=60L)
    public void testMatchingHash() throws Exception {
        this.testMatchingWildcard("#");
    }

    @Test
    @Timeout(value=60L)
    public void testMatchingPlus() throws Exception {
        this.testMatchingWildcard("+");
    }

    private void testMatchingWildcard(String wildcard) throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        MqttClient consumer = this.createPahoClient("consumer");
        consumer.connect();
        consumer.setCallback((MqttCallback)new MQTT5TestSupport.DefaultMqttCallback(){

            @Override
            public void messageArrived(String incomingTopic, MqttMessage message) throws Exception {
                latch.countDown();
            }
        });
        consumer.subscribe(wildcard, 0);
        SimpleString DOLLAR_TOPIC = SimpleString.of((String)"$foo");
        ServerLocator locator = ActiveMQClient.createServerLocator((String)"vm://0");
        ClientSessionFactory csf = locator.createSessionFactory();
        ClientSession s = csf.createSession();
        s.createAddress(DOLLAR_TOPIC, EnumSet.allOf(RoutingType.class), false);
        s.createProducer(DOLLAR_TOPIC).send((Message)s.createMessage(true));
        Assertions.assertFalse((boolean)latch.await(2L, TimeUnit.SECONDS));
    }
}

