/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.mqtt5.spec.controlpackets;

import io.netty.handler.codec.mqtt.MqttConnAckVariableHeader;
import io.netty.handler.codec.mqtt.MqttMessageType;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.activemq.artemis.api.core.BaseInterceptor;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTInterceptor;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTUtil;
import org.apache.activemq.artemis.core.remoting.server.impl.RemotingServiceImpl;
import org.apache.activemq.artemis.spi.core.protocol.ConnectionEntry;
import org.apache.activemq.artemis.tests.integration.mqtt5.MQTT5TestSupport;
import org.apache.activemq.artemis.tests.util.RandomUtil;
import org.apache.activemq.artemis.utils.Wait;
import org.eclipse.paho.mqttv5.client.IMqttToken;
import org.eclipse.paho.mqttv5.client.MqttCallback;
import org.eclipse.paho.mqttv5.client.MqttClient;
import org.eclipse.paho.mqttv5.client.MqttConnectionOptions;
import org.eclipse.paho.mqttv5.client.MqttConnectionOptionsBuilder;
import org.eclipse.paho.mqttv5.client.MqttDisconnectResponse;
import org.eclipse.paho.mqttv5.common.MqttException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class ConnAckTests
extends MQTT5TestSupport {
    @Test
    @Timeout(value=60L)
    public void testEmptyClientID() throws Exception {
        Assertions.assertEquals((int)0, (int)this.getSessionStates().size());
        MqttClient client = this.createPahoClient("");
        IMqttToken result = client.connectWithResult(null);
        Assertions.assertFalse((boolean)result.getSessionPresent());
        String assignedClientID = result.getResponseProperties().getAssignedClientIdentifier();
        Assertions.assertNotNull((Object)assignedClientID);
        Assertions.assertEquals((int)1, (int)this.getSessionStates().size());
        Assertions.assertNotNull((Object)this.getSessionStates().get(assignedClientID));
        client.disconnect();
    }

    @Test
    @Timeout(value=60L)
    public void testConnackWhenCleanStartFalse() throws Exception {
        String CONSUMER_ID = RandomUtil.randomString();
        Assertions.assertEquals((int)0, (int)this.getSessionStates().size());
        MqttClient consumer = this.createPahoClient(CONSUMER_ID);
        MqttConnectionOptions options = new MqttConnectionOptionsBuilder().cleanStart(false).sessionExpiryInterval(Long.valueOf(MQTTUtil.FOUR_BYTE_INT_MAX)).build();
        IMqttToken result = consumer.connectWithResult(options);
        Assertions.assertFalse((boolean)result.getSessionPresent());
        Assertions.assertTrue((boolean)this.getListOfCodes(result.getResponse().getReasonCodes()).contains(0));
        consumer.disconnect();
        Assertions.assertEquals((int)1, (int)this.getSessionStates().size());
        Assertions.assertNotNull((Object)this.getSessionStates().get(CONSUMER_ID));
        result = consumer.connectWithResult(options);
        Assertions.assertTrue((boolean)result.getSessionPresent());
        Assertions.assertTrue((boolean)this.getListOfCodes(result.getResponse().getReasonCodes()).contains(0));
    }

    @Test
    @Timeout(value=60L)
    public void testConnackWhenCleanStartTrue() throws Exception {
        String CONSUMER_ID = RandomUtil.randomString();
        Assertions.assertEquals((int)0, (int)this.getSessionStates().size());
        MqttClient consumer = this.createPahoClient(CONSUMER_ID);
        MqttConnectionOptions options = new MqttConnectionOptionsBuilder().cleanStart(true).build();
        IMqttToken result = consumer.connectWithResult(options);
        Assertions.assertFalse((boolean)result.getSessionPresent());
        Assertions.assertTrue((boolean)this.getListOfCodes(result.getResponse().getReasonCodes()).contains(0));
        consumer.disconnect();
    }

    @Test
    @Timeout(value=60L)
    public void testCleanStartFalseWithAbsentSessionExpiryInterval() throws Exception {
        String CONSUMER_ID = RandomUtil.randomString();
        String TOPIC = this.getTopicName();
        MqttClient consumer = this.createPahoClient(CONSUMER_ID);
        MqttConnectionOptions options = new MqttConnectionOptionsBuilder().cleanStart(false).build();
        consumer.connect(options);
        consumer.subscribe(TOPIC, 2);
        consumer.disconnect();
        Assertions.assertEquals((int)0, (int)this.getSessionStates().size());
        Assertions.assertNull((Object)this.getSessionStates().get(CONSUMER_ID));
    }

    @Test
    @Timeout(value=60L)
    public void testCleanStartFalseWithMaxSessionExpiryInterval() throws Exception {
        String CONSUMER_ID = RandomUtil.randomString();
        String TOPIC = this.getTopicName();
        long EXPIRY_INTERVAL = 2000L;
        MqttClient consumer = this.createPahoClient(CONSUMER_ID);
        MqttConnectionOptions options = new MqttConnectionOptionsBuilder().cleanStart(false).sessionExpiryInterval(Long.valueOf(MQTTUtil.FOUR_BYTE_INT_MAX)).build();
        consumer.connect(options);
        consumer.subscribe(TOPIC, 2);
        consumer.disconnect();
        Assertions.assertFalse((boolean)Wait.waitFor(() -> this.getSessionStates().size() == 0, (long)4000L, (long)100L));
        Assertions.assertNotNull((Object)this.getSessionStates().get(CONSUMER_ID));
    }

    @Test
    @Timeout(value=60L)
    public void testConnackSentFirst() throws Exception {
        String CONSUMER_ID = RandomUtil.randomString();
        CountDownLatch latch = new CountDownLatch(1);
        AtomicBoolean failed = new AtomicBoolean(false);
        MQTTInterceptor outgoingInterceptor = (packet, connection) -> {
            if (packet.fixedHeader().messageType() == MqttMessageType.CONNACK) {
                latch.countDown();
            } else {
                failed.set(true);
            }
            return true;
        };
        this.server.getRemotingService().addOutgoingInterceptor((BaseInterceptor)outgoingInterceptor);
        MqttClient consumer = this.createPahoClient(CONSUMER_ID);
        consumer.connect();
        Assertions.assertTrue((boolean)latch.await(2L, TimeUnit.SECONDS));
        Assertions.assertFalse((boolean)failed.get());
        consumer.disconnect();
    }

    @Test
    @Timeout(value=60L)
    public void testSessionPresentWithNonZeroConnackReasonCode() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        MQTTInterceptor outgoingInterceptor = (packet, connection) -> {
            if (packet.fixedHeader().messageType() == MqttMessageType.CONNACK) {
                Assertions.assertFalse((boolean)((MqttConnAckVariableHeader)packet.variableHeader()).isSessionPresent());
                latch.countDown();
            }
            return true;
        };
        this.server.getRemotingService().addOutgoingInterceptor((BaseInterceptor)outgoingInterceptor);
        Assertions.assertEquals((int)0, (int)this.getSessionStates().size());
        MqttClient client = this.createPahoClient("");
        MqttConnectionOptions options = new MqttConnectionOptionsBuilder().cleanStart(false).build();
        try {
            client.connect(options);
            Assertions.fail((String)"Should throw exception about invalid client identifier");
        }
        catch (MqttException e) {
            Assertions.assertEquals((byte)-123, (byte)((byte)e.getReasonCode()));
        }
        Assertions.assertFalse((boolean)client.isConnected());
        Assertions.assertEquals((int)0, (int)this.getSessionStates().size());
    }

    @Test
    @Timeout(value=60L)
    public void testConnackReasonCode() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        MQTTInterceptor outgoingInterceptor = (packet, connection) -> {
            if (packet.fixedHeader().messageType() == MqttMessageType.CONNACK) {
                Assertions.assertNotNull((Object)((MqttConnAckVariableHeader)packet.variableHeader()).connectReturnCode());
                latch.countDown();
            }
            return true;
        };
        this.server.getRemotingService().addOutgoingInterceptor((BaseInterceptor)outgoingInterceptor);
        MqttClient client = this.createPahoClient(RandomUtil.randomString());
        client.connect();
        Assertions.assertTrue((boolean)latch.await(2L, TimeUnit.SECONDS));
    }

    @Test
    @Timeout(value=60L)
    public void testMaxPacketSize() throws Exception {
        int SIZE = 256;
        this.setAcceptorProperty("maximumPacketSize=256");
        String TOPIC = RandomUtil.randomString();
        final CountDownLatch latch = new CountDownLatch(1);
        StringBuilder builder = new StringBuilder(512);
        for (int i = 0; i < 512; ++i) {
            builder.append("=");
        }
        byte[] bytes = builder.toString().getBytes(StandardCharsets.UTF_8);
        MqttClient producer = this.createPahoClient(RandomUtil.randomString());
        producer.connect();
        producer.setCallback((MqttCallback)new MQTT5TestSupport.DefaultMqttCallback(){

            @Override
            public void disconnected(MqttDisconnectResponse disconnectResponse) {
                Assertions.assertEquals((byte)-107, (byte)((byte)disconnectResponse.getReturnCode()));
                latch.countDown();
            }
        });
        try {
            producer.publish(TOPIC, bytes, 1, false);
            Assertions.fail((String)"Publishing should have failed with an MqttException");
        }
        catch (MqttException mqttException) {
        }
        catch (Exception e) {
            Assertions.fail((String)"Should have thrown an MqttException");
        }
        Assertions.assertTrue((boolean)latch.await(2L, TimeUnit.SECONDS));
        Assertions.assertFalse((boolean)producer.isConnected());
    }

    @Test
    @Timeout(value=60L)
    public void testMaxPacketSizeNegativeOne() throws Exception {
        int SIZE = -1;
        this.setAcceptorProperty("maximumPacketSize=-1");
        MqttClient client = this.createPahoClient(RandomUtil.randomString());
        IMqttToken result = client.connectWithResult(null);
        Assertions.assertNotNull((Object)result.getResponseProperties());
        Assertions.assertNull((Object)result.getResponseProperties().getMaximumPacketSize());
    }

    @Disabled
    @Test
    @Timeout(value=60L)
    public void testMaxPacketSizeZero() throws Exception {
        boolean SIZE = false;
        this.setAcceptorProperty("maximumPacketSize=0");
        MqttClient producer = this.createPahoClient(RandomUtil.randomString());
        try {
            producer.connect();
            Assertions.fail((String)"Connecting should have thrown an exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Wait.assertFalse(() -> producer.isConnected(), (long)2000L, (long)100L);
    }

    @Test
    @Timeout(value=60L)
    public void testTopicAliasMaxNegativeOne() throws Exception {
        int SIZE = -1;
        this.setAcceptorProperty("topicAliasMaximum=-1");
        MqttClient client = this.createPahoClient(RandomUtil.randomString());
        IMqttToken result = client.connectWithResult(null);
        Assertions.assertNotNull((Object)result.getResponseProperties());
        Assertions.assertNull((Object)result.getResponseProperties().getTopicAliasMaximum());
    }

    @Test
    @Timeout(value=60L)
    public void testTopicAliasMaxZero() throws Exception {
        boolean SIZE = false;
        this.setAcceptorProperty("topicAliasMaximum=0");
        MqttClient client = this.createPahoClient(RandomUtil.randomString());
        IMqttToken result = client.connectWithResult(null);
        Assertions.assertNotNull((Object)result.getResponseProperties());
        Assertions.assertEquals((int)0, (int)result.getResponseProperties().getTopicAliasMaximum());
    }

    @Test
    @Timeout(value=60L)
    public void testServerKeepAlive() throws Exception {
        int SERVER_KEEP_ALIVE = 123;
        this.setAcceptorProperty("serverKeepAlive=123");
        MqttClient client = this.createPahoClient(RandomUtil.randomString());
        MqttConnectionOptions options = new MqttConnectionOptions();
        options.setKeepAliveInterval(1234);
        IMqttToken result = client.connectWithResult(options);
        Assertions.assertNotNull((Object)result.getResponseProperties());
        Assertions.assertEquals((long)123L, (long)result.getResponseProperties().getServerKeepAlive().intValue());
        client.disconnect();
    }

    @Test
    @Timeout(value=60L)
    public void testServerKeepAliveNegativeOne() throws Exception {
        int KEEP_ALIVE = 1234;
        this.setAcceptorProperty("serverKeepAlive=-1");
        MqttClient client = this.createPahoClient(RandomUtil.randomString());
        MqttConnectionOptions options = new MqttConnectionOptions();
        options.setKeepAliveInterval(1234);
        IMqttToken result = client.connectWithResult(options);
        Assertions.assertNull((Object)result.getResponseProperties().getServerKeepAlive());
        boolean found = false;
        for (ConnectionEntry entry : ((RemotingServiceImpl)this.getServer().getRemotingService()).getConnectionEntries()) {
            Assertions.assertEquals((long)entry.ttl, (long)1851000L);
            found = true;
        }
        Assertions.assertTrue((boolean)found);
        client.disconnect();
    }

    @Test
    @Timeout(value=60L)
    public void testServerKeepAliveZero() throws Exception {
        boolean SERVER_KEEP_ALIVE = false;
        this.setAcceptorProperty("serverKeepAlive=0");
        MqttClient client = this.createPahoClient(RandomUtil.randomString());
        MqttConnectionOptions options = new MqttConnectionOptions();
        options.setKeepAliveInterval(1234);
        IMqttToken result = client.connectWithResult(options);
        Assertions.assertEquals((long)0L, (long)result.getResponseProperties().getServerKeepAlive().intValue());
        boolean found = false;
        for (ConnectionEntry entry : ((RemotingServiceImpl)this.getServer().getRemotingService()).getConnectionEntries()) {
            Assertions.assertEquals((long)entry.ttl, (long)-1L);
            found = true;
        }
        Assertions.assertTrue((boolean)found);
        client.disconnect();
    }

    @Test
    @Timeout(value=60L)
    public void testServerKeepAliveWithClientKeepAliveZero() throws Exception {
        int SERVER_KEEP_ALIVE = 123;
        this.setAcceptorProperty("serverKeepAlive=123");
        MqttClient client = this.createPahoClient(RandomUtil.randomString());
        MqttConnectionOptions options = new MqttConnectionOptions();
        options.setKeepAliveInterval(0);
        IMqttToken result = client.connectWithResult(options);
        Assertions.assertEquals((long)123L, (long)result.getResponseProperties().getServerKeepAlive().intValue());
        boolean found = false;
        for (ConnectionEntry entry : ((RemotingServiceImpl)this.getServer().getRemotingService()).getConnectionEntries()) {
            Assertions.assertEquals((long)entry.ttl, (long)184500L);
            found = true;
        }
        Assertions.assertTrue((boolean)found);
        client.disconnect();
    }

    private List<Integer> getListOfCodes(int[] codes) {
        return IntStream.of(codes).boxed().collect(Collectors.toList());
    }
}

