/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.mqtt5.spec.controlpackets;

import io.netty.handler.codec.mqtt.MqttMessageIdAndPropertiesVariableHeader;
import io.netty.handler.codec.mqtt.MqttMessageType;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.core.BaseInterceptor;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTInterceptor;
import org.apache.activemq.artemis.tests.integration.mqtt5.MQTT5TestSupport;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.eclipse.paho.mqttv5.client.IMqttToken;
import org.eclipse.paho.mqttv5.client.MqttAsyncClient;
import org.eclipse.paho.mqttv5.client.MqttCallback;
import org.eclipse.paho.mqttv5.client.MqttClient;
import org.eclipse.paho.mqttv5.common.MqttMessage;
import org.eclipse.paho.mqttv5.common.MqttSubscription;
import org.eclipse.paho.mqttv5.common.packet.MqttProperties;
import org.eclipse.paho.mqttv5.common.packet.MqttSubAck;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class SubscribeTests
extends MQTT5TestSupport {
    @Test
    @Timeout(value=60L)
    public void testSubscribeNoLocal() throws Exception {
        String TOPIC = RandomUtil.randomString();
        CountDownLatch latch = new CountDownLatch(1);
        MqttClient client = this.createPahoClient("nolocal");
        client.connect();
        client.setCallback((MqttCallback)new MQTT5TestSupport.LatchedMqttCallback(this, latch));
        MqttSubscription sub = new MqttSubscription(TOPIC, 0);
        sub.setNoLocal(true);
        client.subscribe(new MqttSubscription[]{sub});
        client.publish(TOPIC, new byte[0], 0, false);
        Wait.assertEquals((Long)1L, () -> this.getSubscriptionQueue(TOPIC, "nolocal").getMessagesAdded(), (long)2000L, (long)100L);
        Assertions.assertFalse((boolean)latch.await(2L, TimeUnit.SECONDS));
        client.disconnect();
        client.close();
    }

    @Test
    @Timeout(value=60L)
    public void testRequestResponseNoLocal() throws Exception {
        final String TOPIC = RandomUtil.randomString();
        String REQUEST = "request";
        String RESPONSE = "response";
        final CountDownLatch aclientLatch = new CountDownLatch(2);
        final CountDownLatch bclientLatch = new CountDownLatch(1);
        MqttClient aclient = this.createPahoClient("aclientid");
        aclient.connect();
        aclient.setCallback((MqttCallback)new MQTT5TestSupport.DefaultMqttCallback(){

            @Override
            public void messageArrived(String topic, MqttMessage message) throws Exception {
                Assertions.assertEquals((Object)"response", (Object)new String(message.getPayload()));
                aclientLatch.countDown();
            }
        });
        final MqttClient bclient = this.createPahoClient("bclientid");
        bclient.connect();
        bclient.setCallback((MqttCallback)new MQTT5TestSupport.DefaultMqttCallback(){

            @Override
            public void messageArrived(String topic, MqttMessage message) throws Exception {
                Assertions.assertEquals((Object)"request", (Object)new String(message.getPayload()));
                bclientLatch.countDown();
                MqttMessage m = new MqttMessage();
                m.setPayload("response".getBytes(StandardCharsets.UTF_8));
                m.setQos(1);
                MqttProperties properties = new MqttProperties();
                properties.setResponseTopic(TOPIC);
                properties.setCorrelationData("334".getBytes(StandardCharsets.UTF_8));
                m.setProperties(properties);
                bclient.publish(TOPIC, m);
            }
        });
        MqttSubscription sub = new MqttSubscription(TOPIC, 2);
        sub.setNoLocal(true);
        aclient.subscribe(new MqttSubscription[]{sub});
        bclient.subscribe(new MqttSubscription[]{sub});
        MqttMessage m = new MqttMessage();
        m.setPayload("request".getBytes(StandardCharsets.UTF_8));
        m.setQos(1);
        MqttProperties properties = new MqttProperties();
        properties.setResponseTopic(TOPIC);
        properties.setCorrelationData("334".getBytes(StandardCharsets.UTF_8));
        m.setProperties(properties);
        aclient.publish(TOPIC, m);
        Assertions.assertTrue((boolean)bclientLatch.await(2L, TimeUnit.SECONDS));
        Wait.assertEquals((Long)1L, () -> aclientLatch.getCount(), (long)2000L, (long)100L);
        Assertions.assertFalse((boolean)aclientLatch.await(2L, TimeUnit.SECONDS));
        aclient.disconnect();
        aclient.close();
        bclient.disconnect();
        bclient.close();
    }

    @Test
    @Timeout(value=60L)
    public void testSubAck() throws Exception {
        String TOPIC = RandomUtil.randomString();
        AtomicBoolean subscribed = new AtomicBoolean(false);
        CountDownLatch latch = new CountDownLatch(1);
        MQTTInterceptor incomingInterceptor = (packet, connection) -> {
            if (packet.fixedHeader().messageType() == MqttMessageType.SUBSCRIBE) {
                subscribed.set(true);
            }
            return true;
        };
        MQTTInterceptor outgoingInterceptor = (packet, connection) -> {
            if (subscribed.get() && packet.fixedHeader().messageType() == MqttMessageType.SUBACK) {
                latch.countDown();
            }
            return true;
        };
        this.server.getRemotingService().addIncomingInterceptor((BaseInterceptor)incomingInterceptor);
        this.server.getRemotingService().addOutgoingInterceptor((BaseInterceptor)outgoingInterceptor);
        MqttClient consumer = this.createPahoClient("consumer");
        consumer.connect();
        consumer.subscribe(TOPIC, 0);
        consumer.unsubscribe(TOPIC);
        Assertions.assertTrue((boolean)latch.await(2L, TimeUnit.SECONDS));
        consumer.disconnect();
        consumer.close();
    }

    @Test
    @Timeout(value=60L)
    public void testSubAckPacketId() throws Exception {
        String TOPIC = RandomUtil.randomString();
        AtomicBoolean subscribed = new AtomicBoolean(false);
        AtomicInteger packetId = new AtomicInteger(0);
        CountDownLatch latch = new CountDownLatch(1);
        MQTTInterceptor incomingInterceptor = (packet, connection) -> {
            if (packet.fixedHeader().messageType() == MqttMessageType.SUBSCRIBE) {
                subscribed.set(true);
                packetId.set(((MqttMessageIdAndPropertiesVariableHeader)packet.variableHeader()).messageId());
            }
            return true;
        };
        MQTTInterceptor outgoingInterceptor = (packet, connection) -> {
            if (subscribed.get() && packet.fixedHeader().messageType() == MqttMessageType.SUBACK) {
                Assertions.assertEquals((int)packetId.get(), (int)((MqttMessageIdAndPropertiesVariableHeader)packet.variableHeader()).messageId());
                latch.countDown();
            }
            return true;
        };
        this.server.getRemotingService().addIncomingInterceptor((BaseInterceptor)incomingInterceptor);
        this.server.getRemotingService().addOutgoingInterceptor((BaseInterceptor)outgoingInterceptor);
        MqttClient consumer = this.createPahoClient("consumer");
        consumer.connect();
        consumer.subscribe(TOPIC, 0);
        consumer.unsubscribe(TOPIC);
        Assertions.assertTrue((boolean)latch.await(2L, TimeUnit.SECONDS));
        consumer.disconnect();
        consumer.close();
    }

    @Test
    @Timeout(value=60L)
    public void testReplaceSubscription() throws Exception {
        String TOPIC = RandomUtil.randomString();
        CountDownLatch latch = new CountDownLatch(2);
        MqttClient client = this.createPahoClient("nolocal");
        client.connect();
        client.setCallback((MqttCallback)new MQTT5TestSupport.LatchedMqttCallback(this, latch));
        MqttSubscription sub = new MqttSubscription(TOPIC, 0);
        sub.setNoLocal(false);
        client.subscribe(new MqttSubscription[]{sub});
        client.publish(TOPIC, new byte[0], 0, false);
        Wait.assertEquals((Long)1L, () -> this.getSubscriptionQueue(TOPIC, "nolocal").getMessagesAdded(), (long)2000L, (long)100L);
        Wait.assertTrue(() -> latch.getCount() == 1L, (long)2000L, (long)100L);
        sub = new MqttSubscription(TOPIC, 0);
        sub.setNoLocal(true);
        client.subscribe(new MqttSubscription[]{sub});
        client.publish(TOPIC, new byte[0], 0, false);
        Wait.assertEquals((Long)2L, () -> this.getSubscriptionQueue(TOPIC, "nolocal").getMessagesAdded(), (long)2000L, (long)100L);
        Assertions.assertFalse((boolean)latch.await(2L, TimeUnit.SECONDS));
        client.disconnect();
        client.close();
    }

    @Test
    @Timeout(value=60L)
    public void testReplaceSubscriptionRetainHandling() throws Exception {
        String TOPIC = RandomUtil.randomString();
        String CLIENT_ID = RandomUtil.randomString();
        CountDownLatch latch = new CountDownLatch(2);
        MqttClient client = this.createPahoClient(CLIENT_ID);
        client.connect();
        client.publish(TOPIC, "retained".getBytes(), 0, true);
        client.setCallback((MqttCallback)new MQTT5TestSupport.LatchedMqttCallback(this, latch));
        MqttSubscription sub = new MqttSubscription(TOPIC, 0);
        sub.setRetainHandling(1);
        client.subscribe(new MqttSubscription[]{sub});
        Wait.assertEquals((Long)1L, () -> this.getSubscriptionQueue(TOPIC, CLIENT_ID).getMessagesAdded(), (long)2000L, (long)100L);
        sub = new MqttSubscription(TOPIC, 0);
        sub.setRetainHandling(0);
        client.subscribe(new MqttSubscription[]{sub});
        Wait.assertEquals((Long)2L, () -> this.getSubscriptionQueue(TOPIC, CLIENT_ID).getMessagesAdded(), (long)2000L, (long)100L);
        Assertions.assertTrue((boolean)latch.await(2L, TimeUnit.SECONDS));
        client.disconnect();
        client.close();
    }

    @Test
    @Timeout(value=60L)
    public void testSubscribeAck() throws Exception {
        int i;
        int SUBSCRIPTION_COUNT = 30;
        String TOPIC = RandomUtil.randomString();
        AtomicInteger subAckCount = new AtomicInteger(0);
        SimpleString[] topicNames = new SimpleString[30];
        for (int i2 = 0; i2 < 30; ++i2) {
            topicNames[i2] = SimpleString.of((String)(i2 + "-" + TOPIC));
        }
        MQTTInterceptor outgoingInterceptor = (packet, connection) -> {
            if (packet.fixedHeader().messageType() == MqttMessageType.SUBACK) {
                subAckCount.incrementAndGet();
            }
            return true;
        };
        this.server.getRemotingService().addOutgoingInterceptor((BaseInterceptor)outgoingInterceptor);
        MqttAsyncClient consumer = this.createAsyncPahoClient("consumer");
        consumer.connect().waitForCompletion();
        MqttSubscription[] subscriptions = new MqttSubscription[30];
        for (int i3 = 0; i3 < 30; ++i3) {
            subscriptions[i3] = new MqttSubscription(topicNames[i3].toString(), RandomUtil.randomInterval((int)0, (int)3));
        }
        IMqttToken token = consumer.subscribe(subscriptions);
        token.waitForCompletion();
        MqttSubAck response = (MqttSubAck)token.getResponse();
        Assertions.assertEquals((int)subscriptions.length, (int)response.getReturnCodes().length);
        for (i = 0; i < response.getReturnCodes().length; ++i) {
            Assertions.assertEquals((int)subscriptions[i].getQos(), (int)response.getReturnCodes()[i]);
        }
        for (i = 0; i < 30; ++i) {
            Assertions.assertTrue((boolean)this.server.getPostOffice().isAddressBound(topicNames[i]));
        }
        Assertions.assertEquals((int)1, (int)subAckCount.get());
        consumer.disconnect();
        consumer.close();
    }

    @Test
    @Timeout(value=60L)
    public void testSubscriptionQoS() throws Exception {
        String TOPIC = RandomUtil.randomString();
        int PUBLISH_LOOP = 25;
        int MESSAGES_PER_LOOP = 3;
        int CONSUMER_COUNT = 3;
        final CountDownLatch qos0Latch = new CountDownLatch(75);
        final CountDownLatch qos1Latch = new CountDownLatch(75);
        final CountDownLatch qos2Latch = new CountDownLatch(75);
        final AtomicInteger qos0Total = new AtomicInteger(0);
        final AtomicInteger qos1Total = new AtomicInteger(0);
        final AtomicInteger qos2Total = new AtomicInteger(0);
        MqttClient qos0Client = this.createPahoClient("qos0");
        qos0Client.connect();
        qos0Client.setCallback((MqttCallback)new MQTT5TestSupport.DefaultMqttCallback(){

            @Override
            public void messageArrived(String topic, MqttMessage message) throws Exception {
                Assertions.assertTrue((message.getQos() == 0 ? (byte)1 : 0) != 0);
                qos0Total.incrementAndGet();
                qos0Latch.countDown();
            }
        });
        qos0Client.subscribe(TOPIC, 0);
        MqttClient qos1Client = this.createPahoClient("qos1");
        qos1Client.connect();
        qos1Client.setCallback((MqttCallback)new MQTT5TestSupport.DefaultMqttCallback(){

            @Override
            public void messageArrived(String topic, MqttMessage message) throws Exception {
                Assertions.assertTrue((message.getQos() == 0 || message.getQos() == 1 ? (byte)1 : 0) != 0);
                if (message.getQos() == 0) {
                    qos0Total.incrementAndGet();
                } else if (message.getQos() == 1) {
                    qos1Total.incrementAndGet();
                }
                qos1Latch.countDown();
            }
        });
        qos1Client.subscribe(TOPIC, 1);
        MqttClient qos2Client = this.createPahoClient("qos2");
        qos2Client.connect();
        qos2Client.setCallback((MqttCallback)new MQTT5TestSupport.DefaultMqttCallback(){

            @Override
            public void messageArrived(String topic, MqttMessage message) throws Exception {
                Assertions.assertTrue((message.getQos() == 0 || message.getQos() == 1 || message.getQos() == 2 ? (byte)1 : 0) != 0);
                if (message.getQos() == 0) {
                    qos0Total.incrementAndGet();
                } else if (message.getQos() == 1) {
                    qos1Total.incrementAndGet();
                } else if (message.getQos() == 2) {
                    qos2Total.incrementAndGet();
                }
                qos2Latch.countDown();
            }
        });
        qos2Client.subscribe(TOPIC, 2);
        MqttClient publisher = this.createPahoClient("publisher");
        publisher.connect();
        for (int i = 0; i < 25; ++i) {
            for (int j = 0; j < 3; ++j) {
                publisher.publish(TOPIC, new byte[0], j, false);
            }
        }
        publisher.disconnect();
        publisher.close();
        Assertions.assertTrue((boolean)qos0Latch.await(2L, TimeUnit.SECONDS));
        Assertions.assertTrue((boolean)qos1Latch.await(2L, TimeUnit.SECONDS));
        Assertions.assertTrue((boolean)qos2Latch.await(2L, TimeUnit.SECONDS));
        Assertions.assertEquals((int)225, (int)(qos0Total.get() + qos1Total.get() + qos2Total.get()));
        Assertions.assertEquals((int)125, (int)qos0Total.get());
        Assertions.assertEquals((int)75, (int)qos1Total.get());
        Assertions.assertEquals((int)25, (int)qos2Total.get());
        qos0Client.disconnect();
        qos0Client.close();
        qos1Client.disconnect();
        qos1Client.close();
        qos2Client.disconnect();
        qos2Client.close();
    }
}

