/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.xa;

import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.MessageHandler;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.StoreConfiguration;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.core.transaction.impl.XidImpl;
import org.apache.activemq.artemis.ra.ActiveMQRAXAResource;
import org.apache.activemq.artemis.tests.extensions.parameterized.ParameterizedTestExtension;
import org.apache.activemq.artemis.tests.extensions.parameterized.Parameters;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.UUIDGenerator;
import org.apache.activemq.artemis.utils.Wait;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExtendWith(value={ParameterizedTestExtension.class})
public class BasicXaTest
extends ActiveMQTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Map<String, AddressSettings> addressSettings = new HashMap<String, AddressSettings>();
    private ActiveMQServer messagingService;
    private ClientSession clientSession;
    private ClientSessionFactory sessionFactory;
    private Configuration configuration;
    private final SimpleString atestq = SimpleString.of((String)"BasicXaTestq");
    private ServerLocator locator;
    private StoreConfiguration.StoreType storeType;

    public BasicXaTest(StoreConfiguration.StoreType storeType) {
        this.storeType = storeType;
    }

    @Parameters(name="storeType={0}")
    public static Collection<Object[]> data() {
        Object[][] params = new Object[][]{{StoreConfiguration.StoreType.FILE}, {StoreConfiguration.StoreType.DATABASE}};
        return Arrays.asList(params);
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.addressSettings.clear();
        this.configuration = this.storeType == StoreConfiguration.StoreType.DATABASE ? this.createDefaultJDBCConfig(true) : this.createDefaultNettyConfig();
        this.messagingService = this.createServer(true, this.configuration, -1, -1L, this.addressSettings);
        this.messagingService.start();
        this.locator = this.createInVMNonHALocator();
        this.sessionFactory = this.createSessionFactory(this.locator);
        this.clientSession = this.addClientSession(this.sessionFactory.createSession(true, false, false));
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)this.atestq));
    }

    @TestTemplate
    public void testSendWithoutXID() throws Exception {
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory factory = this.createSessionFactory(locator);
        ClientSession session = this.addClientSession(factory.createSession(true, false, false));
        session.createQueue(QueueConfiguration.of((String)"Test").setRoutingType(RoutingType.ANYCAST));
        ClientProducer prod = session.createProducer("Test");
        prod.send((Message)session.createMessage(true));
        session.start();
        ClientConsumer cons = session.createConsumer("Test");
        Assertions.assertNotNull((Object)cons.receiveImmediate(), (String)"Send went through an invalid XA Session");
    }

    @TestTemplate
    public void testACKWithoutXID() throws Exception {
        ClientSessionFactory factory = this.createSessionFactory(this.locator);
        ClientSession session = this.addClientSession(factory.createSession(false, true, true));
        session.createQueue(QueueConfiguration.of((String)"Test").setRoutingType(RoutingType.ANYCAST));
        ClientProducer prod = session.createProducer("Test");
        prod.send((Message)session.createMessage(true));
        session.close();
        session = this.addClientSession(factory.createSession(true, false, false));
        session.start();
        ClientConsumer cons = session.createConsumer("Test");
        ClientMessage msg = cons.receive(5000L);
        Assertions.assertNotNull((Object)msg);
        msg.acknowledge();
        session.close();
        session = this.addClientSession(factory.createSession(false, false, false));
        session.start();
        cons = session.createConsumer("Test");
        msg = cons.receiveImmediate();
        Assertions.assertNull((Object)msg, (String)"Acknowledge went through invalid XA Session");
    }

    @TestTemplate
    public void testIsSameRM() throws Exception {
        try (ServerLocator locator = this.createNettyNonHALocator();
             ServerLocator locator2 = this.createNettyNonHALocator();){
            ClientSessionFactory nettyFactory = this.createSessionFactory(locator);
            ClientSessionFactory nettyFactory2 = this.createSessionFactory(locator2);
            ClientSession session1 = nettyFactory.createSession(true, false, false);
            ClientSession session2 = nettyFactory2.createSession(true, false, false);
            Assertions.assertTrue((boolean)session1.isSameRM((XAResource)session2));
            ActiveMQRAXAResource activeMQRAXAResource = new ActiveMQRAXAResource(null, (XAResource)session2);
            Assertions.assertTrue((boolean)session1.isSameRM((XAResource)activeMQRAXAResource));
        }
    }

    @TestTemplate
    public void testXAInterleaveResourceSuspendWorkCommit() throws Exception {
        XidImpl xid = this.newXID();
        XidImpl xid2 = this.newXID();
        ClientProducer clientProducer = this.clientSession.createProducer(this.atestq);
        ClientSession recSession = this.sessionFactory.createSession();
        recSession.start();
        ClientConsumer clientConsumer = recSession.createConsumer(this.atestq);
        ClientMessage m1 = this.createTextMessage(this.clientSession, "m1");
        ClientMessage m2 = this.createTextMessage(this.clientSession, "m2");
        this.clientSession.start((Xid)xid, 0);
        clientProducer.send((Message)m1);
        this.clientSession.end((Xid)xid, 0x2000000);
        this.clientSession.start((Xid)xid2, 0);
        clientProducer.send((Message)m2);
        this.clientSession.end((Xid)xid, 0x4000000);
        this.clientSession.end((Xid)xid, 0x4000000);
        this.clientSession.commit((Xid)xid, true);
        ClientMessage message = clientConsumer.receiveImmediate();
        Assertions.assertNotNull((Object)message);
        message = clientConsumer.receiveImmediate();
        Assertions.assertNull((Object)message);
        this.clientSession.end((Xid)xid2, 0x4000000);
        this.clientSession.commit((Xid)xid2, true);
        message = clientConsumer.receiveImmediate();
        Assertions.assertNotNull((Object)message);
    }

    @TestTemplate
    public void testRestartWithTXPrepareDeletedQueue() throws Exception {
        ClientSession clientSession2 = this.sessionFactory.createSession(false, true, true);
        ClientProducer clientProducer = clientSession2.createProducer(this.atestq);
        ClientMessage m1 = this.createTextMessage(clientSession2, "m1");
        clientProducer.send((Message)m1);
        XidImpl xid = this.newXID();
        this.clientSession.start((Xid)xid, 0);
        this.clientSession.start();
        ClientConsumer clientConsumer = this.clientSession.createConsumer(this.atestq);
        ClientMessage message = clientConsumer.receive(5000L);
        message.acknowledge();
        this.clientSession.end((Xid)xid, 0x4000000);
        this.clientSession.prepare((Xid)xid);
        Queue queueAtestQ = this.messagingService.locateQueue(this.atestq);
        Assertions.assertNotNull((Object)queueAtestQ);
        this.clientSession.getSessionFactory().getConnection().destroy();
        Wait.assertEquals((int)0, () -> ((Queue)queueAtestQ).getConsumerCount());
        this.messagingService.destroyQueue(this.atestq);
        this.messagingService.stop();
        this.messagingService.start();
        this.messagingService.waitForActivation(10L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)this.messagingService.isStarted());
    }

    @TestTemplate
    public void testXAInterleaveResourceRollbackAfterPrepare() throws Exception {
        XidImpl xid = this.newXID();
        XidImpl xid2 = this.newXID();
        XidImpl xid3 = this.newXID();
        ClientProducer clientProducer = this.clientSession.createProducer(this.atestq);
        ClientConsumer clientConsumer = this.clientSession.createConsumer(this.atestq);
        ClientMessage m1 = this.createTextMessage(this.clientSession, "m1");
        this.clientSession.start((Xid)xid, 0);
        clientProducer.send((Message)m1);
        this.clientSession.end((Xid)xid, 0x4000000);
        this.clientSession.prepare((Xid)xid);
        this.clientSession.commit((Xid)xid, false);
        this.clientSession.start();
        this.clientSession.start((Xid)xid2, 0);
        ClientMessage m2 = clientConsumer.receiveImmediate();
        Assertions.assertNotNull((Object)m2);
        this.clientSession.end((Xid)xid2, 0x4000000);
        this.clientSession.prepare((Xid)xid2);
        this.clientSession.rollback((Xid)xid2);
        this.clientSession.start((Xid)xid3, 0);
        m2 = clientConsumer.receiveImmediate();
        Assertions.assertNotNull((Object)m2);
        this.clientSession.end((Xid)xid3, 0x4000000);
        this.clientSession.prepare((Xid)xid3);
        this.clientSession.commit((Xid)xid3, false);
    }

    @TestTemplate
    public void testSendPrepareDoesntRollbackOnClose() throws Exception {
        XidImpl xid = this.newXID();
        ClientMessage m1 = this.createTextMessage(this.clientSession, "m1");
        ClientMessage m2 = this.createTextMessage(this.clientSession, "m2");
        ClientMessage m3 = this.createTextMessage(this.clientSession, "m3");
        ClientMessage m4 = this.createTextMessage(this.clientSession, "m4");
        ClientProducer clientProducer = this.clientSession.createProducer(this.atestq);
        this.clientSession.start((Xid)xid, 0);
        clientProducer.send((Message)m1);
        clientProducer.send((Message)m2);
        clientProducer.send((Message)m3);
        clientProducer.send((Message)m4);
        this.clientSession.end((Xid)xid, 0x4000000);
        this.clientSession.prepare((Xid)xid);
        this.clientSession.close();
        this.clientSession = this.sessionFactory.createSession(true, false, false);
        logger.debug("committing");
        this.clientSession.commit((Xid)xid, false);
        this.clientSession.start();
        ClientConsumer clientConsumer = this.clientSession.createConsumer(this.atestq);
        ClientMessage m = clientConsumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m1");
        m = clientConsumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m2");
        m = clientConsumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m3");
        m = clientConsumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m4");
    }

    @TestTemplate
    public void testReceivePrepareDoesntRollbackOnClose() throws Exception {
        XidImpl xid = this.newXID();
        ClientSession clientSession2 = this.sessionFactory.createSession(false, true, true);
        ClientProducer clientProducer = clientSession2.createProducer(this.atestq);
        ClientMessage m1 = this.createTextMessage(clientSession2, "m1");
        ClientMessage m2 = this.createTextMessage(clientSession2, "m2");
        ClientMessage m3 = this.createTextMessage(clientSession2, "m3");
        ClientMessage m4 = this.createTextMessage(clientSession2, "m4");
        clientProducer.send((Message)m1);
        clientProducer.send((Message)m2);
        clientProducer.send((Message)m3);
        clientProducer.send((Message)m4);
        this.clientSession.start((Xid)xid, 0);
        this.clientSession.start();
        ClientConsumer clientConsumer = this.clientSession.createConsumer(this.atestq);
        ClientMessage m = clientConsumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        m.acknowledge();
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m1");
        m = clientConsumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        m.acknowledge();
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m2");
        m = clientConsumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        m.acknowledge();
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m3");
        m = clientConsumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        m.acknowledge();
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m4");
        this.clientSession.end((Xid)xid, 0x4000000);
        this.clientSession.prepare((Xid)xid);
        this.clientSession.close();
        this.clientSession = this.sessionFactory.createSession(true, false, false);
        this.clientSession.commit((Xid)xid, false);
        this.clientSession.start();
        clientConsumer = this.clientSession.createConsumer(this.atestq);
        m = clientConsumer.receiveImmediate();
        Assertions.assertNull((Object)m);
        clientSession2.close();
    }

    @TestTemplate
    public void testPrepareError() throws Exception {
        XidImpl xid = this.newXID();
        ClientSession clientSession2 = this.sessionFactory.createSession(false, true, true);
        ClientProducer clientProducer = clientSession2.createProducer(this.atestq);
        ClientMessage m1 = this.createTextMessage(clientSession2, "m1");
        ClientMessage m2 = this.createTextMessage(clientSession2, "m2");
        ClientMessage m3 = this.createTextMessage(clientSession2, "m3");
        ClientMessage m4 = this.createTextMessage(clientSession2, "m4");
        clientProducer.send((Message)m1);
        clientProducer.send((Message)m2);
        clientProducer.send((Message)m3);
        clientProducer.send((Message)m4);
        this.clientSession.start((Xid)xid, 0);
        this.clientSession.start();
        ClientConsumer clientConsumer = this.clientSession.createConsumer(this.atestq);
        ClientMessage m = clientConsumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        m.acknowledge();
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m1");
        m = clientConsumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        m.acknowledge();
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m2");
        m = clientConsumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        m.acknowledge();
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m3");
        m = clientConsumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        m.acknowledge();
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m4");
        this.clientSession.end((Xid)xid, 0x4000000);
        StorageManager journalStorageManager = this.messagingService.getStorageManager();
        this.clientSession.prepare((Xid)xid);
        journalStorageManager.getMessageJournal().stop();
        try {
            this.clientSession.commit((Xid)xid, false);
            Assertions.fail((String)"Exception exptected");
        }
        catch (XAException e) {
            Assertions.assertTrue((e.errorCode == 4 ? (byte)1 : 0) != 0);
        }
    }

    @TestTemplate
    public void testRollbackError() throws Exception {
        XidImpl xid = this.newXID();
        ClientSession clientSession2 = this.sessionFactory.createSession(false, true, true);
        ClientProducer clientProducer = clientSession2.createProducer(this.atestq);
        ClientMessage m1 = this.createTextMessage(clientSession2, "m1");
        ClientMessage m2 = this.createTextMessage(clientSession2, "m2");
        ClientMessage m3 = this.createTextMessage(clientSession2, "m3");
        ClientMessage m4 = this.createTextMessage(clientSession2, "m4");
        clientProducer.send((Message)m1);
        clientProducer.send((Message)m2);
        clientProducer.send((Message)m3);
        clientProducer.send((Message)m4);
        this.clientSession.start((Xid)xid, 0);
        this.clientSession.start();
        ClientConsumer clientConsumer = this.clientSession.createConsumer(this.atestq);
        ClientMessage m = clientConsumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        m.acknowledge();
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m1");
        m = clientConsumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        m.acknowledge();
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m2");
        m = clientConsumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        m.acknowledge();
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m3");
        m = clientConsumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        m.acknowledge();
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m4");
        this.clientSession.end((Xid)xid, 0x4000000);
        StorageManager journalStorageManager = this.messagingService.getStorageManager();
        this.clientSession.prepare((Xid)xid);
        journalStorageManager.getMessageJournal().stop();
        try {
            this.clientSession.rollback((Xid)xid);
            Assertions.fail((String)"Exception exptected");
        }
        catch (XAException e) {
            Assertions.assertTrue((e.errorCode == -7 ? (byte)1 : 0) != 0);
        }
    }

    @TestTemplate
    public void testReceiveRollback() throws Exception {
        int numSessions = 100;
        ClientSession clientSession2 = this.sessionFactory.createSession(false, true, true);
        ClientProducer clientProducer = clientSession2.createProducer(this.atestq);
        for (int i = 0; i < numSessions; ++i) {
            clientProducer.send((Message)this.createTextMessage(clientSession2, "m" + i));
        }
        ClientSession[] clientSessions = new ClientSession[numSessions];
        ClientConsumer[] clientConsumers = new ClientConsumer[numSessions];
        TxMessageHandler[] handlers = new TxMessageHandler[numSessions];
        CountDownLatch latch = new CountDownLatch(numSessions * 10);
        for (int i = 0; i < clientSessions.length; ++i) {
            clientSessions[i] = this.sessionFactory.createSession(true, false, false);
            clientConsumers[i] = clientSessions[i].createConsumer(this.atestq);
            handlers[i] = new TxMessageHandler(clientSessions[i], latch);
            clientConsumers[i].setMessageHandler((MessageHandler)handlers[i]);
        }
        for (ClientSession session : clientSessions) {
            session.start();
        }
        boolean ok = latch.await(10L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)ok);
        for (TxMessageHandler txMessageHandler : handlers) {
            Assertions.assertFalse((boolean)txMessageHandler.failedToAck);
        }
        clientSession2.close();
        for (TxMessageHandler txMessageHandler : clientSessions) {
            txMessageHandler.stop();
            txMessageHandler.close();
        }
    }

    @TestTemplate
    public void testSendMultipleQueues() throws Exception {
        this.multipleQueuesInternalTest(true, false, false, false, false);
    }

    @TestTemplate
    public void testSendMultipleQueuesOnePhase() throws Exception {
        this.multipleQueuesInternalTest(true, false, false, false, true);
        this.multipleQueuesInternalTest(false, false, true, false, true);
    }

    @TestTemplate
    public void testSendMultipleQueuesOnePhaseJoin() throws Exception {
        this.multipleQueuesInternalTest(true, false, false, true, true);
        this.multipleQueuesInternalTest(false, false, true, true, true);
    }

    @TestTemplate
    public void testSendMultipleQueuesTwoPhaseJoin() throws Exception {
        this.multipleQueuesInternalTest(true, false, false, true, false);
        this.multipleQueuesInternalTest(false, false, true, true, false);
    }

    @TestTemplate
    public void testSendMultipleQueuesRecreate() throws Exception {
        this.multipleQueuesInternalTest(true, false, true, false, false);
    }

    @TestTemplate
    public void testSendMultipleSuspend() throws Exception {
        this.multipleQueuesInternalTest(true, true, false, false, false);
    }

    @TestTemplate
    public void testSendMultipleSuspendRecreate() throws Exception {
        this.multipleQueuesInternalTest(true, true, true, false, false);
    }

    @TestTemplate
    public void testSendMultipleSuspendErrorCheck() throws Exception {
        ClientSession session = null;
        session = this.sessionFactory.createSession(true, false, false);
        XidImpl xid = this.newXID();
        session.start((Xid)xid, 0);
        try {
            session.start((Xid)xid, 0x8000000);
            Assertions.fail((String)"XAException expected");
        }
        catch (XAException e) {
            Assertions.assertEquals((int)-6, (int)e.errorCode);
        }
        session.close();
    }

    @TestTemplate
    public void testEmptyXID() throws Exception {
        XidImpl xid = this.newXID();
        ClientSession session = this.sessionFactory.createSession(true, false, false);
        session.start((Xid)xid, 0);
        session.end((Xid)xid, 0x4000000);
        session.rollback((Xid)xid);
        session.close();
        this.messagingService.stop();
        this.messagingService = this.createServer(true, this.configuration, -1, -1L, this.addressSettings);
        this.messagingService.start();
        this.sessionFactory = this.createSessionFactory(this.locator);
        xid = this.newXID();
        session = this.sessionFactory.createSession(true, false, false);
        session.start((Xid)xid, 0);
        session.end((Xid)xid, 0x4000000);
        session.rollback((Xid)xid);
        xid = this.newXID();
        session.start((Xid)xid, 0);
        session.end((Xid)xid, 0x4000000);
        session.prepare((Xid)xid);
        session.commit((Xid)xid, false);
        session.close();
        xid = this.newXID();
        session = this.sessionFactory.createSession(true, false, false);
        session.start((Xid)xid, 0);
        session.end((Xid)xid, 0x4000000);
        session.prepare((Xid)xid);
        session.rollback((Xid)xid);
        session.close();
        this.messagingService.start();
        this.sessionFactory = this.createSessionFactory(this.locator);
        xid = this.newXID();
        session = this.sessionFactory.createSession(true, false, false);
        session.start((Xid)xid, 0);
        session.end((Xid)xid, 0x4000000);
        session.rollback((Xid)xid);
        session.close();
        this.messagingService.stop();
        this.messagingService.start();
        this.sessionFactory = this.createSessionFactory(this.locator);
        session = this.sessionFactory.createSession(true, false, false);
        Xid[] xids = session.recover(0x1000000);
        Assertions.assertEquals((int)0, (int)xids.length);
        session.close();
    }

    @TestTemplate
    public void testFailXID() throws Exception {
        XidImpl xid = this.newXID();
        ClientSession session = this.sessionFactory.createSession(true, false, false);
        session.start((Xid)xid, 0);
        session.end((Xid)xid, 0x20000000);
        session.rollback((Xid)xid);
        session.close();
    }

    @TestTemplate
    public void testForgetUnknownXID() throws Exception {
        try {
            this.clientSession.forget((Xid)this.newXID());
            Assertions.fail((String)"should throw a XAERR_NOTA XAException");
        }
        catch (XAException e) {
            Assertions.assertEquals((int)-4, (int)e.errorCode);
        }
    }

    @TestTemplate
    public void testForgetHeuristicallyCommittedXID() throws Exception {
        XidImpl xid = this.newXID();
        this.clientSession.start((Xid)xid, 0);
        this.clientSession.end((Xid)xid, 0x4000000);
        this.clientSession.prepare((Xid)xid);
        String[] preparedTransactions = this.messagingService.getActiveMQServerControl().listPreparedTransactions();
        Assertions.assertEquals((int)1, (int)preparedTransactions.length);
        logger.debug(preparedTransactions[0]);
        Assertions.assertTrue((boolean)this.messagingService.getActiveMQServerControl().commitPreparedTransaction(XidImpl.toBase64String((Xid)xid)));
        Assertions.assertEquals((int)1, (int)this.messagingService.getActiveMQServerControl().listHeuristicCommittedTransactions().length);
        this.clientSession.forget((Xid)xid);
        Assertions.assertEquals((int)0, (int)this.messagingService.getActiveMQServerControl().listHeuristicCommittedTransactions().length);
    }

    @TestTemplate
    public void testForgetHeuristicallyRolledBackXID() throws Exception {
        XidImpl xid = this.newXID();
        this.clientSession.start((Xid)xid, 0);
        this.clientSession.end((Xid)xid, 0x4000000);
        this.clientSession.prepare((Xid)xid);
        String[] preparedTransactions = this.messagingService.getActiveMQServerControl().listPreparedTransactions();
        Assertions.assertEquals((int)1, (int)preparedTransactions.length);
        logger.debug(preparedTransactions[0]);
        Assertions.assertTrue((boolean)this.messagingService.getActiveMQServerControl().rollbackPreparedTransaction(XidImpl.toBase64String((Xid)xid)));
        Assertions.assertEquals((int)1, (int)this.messagingService.getActiveMQServerControl().listHeuristicRolledBackTransactions().length);
        this.clientSession.forget((Xid)xid);
        Assertions.assertEquals((int)0, (int)this.messagingService.getActiveMQServerControl().listHeuristicRolledBackTransactions().length);
    }

    @TestTemplate
    public void testCommitHeuristicallyCommittedXID() throws Exception {
        this.doCompleteHeuristicallyCompletedXID(true, true);
    }

    @TestTemplate
    public void testCommitHeuristicallyRolledBackXID() throws Exception {
        this.doCompleteHeuristicallyCompletedXID(true, false);
    }

    @TestTemplate
    public void testRollbacktHeuristicallyCommittedXID() throws Exception {
        this.doCompleteHeuristicallyCompletedXID(false, true);
    }

    @TestTemplate
    public void testRollbackHeuristicallyRolledBackXID() throws Exception {
        this.doCompleteHeuristicallyCompletedXID(false, false);
    }

    @TestTemplate
    public void testSimpleJoin() throws Exception {
        SimpleString ADDRESS1 = SimpleString.of((String)"Address-1");
        SimpleString ADDRESS2 = SimpleString.of((String)"Address-2");
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)ADDRESS1));
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)ADDRESS2));
        XidImpl xid = this.newXID();
        ClientSession sessionA = this.sessionFactory.createSession(true, false, false);
        sessionA.start((Xid)xid, 0);
        ClientSession sessionB = this.sessionFactory.createSession(true, false, false);
        sessionB.start((Xid)xid, 0x200000);
        ClientProducer prodA = sessionA.createProducer(ADDRESS1);
        ClientProducer prodB = sessionB.createProducer(ADDRESS2);
        for (int i = 0; i < 100; ++i) {
            prodA.send((Message)this.createTextMessage(sessionA, "A" + i));
            prodB.send((Message)this.createTextMessage(sessionB, "B" + i));
        }
        sessionA.end((Xid)xid, 0x4000000);
        sessionB.end((Xid)xid, 0x4000000);
        sessionB.close();
        sessionA.commit((Xid)xid, true);
        sessionA.close();
        xid = this.newXID();
        this.clientSession.start((Xid)xid, 0);
        ClientConsumer cons1 = this.clientSession.createConsumer(ADDRESS1);
        ClientConsumer cons2 = this.clientSession.createConsumer(ADDRESS2);
        this.clientSession.start();
        for (int i = 0; i < 100; ++i) {
            ClientMessage msg = cons1.receive(1000L);
            Assertions.assertNotNull((Object)msg);
            Assertions.assertEquals((Object)("A" + i), (Object)this.getTextMessage(msg));
            msg.acknowledge();
            msg = cons2.receive(1000L);
            Assertions.assertNotNull((Object)msg);
            Assertions.assertEquals((Object)("B" + i), (Object)this.getTextMessage(msg));
            msg.acknowledge();
        }
        Assertions.assertNull((Object)cons1.receiveImmediate());
        Assertions.assertNull((Object)cons2.receiveImmediate());
        this.clientSession.end((Xid)xid, 0x4000000);
        this.clientSession.commit((Xid)xid, true);
        this.clientSession.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void multipleQueuesInternalTest(boolean createQueues, boolean suspend, boolean recreateSession, boolean isJoinSession, boolean onePhase) throws Exception {
        int NUMBER_OF_MSGS = 100;
        int NUMBER_OF_QUEUES = 10;
        ClientSession session = null;
        SimpleString ADDRESS = SimpleString.of((String)"Address");
        ClientSession newJoinSession = null;
        try {
            ClientMessage msg;
            XidImpl xid;
            int i;
            session = this.sessionFactory.createSession(true, false, false);
            if (createQueues) {
                for (i = 0; i < NUMBER_OF_QUEUES; ++i) {
                    session.createQueue(QueueConfiguration.of((SimpleString)ADDRESS.concat(Integer.toString(i))).setAddress(ADDRESS));
                    if (!isJoinSession) continue;
                    this.clientSession.createQueue(QueueConfiguration.of((SimpleString)ADDRESS.concat("-join." + i)).setAddress(ADDRESS.concat("-join")).setDurable(Boolean.valueOf(true)));
                }
            }
            for (int tr = 0; tr < 2; ++tr) {
                xid = this.newXID();
                session.start((Xid)xid, 0);
                ClientProducer prod = session.createProducer(ADDRESS);
                for (int nmsg = 0; nmsg < NUMBER_OF_MSGS; ++nmsg) {
                    msg = this.createTextMessage(session, "SimpleMessage" + nmsg);
                    prod.send((Message)msg);
                }
                if (suspend) {
                    session.end((Xid)xid, 0x2000000);
                    session.start((Xid)xid, 0x8000000);
                }
                prod.send((Message)this.createTextMessage(session, "one more"));
                prod.close();
                if (isJoinSession) {
                    newJoinSession = this.sessionFactory.createSession(true, false, false);
                    Assertions.assertTrue((boolean)session.isSameRM((XAResource)newJoinSession));
                    newJoinSession.start((Xid)xid, 0x200000);
                    ClientProducer newProd = newJoinSession.createProducer(ADDRESS.concat("-join"));
                    newProd.send((Message)this.createTextMessage(newJoinSession, "After Join"));
                }
                session.end((Xid)xid, 0x4000000);
                if (isJoinSession) {
                    newJoinSession.end((Xid)xid, 0x4000000);
                    newJoinSession.close();
                }
                if (!onePhase) {
                    session.prepare((Xid)xid);
                }
                if (recreateSession) {
                    session.close();
                    session = this.sessionFactory.createSession(true, false, false);
                }
                if (tr == 0) {
                    session.rollback((Xid)xid);
                    continue;
                }
                session.commit((Xid)xid, onePhase);
            }
            for (i = 0; i < 2; ++i) {
                xid = this.newXID();
                session.start((Xid)xid, 0);
                for (int nqueues = 0; nqueues < NUMBER_OF_QUEUES; ++nqueues) {
                    ClientConsumer consumer = session.createConsumer(ADDRESS.concat(Integer.toString(nqueues)));
                    session.start();
                    for (int nmsg = 0; nmsg < NUMBER_OF_MSGS; ++nmsg) {
                        ClientMessage msg2 = consumer.receive(1000L);
                        Assertions.assertNotNull((Object)msg2);
                        Assertions.assertEquals((Object)("SimpleMessage" + nmsg), (Object)this.getTextMessage(msg2));
                        msg2.acknowledge();
                    }
                    msg = consumer.receive(1000L);
                    Assertions.assertNotNull((Object)msg);
                    Assertions.assertEquals((Object)"one more", (Object)this.getTextMessage(msg));
                    msg.acknowledge();
                    if (suspend) {
                        session.end((Xid)xid, 0x2000000);
                        session.start((Xid)xid, 0x8000000);
                    }
                    Assertions.assertEquals((Object)"one more", (Object)this.getTextMessage(msg));
                    if (isJoinSession) {
                        ClientSession newSession = this.sessionFactory.createSession(true, false, false);
                        newSession.start((Xid)xid, 0x200000);
                        newSession.start();
                        ClientConsumer newConsumer = newSession.createConsumer(ADDRESS.concat("-join." + nqueues));
                        msg = newConsumer.receive(1000L);
                        Assertions.assertNotNull((Object)msg);
                        Assertions.assertEquals((Object)"After Join", (Object)this.getTextMessage(msg));
                        msg.acknowledge();
                        newSession.end((Xid)xid, 0x4000000);
                        newSession.close();
                    }
                    Assertions.assertNull((Object)consumer.receiveImmediate());
                    consumer.close();
                }
                session.end((Xid)xid, 0x4000000);
                session.prepare((Xid)xid);
                if (recreateSession) {
                    session.close();
                    session = this.sessionFactory.createSession(true, false, false);
                }
                if (i == 0) {
                    session.rollback((Xid)xid);
                    continue;
                }
                session.commit((Xid)xid, false);
            }
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    private void doCompleteHeuristicallyCompletedXID(boolean isCommit, boolean heuristicCommit) throws Exception {
        XidImpl xid = this.newXID();
        this.clientSession.start((Xid)xid, 0);
        this.clientSession.end((Xid)xid, 0x4000000);
        this.clientSession.prepare((Xid)xid);
        String[] preparedTransactions = this.messagingService.getActiveMQServerControl().listPreparedTransactions();
        Assertions.assertEquals((int)1, (int)preparedTransactions.length);
        if (heuristicCommit) {
            Assertions.assertTrue((boolean)this.messagingService.getActiveMQServerControl().commitPreparedTransaction(XidImpl.toBase64String((Xid)xid)));
            Assertions.assertEquals((int)1, (int)this.messagingService.getActiveMQServerControl().listHeuristicCommittedTransactions().length);
        } else {
            Assertions.assertTrue((boolean)this.messagingService.getActiveMQServerControl().rollbackPreparedTransaction(XidImpl.toBase64String((Xid)xid)));
            Assertions.assertEquals((int)1, (int)this.messagingService.getActiveMQServerControl().listHeuristicRolledBackTransactions().length);
        }
        Assertions.assertEquals((int)0, (int)this.messagingService.getActiveMQServerControl().listPreparedTransactions().length);
        try {
            if (isCommit) {
                this.clientSession.commit((Xid)xid, false);
            } else {
                this.clientSession.rollback((Xid)xid);
            }
            Assertions.fail((String)"neither commit not rollback must succeed on a heuristically completed tx");
        }
        catch (XAException e) {
            if (heuristicCommit) {
                Assertions.assertEquals((int)7, (int)e.errorCode);
            }
            Assertions.assertEquals((int)6, (int)e.errorCode);
        }
        if (heuristicCommit) {
            Assertions.assertEquals((int)1, (int)this.messagingService.getActiveMQServerControl().listHeuristicCommittedTransactions().length);
        } else {
            Assertions.assertEquals((int)1, (int)this.messagingService.getActiveMQServerControl().listHeuristicRolledBackTransactions().length);
        }
    }

    class TxMessageHandler
    implements MessageHandler {
        boolean failedToAck = false;
        final ClientSession session;
        private final CountDownLatch latch;

        TxMessageHandler(ClientSession session, CountDownLatch latch) {
            this.latch = latch;
            this.session = session;
        }

        public void onMessage(ClientMessage message) {
            XidImpl xid = new XidImpl(UUIDGenerator.getInstance().generateStringUUID().getBytes(), 1, UUIDGenerator.getInstance().generateStringUUID().getBytes());
            try {
                this.session.start((Xid)xid, 0);
            }
            catch (XAException e) {
                e.printStackTrace();
            }
            try {
                message.acknowledge();
            }
            catch (ActiveMQException e) {
                logger.error("Failed to process message", (Throwable)e);
            }
            try {
                this.session.end((Xid)xid, 0x4000000);
                this.session.rollback((Xid)xid);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.failedToAck = true;
                try {
                    this.session.close();
                }
                catch (ActiveMQException activeMQException) {
                    // empty catch block
                }
            }
            this.latch.countDown();
        }
    }
}

