/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq;

import java.util.function.Function;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.messaging.activemq.Capabilities;

public class MessagingServices {
    public static final ServiceName ACTIVEMQ_CLIENT_THREAD_POOL = Capabilities.ACTIVEMQ_SERVER_CAPABILITY.getCapabilityServiceName().getParent().append(new String[]{"client-thread-pool"});
    private static final ServiceName COMMAND_DISPATCHER_FACTORY = Capabilities.ACTIVEMQ_SERVER_CAPABILITY.getCapabilityServiceName().getParent().append(new String[]{"command-dispatcher-factory"});
    static volatile CapabilityServiceSupport capabilityServiceSupport;
    public static final String LOCAL_TRANSACTION_PROVIDER_CAPABILITY = "org.wildfly.transactions.global-default-local-provider";
    public static final String TRANSACTION_XA_RESOURCE_RECOVERY_REGISTRY_CAPABILITY = "org.wildfly.transactions.xa-resource-recovery-registry";

    public static ServiceName getActiveMQServiceName(PathAddress pathAddress) {
        PathAddress serverPathAddress = MessagingServices.getActiveMQServerPathAddress(pathAddress);
        if (serverPathAddress != null && serverPathAddress.size() > 0) {
            return Capabilities.ACTIVEMQ_SERVER_CAPABILITY.getCapabilityServiceName(new String[]{serverPathAddress.getLastElement().getValue()});
        }
        return null;
    }

    public static PathAddress getActiveMQServerPathAddress(PathAddress pathAddress) {
        for (int i = pathAddress.size() - 1; i >= 0; --i) {
            PathElement pe = pathAddress.getElement(i);
            if (!"server".equals(pe.getKey())) continue;
            return pathAddress.subAddress(0, i + 1);
        }
        return PathAddress.EMPTY_ADDRESS;
    }

    public static ServiceName getActiveMQServiceName() {
        return Capabilities.ACTIVEMQ_SERVER_CAPABILITY.getCapabilityServiceName().getParent();
    }

    public static ServiceName getActiveMQServiceName(String serverName) {
        if (serverName == null || serverName.isEmpty()) {
            return MessagingServices.getActiveMQServiceName();
        }
        return Capabilities.ACTIVEMQ_SERVER_CAPABILITY.getCapabilityServiceName(new String[]{serverName});
    }

    public static ServiceName getQueueBaseServiceName(ServiceName serverServiceName) {
        return serverServiceName.append(new String[]{"queue"});
    }

    static ServiceName getHttpUpgradeServiceName(String activemqServerName, String acceptorName) {
        return MessagingServices.getActiveMQServiceName(activemqServerName).append(new String[]{"http-upgrade-service", acceptorName});
    }

    static ServiceName getLegacyHttpUpgradeServiceName(String activemqServerName, String acceptorName) {
        return MessagingServices.getActiveMQServiceName(activemqServerName).append(new String[]{"legacy", "http-upgrade-service", acceptorName});
    }

    public static ServiceName getJMSBridgeServiceName(String bridgeName) {
        return Capabilities.ACTIVEMQ_SERVER_CAPABILITY.getCapabilityServiceName().getParent().append(new String[]{"jms-bridge"}).append(new String[]{bridgeName});
    }

    public static ServiceName getBroadcastCommandDispatcherFactoryServiceName(String channelName) {
        return channelName != null ? COMMAND_DISPATCHER_FACTORY.append(new String[]{channelName}) : COMMAND_DISPATCHER_FACTORY;
    }

    public static ServiceName getCapabilityServiceName(String capabilityBaseName, String ... dynamicParts) {
        if (capabilityServiceSupport == null) {
            throw new IllegalStateException();
        }
        if (dynamicParts == null || dynamicParts.length == 0) {
            return capabilityServiceSupport.getCapabilityServiceName(capabilityBaseName);
        }
        return capabilityServiceSupport.getCapabilityServiceName(capabilityBaseName, dynamicParts);
    }

    public static boolean isSubsystemResource(OperationContext context) {
        return context.getCurrentAddress().size() > 0 && "subsystem".equals(context.getCurrentAddress().getParent().getLastElement().getKey());
    }

    public static class ServerNameMapper
    implements Function<PathAddress, String[]> {
        private final String name;

        public ServerNameMapper(String name) {
            this.name = name;
        }

        @Override
        public String[] apply(PathAddress pathAddress) {
            PathAddress serverAddress = MessagingServices.getActiveMQServerPathAddress(pathAddress);
            if (serverAddress.size() > 0) {
                String servername = MessagingServices.getActiveMQServerPathAddress(pathAddress).getLastElement().getValue();
                return new String[]{servername, this.name, pathAddress.getLastElement().getValue()};
            }
            return new String[]{this.name, pathAddress.getLastElement().getValue()};
        }
    }
}

