/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.LogManager;
import org.jboss.as.cli.impl.CliLauncher;
import org.jboss.logging.Logger;
import org.jboss.logmanager.Configurator;
import org.jboss.logmanager.LogContext;
import org.jboss.logmanager.PropertyConfigurator;

public class CommandLineMain {
    public static void main(String[] args) throws Exception {
        CommandLineMain.configureLogManager(args);
        CommandLineMain.createClientMarker();
        CliLauncher.main(args);
    }

    private static void configureLogManager(String[] args) {
        block10: {
            if (CommandLineMain.getSystemProperty("java.util.logging.manager") == null) {
                try {
                    CommandLineMain.setSystemProperty("java.util.logging.manager", "org.jboss.logmanager.LogManager");
                    String logLevel = CommandLineMain.parseValue(CommandLineMain.getSystemProperty("jboss.cli.log.level"));
                    for (String arg : args) {
                        if (arg.startsWith("-Djboss.cli.log.level")) {
                            logLevel = CommandLineMain.parseValue(arg);
                            continue;
                        }
                        if (!arg.startsWith("-Dlogging.configuration")) continue;
                        CommandLineMain.setSystemProperty("logging.configuration", CommandLineMain.parseValue(arg));
                    }
                    if (logLevel == null) {
                        return;
                    }
                    LogManager logManager = LogManager.getLogManager();
                    if (!(logManager instanceof org.jboss.logmanager.LogManager)) break block10;
                    logManager.readConfiguration();
                    if (LogContext.getSystemLogContext().getAttachment("", Configurator.ATTACHMENT_KEY) != null || "OFF".equalsIgnoreCase(logLevel)) break block10;
                    try {
                        PropertyConfigurator configurator = new PropertyConfigurator();
                        Configurator appearing = (Configurator)LogContext.getSystemLogContext().getLogger("").attachIfAbsent(Configurator.ATTACHMENT_KEY, (Object)configurator);
                        if (appearing == null) {
                            configurator.configure(CommandLineMain.createLogManagerConfig(logLevel));
                        }
                    }
                    catch (IOException e) {
                        System.err.println("ERROR: Could not configure LogManager");
                        e.printStackTrace();
                    }
                }
                catch (SecurityException e) {
                    System.err.println("ERROR: Could not configure LogManager");
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    private static String getSystemProperty(final String key) {
        if (System.getSecurityManager() == null) {
            return System.getProperty(key);
        }
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(key);
            }
        });
    }

    private static void setSystemProperty(final String key, final String value) {
        if (System.getSecurityManager() == null) {
            System.setProperty(key, value);
        } else {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    System.setProperty(key, value);
                    return null;
                }
            });
        }
    }

    private static String parseValue(String prop) {
        int index;
        if (prop != null && (index = prop.indexOf(61)) > 0 && prop.length() > index + 1) {
            return prop.substring(index + 1, prop.length());
        }
        return null;
    }

    private static Properties createLogManagerConfig(String level) {
        Properties properties = new Properties();
        properties.setProperty("logger.level", level.toUpperCase(Locale.ENGLISH));
        properties.setProperty("logger.handlers", "FILE");
        properties.setProperty("handler.FILE", "org.jboss.logmanager.handlers.FileHandler");
        properties.setProperty("handler.FILE.properties", "autoFlush,append,fileName,enabled");
        properties.setProperty("handler.FILE.constructorProperties", "fileName,append");
        properties.setProperty("handler.FILE.append", "true");
        properties.setProperty("handler.FILE.autoFlush", "true");
        properties.setProperty("handler.FILE.fileName", "${jboss.cli.log.file:jboss-cli.log}");
        properties.setProperty("handler.FILE.formatter", "PATTERN");
        properties.setProperty("formatter.PATTERN", "org.jboss.logmanager.formatters.PatternFormatter");
        properties.setProperty("formatter.PATTERN.pattern", "%d{yyyy-MM-dd HH:mm:ss,SSS} %-5p [%c] (%t) %s%e%n");
        properties.setProperty("formatter.PATTERN.properties", "pattern");
        return properties;
    }

    private static void createClientMarker() {
        block8: {
            try {
                String jbossHome = System.getenv("JBOSS_HOME");
                if (jbossHome == null) break block8;
                Path cliMarkerPath = Paths.get(jbossHome, new String[0]).resolve("bin").resolve("cli-marker");
                Files.deleteIfExists(cliMarkerPath);
                Files.createFile(cliMarkerPath, new FileAttribute[0]);
                File cliMarkerFile = cliMarkerPath.toFile();
                cliMarkerFile.deleteOnExit();
                String data = String.valueOf(System.currentTimeMillis());
                try (FileWriter writer = new FileWriter(cliMarkerFile, true);){
                    writer.write(data);
                }
                System.setProperty("cli-marker-value", data);
            }
            catch (SecurityException e) {
                throw e;
            }
            catch (Exception e) {
                Logger.getLogger(CommandLineMain.class).debug((Object)"Creation of cli marker failed and will be ignored.", (Throwable)e);
            }
        }
    }
}

