/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.transform;

import java.util.EnumSet;
import java.util.function.Function;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.ModelVersionRange;
import org.jboss.as.controller.SubsystemModel;
import org.jboss.as.controller.SubsystemResourceRegistration;
import org.jboss.as.controller.transform.ExtensionTransformerRegistration;
import org.jboss.as.controller.transform.SubsystemTransformerRegistration;
import org.jboss.as.controller.transform.description.TransformationDescription;

public class SubsystemExtensionTransformerRegistration
implements ExtensionTransformerRegistration {
    private final String name;
    private final Iterable<? extends SubsystemModel> legacyModels;
    private final Function<ModelVersion, TransformationDescription> factory;

    protected <E extends Enum<E>> SubsystemExtensionTransformerRegistration(SubsystemResourceRegistration description, E currentModel, Function<ModelVersion, TransformationDescription> factory) {
        this(description.getName(), currentModel, factory);
    }

    protected <E extends Enum<E>> SubsystemExtensionTransformerRegistration(String name, E currentModel, Function<ModelVersion, TransformationDescription> factory) {
        this.name = name;
        this.legacyModels = EnumSet.complementOf(EnumSet.of(currentModel));
        this.factory = factory;
    }

    @Override
    public String getSubsystemName() {
        return this.name;
    }

    @Override
    public void registerTransformers(SubsystemTransformerRegistration subsystemRegistration) {
        for (SubsystemModel subsystemModel : this.legacyModels) {
            ModelVersion legacyVersion = subsystemModel.getVersion();
            TransformationDescription.Tools.register(this.factory.apply(legacyVersion), subsystemRegistration, (ModelVersionRange)legacyVersion);
        }
    }
}

