/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.plugin.config.generator;

import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.galleon.Errors;
import org.jboss.galleon.MessageWriter;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.plugin.ProvisionedConfigHandler;
import org.jboss.galleon.progresstracking.ProgressTracker;
import org.jboss.galleon.runtime.ProvisioningRuntime;
import org.jboss.galleon.state.ProvisionedConfig;
import org.wildfly.galleon.plugin.config.generator.BaseConfigGenerator;
import org.wildfly.galleon.plugin.config.generator.ForkedConfigGenerator;
import org.wildfly.galleon.plugin.config.generator.WfProvisionedConfigHandler;
import org.wildfly.galleon.plugin.server.ConfigGeneratorException;
import org.wildfly.galleon.plugin.server.ForkCallback;
import org.wildfly.galleon.plugin.server.ForkedEmbeddedUtil;

public class WfConfigGenerator
extends BaseConfigGenerator {
    private MessageWriter messageWriter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(ProvisioningRuntime runtime, boolean forkEmbedded) throws ProvisioningException {
        this.messageWriter = runtime.getMessageWriter();
        this.forkEmbedded = forkEmbedded;
        this.jbossHome = runtime.getStagedDir().toString();
        HashMap<Object, Object> originalProps = forkEmbedded ? null : new HashMap<Object, Object>(System.getProperties());
        try {
            this.doGenerate(runtime);
        }
        finally {
            this.cleanup(originalProps);
        }
    }

    private void doGenerate(ProvisioningRuntime runtime) throws ProvisioningException {
        if (this.messageWriter.isVerboseEnabled()) {
            this.messageWriter.verbose("Generating WildFly-based configs forkEmbedded=%s", new Object[]{this.forkEmbedded});
        }
        if (this.forkEmbedded) {
            this.initScriptWriter(runtime);
        }
        ProgressTracker progressTracker = runtime.getLayout().getFactory().getProgressTracker("CONFIGS");
        try (WfProvisionedConfigHandler configHandler = new WfProvisionedConfigHandler(runtime, this);){
            List configs = runtime.getConfigs();
            progressTracker.starting((long)configs.size());
            for (ProvisionedConfig config : configs) {
                progressTracker.processing((Object)config);
                if (runtime.getMessageWriter().isVerboseEnabled()) {
                    StringBuilder msg = new StringBuilder(64).append("Feature config");
                    if (config.getModel() != null) {
                        msg.append(" model=").append(config.getModel());
                    }
                    if (config.getName() != null) {
                        msg.append(" name=").append(config.getName());
                    }
                    this.messageWriter.verbose((CharSequence)msg);
                    if (config.hasProperties()) {
                        this.messageWriter.verbose((CharSequence)"  properties");
                        for (Map.Entry entry : config.getProperties().entrySet()) {
                            this.messageWriter.verbose("    %s=%s", new Object[]{entry.getKey(), entry.getValue()});
                        }
                    }
                }
                config.handle((ProvisionedConfigHandler)configHandler);
                progressTracker.processed((Object)config);
            }
            progressTracker.complete();
        }
        if (this.forkEmbedded) {
            this.scriptWriter.close();
            this.scriptWriter = null;
            ForkedEmbeddedUtil.fork((ForkCallback)new ForkedConfigGenerator(), (String[])new String[]{this.jbossHome, this.script.toString()});
        }
    }

    private void cleanup(Map<?, ?> originalProps) {
        if (this.embeddedProcess != null) {
            try {
                this.stopEmbedded();
            }
            catch (ConfigGeneratorException e) {
                e.printStackTrace();
            }
        }
        if (this.scriptWriter != null) {
            this.scriptWriter.close();
        } else if (originalProps != null) {
            ArrayList<String> toClear = new ArrayList<String>();
            for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
                Object value = originalProps.get(entry.getKey());
                if (value != null) {
                    System.setProperty(entry.getKey().toString(), value.toString());
                    continue;
                }
                toClear.add(entry.getKey().toString());
            }
            if (!toClear.isEmpty()) {
                for (String string : toClear) {
                    System.clearProperty(string);
                }
            }
        }
    }

    private void initScriptWriter(ProvisioningRuntime runtime) throws ProvisioningException {
        this.scriptBuf = new StringBuilder();
        this.script = runtime.getTmpPath(new String[]{"forkedembedded.txt"});
        try {
            Files.createDirectories(this.script.getParent(), new FileAttribute[0]);
            this.scriptWriter = new PrintWriter(Files.newBufferedWriter(this.script, new OpenOption[0]));
        }
        catch (IOException e) {
            throw new ProvisioningException(Errors.writeFile((Path)this.script), (Throwable)e);
        }
    }

    void startServer(String ... args) throws ProvisioningException {
        try {
            if (this.forkEmbedded) {
                this.writeScript("standalone");
                this.writeArgs(args);
            } else {
                this.doStartServer(args);
            }
        }
        catch (ConfigGeneratorException e) {
            throw new ProvisioningException((Throwable)e);
        }
    }

    void startHc(String ... args) throws ProvisioningException {
        try {
            if (this.forkEmbedded) {
                this.writeScript("host");
                this.writeArgs(args);
            } else {
                this.doStartHc(args);
            }
        }
        catch (ConfigGeneratorException e) {
            throw new ProvisioningException((Throwable)e);
        }
    }

    private void writeArgs(String ... args) throws ConfigGeneratorException {
        this.scriptBuf.setLength(0);
        this.scriptBuf.append(args[0]);
        for (int i = 1; i < args.length; ++i) {
            this.scriptBuf.append(',').append(args[i]);
        }
        this.writeScript(this.scriptBuf.toString());
    }
}

