/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component.deployers;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.BasicComponent;
import org.jboss.as.ee.component.BasicComponentCreateService;
import org.jboss.as.ee.component.BindingConfiguration;
import org.jboss.as.ee.component.ClassDescriptionTraversal;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ComponentNamingMode;
import org.jboss.as.ee.component.ComponentRegistry;
import org.jboss.as.ee.component.ComponentStartService;
import org.jboss.as.ee.component.DependencyConfigurator;
import org.jboss.as.ee.component.EEApplicationClasses;
import org.jboss.as.ee.component.EEModuleClassDescription;
import org.jboss.as.ee.component.EEModuleConfiguration;
import org.jboss.as.ee.component.InjectionSource;
import org.jboss.as.ee.component.InterceptorDescription;
import org.jboss.as.ee.component.ViewConfiguration;
import org.jboss.as.ee.component.ViewService;
import org.jboss.as.ee.logging.EeLogger;
import org.jboss.as.ee.metadata.MetadataCompleteMarker;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.deployment.JndiNamingDependencyProcessor;
import org.jboss.as.naming.service.BinderService;
import org.jboss.as.naming.service.NamingStoreService;
import org.jboss.as.server.CurrentServiceContainer;
import org.jboss.as.server.Services;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.modules.Module;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.CircularDependencyException;
import org.jboss.msc.service.DuplicateServiceException;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

public final class ComponentInstallProcessor
implements DeploymentUnitProcessor {
    private static final ServiceName JNDI_BINDINGS_SERVICE = ServiceName.of((String[])new String[]{"JndiBindingsService"});
    private static final List<String> SPEC_COMPONENTS = List.of("BeanManager", "DefaultContextService", "DefaultDataSource", "DefaultJMSConnectionFactory", "DefaultManagedExecutorService", "DefaultManagedScheduledExecutorService", "DefaultManagedThreadFactory", "EJBContext", "HandleDelegate", "InAppClientContainer", "InstanceName", "ModuleName", "ORB", "TimerService", "TransactionSynchronizationRegistry", "Validator", "ValidatorFactory");

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        Module module = (Module)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.MODULE);
        EEModuleConfiguration moduleConfiguration = (EEModuleConfiguration)deploymentUnit.getAttachment(Attachments.EE_MODULE_CONFIGURATION);
        if (module == null || moduleConfiguration == null) {
            return;
        }
        ComponentRegistry componentRegistry = (ComponentRegistry)deploymentUnit.getAttachment(Attachments.COMPONENT_REGISTRY);
        List dependencies = deploymentUnit.getAttachmentList(org.jboss.as.server.deployment.Attachments.JNDI_DEPENDENCIES);
        ServiceName bindingDependencyService = JndiNamingDependencyProcessor.serviceName((ServiceName)deploymentUnit.getServiceName());
        for (ComponentConfiguration configuration : moduleConfiguration.getComponentConfigurations()) {
            try {
                EeLogger.ROOT_LOGGER.tracef("Installing component %s", configuration.getComponentClass().getName());
                this.deployComponent(phaseContext, configuration, dependencies, bindingDependencyService);
                componentRegistry.addComponent(configuration);
                deploymentUnit.addToAttachmentList(org.jboss.as.server.deployment.Attachments.WEB_DEPENDENCIES, (Object)configuration.getComponentDescription().getStartServiceName());
            }
            catch (Exception e) {
                throw EeLogger.ROOT_LOGGER.failedToInstallComponent(e, configuration.getComponentName());
            }
        }
    }

    protected void deployComponent(final DeploymentPhaseContext phaseContext, final ComponentConfiguration configuration, List<ServiceName> jndiDependencies, ServiceName bindingDependencyService) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        final ServiceTarget serviceTarget = phaseContext.getServiceTarget();
        String applicationName = configuration.getApplicationName();
        String moduleName = configuration.getModuleName();
        String componentName = configuration.getComponentName();
        EEApplicationClasses applicationClasses = (EEApplicationClasses)deploymentUnit.getAttachment(Attachments.EE_APPLICATION_CLASSES_DESCRIPTION);
        Module module = (Module)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.MODULE);
        ServiceName createServiceName = configuration.getComponentDescription().getCreateServiceName();
        ServiceName startServiceName = configuration.getComponentDescription().getStartServiceName();
        BasicComponentCreateService createService = configuration.getComponentCreateServiceFactory().constructService(configuration);
        ServiceBuilder createBuilder = serviceTarget.addService(createServiceName, (Service)createService);
        ComponentStartService startService = new ComponentStartService();
        ServiceBuilder startBuilder = serviceTarget.addService(startServiceName, (Service)startService);
        deploymentUnit.addToAttachmentList(org.jboss.as.server.deployment.Attachments.DEPLOYMENT_COMPLETE_SERVICES, (Object)startServiceName);
        ServiceName jndiDepServiceName = configuration.getComponentDescription().getServiceName().append(JNDI_BINDINGS_SERVICE);
        final ServiceBuilder jndiDepServiceBuilder = serviceTarget.addService(jndiDepServiceName, Service.NULL);
        jndiDependencies.add(jndiDepServiceName);
        for (DependencyConfigurator<? extends Service<Component>> dependencyConfigurator : configuration.getCreateDependencies()) {
            dependencyConfigurator.configureDependency(createBuilder, createService);
        }
        for (DependencyConfigurator<Object> dependencyConfigurator : configuration.getStartDependencies()) {
            dependencyConfigurator.configureDependency(startBuilder, startService);
        }
        startBuilder.addDependency(createServiceName, BasicComponent.class, startService.getComponentInjector());
        Services.addServerExecutorDependency((ServiceBuilder)startBuilder, startService.getExecutorInjector());
        startBuilder.requires(bindingDependencyService);
        if (configuration.getComponentDescription().getNamingMode() == ComponentNamingMode.CREATE) {
            NamingStoreService namingStoreService = new NamingStoreService(true);
            serviceTarget.addService(configuration.getComponentDescription().getContextServiceName(), (Service)namingStoreService).install();
        }
        final InjectionSource.ResolutionContext resolutionContext = new InjectionSource.ResolutionContext(configuration.getComponentDescription().getNamingMode() == ComponentNamingMode.USE_MODULE, configuration.getComponentName(), configuration.getModuleName(), configuration.getApplicationName());
        for (ViewConfiguration viewConfiguration : configuration.getViews()) {
            ServiceName serviceName = viewConfiguration.getViewServiceName();
            ViewService viewService = new ViewService(viewConfiguration);
            ServiceBuilder componentViewServiceBuilder = serviceTarget.addService(serviceName, (Service)viewService);
            componentViewServiceBuilder.addDependency(createServiceName, Component.class, viewService.getComponentInjector());
            for (DependencyConfigurator<ViewService> depConfig : viewConfiguration.getDependencies()) {
                depConfig.configureDependency(componentViewServiceBuilder, viewService);
            }
            componentViewServiceBuilder.install();
            startBuilder.requires(serviceName);
            for (BindingConfiguration bindingConfiguration : viewConfiguration.getBindingConfigurations()) {
                String bindingName = bindingConfiguration.getName();
                ContextNames.BindInfo bindInfo = ContextNames.bindInfoFor((String)applicationName, (String)moduleName, (String)componentName, (String)bindingName);
                BinderService service = new BinderService(bindInfo.getBindName(), (Object)bindingConfiguration.getSource());
                jndiDepServiceBuilder.requires(bindInfo.getBinderServiceName());
                ServiceBuilder serviceBuilder = serviceTarget.addService(bindInfo.getBinderServiceName(), (Service)service);
                bindingConfiguration.getSource().getResourceValue(resolutionContext, serviceBuilder, phaseContext, (Injector<ManagedReferenceFactory>)service.getManagedObjectInjector());
                serviceBuilder.addDependency(bindInfo.getParentContextServiceName(), ServiceBasedNamingStore.class, (Injector)service.getNamingStoreInjector());
                try {
                    serviceBuilder.install();
                }
                catch (DuplicateServiceException e) {
                    this.handleDuplicateService(configuration, bindInfo.getAbsoluteJndiName());
                    throw e;
                }
            }
        }
        if (configuration.getComponentDescription().getNamingMode() == ComponentNamingMode.CREATE) {
            final HashSet<ServiceName> bound = new HashSet<ServiceName>();
            this.processBindings(phaseContext, configuration, serviceTarget, resolutionContext, configuration.getComponentDescription().getBindingConfigurations(), jndiDepServiceBuilder, bound);
            if (!MetadataCompleteMarker.isMetadataComplete(phaseContext.getDeploymentUnit())) {
                new ClassDescriptionTraversal(configuration.getComponentClass(), applicationClasses){

                    @Override
                    protected void handle(Class<?> clazz, EEModuleClassDescription classDescription) throws DeploymentUnitProcessingException {
                        if (classDescription != null) {
                            ComponentInstallProcessor.this.processBindings(phaseContext, configuration, serviceTarget, resolutionContext, classDescription.getBindingConfigurations(), jndiDepServiceBuilder, bound);
                        }
                    }
                }.run();
                for (InterceptorDescription interceptor : configuration.getComponentDescription().getAllInterceptors()) {
                    Class interceptorClass;
                    try {
                        interceptorClass = module.getClassLoader().loadClass(interceptor.getInterceptorClassName());
                    }
                    catch (ClassNotFoundException e) {
                        throw EeLogger.ROOT_LOGGER.cannotLoadInterceptor(e, interceptor.getInterceptorClassName(), configuration.getComponentClass());
                    }
                    if (interceptorClass == null) continue;
                    new ClassDescriptionTraversal(interceptorClass, applicationClasses){

                        @Override
                        protected void handle(Class<?> clazz, EEModuleClassDescription classDescription) throws DeploymentUnitProcessingException {
                            if (classDescription != null) {
                                ComponentInstallProcessor.this.processBindings(phaseContext, configuration, serviceTarget, resolutionContext, classDescription.getBindingConfigurations(), jndiDepServiceBuilder, bound);
                            }
                        }
                    }.run();
                }
            }
        }
        createBuilder.install();
        startBuilder.install();
        jndiDepServiceBuilder.install();
    }

    private void processBindings(DeploymentPhaseContext phaseContext, ComponentConfiguration configuration, ServiceTarget serviceTarget, InjectionSource.ResolutionContext resolutionContext, List<BindingConfiguration> bindings, ServiceBuilder<?> jndiDepServiceBuilder, Set<ServiceName> bound) throws DeploymentUnitProcessingException {
        for (BindingConfiguration bindingConfiguration : bindings) {
            if (!bindingConfiguration.getName().startsWith("java:comp") && bindingConfiguration.getName().startsWith("java:")) continue;
            Object bindingName = bindingConfiguration.getName().startsWith("java:comp") ? bindingConfiguration.getName() : "java:comp/env/" + bindingConfiguration.getName();
            ContextNames.BindInfo bindInfo = ContextNames.bindInfoForEnvEntry((String)configuration.getApplicationName(), (String)configuration.getModuleName(), (String)configuration.getComponentName(), (configuration.getComponentDescription().getNamingMode() == ComponentNamingMode.CREATE ? 1 : 0) != 0, (String)bindingName);
            if (bound.contains(bindInfo.getBinderServiceName())) continue;
            bound.add(bindInfo.getBinderServiceName());
            try {
                BinderService service = new BinderService(bindInfo.getBindName(), (Object)bindingConfiguration.getSource());
                jndiDepServiceBuilder.requires(bindInfo.getBinderServiceName());
                ServiceBuilder serviceBuilder = serviceTarget.addService(bindInfo.getBinderServiceName(), (Service)service);
                bindingConfiguration.getSource().getResourceValue(resolutionContext, serviceBuilder, phaseContext, (Injector<ManagedReferenceFactory>)service.getManagedObjectInjector());
                serviceBuilder.addDependency(bindInfo.getParentContextServiceName(), ServiceBasedNamingStore.class, (Injector)service.getNamingStoreInjector());
                serviceBuilder.install();
            }
            catch (DuplicateServiceException e) {
                ServiceController registered = CurrentServiceContainer.getServiceContainer().getService(bindInfo.getBinderServiceName());
                if (registered == null) {
                    throw e;
                }
                BinderService service = (BinderService)registered.getService();
                if (service.getSource().equals(bindingConfiguration.getSource())) continue;
                throw EeLogger.ROOT_LOGGER.conflictingBinding((String)bindingName, bindingConfiguration.getSource());
            }
            catch (CircularDependencyException e) {
                throw EeLogger.ROOT_LOGGER.circularDependency((String)bindingName);
            }
        }
    }

    private void handleDuplicateService(ComponentConfiguration configuration, String bindingName) {
        String name = configuration.getComponentName();
        if (SPEC_COMPONENTS.contains(name)) {
            Class<?> conflict = configuration.getComponentClass();
            EeLogger.ROOT_LOGGER.duplicateJndiBindingFound(name, bindingName, conflict);
        }
    }
}

