/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.remote.protocol.versionone;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.ExecutorService;
import org.jboss.as.ejb3.component.EJBComponent;
import org.jboss.as.ejb3.component.stateful.StatefulSessionComponent;
import org.jboss.as.ejb3.deployment.DeploymentRepository;
import org.jboss.as.ejb3.deployment.EjbDeploymentInformation;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.remote.protocol.versionone.ChannelAssociation;
import org.jboss.as.ejb3.remote.protocol.versionone.EJBIdentifierBasedMessageHandler;
import org.jboss.ejb.client.Affinity;
import org.jboss.ejb.client.SessionID;
import org.jboss.ejb.client.remoting.PackedInteger;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.MarshallerFactory;
import org.jboss.remoting3.MessageOutputStream;
import org.xnio.IoUtils;

class SessionOpenRequestHandler
extends EJBIdentifierBasedMessageHandler {
    private static final byte HEADER_SESSION_OPEN_RESPONSE = 2;
    private static final byte HEADER_EJB_NOT_STATEFUL = 13;
    private final ExecutorService executorService;
    private final MarshallerFactory marshallerFactory;

    SessionOpenRequestHandler(DeploymentRepository deploymentRepository, MarshallerFactory marshallerFactory, ExecutorService executorService) {
        super(deploymentRepository);
        this.marshallerFactory = marshallerFactory;
        this.executorService = executorService;
    }

    @Override
    public void processMessage(ChannelAssociation channelAssociation, InputStream inputStream) throws IOException {
        String beanName;
        String distinctName;
        String moduleName;
        if (inputStream == null) {
            throw EjbLogger.ROOT_LOGGER.messageInputStreamCannotBeNull();
        }
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        short invocationId = dataInputStream.readShort();
        String appName = dataInputStream.readUTF();
        EjbDeploymentInformation ejbDeploymentInformation = this.findEJB(appName, moduleName = dataInputStream.readUTF(), distinctName = dataInputStream.readUTF(), beanName = dataInputStream.readUTF());
        if (ejbDeploymentInformation == null) {
            this.writeNoSuchEJBFailureMessage(channelAssociation, invocationId, appName, moduleName, distinctName, beanName, null);
            return;
        }
        EJBComponent component = ejbDeploymentInformation.getEjbComponent();
        if (!(component instanceof StatefulSessionComponent)) {
            String failureMessage = EjbLogger.ROOT_LOGGER.notStatefulSessionBean(beanName, appName, moduleName, distinctName).getLocalizedMessage();
            this.writeInvocationFailure(channelAssociation, (byte)13, invocationId, failureMessage);
            return;
        }
        StatefulSessionComponent statefulSessionComponent = (StatefulSessionComponent)component;
        this.executorService.submit(new SessionIDGeneratorTask(statefulSessionComponent, channelAssociation, invocationId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeSessionId(ChannelAssociation channelAssociation, short invocationId, SessionID sessionID, Affinity hardAffinity) throws IOException {
        MessageOutputStream messageOutputStream;
        byte[] sessionIdBytes = sessionID.getEncodedForm();
        try {
            messageOutputStream = channelAssociation.acquireChannelMessageOutputStream();
        }
        catch (Exception e) {
            throw EjbLogger.ROOT_LOGGER.failedToOpenMessageOutputStream(e);
        }
        DataOutputStream dataOutputStream = new DataOutputStream((OutputStream)messageOutputStream);
        try {
            dataOutputStream.writeByte(2);
            dataOutputStream.writeShort(invocationId);
            PackedInteger.writePackedInteger((DataOutput)dataOutputStream, (int)sessionIdBytes.length);
            dataOutputStream.write(sessionIdBytes);
            Marshaller marshaller = this.prepareForMarshalling(this.marshallerFactory, dataOutputStream);
            marshaller.writeObject((Object)hardAffinity);
            marshaller.finish();
        }
        finally {
            channelAssociation.releaseChannelMessageOutputStream(messageOutputStream);
            dataOutputStream.close();
        }
    }

    private class SessionIDGeneratorTask
    implements Runnable {
        private final StatefulSessionComponent statefulSessionComponent;
        private final ChannelAssociation channelAssociation;
        private final short invocationId;

        SessionIDGeneratorTask(StatefulSessionComponent statefulSessionComponent, ChannelAssociation channelAssociation, short invocationId) {
            this.statefulSessionComponent = statefulSessionComponent;
            this.invocationId = invocationId;
            this.channelAssociation = channelAssociation;
        }

        @Override
        public void run() {
            try {
                SessionID sessionID;
                try {
                    sessionID = this.statefulSessionComponent.createSessionRemote();
                }
                catch (Throwable t) {
                    EjbLogger.ROOT_LOGGER.exceptionGeneratingSessionId(t, this.statefulSessionComponent.getComponentName(), this.invocationId, this.channelAssociation.getChannel());
                    SessionOpenRequestHandler.this.writeException(this.channelAssociation, SessionOpenRequestHandler.this.marshallerFactory, this.invocationId, t, null);
                    return;
                }
                Affinity hardAffinity = this.statefulSessionComponent.getCache().getStrictAffinity();
                SessionOpenRequestHandler.this.writeSessionId(this.channelAssociation, this.invocationId, sessionID, hardAffinity);
            }
            catch (IOException ioe) {
                EjbLogger.ROOT_LOGGER.exceptionGeneratingSessionId(ioe, this.statefulSessionComponent.getComponentName(), this.invocationId, this.channelAssociation.getChannel());
                IoUtils.safeClose((Closeable)this.channelAssociation.getChannel());
                return;
            }
        }
    }
}

