package org.jboss.as.ejb3.logging;

import java.util.Locale;
import javax.ejb.NoSuchEJBException;
import java.io.Serializable;
import java.lang.String;
import javax.transaction.RollbackException;
import javax.ejb.LockType;
import org.jboss.as.ejb3.component.EJBComponentDescription;
import javax.ejb.EJBAccessException;
import org.jboss.as.ejb3.concurrency.LockableComponent;
import org.jboss.as.controller.PathElement;
import javax.ejb.NoMoreTimeoutsException;
import org.jboss.invocation.InterceptorContext;
import org.jboss.as.ee.component.ComponentInstance;
import java.util.concurrent.TimeUnit;
import javax.resource.ResourceException;
import org.jboss.as.ejb3.tx.TimerTransactionRolledBackException;
import java.lang.IllegalArgumentException;
import java.lang.UnsupportedOperationException;
import java.util.concurrent.TimeoutException;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.as.ejb3.component.EJBComponentUnavailableException;
import java.lang.reflect.Method;
import javax.transaction.Transaction;
import javax.ejb.RemoveException;
import java.util.concurrent.CancellationException;
import org.jboss.as.ee.component.ResourceInjectionTarget;
import org.jboss.msc.service.ServiceController.State;
import java.lang.Throwable;
import org.jboss.as.ee.component.ComponentCreateServiceFactory;
import java.lang.Object;
import java.util.Arrays;
import javax.ejb.EJBException;
import javax.ejb.ConcurrentAccessTimeoutException;
import javax.ejb.TimerHandle;
import org.jboss.dmr.ModelNode;
import javax.transaction.NotSupportedException;
import java.io.File;
import javax.ejb.EJBTransactionRequiredException;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import java.lang.IllegalStateException;
import javax.ejb.IllegalLoopbackException;
import java.lang.StringBuilder;
import java.sql.SQLException;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.as.ejb3.component.stateful.StatefulSessionComponentInstance;
import javax.resource.spi.UnavailableException;
import org.jboss.jca.core.spi.rar.NotFoundException;
import org.jboss.logging.Logger;
import org.jboss.as.naming.context.NamespaceContextSelector;
import java.lang.RuntimeException;
import org.jboss.logging.BasicLogger;
import org.jboss.as.ejb3.subsystem.deployment.EJBComponentType;
import org.jboss.as.ee.component.Component;
import javax.interceptor.InvocationContext;
import javax.naming.Context;
import javax.ejb.ScheduleExpression;
import javax.resource.spi.endpoint.MessageEndpoint;
import javax.annotation.Generated;
import org.jboss.as.controller.OperationFailedException;
import java.lang.SecurityException;
import java.io.IOException;
import org.jboss.metadata.ejb.spec.MethodParametersMetaData;
import org.jboss.invocation.proxy.MethodIdentifier;
import java.util.Date;
import java.lang.Exception;
import java.lang.Integer;
import javax.ejb.NoSuchObjectLocalException;
import javax.ejb.Timer;
import org.jboss.as.ejb3.subsystem.deployment.InstalledComponent;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.PathAddress;
import org.jboss.jandex.MethodInfo;
import org.jboss.as.ejb3.timerservice.TimerImpl;
import java.rmi.RemoteException;
import org.jboss.as.server.deployment.DeploymentUnit;
import javax.ejb.TransactionAttributeType;
import org.jboss.jandex.ClassInfo;
import javax.xml.stream.Location;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2017-08-25T20:12:21-0500")
public class EjbLogger_$logger extends DelegatingBasicLogger implements EjbLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = EjbLogger_$logger.class.getName();
    public EjbLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void getTxManagerStatusFailed(final Throwable cause) {
        super.log.logf(FQCN, ERROR, cause, getTxManagerStatusFailed$str());
    }
    private static final String getTxManagerStatusFailed = "WFLYEJB0004: failed to get tx manager status; ignoring";
    protected String getTxManagerStatusFailed$str() {
        return getTxManagerStatusFailed;
    }
    @Override
    public final void setRollbackOnlyFailed(final Throwable se) {
        super.log.logf(FQCN, ERROR, se, setRollbackOnlyFailed$str());
    }
    private static final String setRollbackOnlyFailed = "WFLYEJB0005: failed to set rollback only; ignoring";
    protected String setRollbackOnlyFailed$str() {
        return setRollbackOnlyFailed;
    }
    @Override
    public final void activationConfigPropertyIgnored(final Object propName, final String resourceAdapterName) {
        super.log.logf(FQCN, WARN, null, activationConfigPropertyIgnored$str(), propName, resourceAdapterName);
    }
    private static final String activationConfigPropertyIgnored = "WFLYEJB0006: ActivationConfigProperty %s will be ignored since it is not allowed by resource adapter: %s";
    protected String activationConfigPropertyIgnored$str() {
        return activationConfigPropertyIgnored;
    }
    @Override
    public final void discardingStatefulComponent(final StatefulSessionComponentInstance component, final Throwable t) {
        super.log.logf(FQCN, ERROR, t, discardingStatefulComponent$str(), component);
    }
    private static final String discardingStatefulComponent = "WFLYEJB0007: Discarding stateful component instance: %s due to exception";
    protected String discardingStatefulComponent$str() {
        return discardingStatefulComponent;
    }
    @Override
    public final void defaultInterceptorClassNotListed(final String clazz) {
        super.log.logf(FQCN, WARN, null, defaultInterceptorClassNotListed$str(), clazz);
    }
    private static final String defaultInterceptorClassNotListed = "WFLYEJB0010: Default interceptor class %s is not listed in the <interceptors> section of ejb-jar.xml and will not be applied";
    protected String defaultInterceptorClassNotListed$str() {
        return defaultInterceptorClassNotListed;
    }
    @Override
    public final void unknownTimezoneId(final String timezoneId, final String id) {
        super.log.logf(FQCN, WARN, null, unknownTimezoneId$str(), timezoneId, id);
    }
    private static final String unknownTimezoneId = "WFLYEJB0015: Unknown timezone id: %s found in schedule expression. Ignoring it and using server's timezone: %s";
    protected String unknownTimezoneId$str() {
        return unknownTimezoneId;
    }
    @Override
    public final void timerPersistenceNotEnable() {
        super.log.logf(FQCN, WARN, null, timerPersistenceNotEnable$str());
    }
    private static final String timerPersistenceNotEnable = "WFLYEJB0016: Timer persistence is not enabled, persistent timers will not survive JVM restarts";
    protected String timerPersistenceNotEnable$str() {
        return timerPersistenceNotEnable;
    }
    @Override
    public final void nextExpirationIsNull(final TimerImpl timer) {
        super.log.logf(FQCN, INFO, null, nextExpirationIsNull$str(), timer);
    }
    private static final String nextExpirationIsNull = "WFLYEJB0017: Next expiration is null. No tasks will be scheduled for timer %S";
    protected String nextExpirationIsNull$str() {
        return nextExpirationIsNull;
    }
    @Override
    public final void ignoringException(final Throwable e) {
        super.log.logf(FQCN, ERROR, e, ignoringException$str());
    }
    private static final String ignoringException = "WFLYEJB0018: Ignoring exception during setRollbackOnly";
    protected String ignoringException$str() {
        return ignoringException;
    }
    @Override
    public final void errorInvokeTimeout(final Timer timer, final Throwable e) {
        super.log.logf(FQCN, ERROR, e, errorInvokeTimeout$str(), timer);
    }
    private static final String errorInvokeTimeout = "WFLYEJB0020: Error invoking timeout for timer: %s";
    protected String errorInvokeTimeout$str() {
        return errorInvokeTimeout;
    }
    @Override
    public final void timerRetried(final Timer timer) {
        super.log.logf(FQCN, INFO, null, timerRetried$str(), timer);
    }
    private static final String timerRetried = "WFLYEJB0021: Timer: %s will be retried";
    protected String timerRetried$str() {
        return timerRetried;
    }
    @Override
    public final void errorDuringRetryTimeout(final Timer timer, final Throwable e) {
        super.log.logf(FQCN, ERROR, e, errorDuringRetryTimeout$str(), timer);
    }
    private static final String errorDuringRetryTimeout = "WFLYEJB0022: Error during retrying timeout for timer: %s";
    protected String errorDuringRetryTimeout$str() {
        return errorDuringRetryTimeout;
    }
    @Override
    public final void retryingTimeout(final Timer timer) {
        super.log.logf(FQCN, INFO, null, retryingTimeout$str(), timer);
    }
    private static final String retryingTimeout = "WFLYEJB0023: Retrying timeout for timer: %s";
    protected String retryingTimeout$str() {
        return retryingTimeout;
    }
    @Override
    public final void timerNotActive(final Timer timer) {
        super.log.logf(FQCN, INFO, null, timerNotActive$str(), timer);
    }
    private static final String timerNotActive = "WFLYEJB0024: Timer is not active, skipping retry of timer: %s";
    protected String timerNotActive$str() {
        return timerNotActive;
    }
    @Override
    public final void failToReadTimerInformation(final String componentName) {
        super.log.logf(FQCN, WARN, null, failToReadTimerInformation$str(), componentName);
    }
    private static final String failToReadTimerInformation = "WFLYEJB0026: Could not read timer information for EJB component %s";
    protected String failToReadTimerInformation$str() {
        return failToReadTimerInformation;
    }
    @Override
    public final void failToRestoreTimers(final File file) {
        super.log.logf(FQCN, ERROR, null, failToRestoreTimers$str(), file);
    }
    private static final String failToRestoreTimers = "WFLYEJB0028: %s is not a directory, could not restore timers";
    protected String failToRestoreTimers$str() {
        return failToRestoreTimers;
    }
    @Override
    public final void failToRestoreTimersFromFile(final File timerFile, final Throwable e) {
        super.log.logf(FQCN, ERROR, e, failToRestoreTimersFromFile$str(), timerFile);
    }
    private static final String failToRestoreTimersFromFile = "WFLYEJB0029: Could not restore timer from %s";
    protected String failToRestoreTimersFromFile$str() {
        return failToRestoreTimersFromFile;
    }
    @Override
    public final void failToCloseFile(final Throwable e) {
        super.log.logf(FQCN, ERROR, e, failToCloseFile$str());
    }
    private static final String failToCloseFile = "WFLYEJB0030: error closing file ";
    protected String failToCloseFile$str() {
        return failToCloseFile;
    }
    @Override
    public final void failToRestoreTimersForObjectId(final String timedObjectId, final Throwable e) {
        super.log.logf(FQCN, ERROR, e, failToRestoreTimersForObjectId$str(), timedObjectId);
    }
    private static final String failToRestoreTimersForObjectId = "WFLYEJB0031: Could not restore timers for %s";
    protected String failToRestoreTimersForObjectId$str() {
        return failToRestoreTimersForObjectId;
    }
    @Override
    public final void failToCreateDirectoryForPersistTimers(final File file) {
        super.log.logf(FQCN, ERROR, null, failToCreateDirectoryForPersistTimers$str(), file);
    }
    private static final String failToCreateDirectoryForPersistTimers = "WFLYEJB0032: Could not create directory %s to persist EJB timers.";
    protected String failToCreateDirectoryForPersistTimers$str() {
        return failToCreateDirectoryForPersistTimers;
    }
    @Override
    public final void invocationFailed(final String component, final Method method, final Throwable t) {
        super.log.logf(FQCN, ERROR, t, invocationFailed$str(), component, method);
    }
    private static final String invocationFailed = "WFLYEJB0034: EJB Invocation failed on component %s for method %s";
    protected String invocationFailed$str() {
        return invocationFailed;
    }
    @Override
    public final void couldNotFindEjbForLocatorIIOP(final org.jboss.ejb.client.EJBLocator<?> locator) {
        super.log.logf(FQCN, WARN, null, couldNotFindEjbForLocatorIIOP$str(), locator);
    }
    private static final String couldNotFindEjbForLocatorIIOP = "WFLYEJB0035: Could not find EJB for locator %s, EJB client proxy will not be replaced";
    protected String couldNotFindEjbForLocatorIIOP$str() {
        return couldNotFindEjbForLocatorIIOP;
    }
    @Override
    public final void ejbNotExposedOverIIOP(final org.jboss.ejb.client.EJBLocator<?> locator) {
        super.log.logf(FQCN, WARN, null, ejbNotExposedOverIIOP$str(), locator);
    }
    private static final String ejbNotExposedOverIIOP = "WFLYEJB0036: EJB %s is not being replaced with a Stub as it is not exposed over IIOP";
    protected String ejbNotExposedOverIIOP$str() {
        return ejbNotExposedOverIIOP;
    }
    @Override
    public final void dynamicStubCreationFailed(final String clazz, final Throwable t) {
        super.log.logf(FQCN, ERROR, t, dynamicStubCreationFailed$str(), clazz);
    }
    private static final String dynamicStubCreationFailed = "WFLYEJB0037: Dynamic stub creation failed for class %s";
    protected String dynamicStubCreationFailed$str() {
        return dynamicStubCreationFailed;
    }
    @Override
    public final void logMDBStart(final String mdbName, final String raName) {
        super.log.logf(FQCN, INFO, null, logMDBStart$str(), mdbName, raName);
    }
    private static final String logMDBStart = "WFLYEJB0042: Started message driven bean '%s' with '%s' resource adapter";
    protected String logMDBStart$str() {
        return logMDBStart;
    }
    @Override
    public final void skipOverlappingInvokeTimeout(final Timer timer, final Date scheduledTime) {
        super.log.logf(FQCN, WARN, null, skipOverlappingInvokeTimeout$str(), timer, scheduledTime);
    }
    private static final String skipOverlappingInvokeTimeout = "WFLYEJB0043: A previous execution of timer %s is still in progress, skipping this overlapping scheduled execution at: %s.";
    protected String skipOverlappingInvokeTimeout$str() {
        return skipOverlappingInvokeTimeout;
    }
    private static final String resourceAdapterRepositoryUnAvailable = "WFLYEJB0044: Resource adapter repository is not available";
    protected String resourceAdapterRepositoryUnAvailable$str() {
        return resourceAdapterRepositoryUnAvailable;
    }
    @Override
    public final IllegalStateException resourceAdapterRepositoryUnAvailable() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), resourceAdapterRepositoryUnAvailable$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noSuchEndpointException = "WFLYEJB0045: Could not find an Endpoint for resource adapter %s";
    protected String noSuchEndpointException$str() {
        return noSuchEndpointException;
    }
    @Override
    public final IllegalArgumentException noSuchEndpointException(final String resourceAdapterName, final NotFoundException notFoundException) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), noSuchEndpointException$str(), resourceAdapterName), notFoundException);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String endpointUnAvailable = "WFLYEJB0046: Endpoint is not available for message driven component %s";
    protected String endpointUnAvailable$str() {
        return endpointUnAvailable;
    }
    @Override
    public final IllegalStateException endpointUnAvailable(final String componentName) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), endpointUnAvailable$str(), componentName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failureDuringEndpointDeactivation = "WFLYEJB0047: Could not deactivate endpoint for message driven component %s";
    protected String failureDuringEndpointDeactivation$str() {
        return failureDuringEndpointDeactivation;
    }
    @Override
    public final RuntimeException failureDuringEndpointDeactivation(final String componentName, final ResourceException cause) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), failureDuringEndpointDeactivation$str(), componentName), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failureDuringLoadOfClusterNodeSelector = "WFLYEJB0049: Could not create an instance of cluster node selector %s for cluster %s";
    protected String failureDuringLoadOfClusterNodeSelector$str() {
        return failureDuringLoadOfClusterNodeSelector;
    }
    @Override
    public final RuntimeException failureDuringLoadOfClusterNodeSelector(final String clusterNodeSelectorName, final String clusterName, final Exception e) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), failureDuringLoadOfClusterNodeSelector$str(), clusterNodeSelectorName, clusterName), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void failedToCreateOptionForProperty(final String propertyName, final String reason) {
        super.log.logf(FQCN, WARN, null, failedToCreateOptionForProperty$str(), propertyName, reason);
    }
    private static final String failedToCreateOptionForProperty = "WFLYEJB0050: Failed to parse property %s due to %s";
    protected String failedToCreateOptionForProperty$str() {
        return failedToCreateOptionForProperty;
    }
    private static final String viewNotFound = "WFLYEJB0051: Could not find view %s for EJB %s";
    protected String viewNotFound$str() {
        return viewNotFound;
    }
    @Override
    public final IllegalStateException viewNotFound(final String viewClass, final String ejbName) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), viewNotFound$str(), viewClass, ejbName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String asyncInvocationOnlyApplicableForSessionBeans = "WFLYEJB0052: Cannot perform asynchronous local invocation for component that is not a session bean";
    protected String asyncInvocationOnlyApplicableForSessionBeans$str() {
        return asyncInvocationOnlyApplicableForSessionBeans;
    }
    @Override
    public final RuntimeException asyncInvocationOnlyApplicableForSessionBeans() {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), asyncInvocationOnlyApplicableForSessionBeans$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String notStatefulSessionBean = "WFLYEJB0053: %s is not a Stateful Session bean in app: %s module: %s distinct-name: %s";
    protected String notStatefulSessionBean$str() {
        return notStatefulSessionBean;
    }
    @Override
    public final IllegalArgumentException notStatefulSessionBean(final String ejbName, final String appName, final String moduleName, final String distinctName) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), notStatefulSessionBean$str(), ejbName, appName, moduleName, distinctName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToMarshalEjbParameters = "WFLYEJB0054: Failed to marshal EJB parameters";
    protected String failedToMarshalEjbParameters$str() {
        return failedToMarshalEjbParameters;
    }
    @Override
    public final RuntimeException failedToMarshalEjbParameters(final Exception e) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), failedToMarshalEjbParameters$str()), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unknownDeployment = "WFLYEJB0055: No matching deployment for EJB: %s";
    protected String unknownDeployment$str() {
        return unknownDeployment;
    }
    @Override
    public final NoSuchEJBException unknownDeployment(final org.jboss.ejb.client.EJBLocator<?> locator) {
        final NoSuchEJBException result = new NoSuchEJBException(String.format(getLoggingLocale(), unknownDeployment$str(), locator));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String ejbNotFoundInDeployment = "WFLYEJB0056: Could not find EJB in matching deployment: %s";
    protected String ejbNotFoundInDeployment$str() {
        return ejbNotFoundInDeployment;
    }
    @Override
    public final NoSuchEJBException ejbNotFoundInDeployment(final org.jboss.ejb.client.EJBLocator<?> locator) {
        final NoSuchEJBException result = new NoSuchEJBException(String.format(getLoggingLocale(), ejbNotFoundInDeployment$str(), locator));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String annotationApplicableOnlyForMethods = "WFLYEJB0057: %s annotation is only valid on method targets";
    protected String annotationApplicableOnlyForMethods$str() {
        return annotationApplicableOnlyForMethods;
    }
    @Override
    public final IllegalArgumentException annotationApplicableOnlyForMethods(final String annotationName) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), annotationApplicableOnlyForMethods$str(), annotationName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String aroundTimeoutMethodExpectedWithInvocationContextParam = "WFLYEJB0058: Method %s, on class %s, annotated with @javax.interceptor.AroundTimeout is expected to accept a single param of type javax.interceptor.InvocationContext";
    protected String aroundTimeoutMethodExpectedWithInvocationContextParam$str() {
        return aroundTimeoutMethodExpectedWithInvocationContextParam;
    }
    @Override
    public final IllegalArgumentException aroundTimeoutMethodExpectedWithInvocationContextParam(final String methodName, final String className) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), aroundTimeoutMethodExpectedWithInvocationContextParam$str(), methodName, className));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String aroundTimeoutMethodMustReturnObjectType = "WFLYEJB0059: Method %s, on class %s, annotated with @javax.interceptor.AroundTimeout must return Object type";
    protected String aroundTimeoutMethodMustReturnObjectType$str() {
        return aroundTimeoutMethodMustReturnObjectType;
    }
    @Override
    public final IllegalArgumentException aroundTimeoutMethodMustReturnObjectType(final String methodName, final String className) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), aroundTimeoutMethodMustReturnObjectType$str(), methodName, className));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String wrongTxOnThread = "WFLYEJB0060: Wrong tx on thread: expected %s, actual %s";
    protected String wrongTxOnThread$str() {
        return wrongTxOnThread;
    }
    @Override
    public final IllegalStateException wrongTxOnThread(final Transaction expected, final Transaction actual) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), wrongTxOnThread$str(), expected, actual));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unknownTxAttributeOnInvocation = "WFLYEJB0061: Unknown transaction attribute %s on invocation %s";
    protected String unknownTxAttributeOnInvocation$str() {
        return unknownTxAttributeOnInvocation;
    }
    @Override
    public final IllegalStateException unknownTxAttributeOnInvocation(final TransactionAttributeType txAttr, final InterceptorContext invocation) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), unknownTxAttributeOnInvocation$str(), txAttr, invocation));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String txRequiredForInvocation = "WFLYEJB0062: Transaction is required for invocation %s";
    protected String txRequiredForInvocation$str() {
        return txRequiredForInvocation;
    }
    @Override
    public final EJBTransactionRequiredException txRequiredForInvocation(final InterceptorContext invocation) {
        final EJBTransactionRequiredException result = new EJBTransactionRequiredException(String.format(getLoggingLocale(), txRequiredForInvocation$str(), invocation));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String txPresentForNeverTxAttribute = "WFLYEJB0063: Transaction present on server in Never call (EJB3 13.6.2.6)";
    protected String txPresentForNeverTxAttribute$str() {
        return txPresentForNeverTxAttribute;
    }
    @Override
    public final EJBException txPresentForNeverTxAttribute() {
        final EJBException result = new EJBException(String.format(getLoggingLocale(), txPresentForNeverTxAttribute$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void failedToSetRollbackOnly(final Exception e) {
        super.log.logf(FQCN, ERROR, e, failedToSetRollbackOnly$str());
    }
    private static final String failedToSetRollbackOnly = "WFLYEJB0064: Failed to set transaction for rollback only";
    protected String failedToSetRollbackOnly$str() {
        return failedToSetRollbackOnly;
    }
    private static final String viewInterfaceCannotBeNull = "WFLYEJB0065: View interface cannot be null";
    protected String viewInterfaceCannotBeNull$str() {
        return viewInterfaceCannotBeNull;
    }
    @Override
    public final IllegalArgumentException viewInterfaceCannotBeNull() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), viewInterfaceCannotBeNull$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToLoadViewClassForComponent = "WFLYEJB0068: Could not load view class for component %s";
    protected String failedToLoadViewClassForComponent$str() {
        return failedToLoadViewClassForComponent;
    }
    @Override
    public final RuntimeException failedToLoadViewClassForComponent(final Exception e, final String componentName) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), failedToLoadViewClassForComponent$str(), componentName), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String illegalCallToEjbHomeRemove = "WFLYEJB0073: Illegal call to EJBHome.remove(Object) on a session bean";
    protected String illegalCallToEjbHomeRemove$str() {
        return illegalCallToEjbHomeRemove;
    }
    @Override
    public final RemoveException illegalCallToEjbHomeRemove() {
        final RemoveException result = new RemoveException(String.format(getLoggingLocale(), illegalCallToEjbHomeRemove$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String setRollbackOnlyNotAllowedForSupportsTxAttr = "WFLYEJB0074: EJB 3.1 FR 13.6.2.8 setRollbackOnly is not allowed with SUPPORTS transaction attribute";
    protected String setRollbackOnlyNotAllowedForSupportsTxAttr$str() {
        return setRollbackOnlyNotAllowedForSupportsTxAttr;
    }
    @Override
    public final IllegalStateException setRollbackOnlyNotAllowedForSupportsTxAttr() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), setRollbackOnlyNotAllowedForSupportsTxAttr$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotCallGetPKOnSessionBean = "WFLYEJB0075: Cannot call getPrimaryKey on a session bean";
    protected String cannotCallGetPKOnSessionBean$str() {
        return cannotCallGetPKOnSessionBean;
    }
    @Override
    public final EJBException cannotCallGetPKOnSessionBean() {
        final EJBException result = new EJBException(String.format(getLoggingLocale(), cannotCallGetPKOnSessionBean$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String ejb2xViewNotApplicableForSingletonBeans = "WFLYEJB0076: Singleton beans cannot have EJB 2.x views";
    protected String ejb2xViewNotApplicableForSingletonBeans$str() {
        return ejb2xViewNotApplicableForSingletonBeans;
    }
    @Override
    public final RuntimeException ejb2xViewNotApplicableForSingletonBeans() {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), ejb2xViewNotApplicableForSingletonBeans$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String ejbLocalObjectUnavailable = "WFLYEJB0078: Bean %s does not have an EJBLocalObject";
    protected String ejbLocalObjectUnavailable$str() {
        return ejbLocalObjectUnavailable;
    }
    @Override
    public final IllegalStateException ejbLocalObjectUnavailable(final String beanName) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), ejbLocalObjectUnavailable$str(), beanName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotBeApplicationExceptionBecauseNotAnExceptionType = "WFLYEJB0079: [EJB 3.1 spec, section 14.1.1] Class: %s cannot be marked as an application exception because it is not of type java.lang.Exception";
    protected String cannotBeApplicationExceptionBecauseNotAnExceptionType$str() {
        return cannotBeApplicationExceptionBecauseNotAnExceptionType;
    }
    @Override
    public final IllegalArgumentException cannotBeApplicationExceptionBecauseNotAnExceptionType(final Class<?> klass) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), cannotBeApplicationExceptionBecauseNotAnExceptionType$str(), klass));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String rmiRemoteExceptionCannotBeApplicationException = "WFLYEJB0080: [EJB 3.1 spec, section 14.1.1] Exception class: %s cannot be marked as an application exception because it is of type java.rmi.RemoteException";
    protected String rmiRemoteExceptionCannotBeApplicationException$str() {
        return rmiRemoteExceptionCannotBeApplicationException;
    }
    @Override
    public final IllegalArgumentException rmiRemoteExceptionCannotBeApplicationException(final Class<?> klass) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), rmiRemoteExceptionCannotBeApplicationException$str(), klass));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String annotationOnlyAllowedOnClass = "WFLYEJB0081: %s annotation is allowed only on classes. %s is not a class";
    protected String annotationOnlyAllowedOnClass$str() {
        return annotationOnlyAllowedOnClass;
    }
    @Override
    public final RuntimeException annotationOnlyAllowedOnClass(final String annotationName, final AnnotationTarget incorrectTarget) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), annotationOnlyAllowedOnClass$str(), annotationName, incorrectTarget));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String beanWithRemoteAnnotationImplementsMoreThanOneInterface = "WFLYEJB0082: Bean %s specifies @Remote annotation, but does not implement 1 interface";
    protected String beanWithRemoteAnnotationImplementsMoreThanOneInterface$str() {
        return beanWithRemoteAnnotationImplementsMoreThanOneInterface;
    }
    @Override
    public final DeploymentUnitProcessingException beanWithRemoteAnnotationImplementsMoreThanOneInterface(final Class<?> beanClass) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), beanWithRemoteAnnotationImplementsMoreThanOneInterface$str(), beanClass));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String beanWithLocalAnnotationImplementsMoreThanOneInterface = "WFLYEJB0083: Bean %s specifies @Local annotation, but does not implement 1 interface";
    protected String beanWithLocalAnnotationImplementsMoreThanOneInterface$str() {
        return beanWithLocalAnnotationImplementsMoreThanOneInterface;
    }
    @Override
    public final DeploymentUnitProcessingException beanWithLocalAnnotationImplementsMoreThanOneInterface(final Class<?> beanClass) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), beanWithLocalAnnotationImplementsMoreThanOneInterface$str(), beanClass));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToAnalyzeRemoteInterface = "WFLYEJB0084: Could not analyze remote interface for %s";
    protected String failedToAnalyzeRemoteInterface$str() {
        return failedToAnalyzeRemoteInterface;
    }
    @Override
    public final RuntimeException failedToAnalyzeRemoteInterface(final Exception e, final String beanName) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), failedToAnalyzeRemoteInterface$str(), beanName), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToParse = "WFLYEJB0085: Exception while parsing %s";
    protected String failedToParse$str() {
        return failedToParse;
    }
    @Override
    public final DeploymentUnitProcessingException failedToParse(final Exception e, final String filePath) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), failedToParse$str(), filePath), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToInstallManagementResource = "WFLYEJB0086: Failed to install management resources for %s";
    protected String failedToInstallManagementResource$str() {
        return failedToInstallManagementResource;
    }
    @Override
    public final DeploymentUnitProcessingException failedToInstallManagementResource(final Exception e, final String componentName) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), failedToInstallManagementResource$str(), componentName), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToLoadViewClass = "WFLYEJB0087: Could not load view %s";
    protected String failedToLoadViewClass$str() {
        return failedToLoadViewClass;
    }
    @Override
    public final RuntimeException failedToLoadViewClass(final Exception e, final String viewClassName) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), failedToLoadViewClass$str(), viewClassName), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldNotDetermineEjbRefForInjectionTarget = "WFLYEJB0088: Could not determine type of ejb-ref %s for injection target %s";
    protected String couldNotDetermineEjbRefForInjectionTarget$str() {
        return couldNotDetermineEjbRefForInjectionTarget;
    }
    @Override
    public final DeploymentUnitProcessingException couldNotDetermineEjbRefForInjectionTarget(final String ejbRefName, final ResourceInjectionTarget injectionTarget) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), couldNotDetermineEjbRefForInjectionTarget$str(), ejbRefName, injectionTarget));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldNotDetermineEjbLocalRefForInjectionTarget = "WFLYEJB0089: Could not determine type of ejb-local-ref %s for injection target %s";
    protected String couldNotDetermineEjbLocalRefForInjectionTarget$str() {
        return couldNotDetermineEjbLocalRefForInjectionTarget;
    }
    @Override
    public final DeploymentUnitProcessingException couldNotDetermineEjbLocalRefForInjectionTarget(final String ejbLocalRefName, final ResourceInjectionTarget injectionTarget) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), couldNotDetermineEjbLocalRefForInjectionTarget$str(), ejbLocalRefName, injectionTarget));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String onlySetterMethodsAllowedToHaveEJBAnnotation = "WFLYEJB0090: @EJB injection target %s is invalid. Only setter methods are allowed";
    protected String onlySetterMethodsAllowedToHaveEJBAnnotation$str() {
        return onlySetterMethodsAllowedToHaveEJBAnnotation;
    }
    @Override
    public final IllegalArgumentException onlySetterMethodsAllowedToHaveEJBAnnotation(final MethodInfo methodInfo) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), onlySetterMethodsAllowedToHaveEJBAnnotation$str(), methodInfo));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String nameAttributeRequiredForEJBAnnotationOnClass = "WFLYEJB0091: @EJB attribute 'name' is required for class level annotations. Class: %s";
    protected String nameAttributeRequiredForEJBAnnotationOnClass$str() {
        return nameAttributeRequiredForEJBAnnotationOnClass;
    }
    @Override
    public final DeploymentUnitProcessingException nameAttributeRequiredForEJBAnnotationOnClass(final String className) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), nameAttributeRequiredForEJBAnnotationOnClass$str(), className));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String beanInterfaceAttributeRequiredForEJBAnnotationOnClass = "WFLYEJB0092: @EJB attribute 'beanInterface' is required for class level annotations. Class: %s";
    protected String beanInterfaceAttributeRequiredForEJBAnnotationOnClass$str() {
        return beanInterfaceAttributeRequiredForEJBAnnotationOnClass;
    }
    @Override
    public final DeploymentUnitProcessingException beanInterfaceAttributeRequiredForEJBAnnotationOnClass(final String className) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), beanInterfaceAttributeRequiredForEJBAnnotationOnClass$str(), className));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String moduleNotAttachedToDeploymentUnit = "WFLYEJB0093: Module hasn't been attached to deployment unit %s";
    protected String moduleNotAttachedToDeploymentUnit$str() {
        return moduleNotAttachedToDeploymentUnit;
    }
    @Override
    public final IllegalStateException moduleNotAttachedToDeploymentUnit(final DeploymentUnit deploymentUnit) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), moduleNotAttachedToDeploymentUnit$str(), deploymentUnit));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mdbDoesNotImplementNorSpecifyMessageListener = "WFLYEJB0094: EJB 3.1 FR 5.4.2 MessageDrivenBean %s does not implement 1 interface nor specifies message listener interface";
    protected String mdbDoesNotImplementNorSpecifyMessageListener$str() {
        return mdbDoesNotImplementNorSpecifyMessageListener;
    }
    @Override
    public final DeploymentUnitProcessingException mdbDoesNotImplementNorSpecifyMessageListener(final ClassInfo beanClass) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), mdbDoesNotImplementNorSpecifyMessageListener$str(), beanClass));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unknownSessionBeanType = "WFLYEJB0095: Unknown session bean type %s";
    protected String unknownSessionBeanType$str() {
        return unknownSessionBeanType;
    }
    @Override
    public final IllegalArgumentException unknownSessionBeanType(final String sessionType) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unknownSessionBeanType$str(), sessionType));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String moreThanOneMethodWithSameNameOnComponent = "WFLYEJB0096: More than one method found with name %s on %s";
    protected String moreThanOneMethodWithSameNameOnComponent$str() {
        return moreThanOneMethodWithSameNameOnComponent;
    }
    @Override
    public final DeploymentUnitProcessingException moreThanOneMethodWithSameNameOnComponent(final String methodName, final Class<?> componentClass) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), moreThanOneMethodWithSameNameOnComponent$str(), methodName, componentClass));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unknownEJBLocatorType = "WFLYEJB0097: Unknown EJB locator type %s";
    protected String unknownEJBLocatorType$str() {
        return unknownEJBLocatorType;
    }
    @Override
    public final RuntimeException unknownEJBLocatorType(final org.jboss.ejb.client.EJBLocator<?> locator) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), unknownEJBLocatorType$str(), locator));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldNotCreateCorbaObject = "WFLYEJB0098: Could not create CORBA object for %s";
    protected String couldNotCreateCorbaObject$str() {
        return couldNotCreateCorbaObject;
    }
    @Override
    public final RuntimeException couldNotCreateCorbaObject(final Exception cause, final org.jboss.ejb.client.EJBLocator<?> locator) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), couldNotCreateCorbaObject$str(), locator), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String incorrectEJBLocatorForBean = "WFLYEJB0099: Provided locator %s was not for EJB %s";
    protected String incorrectEJBLocatorForBean$str() {
        return incorrectEJBLocatorForBean;
    }
    @Override
    public final IllegalArgumentException incorrectEJBLocatorForBean(final org.jboss.ejb.client.EJBLocator<?> locator, final String beanName) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), incorrectEJBLocatorForBean$str(), locator, beanName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToLookupORB = "WFLYEJB0100: Failed to lookup java:comp/ORB";
    protected String failedToLookupORB$str() {
        return failedToLookupORB;
    }
    @Override
    public final IOException failedToLookupORB() {
        final IOException result = new IOException(String.format(getLoggingLocale(), failedToLookupORB$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String notAnObjectImpl = "WFLYEJB0101: %s is not an ObjectImpl";
    protected String notAnObjectImpl$str() {
        return notAnObjectImpl;
    }
    @Override
    public final IOException notAnObjectImpl(final Class<?> type) {
        final IOException result = new IOException(String.format(getLoggingLocale(), notAnObjectImpl$str(), type));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String messageEndpointAlreadyReleased = "WFLYEJB0102: Message endpoint %s has already been released";
    protected String messageEndpointAlreadyReleased$str() {
        return messageEndpointAlreadyReleased;
    }
    @Override
    public final UnavailableException messageEndpointAlreadyReleased(final MessageEndpoint messageEndpoint) {
        final UnavailableException result = new UnavailableException(String.format(getLoggingLocale(), messageEndpointAlreadyReleased$str(), messageEndpoint));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String notAnEJBComponent = "WFLYEJB0105: %s is not an EJB component";
    protected String notAnEJBComponent$str() {
        return notAnEJBComponent;
    }
    @Override
    public final IllegalArgumentException notAnEJBComponent(final Component component) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), notAnEJBComponent$str(), component));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToLoadTimeoutMethodParamClass = "WFLYEJB0106: Could not load method param class %s of timeout method";
    protected String failedToLoadTimeoutMethodParamClass$str() {
        return failedToLoadTimeoutMethodParamClass;
    }
    @Override
    public final RuntimeException failedToLoadTimeoutMethodParamClass(final Exception cause, final String className) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), failedToLoadTimeoutMethodParamClass$str(), className), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String timerInvocationFailedDueToInvokerNotBeingStarted = "WFLYEJB0107: Timer invocation failed, invoker is not started";
    protected String timerInvocationFailedDueToInvokerNotBeingStarted$str() {
        return timerInvocationFailedDueToInvokerNotBeingStarted;
    }
    @Override
    public final IllegalStateException timerInvocationFailedDueToInvokerNotBeingStarted() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), timerInvocationFailedDueToInvokerNotBeingStarted$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidValueForSecondInScheduleExpression = "WFLYEJB0109: Invalid value for second: %s";
    protected String invalidValueForSecondInScheduleExpression$str() {
        return invalidValueForSecondInScheduleExpression;
    }
    @Override
    public final IllegalArgumentException invalidValueForSecondInScheduleExpression(final String value) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidValueForSecondInScheduleExpression$str(), value));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String timerInvocationRolledBack = "WFLYEJB0110: Timer invocation failed, transaction rolled back";
    protected String timerInvocationRolledBack$str() {
        return timerInvocationRolledBack;
    }
    @Override
    public final TimerTransactionRolledBackException timerInvocationRolledBack() {
        final TimerTransactionRolledBackException result = new TimerTransactionRolledBackException(String.format(getLoggingLocale(), timerInvocationRolledBack$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void noJNDIBindingsForSessionBean(final String beanName) {
        super.log.logf(FQCN, INFO, null, noJNDIBindingsForSessionBean$str(), beanName);
    }
    private static final String noJNDIBindingsForSessionBean = "WFLYEJB0111: No jndi bindings will be created for EJB %s since no views are exposed";
    protected String noJNDIBindingsForSessionBean$str() {
        return noJNDIBindingsForSessionBean;
    }
    @Override
    public final void sessionBeanClassCannotBeAnInterface(final String className) {
        super.log.logf(FQCN, WARN, null, sessionBeanClassCannotBeAnInterface$str(), className);
    }
    private static final String sessionBeanClassCannotBeAnInterface = "WFLYEJB0118: [EJB3.1 spec, section 4.9.2] Session bean implementation class MUST NOT be a interface - %s is an interface, hence won't be considered as a session bean";
    protected String sessionBeanClassCannotBeAnInterface$str() {
        return sessionBeanClassCannotBeAnInterface;
    }
    @Override
    public final void sessionBeanClassMustBePublicNonAbstractNonFinal(final String className) {
        super.log.logf(FQCN, WARN, null, sessionBeanClassMustBePublicNonAbstractNonFinal$str(), className);
    }
    private static final String sessionBeanClassMustBePublicNonAbstractNonFinal = "WFLYEJB0119: [EJB3.1 spec, section 4.9.2] Session bean implementation class MUST be public, not abstract and not final - %s won't be considered as a session bean, since it doesn't meet that requirement";
    protected String sessionBeanClassMustBePublicNonAbstractNonFinal$str() {
        return sessionBeanClassMustBePublicNonAbstractNonFinal;
    }
    @Override
    public final void mdbClassCannotBeAnInterface(final String className) {
        super.log.logf(FQCN, WARN, null, mdbClassCannotBeAnInterface$str(), className);
    }
    private static final String mdbClassCannotBeAnInterface = "WFLYEJB0120: [EJB3.1 spec, section 5.6.2] Message driven bean implementation class MUST NOT be a interface - %s is an interface, hence won't be considered as a message driven bean";
    protected String mdbClassCannotBeAnInterface$str() {
        return mdbClassCannotBeAnInterface;
    }
    @Override
    public final void mdbClassMustBePublicNonAbstractNonFinal(final String className) {
        super.log.logf(FQCN, WARN, null, mdbClassMustBePublicNonAbstractNonFinal$str(), className);
    }
    private static final String mdbClassMustBePublicNonAbstractNonFinal = "WFLYEJB0121: [EJB3.1 spec, section 5.6.2] Message driven bean implementation class MUST be public, not abstract and not final - %s won't be considered as a message driven bean, since it doesn't meet that requirement";
    protected String mdbClassMustBePublicNonAbstractNonFinal$str() {
        return mdbClassMustBePublicNonAbstractNonFinal;
    }
    private static final String failedToCreateDeploymentNodeSelector = "WFLYEJB0125: Could not create an instance of deployment node selector %s";
    protected String failedToCreateDeploymentNodeSelector$str() {
        return failedToCreateDeploymentNodeSelector;
    }
    @Override
    public final DeploymentUnitProcessingException failedToCreateDeploymentNodeSelector(final Exception e, final String deploymentNodeSelectorClassName) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), failedToCreateDeploymentNodeSelector$str(), deploymentNodeSelectorClassName), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String ejbMustHavePublicDefaultConstructor = "WFLYEJB0127: EJB %s of type %s must have public default constructor";
    protected String ejbMustHavePublicDefaultConstructor$str() {
        return ejbMustHavePublicDefaultConstructor;
    }
    @Override
    public final DeploymentUnitProcessingException ejbMustHavePublicDefaultConstructor(final String componentName, final String componentClassName) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), ejbMustHavePublicDefaultConstructor$str(), componentName, componentClassName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String ejbMustNotBeInnerClass = "WFLYEJB0128: EJB %s of type %s must not be inner class";
    protected String ejbMustNotBeInnerClass$str() {
        return ejbMustNotBeInnerClass;
    }
    @Override
    public final DeploymentUnitProcessingException ejbMustNotBeInnerClass(final String componentName, final String componentClassName) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), ejbMustNotBeInnerClass$str(), componentName, componentClassName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String ejbMustBePublicClass = "WFLYEJB0129: EJB %s of type %s must be declared public";
    protected String ejbMustBePublicClass$str() {
        return ejbMustBePublicClass;
    }
    @Override
    public final DeploymentUnitProcessingException ejbMustBePublicClass(final String componentName, final String componentClassName) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), ejbMustBePublicClass$str(), componentName, componentClassName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String ejbMustNotBeFinalClass = "WFLYEJB0130: EJB %s of type %s must not be declared final";
    protected String ejbMustNotBeFinalClass$str() {
        return ejbMustNotBeFinalClass;
    }
    @Override
    public final DeploymentUnitProcessingException ejbMustNotBeFinalClass(final String componentName, final String componentClassName) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), ejbMustNotBeFinalClass$str(), componentName, componentClassName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String reentrantSingletonCreation = "WFLYEJB0132: @PostConstruct method of EJB singleton %s of type %s has been recursively invoked";
    protected String reentrantSingletonCreation$str() {
        return reentrantSingletonCreation;
    }
    @Override
    public final IllegalStateException reentrantSingletonCreation(final String componentName, final String componentClassName) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), reentrantSingletonCreation$str(), componentName, componentClassName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unauthorizedAccessToUserTransaction = "WFLYEJB0137: Only session and message-driven beans with bean-managed transaction demarcation are allowed to access UserTransaction";
    protected String unauthorizedAccessToUserTransaction$str() {
        return unauthorizedAccessToUserTransaction;
    }
    @Override
    public final IllegalStateException unauthorizedAccessToUserTransaction() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), unauthorizedAccessToUserTransaction$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String timerServiceIsNotActive = "WFLYEJB0139: The timer service has been disabled. Please add a <timer-service> entry into the ejb section of the server configuration to enable it.";
    protected String timerServiceIsNotActive$str() {
        return timerServiceIsNotActive;
    }
    @Override
    public final String timerServiceIsNotActive() {
        return String.format(getLoggingLocale(), timerServiceIsNotActive$str());
    }
    private static final String ejbHasNoTimerMethods = "WFLYEJB0140: This EJB does not have any timeout methods";
    protected String ejbHasNoTimerMethods$str() {
        return ejbHasNoTimerMethods;
    }
    @Override
    public final String ejbHasNoTimerMethods() {
        return String.format(getLoggingLocale(), ejbHasNoTimerMethods$str());
    }
    @Override
    public final void deploymentAddListenerException(final Throwable cause) {
        super.log.logf(FQCN, ERROR, cause, deploymentAddListenerException$str());
    }
    private static final String deploymentAddListenerException = "WFLYEJB0141: Exception calling deployment added listener";
    protected String deploymentAddListenerException$str() {
        return deploymentAddListenerException;
    }
    @Override
    public final void deploymentRemoveListenerException(final Throwable cause) {
        super.log.logf(FQCN, ERROR, cause, deploymentRemoveListenerException$str());
    }
    private static final String deploymentRemoveListenerException = "WFLYEJB0142: Exception calling deployment removal listener";
    protected String deploymentRemoveListenerException$str() {
        return deploymentRemoveListenerException;
    }
    @Override
    public final void failedToRemoveManagementResources(final InstalledComponent component, final String cause) {
        super.log.logf(FQCN, ERROR, null, failedToRemoveManagementResources$str(), component, cause);
    }
    private static final String failedToRemoveManagementResources = "WFLYEJB0143: Failed to remove management resources for %s -- %s";
    protected String failedToRemoveManagementResources$str() {
        return failedToRemoveManagementResources;
    }
    @Override
    public final void cobraInterfaceRepository(final String repo, final String object) {
        super.log.logf(FQCN, INFO, null, cobraInterfaceRepository$str(), repo, object);
    }
    private static final String cobraInterfaceRepository = "WFLYEJB0144: CORBA interface repository for %s: %s";
    protected String cobraInterfaceRepository$str() {
        return cobraInterfaceRepository;
    }
    @Override
    public final void cannotUnregisterEJBHomeFromCobra(final Throwable cause) {
        super.log.logf(FQCN, ERROR, cause, cannotUnregisterEJBHomeFromCobra$str());
    }
    private static final String cannotUnregisterEJBHomeFromCobra = "WFLYEJB0145: Cannot unregister EJBHome from CORBA naming service";
    protected String cannotUnregisterEJBHomeFromCobra$str() {
        return cannotUnregisterEJBHomeFromCobra;
    }
    @Override
    public final void cannotDeactivateHomeServant(final Throwable cause) {
        super.log.logf(FQCN, ERROR, cause, cannotDeactivateHomeServant$str());
    }
    private static final String cannotDeactivateHomeServant = "WFLYEJB0146: Cannot deactivate home servant";
    protected String cannotDeactivateHomeServant$str() {
        return cannotDeactivateHomeServant;
    }
    @Override
    public final void cannotDeactivateBeanServant(final Throwable cause) {
        super.log.logf(FQCN, ERROR, cause, cannotDeactivateBeanServant$str());
    }
    private static final String cannotDeactivateBeanServant = "WFLYEJB0147: Cannot deactivate bean servant";
    protected String cannotDeactivateBeanServant$str() {
        return cannotDeactivateBeanServant;
    }
    @Override
    public final void couldNotWriteMethodInvocation(final Throwable cause, final Method invokedMethod, final String beanName, final String appName, final String moduleName, final String distinctName) {
        super.log.logf(FQCN, ERROR, cause, couldNotWriteMethodInvocation$str(), invokedMethod, beanName, appName, moduleName, distinctName);
    }
    private static final String couldNotWriteMethodInvocation = "WFLYEJB0150: Could not write method invocation failure for method %s on bean named %s for appname %s modulename %s distinctname %s due to";
    protected String couldNotWriteMethodInvocation$str() {
        return couldNotWriteMethodInvocation;
    }
    @Override
    public final void exceptionGeneratingSessionId(final Throwable cause, final String componentName, final Object invocationInformation) {
        super.log.logf(FQCN, ERROR, cause, exceptionGeneratingSessionId$str(), componentName, invocationInformation);
    }
    private static final String exceptionGeneratingSessionId = "WFLYEJB0151: Exception while generating session id for component %s with invocation %s";
    protected String exceptionGeneratingSessionId$str() {
        return exceptionGeneratingSessionId;
    }
    @Override
    public final void retrying(final String message, final int count) {
        super.log.logf(FQCN, WARN, null, retrying$str(), message, count);
    }
    private static final String retrying = "WFLYEJB0156: %s retrying %d";
    protected String retrying$str() {
        return retrying;
    }
    @Override
    public final void failedToGetStatus(final Throwable cause) {
        super.log.logf(FQCN, ERROR, cause, failedToGetStatus$str());
    }
    private static final String failedToGetStatus = "WFLYEJB0157: Failed to get status";
    protected String failedToGetStatus$str() {
        return failedToGetStatus;
    }
    @Override
    public final void failedToRollback(final Throwable cause) {
        super.log.logf(FQCN, ERROR, cause, failedToRollback$str());
    }
    private static final String failedToRollback = "WFLYEJB0158: Failed to rollback";
    protected String failedToRollback$str() {
        return failedToRollback;
    }
    @Override
    public final void transactionNotComplete(final String componentName, final String status) {
        super.log.logf(FQCN, ERROR, null, transactionNotComplete2$str(), componentName, status);
    }
    private static final String transactionNotComplete2 = "WFLYEJB0159: BMT stateful bean '%s' did not complete user transaction properly status=%s";
    protected String transactionNotComplete2$str() {
        return transactionNotComplete2;
    }
    @Override
    public final void timerReinstatementFailed(final String timedObjectId, final String timerId, final Throwable cause) {
        super.log.logf(FQCN, WARN, cause, timerReinstatementFailed$str(), timedObjectId, timerId);
    }
    private static final String timerReinstatementFailed = "WFLYEJB0161: Failed to reinstate timer '%s' (id=%s) from its persistent state";
    protected String timerReinstatementFailed$str() {
        return timerReinstatementFailed;
    }
    @Override
    public final void skipInvokeTimeoutDuringRetry(final Timer timer, final Date scheduledTime) {
        super.log.logf(FQCN, WARN, null, skipInvokeTimeoutDuringRetry$str(), timer, scheduledTime);
    }
    private static final String skipInvokeTimeoutDuringRetry = "WFLYEJB0162: A previous execution of timer %s is being retried, skipping this scheduled execution at: %s";
    protected String skipInvokeTimeoutDuringRetry$str() {
        return skipInvokeTimeoutDuringRetry;
    }
    @Override
    public final void couldNotCreateTable(final SQLException e) {
        super.log.logf(FQCN, ERROR, e, couldNotCreateTable$str());
    }
    private static final String couldNotCreateTable = "WFLYEJB0163: Cannot create table for timer persistence";
    protected String couldNotCreateTable$str() {
        return couldNotCreateTable;
    }
    @Override
    public final void exceptionRunningTimerTask(final Timer timer, final String timedObjectId, final Exception e) {
        super.log.logf(FQCN, ERROR, e, exceptionRunningTimerTask$str(), timer, timedObjectId);
    }
    private static final String exceptionRunningTimerTask = "WFLYEJB0164: Exception running timer task for timer %s on EJB %s";
    protected String exceptionRunningTimerTask$str() {
        return exceptionRunningTimerTask;
    }
    @Override
    public final void deprecatedAnnotation(final String annotation) {
        super.log.logf(FQCN, WARN, null, deprecatedAnnotation$str(), annotation);
    }
    private static final String deprecatedAnnotation = "WFLYEJB0166: The @%s annotation is deprecated and will be ignored.";
    protected String deprecatedAnnotation$str() {
        return deprecatedAnnotation;
    }
    @Override
    public final void deprecatedNamespace(final String namespace, final String element) {
        super.log.logf(FQCN, WARN, null, deprecatedNamespace$str(), namespace, element);
    }
    private static final String deprecatedNamespace = "WFLYEJB0167: The <%2$s xmlns=\"%1$s\"/> element will be ignored.";
    protected String deprecatedNamespace$str() {
        return deprecatedNamespace;
    }
    private static final String couldNotFindEjb = "WFLYEJB0168: Could not find EJB with id %s";
    protected String couldNotFindEjb$str() {
        return couldNotFindEjb;
    }
    @Override
    public final NoSuchEJBException couldNotFindEjb(final String sessionId) {
        final NoSuchEJBException result = new NoSuchEJBException(String.format(getLoggingLocale(), couldNotFindEjb$str(), sessionId));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String componentNotSetInInterceptor = "WFLYEJB0169: Component not set in InterceptorContext: %s";
    protected String componentNotSetInInterceptor$str() {
        return componentNotSetInInterceptor;
    }
    @Override
    public final IllegalStateException componentNotSetInInterceptor(final InterceptorContext context) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), componentNotSetInInterceptor$str(), context));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String methodNameIsNull = "WFLYEJB0170: Method name cannot be null";
    protected String methodNameIsNull$str() {
        return methodNameIsNull;
    }
    @Override
    public final IllegalArgumentException methodNameIsNull() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), methodNameIsNull$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String beanHomeInterfaceIsNull = "WFLYEJB0171: Bean %s does not have a Home interface";
    protected String beanHomeInterfaceIsNull$str() {
        return beanHomeInterfaceIsNull;
    }
    @Override
    public final IllegalStateException beanHomeInterfaceIsNull(final String componentName) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), beanHomeInterfaceIsNull$str(), componentName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String beanLocalHomeInterfaceIsNull = "WFLYEJB0172: Bean %s does not have a Local Home interface";
    protected String beanLocalHomeInterfaceIsNull$str() {
        return beanLocalHomeInterfaceIsNull;
    }
    @Override
    public final IllegalStateException beanLocalHomeInterfaceIsNull(final String componentName) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), beanLocalHomeInterfaceIsNull$str(), componentName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failToCallgetRollbackOnly = "WFLYEJB0173: EJB 3.1 FR 13.6.1 Only beans with container-managed transaction demarcation can use getRollbackOnly.";
    protected String failToCallgetRollbackOnly$str() {
        return failToCallgetRollbackOnly;
    }
    @Override
    public final IllegalStateException failToCallgetRollbackOnly() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), failToCallgetRollbackOnly$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failToCallgetRollbackOnlyOnNoneTransaction = "WFLYEJB0174: getRollbackOnly() not allowed without a transaction.";
    protected String failToCallgetRollbackOnlyOnNoneTransaction$str() {
        return failToCallgetRollbackOnlyOnNoneTransaction;
    }
    @Override
    public final IllegalStateException failToCallgetRollbackOnlyOnNoneTransaction() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), failToCallgetRollbackOnlyOnNoneTransaction$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failToCallgetRollbackOnlyAfterTxcompleted = "WFLYEJB0175: getRollbackOnly() not allowed after transaction is completed (EJBTHREE-1445)";
    protected String failToCallgetRollbackOnlyAfterTxcompleted$str() {
        return failToCallgetRollbackOnlyAfterTxcompleted;
    }
    @Override
    public final IllegalStateException failToCallgetRollbackOnlyAfterTxcompleted() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), failToCallgetRollbackOnlyAfterTxcompleted$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String jndiNameCannotBeNull = "WFLYEJB0177: jndi name cannot be null during lookup";
    protected String jndiNameCannotBeNull$str() {
        return jndiNameCannotBeNull;
    }
    @Override
    public final IllegalArgumentException jndiNameCannotBeNull() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), jndiNameCannotBeNull$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noNamespaceContextSelectorAvailable = "WFLYEJB0178: No NamespaceContextSelector available, cannot lookup %s";
    protected String noNamespaceContextSelectorAvailable$str() {
        return noNamespaceContextSelectorAvailable;
    }
    @Override
    public final IllegalArgumentException noNamespaceContextSelectorAvailable(final String name) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), noNamespaceContextSelectorAvailable$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failToLookupJNDI = "WFLYEJB0179:  Could not lookup jndi name: %s";
    protected String failToLookupJNDI$str() {
        return failToLookupJNDI;
    }
    @Override
    public final RuntimeException failToLookupJNDI(final String name, final Throwable e) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), failToLookupJNDI$str(), name), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failToLookupJNDINameSpace = "WFLYEJB0180: Cannot lookup jndi name: %s since it doesn't belong to java:app, java:module, java:comp or java:global namespace";
    protected String failToLookupJNDINameSpace$str() {
        return failToLookupJNDINameSpace;
    }
    @Override
    public final IllegalArgumentException failToLookupJNDINameSpace(final String name) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), failToLookupJNDINameSpace$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failToLookupStrippedJNDI = "WFLYEJB0181: Could not lookup jndi name: %s in context: %s";
    protected String failToLookupStrippedJNDI$str() {
        return failToLookupStrippedJNDI;
    }
    @Override
    public final IllegalArgumentException failToLookupStrippedJNDI(final NamespaceContextSelector namespaceContextSelector, final Context jndiContext, final Throwable ne) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), failToLookupStrippedJNDI$str(), namespaceContextSelector, jndiContext), ne);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failToCallSetRollbackOnlyOnNoneCMB = "WFLYEJB0182: EJB 3.1 FR 13.6.1 Only beans with container-managed transaction demarcation can use setRollbackOnly.";
    protected String failToCallSetRollbackOnlyOnNoneCMB$str() {
        return failToCallSetRollbackOnlyOnNoneCMB;
    }
    @Override
    public final IllegalStateException failToCallSetRollbackOnlyOnNoneCMB() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), failToCallSetRollbackOnlyOnNoneCMB$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failToCallSetRollbackOnlyWithNoTx = "WFLYEJB0183: setRollbackOnly() not allowed without a transaction.";
    protected String failToCallSetRollbackOnlyWithNoTx$str() {
        return failToCallSetRollbackOnlyWithNoTx;
    }
    @Override
    public final IllegalStateException failToCallSetRollbackOnlyWithNoTx() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), failToCallSetRollbackOnlyWithNoTx$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String EjbJarConfigurationIsNull = "WFLYEJB0184: EjbJarConfiguration cannot be null";
    protected String EjbJarConfigurationIsNull$str() {
        return EjbJarConfigurationIsNull;
    }
    @Override
    public final IllegalArgumentException EjbJarConfigurationIsNull() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), EjbJarConfigurationIsNull$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String SecurityRolesIsNull = "WFLYEJB0185: Cannot set security roles to null";
    protected String SecurityRolesIsNull$str() {
        return SecurityRolesIsNull;
    }
    @Override
    public final IllegalArgumentException SecurityRolesIsNull() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), SecurityRolesIsNull$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failToLinkFromEmptySecurityRole = "WFLYEJB0193: Cannot link from a null or empty security role: %s";
    protected String failToLinkFromEmptySecurityRole$str() {
        return failToLinkFromEmptySecurityRole;
    }
    @Override
    public final IllegalArgumentException failToLinkFromEmptySecurityRole(final String fromRole) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), failToLinkFromEmptySecurityRole$str(), fromRole));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failToLinkToEmptySecurityRole = "WFLYEJB0194: Cannot link to a null or empty security role: %s";
    protected String failToLinkToEmptySecurityRole$str() {
        return failToLinkToEmptySecurityRole;
    }
    @Override
    public final IllegalArgumentException failToLinkToEmptySecurityRole(final String toRole) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), failToLinkToEmptySecurityRole$str(), toRole));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String ejbJarConfigNotFound = "WFLYEJB0195: EjbJarConfiguration not found as an attachment in deployment unit: %s";
    protected String ejbJarConfigNotFound$str() {
        return ejbJarConfigNotFound;
    }
    @Override
    public final DeploymentUnitProcessingException ejbJarConfigNotFound(final DeploymentUnit deploymentUnit) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), ejbJarConfigNotFound$str(), deploymentUnit));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String componentViewNotAvailableInContext = "WFLYEJB0196: ComponentViewInstance not available in interceptor context: %s";
    protected String componentViewNotAvailableInContext$str() {
        return componentViewNotAvailableInContext;
    }
    @Override
    public final IllegalStateException componentViewNotAvailableInContext(final InterceptorContext context) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), componentViewNotAvailableInContext$str(), context));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unknownResourceAdapter = "WFLYEJB0199: No resource adapter registered with resource adapter name %s";
    protected String unknownResourceAdapter$str() {
        return unknownResourceAdapter;
    }
    @Override
    public final IllegalStateException unknownResourceAdapter(final String resourceAdapterName) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), unknownResourceAdapter$str(), resourceAdapterName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String securityNotEnabled = "WFLYEJB0201: Security is not enabled";
    protected String securityNotEnabled$str() {
        return securityNotEnabled;
    }
    @Override
    public final UnsupportedOperationException securityNotEnabled() {
        final UnsupportedOperationException result = new UnsupportedOperationException(String.format(getLoggingLocale(), securityNotEnabled$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failToCompleteTaskBeforeTimeOut = "WFLYEJB0202: Task did not complete in %s  %S";
    protected String failToCompleteTaskBeforeTimeOut$str() {
        return failToCompleteTaskBeforeTimeOut;
    }
    @Override
    public final TimeoutException failToCompleteTaskBeforeTimeOut(final long timeout, final TimeUnit unit) {
        final TimeoutException result = new TimeoutException(String.format(getLoggingLocale(), failToCompleteTaskBeforeTimeOut$str(), timeout, unit));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String taskWasCancelled = "WFLYEJB0203: Task was cancelled";
    protected String taskWasCancelled$str() {
        return taskWasCancelled;
    }
    @Override
    public final CancellationException taskWasCancelled() {
        final CancellationException result = new CancellationException(String.format(getLoggingLocale(), taskWasCancelled$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String methodNotImplemented = "WFLYEJB0206: Not implemented yet";
    protected String methodNotImplemented$str() {
        return methodNotImplemented;
    }
    @Override
    public final IllegalStateException methodNotImplemented() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), methodNotImplemented$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unexpectedComponent = "WFLYEJB0213: Unexpected component: %s component Expected %s";
    protected String unexpectedComponent$str() {
        return unexpectedComponent;
    }
    @Override
    public final IllegalStateException unexpectedComponent(final Component component, final Class<?> entityBeanComponentClass) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), unexpectedComponent$str(), component, entityBeanComponentClass));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String ejbJarConfigNotBeenSet = "WFLYEJB0214: EjbJarConfiguration hasn't been set in %s Cannot create component create service for EJB %S";
    protected String ejbJarConfigNotBeenSet$str() {
        return ejbJarConfigNotBeenSet;
    }
    @Override
    public final IllegalStateException ejbJarConfigNotBeenSet(final ComponentCreateServiceFactory serviceFactory, final String componentName) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), ejbJarConfigNotBeenSet$str(), serviceFactory, componentName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String poolConfigIsEmpty = "WFLYEJB0218: PoolConfig cannot be null or empty";
    protected String poolConfigIsEmpty$str() {
        return poolConfigIsEmpty;
    }
    @Override
    public final IllegalStateException poolConfigIsEmpty() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), poolConfigIsEmpty$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failToAddClassToLocalView = "WFLYEJB0220: [EJB 3.1 spec, section 4.9.7] - Can't add view class: %s as local view since it's already marked as remote view for bean: %s";
    protected String failToAddClassToLocalView$str() {
        return failToAddClassToLocalView;
    }
    @Override
    public final IllegalStateException failToAddClassToLocalView(final String viewClassName, final String ejbName) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), failToAddClassToLocalView$str(), viewClassName, ejbName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String businessInterfaceIsNull = "WFLYEJB0221: Business interface type cannot be null";
    protected String businessInterfaceIsNull$str() {
        return businessInterfaceIsNull;
    }
    @Override
    public final IllegalStateException businessInterfaceIsNull() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), businessInterfaceIsNull$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String beanComponentMissingEjbObject = "WFLYEJB0222: Bean %s does not have an %s";
    protected String beanComponentMissingEjbObject$str() {
        return beanComponentMissingEjbObject;
    }
    @Override
    public final IllegalStateException beanComponentMissingEjbObject(final String componentName, final String ejbLocalObject) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), beanComponentMissingEjbObject$str(), componentName, ejbLocalObject));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String getRollBackOnlyIsNotAllowWithSupportsAttribute = "WFLYEJB0223: EJB 3.1 FR 13.6.2.9 getRollbackOnly is not allowed with SUPPORTS attribute";
    protected String getRollBackOnlyIsNotAllowWithSupportsAttribute$str() {
        return getRollBackOnlyIsNotAllowWithSupportsAttribute;
    }
    @Override
    public final IllegalStateException getRollBackOnlyIsNotAllowWithSupportsAttribute() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), getRollBackOnlyIsNotAllowWithSupportsAttribute$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failToCallBusinessOnNonePublicMethod = "WFLYEJB0224: Not a business method %s. Do not call non-public methods on EJB's";
    protected String failToCallBusinessOnNonePublicMethod$str() {
        return failToCallBusinessOnNonePublicMethod;
    }
    @Override
    public final EJBException failToCallBusinessOnNonePublicMethod(final Method method) {
        final EJBException result = new EJBException(String.format(getLoggingLocale(), failToCallBusinessOnNonePublicMethod$str(), method));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String componentInstanceNotAvailable = "WFLYEJB0225: Component instance isn't available for invocation: %s";
    protected String componentInstanceNotAvailable$str() {
        return componentInstanceNotAvailable;
    }
    @Override
    public final Exception componentInstanceNotAvailable(final InterceptorContext interceptorContext) {
        final Exception result = new Exception(String.format(getLoggingLocale(), componentInstanceNotAvailable$str(), interceptorContext));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failToObtainLock = "WFLYEJB0228: EJB 3.1 FR 4.3.14.1 concurrent access timeout on %s - could not obtain lock within %s %s";
    protected String failToObtainLock$str() {
        return failToObtainLock;
    }
    @Override
    public final ConcurrentAccessTimeoutException failToObtainLock(final String ejb, final long value, final TimeUnit timeUnit) {
        final ConcurrentAccessTimeoutException result = new ConcurrentAccessTimeoutException(String.format(getLoggingLocale(), failToObtainLock$str(), ejb, value, timeUnit));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String statefulSessionIdIsNull = "WFLYEJB0234: Session id hasn't been set for stateful component: %s";
    protected String statefulSessionIdIsNull$str() {
        return statefulSessionIdIsNull;
    }
    @Override
    public final IllegalStateException statefulSessionIdIsNull(final String componentName) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), statefulSessionIdIsNull$str(), componentName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String removeMethodIsNull = "WFLYEJB0235: @Remove method identifier cannot be null";
    protected String removeMethodIsNull$str() {
        return removeMethodIsNull;
    }
    @Override
    public final IllegalArgumentException removeMethodIsNull() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), removeMethodIsNull$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String componentNotInstanceOfSessionComponent = "WFLYEJB0236: Component %s with component class: %s%n isn't a %s component";
    protected String componentNotInstanceOfSessionComponent$str() {
        return componentNotInstanceOfSessionComponent;
    }
    @Override
    public final IllegalArgumentException componentNotInstanceOfSessionComponent(final Component component, final Class<?> componentClass, final String type) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), componentNotInstanceOfSessionComponent$str(), component, componentClass, type));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String bothMethodIntAndClassNameSet = "WFLYEJB0237: both methodIntf and className are set on %s";
    protected String bothMethodIntAndClassNameSet$str() {
        return bothMethodIntAndClassNameSet;
    }
    @Override
    public final IllegalArgumentException bothMethodIntAndClassNameSet(final String componentName) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), bothMethodIntAndClassNameSet$str(), componentName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failToUpgradeToWriteLock = "WFLYEJB0238: EJB 3.1 PFD2 4.8.5.1.1 upgrading from read to write lock is not allowed";
    protected String failToUpgradeToWriteLock$str() {
        return failToUpgradeToWriteLock;
    }
    @Override
    public final IllegalLoopbackException failToUpgradeToWriteLock() {
        final IllegalLoopbackException result = new IllegalLoopbackException(String.format(getLoggingLocale(), failToUpgradeToWriteLock$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String componentIsNull = "WFLYEJB0239: %s cannot be null";
    protected String componentIsNull$str() {
        return componentIsNull;
    }
    @Override
    public final IllegalArgumentException componentIsNull(final String name) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), componentIsNull$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invocationNotApplicableForMethodInvocation = "WFLYEJB0240: Invocation context: %s cannot be processed because it's not applicable for a method invocation";
    protected String invocationNotApplicableForMethodInvocation$str() {
        return invocationNotApplicableForMethodInvocation;
    }
    @Override
    public final IllegalArgumentException invocationNotApplicableForMethodInvocation(final InvocationContext invocationContext) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invocationNotApplicableForMethodInvocation$str(), invocationContext));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String concurrentAccessTimeoutException = "WFLYEJB0241: EJB 3.1 PFD2 4.8.5.5.1 concurrent access timeout on %s - could not obtain lock within %s";
    protected String concurrentAccessTimeoutException$str() {
        return concurrentAccessTimeoutException;
    }
    @Override
    public final ConcurrentAccessTimeoutException concurrentAccessTimeoutException(final String ejb, final String s) {
        final ConcurrentAccessTimeoutException result = new ConcurrentAccessTimeoutException(String.format(getLoggingLocale(), concurrentAccessTimeoutException$str(), ejb, s));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failToObtainLockIllegalType = "WFLYEJB0242: Illegal lock type %s on %s for component %s";
    protected String failToObtainLockIllegalType$str() {
        return failToObtainLockIllegalType;
    }
    @Override
    public final IllegalStateException failToObtainLockIllegalType(final LockType lockType, final Method method, final LockableComponent lockableComponent) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), failToObtainLockIllegalType$str(), lockType, method, lockableComponent));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotCall2 = "WFLYEJB0243: Cannot call %s, no %s is present for this invocation";
    protected String cannotCall2$str() {
        return cannotCall2;
    }
    @Override
    public final IllegalStateException cannotCall(final String methodName, final String missing) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), cannotCall2$str(), methodName, missing));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noAsynchronousInvocationInProgress = "WFLYEJB0244: No asynchronous invocation in progress";
    protected String noAsynchronousInvocationInProgress$str() {
        return noAsynchronousInvocationInProgress;
    }
    @Override
    public final IllegalStateException noAsynchronousInvocationInProgress() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), noAsynchronousInvocationInProgress$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String isDeprecated = "WFLYEJB0246: %s is deprecated";
    protected String isDeprecated$str() {
        return isDeprecated;
    }
    @Override
    public final UnsupportedOperationException isDeprecated(final String getEnvironment) {
        final UnsupportedOperationException result = new UnsupportedOperationException(String.format(getLoggingLocale(), isDeprecated$str(), getEnvironment));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String shouldBeOverridden = "WFLYEJB0253: Should be overridden";
    protected String shouldBeOverridden$str() {
        return shouldBeOverridden;
    }
    @Override
    public final IllegalStateException shouldBeOverridden() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), shouldBeOverridden$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String roleNamesIsNull = "WFLYEJB0255: <role-name> cannot be null or empty in <security-role-ref>%nfor bean: %s";
    protected String roleNamesIsNull$str() {
        return roleNamesIsNull;
    }
    @Override
    public final DeploymentUnitProcessingException roleNamesIsNull(final String ejbName) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), roleNamesIsNull$str(), ejbName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String defaultInterceptorsNotBindToMethod = "WFLYEJB0256: Default interceptors cannot specify a method to bind to in ejb-jar.xml";
    protected String defaultInterceptorsNotBindToMethod$str() {
        return defaultInterceptorsNotBindToMethod;
    }
    @Override
    public final DeploymentUnitProcessingException defaultInterceptorsNotBindToMethod() {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), defaultInterceptorsNotBindToMethod$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String twoEjbBindingsSpecifyAbsoluteOrder = "WFLYEJB0258: Two ejb-jar.xml bindings for %s specify an absolute order";
    protected String twoEjbBindingsSpecifyAbsoluteOrder$str() {
        return twoEjbBindingsSpecifyAbsoluteOrder;
    }
    @Override
    public final DeploymentUnitProcessingException twoEjbBindingsSpecifyAbsoluteOrder(final String component) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), twoEjbBindingsSpecifyAbsoluteOrder$str(), component));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failToFindMethodInEjbJarXml = "WFLYEJB0259: Could not find method %s.%s referenced in ejb-jar.xml";
    protected String failToFindMethodInEjbJarXml$str() {
        return failToFindMethodInEjbJarXml;
    }
    @Override
    public final DeploymentUnitProcessingException failToFindMethodInEjbJarXml(final String name, final String methodName) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), failToFindMethodInEjbJarXml$str(), name, methodName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String multipleMethodReferencedInEjbJarXml = "WFLYEJB0260: More than one method %s found on class %s referenced in ejb-jar.xml. Specify the parameter types to resolve the ambiguity";
    protected String multipleMethodReferencedInEjbJarXml$str() {
        return multipleMethodReferencedInEjbJarXml;
    }
    @Override
    public final DeploymentUnitProcessingException multipleMethodReferencedInEjbJarXml(final String methodName, final String name) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), multipleMethodReferencedInEjbJarXml$str(), methodName, name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failToFindMethodWithParameterTypes = "WFLYEJB0261: Could not find method %s.%s with parameter types %s referenced in ejb-jar.xml";
    protected String failToFindMethodWithParameterTypes$str() {
        return failToFindMethodWithParameterTypes;
    }
    @Override
    public final DeploymentUnitProcessingException failToFindMethodWithParameterTypes(final String name, final String methodName, final MethodParametersMetaData methodParams) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), failToFindMethodWithParameterTypes$str(), name, methodName, methodParams));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failToLoadComponentClass = "WFLYEJB0262: Could not load component class for component %s";
    protected String failToLoadComponentClass$str() {
        return failToLoadComponentClass;
    }
    @Override
    public final DeploymentUnitProcessingException failToLoadComponentClass(final Throwable t, final String componentName) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), failToLoadComponentClass$str(), componentName), t);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failToLoadEjbViewClass = "WFLYEJB0263: Could not load EJB view class ";
    protected String failToLoadEjbViewClass$str() {
        return failToLoadEjbViewClass;
    }
    @Override
    public final RuntimeException failToLoadEjbViewClass(final Throwable e) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), failToLoadEjbViewClass$str()), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failToMergeData = "WFLYEJB0264: Could not merge data for %s";
    protected String failToMergeData$str() {
        return failToMergeData;
    }
    @Override
    public final DeploymentUnitProcessingException failToMergeData(final String componentName, final Throwable e) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), failToMergeData$str(), componentName), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failToLoadEjbClass = "WFLYEJB0265: Could not load EJB class %s";
    protected String failToLoadEjbClass$str() {
        return failToLoadEjbClass;
    }
    @Override
    public final DeploymentUnitProcessingException failToLoadEjbClass(final String ejbClassName, final Throwable e) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), failToLoadEjbClass$str(), ejbClassName), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String multipleAnnotationsOnBean = "WFLYEJB0266: Only one %s method is allowed on bean %s";
    protected String multipleAnnotationsOnBean$str() {
        return multipleAnnotationsOnBean;
    }
    @Override
    public final RuntimeException multipleAnnotationsOnBean(final String annotationType, final String ejbClassName) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), multipleAnnotationsOnBean$str(), annotationType, ejbClassName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String multipleCreateMethod = "WFLYEJB0267: Could not determine type of corresponding implied EJB 2.x local interface (see EJB 3.1 21.4.5)%n due to multiple create* methods with different return types on home %s";
    protected String multipleCreateMethod$str() {
        return multipleCreateMethod;
    }
    @Override
    public final DeploymentUnitProcessingException multipleCreateMethod(final Class<?> localHomeClass) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), multipleCreateMethod$str(), localHomeClass));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failToFindEjbRefByDependsOn = "WFLYEJB0268: Could not find EJB %s referenced by @DependsOn annotation in %s";
    protected String failToFindEjbRefByDependsOn$str() {
        return failToFindEjbRefByDependsOn;
    }
    @Override
    public final DeploymentUnitProcessingException failToFindEjbRefByDependsOn(final String annotationValue, final String componentClassName) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), failToFindEjbRefByDependsOn$str(), annotationValue, componentClassName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failToCallEjbRefByDependsOn = "WFLYEJB0269: More than one EJB called %s referenced by @DependsOn annotation in %s Components:%s";
    protected String failToCallEjbRefByDependsOn$str() {
        return failToCallEjbRefByDependsOn;
    }
    @Override
    public final DeploymentUnitProcessingException failToCallEjbRefByDependsOn(final String annotationValue, final String componentClassName, final java.util.Set<org.jboss.as.ee.component.ComponentDescription> components) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), failToCallEjbRefByDependsOn$str(), annotationValue, componentClassName, components));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String wrongReturnTypeForAsyncMethod = "WFLYEJB0270: Async method %s does not return void or Future";
    protected String wrongReturnTypeForAsyncMethod$str() {
        return wrongReturnTypeForAsyncMethod;
    }
    @Override
    public final DeploymentUnitProcessingException wrongReturnTypeForAsyncMethod(final Method method) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), wrongReturnTypeForAsyncMethod$str(), method));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failToLoadAppExceptionClassInEjbJarXml = "WFLYEJB0271: Could not load application exception class %s in ejb-jar.xml";
    protected String failToLoadAppExceptionClassInEjbJarXml$str() {
        return failToLoadAppExceptionClassInEjbJarXml;
    }
    @Override
    public final DeploymentUnitProcessingException failToLoadAppExceptionClassInEjbJarXml(final String exceptionClassName, final Throwable e) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), failToLoadAppExceptionClassInEjbJarXml$str(), exceptionClassName), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidEjbEntityTimeout = "WFLYEJB0272: EJB %s entity bean %s implemented TimedObject, but has a different timeout method specified either via annotations or via the deployment descriptor";
    protected String invalidEjbEntityTimeout$str() {
        return invalidEjbEntityTimeout;
    }
    @Override
    public final DeploymentUnitProcessingException invalidEjbEntityTimeout(final String versionId, final Class<?> componentClass) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), invalidEjbEntityTimeout$str(), versionId, componentClass));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidEjbLocalInterface = "WFLYEJB0273: %s does not have an EJB 2.x local interface";
    protected String invalidEjbLocalInterface$str() {
        return invalidEjbLocalInterface;
    }
    @Override
    public final RuntimeException invalidEjbLocalInterface(final String componentName) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), invalidEjbLocalInterface$str(), componentName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String localHomeNotAllow = "WFLYEJB0274: Local Home not allowed for %s";
    protected String localHomeNotAllow$str() {
        return localHomeNotAllow;
    }
    @Override
    public final DeploymentUnitProcessingException localHomeNotAllow(final EJBComponentDescription description) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), localHomeNotAllow$str(), description));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failToCallEjbCreateForHomeInterface = "WFLYEJB0275: Could not resolve corresponding ejbCreate or @Init method for home interface method %s on EJB %s";
    protected String failToCallEjbCreateForHomeInterface$str() {
        return failToCallEjbCreateForHomeInterface;
    }
    @Override
    public final DeploymentUnitProcessingException failToCallEjbCreateForHomeInterface(final Method method, final String ejbClassName) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), failToCallEjbCreateForHomeInterface$str(), method, ejbClassName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failToGetEjbComponent = "WFLYEJB0276: EJBComponent has not been set in the current invocation context %s";
    protected String failToGetEjbComponent$str() {
        return failToGetEjbComponent;
    }
    @Override
    public final IllegalStateException failToGetEjbComponent(final InterceptorContext currentInvocationContext) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), failToGetEjbComponent$str(), currentInvocationContext));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String valueIsNull = "WFLYEJB0277: Value cannot be null";
    protected String valueIsNull$str() {
        return valueIsNull;
    }
    @Override
    public final IllegalArgumentException valueIsNull() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), valueIsNull$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidScheduleExpression = "WFLYEJB0278: Cannot create %s from a null schedule expression";
    protected String invalidScheduleExpression$str() {
        return invalidScheduleExpression;
    }
    @Override
    public final IllegalArgumentException invalidScheduleExpression(final String name) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidScheduleExpression$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidScheduleExpressionSecond = "WFLYEJB0279: Second cannot be null in schedule expression %s";
    protected String invalidScheduleExpressionSecond$str() {
        return invalidScheduleExpressionSecond;
    }
    @Override
    public final IllegalArgumentException invalidScheduleExpressionSecond(final ScheduleExpression schedule) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidScheduleExpressionSecond$str(), schedule));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidScheduleExpressionMinute = "WFLYEJB0280: Minute cannot be null in schedule expression %s";
    protected String invalidScheduleExpressionMinute$str() {
        return invalidScheduleExpressionMinute;
    }
    @Override
    public final IllegalArgumentException invalidScheduleExpressionMinute(final ScheduleExpression schedule) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidScheduleExpressionMinute$str(), schedule));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidScheduleExpressionHour = "WFLYEJB0281: Hour cannot be null in schedule expression %s";
    protected String invalidScheduleExpressionHour$str() {
        return invalidScheduleExpressionHour;
    }
    @Override
    public final IllegalArgumentException invalidScheduleExpressionHour(final ScheduleExpression schedule) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidScheduleExpressionHour$str(), schedule));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidScheduleExpressionDayOfMonth = "WFLYEJB0282: day-of-month cannot be null in schedule expression %s";
    protected String invalidScheduleExpressionDayOfMonth$str() {
        return invalidScheduleExpressionDayOfMonth;
    }
    @Override
    public final IllegalArgumentException invalidScheduleExpressionDayOfMonth(final ScheduleExpression schedule) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidScheduleExpressionDayOfMonth$str(), schedule));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidScheduleExpressionDayOfWeek = "WFLYEJB0283: day-of-week cannot be null in schedule expression %s";
    protected String invalidScheduleExpressionDayOfWeek$str() {
        return invalidScheduleExpressionDayOfWeek;
    }
    @Override
    public final IllegalArgumentException invalidScheduleExpressionDayOfWeek(final ScheduleExpression schedule) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidScheduleExpressionDayOfWeek$str(), schedule));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidScheduleExpressionMonth = "WFLYEJB0284: Month cannot be null in schedule expression %s";
    protected String invalidScheduleExpressionMonth$str() {
        return invalidScheduleExpressionMonth;
    }
    @Override
    public final IllegalArgumentException invalidScheduleExpressionMonth(final ScheduleExpression schedule) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidScheduleExpressionMonth$str(), schedule));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidScheduleExpressionYear = "WFLYEJB0285: Year cannot be null in schedule expression %s";
    protected String invalidScheduleExpressionYear$str() {
        return invalidScheduleExpressionYear;
    }
    @Override
    public final IllegalArgumentException invalidScheduleExpressionYear(final ScheduleExpression schedule) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidScheduleExpressionYear$str(), schedule));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidRange = "WFLYEJB0286: Invalid range value: %s";
    protected String invalidRange$str() {
        return invalidRange;
    }
    @Override
    public final IllegalArgumentException invalidRange(final String range) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidRange$str(), range));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidListExpression = "WFLYEJB0287: Invalid list expression: %s";
    protected String invalidListExpression$str() {
        return invalidListExpression;
    }
    @Override
    public final IllegalArgumentException invalidListExpression(final String list) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidListExpression$str(), list));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidIncrementValue = "WFLYEJB0288: Invalid increment value: %s";
    protected String invalidIncrementValue$str() {
        return invalidIncrementValue;
    }
    @Override
    public final IllegalArgumentException invalidIncrementValue(final String value) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidIncrementValue$str(), value));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidExpressionSeconds = "WFLYEJB0289: There are no valid seconds for expression: %s";
    protected String invalidExpressionSeconds$str() {
        return invalidExpressionSeconds;
    }
    @Override
    public final IllegalStateException invalidExpressionSeconds(final String origValue) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), invalidExpressionSeconds$str(), origValue));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidExpressionMinutes = "WFLYEJB0290: There are no valid minutes for expression: %s";
    protected String invalidExpressionMinutes$str() {
        return invalidExpressionMinutes;
    }
    @Override
    public final IllegalStateException invalidExpressionMinutes(final String origValue) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), invalidExpressionMinutes$str(), origValue));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidScheduleExpressionType = "WFLYEJB0291: Invalid value: %s since %s doesn't support values of types %s";
    protected String invalidScheduleExpressionType$str() {
        return invalidScheduleExpressionType;
    }
    @Override
    public final IllegalArgumentException invalidScheduleExpressionType(final String value, final String name, final String type) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidScheduleExpressionType$str(), value, name, type));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidListValue = "WFLYEJB0292: A list value can only contain either a range or an individual value. Invalid value: %s";
    protected String invalidListValue$str() {
        return invalidListValue;
    }
    @Override
    public final IllegalArgumentException invalidListValue(final String listItem) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidListValue$str(), listItem));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldNotParseScheduleExpression = "WFLYEJB0293: Could not parse: %s in schedule expression";
    protected String couldNotParseScheduleExpression$str() {
        return couldNotParseScheduleExpression;
    }
    @Override
    public final IllegalArgumentException couldNotParseScheduleExpression(final String origValue) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), couldNotParseScheduleExpression$str(), origValue));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidValuesRange = "WFLYEJB0294: Invalid value: %s Valid values are between %s and %s";
    protected String invalidValuesRange$str() {
        return invalidValuesRange;
    }
    @Override
    public final IllegalArgumentException invalidValuesRange(final Integer value, final int min, final int max) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidValuesRange$str(), value, min, max));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidValueDayOfMonth = "WFLYEJB0295: Invalid value for day-of-month: %s";
    protected String invalidValueDayOfMonth$str() {
        return invalidValueDayOfMonth;
    }
    @Override
    public final IllegalArgumentException invalidValueDayOfMonth(final Integer value) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidValueDayOfMonth$str(), value));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String relativeDayOfMonthIsNull = "WFLYEJB0296: Relative day-of-month cannot be null or empty";
    protected String relativeDayOfMonthIsNull$str() {
        return relativeDayOfMonthIsNull;
    }
    @Override
    public final IllegalArgumentException relativeDayOfMonthIsNull() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), relativeDayOfMonthIsNull$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidRelativeValue = "WFLYEJB0297: %s is not a relative value";
    protected String invalidRelativeValue$str() {
        return invalidRelativeValue;
    }
    @Override
    public final IllegalArgumentException invalidRelativeValue(final String relativeDayOfMonth) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidRelativeValue$str(), relativeDayOfMonth));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String relativeValueIsNull = "WFLYEJB0298: Value is null, cannot determine if it's relative";
    protected String relativeValueIsNull$str() {
        return relativeValueIsNull;
    }
    @Override
    public final IllegalArgumentException relativeValueIsNull() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), relativeValueIsNull$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invokerIsNull = "WFLYEJB0303: Invoker cannot be null";
    protected String invokerIsNull$str() {
        return invokerIsNull;
    }
    @Override
    public final IllegalArgumentException invokerIsNull() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invokerIsNull$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String executorIsNull = "WFLYEJB0305: Executor cannot be null";
    protected String executorIsNull$str() {
        return executorIsNull;
    }
    @Override
    public final IllegalArgumentException executorIsNull() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), executorIsNull$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String initialExpirationIsNullCreatingTimer = "WFLYEJB0306: initialExpiration cannot be null while creating a timer";
    protected String initialExpirationIsNullCreatingTimer$str() {
        return initialExpirationIsNullCreatingTimer;
    }
    @Override
    public final IllegalArgumentException initialExpirationIsNullCreatingTimer() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), initialExpirationIsNullCreatingTimer$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidInitialExpiration = "WFLYEJB0307: %s cannot be negative while creating a timer";
    protected String invalidInitialExpiration$str() {
        return invalidInitialExpiration;
    }
    @Override
    public final IllegalArgumentException invalidInitialExpiration(final String type) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidInitialExpiration$str(), type));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String expirationIsNull = "WFLYEJB0308: expiration cannot be null while creating a single action timer";
    protected String expirationIsNull$str() {
        return expirationIsNull;
    }
    @Override
    public final IllegalArgumentException expirationIsNull() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), expirationIsNull$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidExpirationActionTimer = "WFLYEJB0309: expiration.getTime() cannot be negative while creating a single action timer";
    protected String invalidExpirationActionTimer$str() {
        return invalidExpirationActionTimer;
    }
    @Override
    public final IllegalArgumentException invalidExpirationActionTimer() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidExpirationActionTimer$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidDurationActionTimer = "WFLYEJB0310: duration cannot be negative while creating single action timer";
    protected String invalidDurationActionTimer$str() {
        return invalidDurationActionTimer;
    }
    @Override
    public final IllegalArgumentException invalidDurationActionTimer() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidDurationActionTimer$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidDurationTimer = "WFLYEJB0311: Duration cannot negative while creating the timer";
    protected String invalidDurationTimer$str() {
        return invalidDurationTimer;
    }
    @Override
    public final IllegalArgumentException invalidDurationTimer() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidDurationTimer$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String expirationDateIsNull = "WFLYEJB0312: Expiration date cannot be null while creating a timer";
    protected String expirationDateIsNull$str() {
        return expirationDateIsNull;
    }
    @Override
    public final IllegalArgumentException expirationDateIsNull() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), expirationDateIsNull$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidExpirationTimer = "WFLYEJB0313: expiration.getTime() cannot be negative while creating a timer";
    protected String invalidExpirationTimer$str() {
        return invalidExpirationTimer;
    }
    @Override
    public final IllegalArgumentException invalidExpirationTimer() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidExpirationTimer$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidInitialDurationTimer = "WFLYEJB0314: Initial duration cannot be negative while creating timer";
    protected String invalidInitialDurationTimer$str() {
        return invalidInitialDurationTimer;
    }
    @Override
    public final IllegalArgumentException invalidInitialDurationTimer() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidInitialDurationTimer$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidIntervalTimer = "WFLYEJB0315: Interval cannot be negative while creating timer";
    protected String invalidIntervalTimer$str() {
        return invalidIntervalTimer;
    }
    @Override
    public final IllegalArgumentException invalidIntervalTimer() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidIntervalTimer$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String initialExpirationDateIsNull = "WFLYEJB0316: initial expiration date cannot be null while creating a timer";
    protected String initialExpirationDateIsNull$str() {
        return initialExpirationDateIsNull;
    }
    @Override
    public final IllegalArgumentException initialExpirationDateIsNull() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), initialExpirationDateIsNull$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidIntervalDurationTimer = "WFLYEJB0317: interval duration cannot be negative while creating timer";
    protected String invalidIntervalDurationTimer$str() {
        return invalidIntervalDurationTimer;
    }
    @Override
    public final IllegalArgumentException invalidIntervalDurationTimer() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidIntervalDurationTimer$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failToCreateTimerDoLifecycle = "WFLYEJB0318: Creation of timers is not allowed during lifecycle callback of non-singleton EJBs";
    protected String failToCreateTimerDoLifecycle$str() {
        return failToCreateTimerDoLifecycle;
    }
    @Override
    public final IllegalStateException failToCreateTimerDoLifecycle() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), failToCreateTimerDoLifecycle$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String initialExpirationIsNull = "WFLYEJB0319: initial expiration is null";
    protected String initialExpirationIsNull$str() {
        return initialExpirationIsNull;
    }
    @Override
    public final IllegalArgumentException initialExpirationIsNull() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), initialExpirationIsNull$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidIntervalDuration = "WFLYEJB0320: interval duration is negative";
    protected String invalidIntervalDuration$str() {
        return invalidIntervalDuration;
    }
    @Override
    public final IllegalArgumentException invalidIntervalDuration() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidIntervalDuration$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String scheduleIsNull = "WFLYEJB0321: schedule is null";
    protected String scheduleIsNull$str() {
        return scheduleIsNull;
    }
    @Override
    public final IllegalArgumentException scheduleIsNull() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), scheduleIsNull$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failToInvokeTimerServiceDoLifecycle = "WFLYEJB0325: Cannot invoke timer service methods in lifecycle callback of non-singleton beans";
    protected String failToInvokeTimerServiceDoLifecycle$str() {
        return failToInvokeTimerServiceDoLifecycle;
    }
    @Override
    public final IllegalStateException failToInvokeTimerServiceDoLifecycle() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), failToInvokeTimerServiceDoLifecycle$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String timerIsNull = "WFLYEJB0326: Timer cannot be null";
    protected String timerIsNull$str() {
        return timerIsNull;
    }
    @Override
    public final IllegalStateException timerIsNull() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), timerIsNull$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidTimerHandlersForPersistentTimers = "WFLYEJB0327: %s Timer handles are only available for persistent timers.";
    protected String invalidTimerHandlersForPersistentTimers$str() {
        return invalidTimerHandlersForPersistentTimers;
    }
    @Override
    public final IllegalStateException invalidTimerHandlersForPersistentTimers(final String s) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), invalidTimerHandlersForPersistentTimers$str(), s));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noMoreTimeoutForTimer = "WFLYEJB0328: No more timeouts for timer %s";
    protected String noMoreTimeoutForTimer$str() {
        return noMoreTimeoutForTimer;
    }
    @Override
    public final NoMoreTimeoutsException noMoreTimeoutForTimer(final TimerImpl timer) {
        final NoMoreTimeoutsException result = new NoMoreTimeoutsException(String.format(getLoggingLocale(), noMoreTimeoutForTimer$str(), timer));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidTimerNotCalendarBaseTimer = "WFLYEJB0329: Timer %s is not a calendar based timer";
    protected String invalidTimerNotCalendarBaseTimer$str() {
        return invalidTimerNotCalendarBaseTimer;
    }
    @Override
    public final IllegalStateException invalidTimerNotCalendarBaseTimer(final TimerImpl timer) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), invalidTimerNotCalendarBaseTimer$str(), timer));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String timerHasExpired = "WFLYEJB0330: Timer has expired";
    protected String timerHasExpired$str() {
        return timerHasExpired;
    }
    @Override
    public final NoSuchObjectLocalException timerHasExpired() {
        final NoSuchObjectLocalException result = new NoSuchObjectLocalException(String.format(getLoggingLocale(), timerHasExpired$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String timerWasCanceled = "WFLYEJB0331: Timer was canceled";
    protected String timerWasCanceled$str() {
        return timerWasCanceled;
    }
    @Override
    public final NoSuchObjectLocalException timerWasCanceled() {
        final NoSuchObjectLocalException result = new NoSuchObjectLocalException(String.format(getLoggingLocale(), timerWasCanceled$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String idIsNull = "WFLYEJB0335: Id cannot be null";
    protected String idIsNull$str() {
        return idIsNull;
    }
    @Override
    public final IllegalArgumentException idIsNull() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), idIsNull$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String timedObjectNull = "WFLYEJB0336: Timed objectid cannot be null";
    protected String timedObjectNull$str() {
        return timedObjectNull;
    }
    @Override
    public final IllegalArgumentException timedObjectNull() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), timedObjectNull$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String timerServiceIsNull = "WFLYEJB0337: Timer service cannot be null";
    protected String timerServiceIsNull$str() {
        return timerServiceIsNull;
    }
    @Override
    public final IllegalArgumentException timerServiceIsNull() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), timerServiceIsNull$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String timerServiceWithIdNotRegistered = "WFLYEJB0338: Timerservice with timedObjectId: %s is not registered";
    protected String timerServiceWithIdNotRegistered$str() {
        return timerServiceWithIdNotRegistered;
    }
    @Override
    public final EJBException timerServiceWithIdNotRegistered(final String timedObjectId) {
        final EJBException result = new EJBException(String.format(getLoggingLocale(), timerServiceWithIdNotRegistered$str(), timedObjectId));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String timerHandleIsNotActive = "WFLYEJB0339: Timer for handle: %s is not active";
    protected String timerHandleIsNotActive$str() {
        return timerHandleIsNotActive;
    }
    @Override
    public final NoSuchObjectLocalException timerHandleIsNotActive(final TimerHandle timerHandle) {
        final NoSuchObjectLocalException result = new NoSuchObjectLocalException(String.format(getLoggingLocale(), timerHandleIsNotActive$str(), timerHandle));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failToInvokegetTimeoutMethod = "WFLYEJB0341: Cannot invoke getTimeoutMethod on a timer which is not an auto-timer";
    protected String failToInvokegetTimeoutMethod$str() {
        return failToInvokegetTimeoutMethod;
    }
    @Override
    public final IllegalStateException failToInvokegetTimeoutMethod() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), failToInvokegetTimeoutMethod$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failToLoadDeclaringClassOfTimeOut = "WFLYEJB0342: Could not load declaring class: %s of timeout method";
    protected String failToLoadDeclaringClassOfTimeOut$str() {
        return failToLoadDeclaringClassOfTimeOut;
    }
    @Override
    public final RuntimeException failToLoadDeclaringClassOfTimeOut(final String declaringClass) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), failToLoadDeclaringClassOfTimeOut$str(), declaringClass));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failToInvokeTimeout = "WFLYEJB0343: Cannot invoke timeout method because method %s is not a timeout method";
    protected String failToInvokeTimeout$str() {
        return failToInvokeTimeout;
    }
    @Override
    public final RuntimeException failToInvokeTimeout(final Method method) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), failToInvokeTimeout$str(), method));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failToCreateTimerFileStoreDir = "WFLYEJB0344: Could not create timer file store directory %s";
    protected String failToCreateTimerFileStoreDir$str() {
        return failToCreateTimerFileStoreDir;
    }
    @Override
    public final RuntimeException failToCreateTimerFileStoreDir(final File baseDir) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), failToCreateTimerFileStoreDir$str(), baseDir));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String timerFileStoreDirNotExist = "WFLYEJB0345: Timer file store directory %s does not exist";
    protected String timerFileStoreDirNotExist$str() {
        return timerFileStoreDirNotExist;
    }
    @Override
    public final RuntimeException timerFileStoreDirNotExist(final File baseDir) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), timerFileStoreDirNotExist$str(), baseDir));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidTimerFileStoreDir = "WFLYEJB0346: Timer file store directory %s is not a directory";
    protected String invalidTimerFileStoreDir$str() {
        return invalidTimerFileStoreDir;
    }
    @Override
    public final RuntimeException invalidTimerFileStoreDir(final File baseDir) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), invalidTimerFileStoreDir$str(), baseDir));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidSecurityForDomainSet = "WFLYEJB0347: EJB %s is enabled for security but doesn't have a security domain set";
    protected String invalidSecurityForDomainSet$str() {
        return invalidSecurityForDomainSet;
    }
    @Override
    public final IllegalStateException invalidSecurityForDomainSet(final String componentName) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), invalidSecurityForDomainSet$str(), componentName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidComponentConfiguration = "WFLYEJB0348: %s is not an EJB component";
    protected String invalidComponentConfiguration$str() {
        return invalidComponentConfiguration;
    }
    @Override
    public final IllegalArgumentException invalidComponentConfiguration(final String componentName) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidComponentConfiguration$str(), componentName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failToLoadViewClassEjb = "WFLYEJB0349: Could not load view class for ejb %s";
    protected String failToLoadViewClassEjb$str() {
        return failToLoadViewClassEjb;
    }
    @Override
    public final RuntimeException failToLoadViewClassEjb(final String beanName, final Throwable e) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), failToLoadViewClassEjb$str(), beanName), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidEjbComponent = "WFLYEJB0350: Component named %s with component class %s is not an EJB component";
    protected String invalidEjbComponent$str() {
        return invalidEjbComponent;
    }
    @Override
    public final IllegalArgumentException invalidEjbComponent(final String componentName, final Class<?> componentClass) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidEjbComponent$str(), componentName, componentClass));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String resourceBundleDescriptionsNotSupported = "WFLYEJB0353: ResourceBundle based descriptions of %s are not supported";
    protected String resourceBundleDescriptionsNotSupported$str() {
        return resourceBundleDescriptionsNotSupported;
    }
    @Override
    public final UnsupportedOperationException resourceBundleDescriptionsNotSupported(final String name) {
        final UnsupportedOperationException result = new UnsupportedOperationException(String.format(getLoggingLocale(), resourceBundleDescriptionsNotSupported$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String runtimeAttributeNotMarshallable = "WFLYEJB0354: Runtime attribute %s is not marshallable";
    protected String runtimeAttributeNotMarshallable$str() {
        return runtimeAttributeNotMarshallable;
    }
    @Override
    public final UnsupportedOperationException runtimeAttributeNotMarshallable(final String name) {
        final UnsupportedOperationException result = new UnsupportedOperationException(String.format(getLoggingLocale(), runtimeAttributeNotMarshallable$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidComponentType = "WFLYEJB0356: EJB component type %s does not support pools";
    protected String invalidComponentType$str() {
        return invalidComponentType;
    }
    @Override
    public final IllegalStateException invalidComponentType(final String simpleName) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), invalidComponentType$str(), simpleName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unknownComponentType = "WFLYEJB0357: Unknown EJBComponent type %s";
    protected String unknownComponentType$str() {
        return unknownComponentType;
    }
    @Override
    public final IllegalStateException unknownComponentType(final EJBComponentType ejbComponentType) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), unknownComponentType$str(), ejbComponentType));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String ejbMethodSecurityMetaDataIsNull = "WFLYEJB0360: EJB method security metadata cannot be null";
    protected String ejbMethodSecurityMetaDataIsNull$str() {
        return ejbMethodSecurityMetaDataIsNull;
    }
    @Override
    public final IllegalArgumentException ejbMethodSecurityMetaDataIsNull() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), ejbMethodSecurityMetaDataIsNull$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String viewClassNameIsNull = "WFLYEJB0361: View classname cannot be null or empty";
    protected String viewClassNameIsNull$str() {
        return viewClassNameIsNull;
    }
    @Override
    public final IllegalArgumentException viewClassNameIsNull() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), viewClassNameIsNull$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String viewMethodIsNull = "WFLYEJB0362: View method cannot be null";
    protected String viewMethodIsNull$str() {
        return viewMethodIsNull;
    }
    @Override
    public final IllegalArgumentException viewMethodIsNull() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), viewMethodIsNull$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failProcessInvocation = "WFLYEJB0363: %s cannot handle method %s of view class %s.Expected view method to be %s on view class %s";
    protected String failProcessInvocation$str() {
        return failProcessInvocation;
    }
    @Override
    public final IllegalStateException failProcessInvocation(final String name, final Method invokedMethod, final String viewClassOfInvokedMethod, final Method viewMethod, final String viewClassName) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), failProcessInvocation$str(), name, invokedMethod, viewClassOfInvokedMethod, viewMethod, viewClassName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invocationOfMethodNotAllowed = "WFLYEJB0364: Invocation on method: %s of bean: %s is not allowed";
    protected String invocationOfMethodNotAllowed$str() {
        return invocationOfMethodNotAllowed;
    }
    @Override
    public final EJBAccessException invocationOfMethodNotAllowed(final Method invokedMethod, final String componentName) {
        final EJBAccessException result = new EJBAccessException(String.format(getLoggingLocale(), invocationOfMethodNotAllowed$str(), invokedMethod, componentName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unknownComponentDescriptionType = "WFLYEJB0365: Unknown EJB Component description type %s";
    protected String unknownComponentDescriptionType$str() {
        return unknownComponentDescriptionType;
    }
    @Override
    public final IllegalArgumentException unknownComponentDescriptionType(final Class<?> aClass) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unknownComponentDescriptionType$str(), aClass));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unknownAttribute = "WFLYEJB0366: Unknown attribute %s";
    protected String unknownAttribute$str() {
        return unknownAttribute;
    }
    @Override
    public final IllegalStateException unknownAttribute(final String attributeName) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), unknownAttribute$str(), attributeName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unknownOperations = "WFLYEJB0367: Unknown operation %s";
    protected String unknownOperations$str() {
        return unknownOperations;
    }
    @Override
    public final IllegalStateException unknownOperations(final String opName) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), unknownOperations$str(), opName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noComponentRegisteredForAddress = "WFLYEJB0368: No EJB component registered for address %s";
    protected String noComponentRegisteredForAddress$str() {
        return noComponentRegisteredForAddress;
    }
    @Override
    public final String noComponentRegisteredForAddress(final PathAddress operationAddress) {
        return String.format(getLoggingLocale(), noComponentRegisteredForAddress$str(), operationAddress);
    }
    private static final String noComponentAvailableForAddress = "WFLYEJB0369: No EJB component is available for address %s";
    protected String noComponentAvailableForAddress$str() {
        return noComponentAvailableForAddress;
    }
    @Override
    public final String noComponentAvailableForAddress(final PathAddress operationAddress) {
        return String.format(getLoggingLocale(), noComponentAvailableForAddress$str(), operationAddress);
    }
    private static final String invalidComponentState = "WFLYEJB0370: EJB component for address %s is in %n state %s, must be in state %s";
    protected String invalidComponentState$str() {
        return invalidComponentState;
    }
    @Override
    public final String invalidComponentState(final PathAddress operationAddress, final State controllerState, final State up) {
        return String.format(getLoggingLocale(), invalidComponentState$str(), operationAddress, controllerState, up);
    }
    private static final String componentClassHasMultipleTimeoutAnnotations = "WFLYEJB0372: Component class %s has multiple @Timeout annotations";
    protected String componentClassHasMultipleTimeoutAnnotations$str() {
        return componentClassHasMultipleTimeoutAnnotations;
    }
    @Override
    public final DeploymentUnitProcessingException componentClassHasMultipleTimeoutAnnotations(final Class<?> componentClass) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), componentClassHasMultipleTimeoutAnnotations$str(), componentClass));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String currentComponentNotAEjb = "WFLYEJB0373: Current component is not an EJB %s";
    protected String currentComponentNotAEjb$str() {
        return currentComponentNotAEjb;
    }
    @Override
    public final IllegalStateException currentComponentNotAEjb(final ComponentInstance component) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), currentComponentNotAEjb$str(), component));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String lifecycleMethodNotAllowed = "WFLYEJB0374: %s not allowed in lifecycle methods";
    protected String lifecycleMethodNotAllowed$str() {
        return lifecycleMethodNotAllowed;
    }
    @Override
    public final IllegalStateException lifecycleMethodNotAllowed(final String methodName) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), lifecycleMethodNotAllowed$str(), methodName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotCall3 = "WFLYEJB0376: Cannot call %s when invoking through %s or %s";
    protected String cannotCall3$str() {
        return cannotCall3;
    }
    @Override
    public final IllegalStateException cannotCall(final String methodName, final String name, final String localName) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), cannotCall3$str(), methodName, name, localName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String notAllowedFromStatefulBeans = "WFLYEJB0377: %s is not allowed from stateful beans";
    protected String notAllowedFromStatefulBeans$str() {
        return notAllowedFromStatefulBeans;
    }
    @Override
    public final IllegalStateException notAllowedFromStatefulBeans(final String method) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), notAllowedFromStatefulBeans$str(), method));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToAcquirePermit = "WFLYEJB0378: Failed to acquire a permit within %s %s";
    protected String failedToAcquirePermit$str() {
        return failedToAcquirePermit;
    }
    @Override
    public final EJBException failedToAcquirePermit(final long timeout, final TimeUnit timeUnit) {
        final EJBException result = new EJBException(String.format(getLoggingLocale(), failedToAcquirePermit$str(), timeout, timeUnit));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String acquireSemaphoreInterrupted = "WFLYEJB0379: Acquire semaphore was interrupted";
    protected String acquireSemaphoreInterrupted$str() {
        return acquireSemaphoreInterrupted;
    }
    @Override
    public final EJBException acquireSemaphoreInterrupted() {
        final EJBException result = new EJBException(String.format(getLoggingLocale(), acquireSemaphoreInterrupted$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String isDeprecatedIllegalState = "WFLYEJB0380: %s is deprecated";
    protected String isDeprecatedIllegalState$str() {
        return isDeprecatedIllegalState;
    }
    @Override
    public final IllegalStateException isDeprecatedIllegalState(final String getEnvironment) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), isDeprecatedIllegalState$str(), getEnvironment));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldNotFindClassLoaderForStub = "WFLYEJB0382: Could not determine ClassLoader for stub %s";
    protected String couldNotFindClassLoaderForStub$str() {
        return couldNotFindClassLoaderForStub;
    }
    @Override
    public final RuntimeException couldNotFindClassLoaderForStub(final String stub) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), couldNotFindClassLoaderForStub$str(), stub));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unknownMessageListenerType = "WFLYEJB0383: No message listener of type %s found in resource adapter %s";
    protected String unknownMessageListenerType$str() {
        return unknownMessageListenerType;
    }
    @Override
    public final IllegalStateException unknownMessageListenerType(final String resourceAdapterName, final String messageListenerType) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), unknownMessageListenerType$str(), resourceAdapterName, messageListenerType));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldNotFindViewMethodOnEjb = "WFLYEJB0384: Could not find method %s from view %s on EJB class %s";
    protected String couldNotFindViewMethodOnEjb$str() {
        return couldNotFindViewMethodOnEjb;
    }
    @Override
    public final DeploymentUnitProcessingException couldNotFindViewMethodOnEjb(final Method method, final String viewClass, final String ejb) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), couldNotFindViewMethodOnEjb$str(), method, viewClass, ejb));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String stringParamCannotBeNullOrEmpty = "WFLYEJB0385: %s cannot be null or empty";
    protected String stringParamCannotBeNullOrEmpty$str() {
        return stringParamCannotBeNullOrEmpty;
    }
    @Override
    public final IllegalArgumentException stringParamCannotBeNullOrEmpty(final String paramName) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), stringParamCannotBeNullOrEmpty$str(), paramName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotRemoveWhileParticipatingInTransaction = "WFLYEJB0386: EJB 4.6.4 Cannot remove EJB via EJB 2.x remove() method while participating in a transaction";
    protected String cannotRemoveWhileParticipatingInTransaction$str() {
        return cannotRemoveWhileParticipatingInTransaction;
    }
    @Override
    public final RemoveException cannotRemoveWhileParticipatingInTransaction() {
        final RemoveException result = new RemoveException(String.format(getLoggingLocale(), cannotRemoveWhileParticipatingInTransaction$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String transactionPropagationNotSupported = "WFLYEJB0387: Transaction propagation over IIOP is not supported";
    protected String transactionPropagationNotSupported$str() {
        return transactionPropagationNotSupported;
    }
    @Override
    public final RemoteException transactionPropagationNotSupported() {
        final RemoteException result = new RemoteException(String.format(getLoggingLocale(), transactionPropagationNotSupported$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotCallMethodInAfterCompletion = "WFLYEJB0388: Cannot call method %s in afterCompletion callback";
    protected String cannotCallMethodInAfterCompletion$str() {
        return cannotCallMethodInAfterCompletion;
    }
    @Override
    public final IllegalStateException cannotCallMethodInAfterCompletion(final String methodName) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), cannotCallMethodInAfterCompletion$str(), methodName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotCallMethod = "WFLYEJB0389: Cannot call %s when state is %s";
    protected String cannotCallMethod$str() {
        return cannotCallMethod;
    }
    @Override
    public final IllegalStateException cannotCallMethod(final String methodName, final String state) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), cannotCallMethod$str(), methodName, state));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String existingSerializationGroup = "WFLYEJB0390: %s is already associated with serialization group %s";
    protected String existingSerializationGroup$str() {
        return existingSerializationGroup;
    }
    @Override
    public final IllegalStateException existingSerializationGroup(final Object key, final Object group) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), existingSerializationGroup$str(), key, group));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String incompatibleSerializationGroup = "WFLYEJB0391: %s is not compatible with serialization group %s";
    protected String incompatibleSerializationGroup$str() {
        return incompatibleSerializationGroup;
    }
    @Override
    public final IllegalStateException incompatibleSerializationGroup(final Object object, final Object group) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), incompatibleSerializationGroup$str(), object, group));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cacheEntryInUse = "WFLYEJB0392: Cache entry %s is in use";
    protected String cacheEntryInUse$str() {
        return cacheEntryInUse;
    }
    @Override
    public final IllegalStateException cacheEntryInUse(final Object entry) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), cacheEntryInUse$str(), entry));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cacheEntryNotInUse = "WFLYEJB0393: Cache entry %s is not in use";
    protected String cacheEntryNotInUse$str() {
        return cacheEntryNotInUse;
    }
    @Override
    public final IllegalStateException cacheEntryNotInUse(final Object entry) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), cacheEntryNotInUse$str(), entry));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String lockAcquisitionInterrupted = "WFLYEJB0394: Failed to acquire lock on %s";
    protected String lockAcquisitionInterrupted$str() {
        return lockAcquisitionInterrupted;
    }
    @Override
    public final RuntimeException lockAcquisitionInterrupted(final Throwable cause, final Object id) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), lockAcquisitionInterrupted$str(), id), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String duplicateSerializationGroupMember = "WFLYEJB0395: %s is already a member of serialization group %s";
    protected String duplicateSerializationGroupMember$str() {
        return duplicateSerializationGroupMember;
    }
    @Override
    public final IllegalStateException duplicateSerializationGroupMember(final Object id, final Object groupId) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), duplicateSerializationGroupMember$str(), id, groupId));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String missingSerializationGroupMember = "WFLYEJB0396: %s is not a member of serialization group %s";
    protected String missingSerializationGroupMember$str() {
        return missingSerializationGroupMember;
    }
    @Override
    public final IllegalStateException missingSerializationGroupMember(final Object id, final Object groupId) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), missingSerializationGroupMember$str(), id, groupId));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String duplicateCacheEntry = "WFLYEJB0397: %s already exists in cache";
    protected String duplicateCacheEntry$str() {
        return duplicateCacheEntry;
    }
    @Override
    public final IllegalStateException duplicateCacheEntry(final Object id) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), duplicateCacheEntry$str(), id));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String missingCacheEntry = "WFLYEJB0398: %s is missing from cache";
    protected String missingCacheEntry$str() {
        return missingCacheEntry;
    }
    @Override
    public final IllegalStateException missingCacheEntry(final Object id) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), missingCacheEntry$str(), id));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String incompatibleCaches = "WFLYEJB0399: Incompatible cache implementations in nested hierarchy";
    protected String incompatibleCaches$str() {
        return incompatibleCaches;
    }
    @Override
    public final IllegalStateException incompatibleCaches() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), incompatibleCaches$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String passivationFailed = "WFLYEJB0400: Failed to passivate %s";
    protected String passivationFailed$str() {
        return passivationFailed;
    }
    @Override
    public final RuntimeException passivationFailed(final Throwable cause, final Object id) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), passivationFailed$str(), id), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String activationFailed = "WFLYEJB0401: Failed to activate %s";
    protected String activationFailed$str() {
        return activationFailed;
    }
    @Override
    public final RuntimeException activationFailed(final Throwable cause, final Object id) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), activationFailed$str(), id), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String passivationDirectoryCreationFailed = "WFLYEJB0402: Failed to create passivation directory: %s";
    protected String passivationDirectoryCreationFailed$str() {
        return passivationDirectoryCreationFailed;
    }
    @Override
    public final RuntimeException passivationDirectoryCreationFailed(final String path) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), passivationDirectoryCreationFailed$str(), path));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String passivationPathNotADirectory = "WFLYEJB0403: Failed to create passivation directory: %s";
    protected String passivationPathNotADirectory$str() {
        return passivationPathNotADirectory;
    }
    @Override
    public final RuntimeException passivationPathNotADirectory(final String path) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), passivationPathNotADirectory$str(), path));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String groupCreationContextAlreadyExists = "WFLYEJB0404: Group creation context already exists";
    protected String groupCreationContextAlreadyExists$str() {
        return groupCreationContextAlreadyExists;
    }
    @Override
    public final IllegalStateException groupCreationContextAlreadyExists() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), groupCreationContextAlreadyExists$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String ejbNotFound3 = "WFLYEJB0405: No EJB found with interface of type '%s' and name '%s' for binding %s";
    protected String ejbNotFound3$str() {
        return ejbNotFound3;
    }
    @Override
    public final String ejbNotFound(final String typeName, final String beanName, final String binding) {
        return String.format(getLoggingLocale(), ejbNotFound3$str(), typeName, beanName, binding);
    }
    private static final String ejbNotFound2 = "WFLYEJB0406: No EJB found with interface of type '%s' for binding %s";
    protected String ejbNotFound2$str() {
        return ejbNotFound2;
    }
    @Override
    public final String ejbNotFound(final String typeName, final String binding) {
        return String.format(getLoggingLocale(), ejbNotFound2$str(), typeName, binding);
    }
    private static final String moreThanOneEjbFound4 = "WFLYEJB0407: More than one EJB found with interface of type '%s' and name '%s' for binding %s. Found: %s";
    protected String moreThanOneEjbFound4$str() {
        return moreThanOneEjbFound4;
    }
    @Override
    public final String moreThanOneEjbFound(final String typeName, final String beanName, final String binding, final java.util.Set<org.jboss.as.ejb3.component.EJBViewDescription> componentViews) {
        return String.format(getLoggingLocale(), moreThanOneEjbFound4$str(), typeName, beanName, binding, componentViews);
    }
    private static final String moreThanOneEjbFound3 = "WFLYEJB0408: More than one EJB found with interface of type '%s' for binding %s. Found: %s";
    protected String moreThanOneEjbFound3$str() {
        return moreThanOneEjbFound3;
    }
    @Override
    public final String moreThanOneEjbFound(final String typeName, final String binding, final java.util.Set<org.jboss.as.ejb3.component.EJBViewDescription> componentViews) {
        return String.format(getLoggingLocale(), moreThanOneEjbFound3$str(), typeName, binding, componentViews);
    }
    private static final String clusteredAnnotationIsNotApplicableForMDB = "WFLYEJB0409: @Clustered annotation cannot be used with message driven beans. %s failed since %s bean is marked with @Clustered on class %s";
    protected String clusteredAnnotationIsNotApplicableForMDB$str() {
        return clusteredAnnotationIsNotApplicableForMDB;
    }
    @Override
    public final DeploymentUnitProcessingException clusteredAnnotationIsNotApplicableForMDB(final DeploymentUnit unit, final String componentName, final String componentClassName) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), clusteredAnnotationIsNotApplicableForMDB$str(), unit, componentName, componentClassName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String clusteredAnnotationIsNotApplicableForEntityBean = "WFLYEJB0410: @Clustered annotation cannot be used with entity beans. %s failed since %s bean is marked with @Clustered on class %s";
    protected String clusteredAnnotationIsNotApplicableForEntityBean$str() {
        return clusteredAnnotationIsNotApplicableForEntityBean;
    }
    @Override
    public final DeploymentUnitProcessingException clusteredAnnotationIsNotApplicableForEntityBean(final DeploymentUnit unit, final String componentName, final String componentClassName) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), clusteredAnnotationIsNotApplicableForEntityBean$str(), unit, componentName, componentClassName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String clusteredAnnotationNotYetImplementedForSingletonBean = "WFLYEJB0411: @Clustered annotation is currently not supported for singleton EJB. %s failed since %s bean is marked with @Clustered on class %s";
    protected String clusteredAnnotationNotYetImplementedForSingletonBean$str() {
        return clusteredAnnotationNotYetImplementedForSingletonBean;
    }
    @Override
    public final DeploymentUnitProcessingException clusteredAnnotationNotYetImplementedForSingletonBean(final DeploymentUnit unit, final String componentName, final String componentClassName) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), clusteredAnnotationNotYetImplementedForSingletonBean$str(), unit, componentName, componentClassName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String clusteredAnnotationIsNotApplicableForBean = "WFLYEJB0412: %s failed since @Clustered annotation cannot be used for %s bean on class %s";
    protected String clusteredAnnotationIsNotApplicableForBean$str() {
        return clusteredAnnotationIsNotApplicableForBean;
    }
    @Override
    public final DeploymentUnitProcessingException clusteredAnnotationIsNotApplicableForBean(final DeploymentUnit unit, final String componentName, final String componentClassName) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), clusteredAnnotationIsNotApplicableForBean$str(), unit, componentName, componentClassName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String sessionTypeNotSpecified = "WFLYEJB0413: <session-type> not specified for ejb %s. This must be present in ejb-jar.xml";
    protected String sessionTypeNotSpecified$str() {
        return sessionTypeNotSpecified;
    }
    @Override
    public final DeploymentUnitProcessingException sessionTypeNotSpecified(final String bean) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), sessionTypeNotSpecified$str(), bean));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String defaultInterceptorsNotSpecifyOrder = "WFLYEJB0414: Default interceptors cannot specify an <interceptor-order> element in ejb-jar.xml";
    protected String defaultInterceptorsNotSpecifyOrder$str() {
        return defaultInterceptorsNotSpecifyOrder;
    }
    @Override
    public final DeploymentUnitProcessingException defaultInterceptorsNotSpecifyOrder() {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), defaultInterceptorsNotSpecifyOrder$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String paramCannotBeNull = "WFLYEJB0416: %s cannot be null";
    protected String paramCannotBeNull$str() {
        return paramCannotBeNull;
    }
    @Override
    public final IllegalArgumentException paramCannotBeNull(final String paramName) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), paramCannotBeNull$str(), paramName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String poolNameCannotBeEmptyString = "WFLYEJB0419: Pool name cannot be empty string for bean %s";
    protected String poolNameCannotBeEmptyString$str() {
        return poolNameCannotBeEmptyString;
    }
    @Override
    public final IllegalArgumentException poolNameCannotBeEmptyString(final String ejbName) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), poolNameCannotBeEmptyString$str(), ejbName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noEjbContextAvailable = "WFLYEJB0420: No EjbContext available as no EJB invocation is active";
    protected String noEjbContextAvailable$str() {
        return noEjbContextAvailable;
    }
    @Override
    public final IllegalStateException noEjbContextAvailable() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), noEjbContextAvailable$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String componentIsShuttingDown = "WFLYEJB0421: Invocation cannot proceed as component is shutting down";
    protected String componentIsShuttingDown$str() {
        return componentIsShuttingDown;
    }
    @Override
    public final EJBComponentUnavailableException componentIsShuttingDown() {
        final EJBComponentUnavailableException result = new EJBComponentUnavailableException(String.format(getLoggingLocale(), componentIsShuttingDown$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToCreateSessionForStatefulBean = "WFLYEJB0423: Could not create session for stateful bean %s";
    protected String failedToCreateSessionForStatefulBean$str() {
        return failedToCreateSessionForStatefulBean;
    }
    @Override
    public final RuntimeException failedToCreateSessionForStatefulBean(final Exception e, final String beanName) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), failedToCreateSessionForStatefulBean$str(), beanName), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unknownChannelCreationOptionType = "WFLYEJB0436: Unknown channel creation option type %s";
    protected String unknownChannelCreationOptionType$str() {
        return unknownChannelCreationOptionType;
    }
    @Override
    public final IllegalArgumentException unknownChannelCreationOptionType(final String optionType) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unknownChannelCreationOptionType$str(), optionType));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldNotDetermineRemoteInterfaceFromHome = "WFLYEJB0437: Could not determine remote interface from home interface %s for bean %s";
    protected String couldNotDetermineRemoteInterfaceFromHome$str() {
        return couldNotDetermineRemoteInterfaceFromHome;
    }
    @Override
    public final DeploymentUnitProcessingException couldNotDetermineRemoteInterfaceFromHome(final String homeClass, final String beanName) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), couldNotDetermineRemoteInterfaceFromHome$str(), homeClass, beanName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldNotDetermineLocalInterfaceFromLocalHome = "WFLYEJB0438: Could not determine local interface from local home interface %s for bean %s";
    protected String couldNotDetermineLocalInterfaceFromLocalHome$str() {
        return couldNotDetermineLocalInterfaceFromLocalHome;
    }
    @Override
    public final DeploymentUnitProcessingException couldNotDetermineLocalInterfaceFromLocalHome(final String localHomeClass, final String beanName) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), couldNotDetermineLocalInterfaceFromLocalHome$str(), localHomeClass, beanName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String ejbBusinessMethodMustBePublic = "WFLYEJB0441: EJB business method %s must be public";
    protected String ejbBusinessMethodMustBePublic$str() {
        return ejbBusinessMethodMustBePublic;
    }
    @Override
    public final DeploymentUnitProcessingException ejbBusinessMethodMustBePublic(final Method method) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), ejbBusinessMethodMustBePublic$str(), method));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unexpectedError = "WFLYEJB0442: Unexpected Error";
    protected String unexpectedError$str() {
        return unexpectedError;
    }
    @Override
    public final EJBException unexpectedError() {
        final EJBException result = new EJBException(String.format(getLoggingLocale(), unexpectedError$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String transactionNotComplete1 = "WFLYEJB0443: EJB 3.1 FR 13.3.3: BMT bean %s should complete transaction before returning.";
    protected String transactionNotComplete1$str() {
        return transactionNotComplete1;
    }
    @Override
    public final String transactionNotComplete(final String componentName) {
        return String.format(getLoggingLocale(), transactionNotComplete1$str(), componentName);
    }
    private static final String untransformableTimerService = "WFLYEJB0444: Timer service resource %s is not suitable for the target. Only a configuration with a single file-store and no other configured data-store is supported on target";
    protected String untransformableTimerService$str() {
        return untransformableTimerService;
    }
    @Override
    public final String untransformableTimerService(final PathAddress address) {
        return String.format(getLoggingLocale(), untransformableTimerService$str(), address);
    }
    private static final String asymmetricCacheUsage = "WFLYEJB0445: Detected asymmetric usage of cache";
    protected String asymmetricCacheUsage$str() {
        return asymmetricCacheUsage;
    }
    @Override
    public final IllegalStateException asymmetricCacheUsage() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), asymmetricCacheUsage$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String timerIsActive = "WFLYEJB0446: The timer %s is already active.";
    protected String timerIsActive$str() {
        return timerIsActive;
    }
    @Override
    public final IllegalStateException timerIsActive(final Timer timer) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), timerIsActive$str(), timer));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String transactionAlreadyRolledBack = "WFLYEJB0447: Transaction '%s' was already rolled back";
    protected String transactionAlreadyRolledBack$str() {
        return transactionAlreadyRolledBack;
    }
    @Override
    public final RollbackException transactionAlreadyRolledBack(final Transaction tx) {
        final RollbackException result = new RollbackException(String.format(getLoggingLocale(), transactionAlreadyRolledBack$str(), tx));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String transactionInUnexpectedState = "WFLYEJB0448: Transaction '%s' is in unexpected state (%s)";
    protected String transactionInUnexpectedState$str() {
        return transactionInUnexpectedState;
    }
    @Override
    public final EJBException transactionInUnexpectedState(final Transaction tx, final String txStatus) {
        final EJBException result = new EJBException(String.format(getLoggingLocale(), transactionInUnexpectedState$str(), tx, txStatus));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String timerServiceMethodNotAllowedForSFSB = "WFLYEJB0449: Timerservice API is not allowed on stateful session bean %s";
    protected String timerServiceMethodNotAllowedForSFSB$str() {
        return timerServiceMethodNotAllowedForSFSB;
    }
    @Override
    public final String timerServiceMethodNotAllowedForSFSB(final String ejbComponent) {
        return String.format(getLoggingLocale(), timerServiceMethodNotAllowedForSFSB$str(), ejbComponent);
    }
    private static final String entityBeansAreNotSupported = "WFLYEJB0450: Entity Beans are no longer supported, beans %s cannot be deployed";
    protected String entityBeansAreNotSupported$str() {
        return entityBeansAreNotSupported;
    }
    @Override
    public final DeploymentUnitProcessingException entityBeansAreNotSupported(final String beanName) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), entityBeansAreNotSupported$str(), beanName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String inconsistentAttributeNotSupported = "WFLYEJB0451: Attribute '%s' is not supported on current version servers; it is only allowed if its value matches '%s'";
    protected String inconsistentAttributeNotSupported$str() {
        return inconsistentAttributeNotSupported;
    }
    @Override
    public final OperationFailedException inconsistentAttributeNotSupported(final String attributeName, final String mustMatch) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), inconsistentAttributeNotSupported$str(), attributeName, mustMatch));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void failedToPersistTimer(final Timer timerid, final Exception e) {
        super.log.logf(FQCN, ERROR, e, failedToPersistTimer$str(), timerid);
    }
    private static final String failedToPersistTimer = "WFLYEJB0453: Failed to persist timer %s";
    protected String failedToPersistTimer$str() {
        return failedToPersistTimer;
    }
    private static final String mustOnlyBeSingleContainerTransactionElementWithWildcard = "WFLYEJB0454: Only one instance on <container-transaction> with an ejb-name of * can be present.";
    protected String mustOnlyBeSingleContainerTransactionElementWithWildcard$str() {
        return mustOnlyBeSingleContainerTransactionElementWithWildcard;
    }
    @Override
    public final DeploymentUnitProcessingException mustOnlyBeSingleContainerTransactionElementWithWildcard() {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), mustOnlyBeSingleContainerTransactionElementWithWildcard$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String wildcardContainerTransactionElementsMustHaveWildcardMethodName = "WFLYEJB0455: <container-transaction> elements that use the wildcard EJB name * can only use a method name of *";
    protected String wildcardContainerTransactionElementsMustHaveWildcardMethodName$str() {
        return wildcardContainerTransactionElementsMustHaveWildcardMethodName;
    }
    @Override
    public final DeploymentUnitProcessingException wildcardContainerTransactionElementsMustHaveWildcardMethodName() {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), wildcardContainerTransactionElementsMustHaveWildcardMethodName$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void failedToRefreshTimers(final String timedObjectId) {
        super.log.logf(FQCN, ERROR, null, failedToRefreshTimers$str(), timedObjectId);
    }
    private static final String failedToRefreshTimers = "WFLYEJB0456: Failed to refresh timers for %s";
    protected String failedToRefreshTimers$str() {
        return failedToRefreshTimers;
    }
    private static final String convertUnexpectedError = "WFLYEJB0457: Unexpected Error";
    protected String convertUnexpectedError$str() {
        return convertUnexpectedError;
    }
    @Override
    public final String convertUnexpectedError() {
        return String.format(getLoggingLocale(), convertUnexpectedError$str());
    }
    private static final String relativeResourceAdapterNameInStandaloneModule = "WFLYEJB0459: Module %s containing bean %s is not deployed in ear but it specifies resource adapter name '%s' in a relative format.";
    protected String relativeResourceAdapterNameInStandaloneModule$str() {
        return relativeResourceAdapterNameInStandaloneModule;
    }
    @Override
    public final DeploymentUnitProcessingException relativeResourceAdapterNameInStandaloneModule(final String module, final String bean, final String adapterName) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), relativeResourceAdapterNameInStandaloneModule$str(), module, bean, adapterName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void wrongTransactionIsolationConfiguredForTimer() {
        super.log.logf(FQCN, WARN, null, wrongTransactionIsolationConfiguredForTimer$str());
    }
    private static final String wrongTransactionIsolationConfiguredForTimer = "WFLYEJB0460: The transaction isolation need to be equal or stricter than READ_COMMITTED to ensure that the timer run once-and-only-once";
    protected String wrongTransactionIsolationConfiguredForTimer$str() {
        return wrongTransactionIsolationConfiguredForTimer;
    }
    @Override
    public final void timerUpdateFailedAndRollbackNotPossible(final Throwable rbe) {
        super.log.logf(FQCN, ERROR, rbe, timerUpdateFailedAndRollbackNotPossible$str());
    }
    private static final String timerUpdateFailedAndRollbackNotPossible = "WFLYEJB0461: Update timer failed and it was not possible to rollback the transaction!";
    protected String timerUpdateFailedAndRollbackNotPossible$str() {
        return timerUpdateFailedAndRollbackNotPossible;
    }
    @Override
    public final void jdbcDatabaseDialectDetectionFailed(final String validDialects) {
        super.log.logf(FQCN, WARN, null, jdbcDatabaseDialectDetectionFailed$str(), validDialects);
    }
    private static final String jdbcDatabaseDialectDetectionFailed = "WFLYEJB0462: Unable to detect database dialect from connection metadata or JDBC driver name. Please configure this manually using the 'datasource' property in your configuration.  Known database dialect strings are %s";
    protected String jdbcDatabaseDialectDetectionFailed$str() {
        return jdbcDatabaseDialectDetectionFailed;
    }
    @Override
    public final void invalidTransactionTypeForSfsbLifecycleMethod(final TransactionAttributeType txAttr, final MethodIdentifier method, final Class<?> clazz) {
        super.log.logf(FQCN, WARN, null, invalidTransactionTypeForSfsbLifecycleMethod$str(), txAttr, method, clazz);
    }
    private static final String invalidTransactionTypeForSfsbLifecycleMethod = "WFLYEJB0463: Invalid transaction attribute type %s on SFSB lifecycle method %s of class %s, valid types are REQUIRES_NEW and NOT_SUPPORTED. Method will be treated as NOT_SUPPORTED.";
    protected String invalidTransactionTypeForSfsbLifecycleMethod$str() {
        return invalidTransactionTypeForSfsbLifecycleMethod;
    }
    private static final String disableDefaultEjbPermissionsCannotBeTrue = "WFLYEJB0464: The \"disable-default-ejb-permissions\" attribute may not be set to true";
    protected String disableDefaultEjbPermissionsCannotBeTrue$str() {
        return disableDefaultEjbPermissionsCannotBeTrue;
    }
    @Override
    public final OperationFailedException disableDefaultEjbPermissionsCannotBeTrue() {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), disableDefaultEjbPermissionsCannotBeTrue$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String profileAndRemotingEjbReceiversUsedTogether = "WFLYEJB0465: Invalid client descriptor configuration: 'profile' and 'remoting-ejb-receivers' cannot be used together";
    protected String profileAndRemotingEjbReceiversUsedTogether$str() {
        return profileAndRemotingEjbReceiversUsedTogether;
    }
    @Override
    public final DeploymentUnitProcessingException profileAndRemotingEjbReceiversUsedTogether() {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), profileAndRemotingEjbReceiversUsedTogether$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToProcessBusinessInterfaces = "WFLYEJB0466: Failed to process business interfaces for EJB class %s";
    protected String failedToProcessBusinessInterfaces$str() {
        return failedToProcessBusinessInterfaces;
    }
    @Override
    public final DeploymentUnitProcessingException failedToProcessBusinessInterfaces(final Class<?> ejbClass, final Exception e) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), failedToProcessBusinessInterfaces$str(), ejbClass), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String containerSuspended = "WFLYEJB0467: The request was rejected as the container is suspended";
    protected String containerSuspended$str() {
        return containerSuspended;
    }
    @Override
    public final EJBComponentUnavailableException containerSuspended() {
        final EJBComponentUnavailableException result = new EJBComponentUnavailableException(String.format(getLoggingLocale(), containerSuspended$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String timerInvocationFailed = "WFLYEJB0468: Timer invocation failed";
    protected String timerInvocationFailed$str() {
        return timerInvocationFailed;
    }
    @Override
    public final OperationFailedException timerInvocationFailed(final Exception e) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), timerInvocationFailed$str()), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String indexedChildResourceRegistrationNotAvailable = "WFLYEJB0469: Indexed child resources can only be registered if the parent resource supports ordered children. The parent of '%s' is not indexed";
    protected String indexedChildResourceRegistrationNotAvailable$str() {
        return indexedChildResourceRegistrationNotAvailable;
    }
    @Override
    public final IllegalStateException indexedChildResourceRegistrationNotAvailable(final PathElement address) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), indexedChildResourceRegistrationNotAvailable$str(), address));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String rmiIiopVoliation = "WFLYEJB0471: RMI/IIOP Violation: %s%n";
    protected String rmiIiopVoliation$str() {
        return rmiIiopVoliation;
    }
    @Override
    public final RuntimeException rmiIiopVoliation(final String violation) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), rmiIiopVoliation$str(), violation));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String exceptionRepositoryNotFound = "WFLYEJB0472: Cannot obtain exception repository id for %s:%n%s";
    protected String exceptionRepositoryNotFound$str() {
        return exceptionRepositoryNotFound;
    }
    @Override
    public final RuntimeException exceptionRepositoryNotFound(final String name, final String message) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), exceptionRepositoryNotFound$str(), name, message));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void jndiBindings(final String ejbName, final DeploymentUnit deploymentUnit, final StringBuilder bindings) {
        super.log.logf(FQCN, INFO, null, jndiBindings$str(), ejbName, deploymentUnit, bindings);
    }
    private static final String jndiBindings = "WFLYEJB0473: JNDI bindings for session bean named '%s' in deployment unit '%s' are as follows:%s";
    protected String jndiBindings$str() {
        return jndiBindings;
    }
    @Override
    public final void logInconsistentAttributeNotSupported(final String attributeName, final String mustMatch) {
        super.log.logf(FQCN, ERROR, null, logInconsistentAttributeNotSupported$str(), attributeName, mustMatch);
    }
    private static final String logInconsistentAttributeNotSupported = "WFLYEJB0474: Attribute '%s' is not supported on current version servers; it is only allowed if its value matches '%s'. This attribute should be removed.";
    protected String logInconsistentAttributeNotSupported$str() {
        return logInconsistentAttributeNotSupported;
    }
    @Override
    public final void mdbDeliveryStarted(final String appName, final String componentName) {
        super.log.logf(FQCN, INFO, null, mdbDeliveryStarted$str(), appName, componentName);
    }
    private static final String mdbDeliveryStarted = "WFLYEJB0475: MDB delivery started: %s,%s";
    protected String mdbDeliveryStarted$str() {
        return mdbDeliveryStarted;
    }
    @Override
    public final void mdbDeliveryStopped(final String appName, final String componentName) {
        super.log.logf(FQCN, INFO, null, mdbDeliveryStopped$str(), appName, componentName);
    }
    private static final String mdbDeliveryStopped = "WFLYEJB0476: MDB delivery stopped: %s,%s";
    protected String mdbDeliveryStopped$str() {
        return mdbDeliveryStopped;
    }
    private static final String missingMdbDeliveryGroup = "WFLYEJB0477: MDB delivery group is missing: %s";
    protected String missingMdbDeliveryGroup$str() {
        return missingMdbDeliveryGroup;
    }
    @Override
    public final DeploymentUnitProcessingException missingMdbDeliveryGroup(final String deliveryGroupName) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), missingMdbDeliveryGroup$str(), deliveryGroupName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void loadedPersistentTimerInTimeout(final String timer, final String timedObject) {
        super.log.logf(FQCN, ERROR, null, loadedPersistentTimerInTimeout$str(), timer, timedObject);
    }
    private static final String loadedPersistentTimerInTimeout = "WFLYEJB0480: Loaded timer (%s) for EJB (%s) and this node that is marked as being in a timeout. The original timeout may not have been processed. Please use graceful shutdown to ensure timeout tasks are finished before shutting down.";
    protected String loadedPersistentTimerInTimeout$str() {
        return loadedPersistentTimerInTimeout;
    }
    @Override
    public final void strictPoolDerivedFromWorkers(final String name, final int max) {
        super.log.logf(FQCN, INFO, null, strictPoolDerivedFromWorkers$str(), name, max);
    }
    private static final String strictPoolDerivedFromWorkers = "WFLYEJB0481: Strict pool %s is using a max instance size of %d (per class), which is derived from thread worker pool sizing.";
    protected String strictPoolDerivedFromWorkers$str() {
        return strictPoolDerivedFromWorkers;
    }
    @Override
    public final void strictPoolDerivedFromCPUs(final String name, final int max) {
        super.log.logf(FQCN, INFO, null, strictPoolDerivedFromCPUs$str(), name, max);
    }
    private static final String strictPoolDerivedFromCPUs = "WFLYEJB0482: Strict pool %s is using a max instance size of %d (per class), which is derived from the number of CPUs on this host.";
    protected String strictPoolDerivedFromCPUs$str() {
        return strictPoolDerivedFromCPUs;
    }
    private static final String mutuallyExclusiveAttributes = "WFLYEJB0483: Attributes are mutually exclusive: %s, %s";
    protected String mutuallyExclusiveAttributes$str() {
        return mutuallyExclusiveAttributes;
    }
    @Override
    public final XMLStreamException mutuallyExclusiveAttributes(final Location location, final String attribute1, final String attribute2) {
        final XMLStreamException result = new XMLStreamException(String.format(getLoggingLocale(), mutuallyExclusiveAttributes$str(), attribute1, attribute2), location);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void invalidTransactionTypeForMDB(final TransactionAttributeType transactionAttributeType, final String methond, final String componentName) {
        super.log.logf(FQCN, WARN, null, invalidTransactionTypeForMDB$str(), transactionAttributeType, methond, componentName);
    }
    private static final String invalidTransactionTypeForMDB = "WFLYEJB0485: Transaction type %s is unspecified for the %s method of the %s message-driven bean. It will be handled as NOT_SUPPORTED.";
    protected String invalidTransactionTypeForMDB$str() {
        return invalidTransactionTypeForMDB;
    }
    @Override
    public final void remappingCacheAttributes(final String address, final ModelNode defClustered, final ModelNode passivationDisabled) {
        super.log.logf(FQCN, INFO, null, remappingCacheAttributes$str(), address, defClustered, passivationDisabled);
    }
    private static final String remappingCacheAttributes = "WFLYEJB0486: Parameter 'default-clustered-sfsb-cache' was defined for the 'add' operation for resource '%s'. This parameter is deprecated and its previous behavior has been remapped to attribute 'default-sfsb-cache'. As a result the 'default-sfsb-cache' attribute has been set to '%s' and the 'default-sfsb-passivation-disabled-cache' attribute has been set to '%s'.";
    protected String remappingCacheAttributes$str() {
        return remappingCacheAttributes;
    }
    @Override
    public final void unexpectedInvocationState(final int state) {
        super.log.logf(FQCN, ERROR, null, unexpectedInvocationState$str(), state);
    }
    private static final String unexpectedInvocationState = "WFLYEJB0487: Unexpected invocation state %s";
    protected String unexpectedInvocationState$str() {
        return unexpectedInvocationState;
    }
    private static final String ejbAuthenticationRequired = "WFLYEJB0488: Unauthenticated (anonymous) access to this EJB method is not authorized";
    protected String ejbAuthenticationRequired$str() {
        return ejbAuthenticationRequired;
    }
    @Override
    public final SecurityException ejbAuthenticationRequired() {
        final SecurityException result = new SecurityException(String.format(getLoggingLocale(), ejbAuthenticationRequired$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void timerNotRunning(final NotSupportedException e, final TimerImpl timer) {
        super.log.logf(FQCN, ERROR, e, timerNotRunning$str(), timer);
    }
    private static final String timerNotRunning = "WFLYEJB0489: Timer %s not running as transaction could not be started";
    protected String timerNotRunning$str() {
        return timerNotRunning;
    }
    private static final String multipleSecurityDomainsDetected = "WFLYEJB0490: Multiple security domains not supported";
    protected String multipleSecurityDomainsDetected$str() {
        return multipleSecurityDomainsDetected;
    }
    @Override
    public final DeploymentUnitProcessingException multipleSecurityDomainsDetected() {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), multipleSecurityDomainsDetected$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotBeginUserTransaction = "WFLYEJB0491: The transaction begin request was rejected as the container is suspended";
    protected String cannotBeginUserTransaction$str() {
        return cannotBeginUserTransaction;
    }
    @Override
    public final EJBException cannotBeginUserTransaction() {
        final EJBException result = new EJBException(String.format(getLoggingLocale(), cannotBeginUserTransaction$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void suspensionWaitingActiveTransactions(final int activeTransactionCount) {
        super.log.logf(FQCN, INFO, null, suspensionWaitingActiveTransactions$str(), activeTransactionCount);
    }
    private static final String suspensionWaitingActiveTransactions = "WFLYEJB0492: EJB subsystem suspension waiting for active transactions, %d transaction(s) remaining";
    protected String suspensionWaitingActiveTransactions$str() {
        return suspensionWaitingActiveTransactions;
    }
    @Override
    public final void suspensionComplete() {
        super.log.logf(FQCN, INFO, null, suspensionComplete$str());
    }
    private static final String suspensionComplete = "WFLYEJB0493: EJB subsystem suspension complete";
    protected String suspensionComplete$str() {
        return suspensionComplete;
    }
    private static final String failedToObtainSSLContext = "WFLYEJB0494: Failed to obtain SSLContext";
    protected String failedToObtainSSLContext$str() {
        return failedToObtainSSLContext;
    }
    @Override
    public final RuntimeException failedToObtainSSLContext(final Exception cause) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), failedToObtainSSLContext$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void scheduleExpressionDateFromTimerPersistenceInvalid(final String timerId, final String parserMessage) {
        super.log.logf(FQCN, WARN, null, scheduleExpressionDateFromTimerPersistenceInvalid$str(), timerId, parserMessage);
    }
    private static final String scheduleExpressionDateFromTimerPersistenceInvalid = "WFLYEJB0495: Ignoring the persisted start or end date for scheduled expression of timer ID:%s as it is not valid : %s.";
    protected String scheduleExpressionDateFromTimerPersistenceInvalid$str() {
        return scheduleExpressionDateFromTimerPersistenceInvalid;
    }
    private static final String failedToCreateEJBClientInterceptor = "WFLYEJB0496: Could not create an instance of EJB client interceptor %s";
    protected String failedToCreateEJBClientInterceptor$str() {
        return failedToCreateEJBClientInterceptor;
    }
    @Override
    public final DeploymentUnitProcessingException failedToCreateEJBClientInterceptor(final Exception e, final String ejbClientInterceptorClassName) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), failedToCreateEJBClientInterceptor$str(), ejbClientInterceptorClassName), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void failedToPersistTimerOnStartup(final TimerImpl activeTimer, final Exception e) {
        super.log.logf(FQCN, WARN, e, failedToPersistTimerOnStartup$str(), activeTimer);
    }
    private static final String failedToPersistTimerOnStartup = "WFLYEJB0497: Failed to persist timer %s on startup. This is likely due to another cluster member making the same change, and should not affect operation.";
    protected String failedToPersistTimerOnStartup$str() {
        return failedToPersistTimerOnStartup;
    }
}
