/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.tx;

import javax.ejb.TransactionAttributeType;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentInterceptorFactory;
import org.jboss.as.ejb3.component.EJBComponent;
import org.jboss.as.ejb3.component.MethodIntf;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.tx.CMTTxInterceptor;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactoryContext;
import org.jboss.invocation.proxy.MethodIdentifier;
import org.wildfly.transaction.client.ContextTransactionManager;
import org.wildfly.transaction.client.LocalTransaction;
import org.wildfly.transaction.client.LocalTransactionContext;

public class LifecycleCMTTxInterceptor
extends CMTTxInterceptor {
    private final TransactionAttributeType transactionAttributeType;
    private final int transactionTimeout;

    public LifecycleCMTTxInterceptor(TransactionAttributeType transactionAttributeType, int transactionTimeout) {
        this.transactionAttributeType = transactionAttributeType;
        this.transactionTimeout = transactionTimeout;
    }

    @Override
    public Object processInvocation(InterceptorContext invocation) throws Exception {
        EJBComponent component = (EJBComponent)((Object)invocation.getPrivateData(Component.class));
        switch (this.transactionAttributeType) {
            case MANDATORY: {
                return this.mandatory(invocation, component);
            }
            case NEVER: {
                return this.never(invocation, component);
            }
            case NOT_SUPPORTED: {
                return this.notSupported(invocation, component);
            }
            case REQUIRED: {
                return this.required(invocation, component, this.transactionTimeout);
            }
            case REQUIRES_NEW: {
                return this.requiresNew(invocation, component, this.transactionTimeout);
            }
            case SUPPORTS: {
                return this.supports(invocation, component);
            }
        }
        throw EjbLogger.ROOT_LOGGER.unknownTxAttributeOnInvocation(this.transactionAttributeType, invocation);
    }

    @Override
    protected Transaction beginTransaction(TransactionManager tm) throws NotSupportedException, SystemException {
        if (tm instanceof ContextTransactionManager) {
            ContextTransactionManager contextTransactionManager = (ContextTransactionManager)tm;
            int timeout = contextTransactionManager.getTransactionTimeout();
            LocalTransaction transaction = LocalTransactionContext.getCurrent().beginTransaction(timeout, false);
            try {
                contextTransactionManager.resume((Transaction)transaction);
            }
            catch (InvalidTransactionException e) {
                throw new IllegalStateException(e);
            }
            return transaction;
        }
        return super.beginTransaction(tm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object notSupported(InterceptorContext invocation, EJBComponent component) throws Exception {
        TransactionManager tm = component.getTransactionManager();
        Transaction tx = tm.getTransaction();
        int status = tx != null ? tx.getStatus() : 6;
        switch (status) {
            case 3: 
            case 4: 
            case 6: {
                return this.invokeInNoTx(invocation, component);
            }
        }
        Transaction suspendedTx = tm.suspend();
        try {
            Object object = this.invokeInNoTx(invocation, component);
            return object;
        }
        finally {
            if (suspendedTx != null) {
                tm.resume(suspendedTx);
            }
        }
    }

    public static class Factory
    extends ComponentInterceptorFactory {
        private final MethodIdentifier methodIdentifier;
        private final boolean treatRequiredAsRequiresNew;

        public Factory(MethodIdentifier methodIdentifier, boolean treatRequiredAsRequiresNew) {
            this.methodIdentifier = methodIdentifier;
            this.treatRequiredAsRequiresNew = treatRequiredAsRequiresNew;
        }

        protected Interceptor create(Component component, InterceptorFactoryContext context) {
            EJBComponent ejb = (EJBComponent)component;
            TransactionAttributeType txAttr = this.methodIdentifier == null ? (this.treatRequiredAsRequiresNew ? TransactionAttributeType.REQUIRED : TransactionAttributeType.NOT_SUPPORTED) : ejb.getTransactionAttributeType(MethodIntf.BEAN, this.methodIdentifier, this.treatRequiredAsRequiresNew ? TransactionAttributeType.REQUIRES_NEW : TransactionAttributeType.NOT_SUPPORTED);
            int txTimeout = this.methodIdentifier == null ? -1 : ejb.getTransactionTimeout(MethodIntf.BEAN, this.methodIdentifier);
            if (this.treatRequiredAsRequiresNew && txAttr == TransactionAttributeType.REQUIRED) {
                txAttr = TransactionAttributeType.REQUIRES_NEW;
            }
            if (!this.treatRequiredAsRequiresNew && txAttr != TransactionAttributeType.NOT_SUPPORTED && txAttr != TransactionAttributeType.REQUIRES_NEW) {
                EjbLogger.ROOT_LOGGER.invalidTransactionTypeForSfsbLifecycleMethod(txAttr, this.methodIdentifier, ejb.getComponentClass());
                txAttr = TransactionAttributeType.NOT_SUPPORTED;
            }
            LifecycleCMTTxInterceptor interceptor = new LifecycleCMTTxInterceptor(txAttr, txTimeout);
            return interceptor;
        }
    }
}

