/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.cache.simple;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.ThreadFactory;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.ejb3.cache.CacheFactory;
import org.jboss.as.ejb3.cache.CacheFactoryBuilder;
import org.jboss.as.ejb3.cache.CacheFactoryBuilderService;
import org.jboss.as.ejb3.cache.Identifiable;
import org.jboss.as.ejb3.cache.simple.SimpleCache;
import org.jboss.as.ejb3.cache.simple.SimpleCacheFactoryService;
import org.jboss.as.ejb3.component.stateful.StatefulTimeoutInfo;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.threads.JBossThreadFactory;
import org.wildfly.clustering.ejb.BeanContext;
import org.wildfly.clustering.service.concurrent.RemoveOnCancelScheduledExecutorServiceBuilder;

public class SimpleCacheFactoryBuilderService<K, V extends Identifiable<K>>
extends CacheFactoryBuilderService<K, V>
implements CacheFactoryBuilder<K, V> {
    private static final ThreadFactory THREAD_FACTORY = (ThreadFactory)AccessController.doPrivileged(new PrivilegedAction<JBossThreadFactory>(){

        @Override
        public JBossThreadFactory run() {
            return new JBossThreadFactory(new ThreadGroup(SimpleCache.class.getSimpleName()), Boolean.FALSE, null, "%G - %t", null, null);
        }
    });
    private final String name;

    public SimpleCacheFactoryBuilderService(String name) {
        super(name);
        this.name = name;
    }

    public CacheFactoryBuilder<K, V> getValue() {
        return this;
    }

    @Override
    public void installDeploymentUnitDependencies(CapabilityServiceSupport support, ServiceTarget target, ServiceName deploymentUnitServiceName) {
        new RemoveOnCancelScheduledExecutorServiceBuilder(deploymentUnitServiceName.append(new String[]{this.name, "expiration"}), THREAD_FACTORY).build(target).install();
    }

    @Override
    public ServiceBuilder<? extends CacheFactory<K, V>> build(ServiceTarget target, ServiceName name, BeanContext context, StatefulTimeoutInfo timeout) {
        return SimpleCacheFactoryService.build(this.name, target, name, context, timeout);
    }

    @Override
    public boolean supportsPassivation() {
        return false;
    }
}

