/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.stateful;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Set;
import org.jboss.as.ee.component.BasicComponent;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ejb3.cache.CacheFactory;
import org.jboss.as.ejb3.cache.CacheFactoryBuilder;
import org.jboss.as.ejb3.cache.CacheInfo;
import org.jboss.as.ejb3.component.DefaultAccessTimeoutService;
import org.jboss.as.ejb3.component.InvokeMethodOnTargetInterceptor;
import org.jboss.as.ejb3.component.interceptors.CurrentInvocationContextInterceptor;
import org.jboss.as.ejb3.component.session.SessionBeanComponentCreateService;
import org.jboss.as.ejb3.component.stateful.StatefulComponentDescription;
import org.jboss.as.ejb3.component.stateful.StatefulRemoveInterceptor;
import org.jboss.as.ejb3.component.stateful.StatefulSessionComponent;
import org.jboss.as.ejb3.component.stateful.StatefulSessionSynchronizationInterceptor;
import org.jboss.as.ejb3.component.stateful.StatefulTimeoutInfo;
import org.jboss.as.ejb3.deployment.ApplicationExceptions;
import org.jboss.invocation.ContextClassLoaderInterceptor;
import org.jboss.invocation.ImmediateInterceptorFactory;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.Interceptors;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;
import org.wildfly.clustering.ejb.BeanContext;
import org.wildfly.clustering.ejb.Time;

public class StatefulSessionComponentCreateService
extends SessionBeanComponentCreateService
implements BeanContext {
    private final InterceptorFactory afterBegin;
    private final Method afterBeginMethod;
    private final InterceptorFactory afterCompletion;
    private final Method afterCompletionMethod;
    private final InterceptorFactory beforeCompletion;
    private final Method beforeCompletionMethod;
    private final InterceptorFactory prePassivate;
    private final InterceptorFactory postActivate;
    private final StatefulTimeoutInfo statefulTimeout;
    private final CacheInfo cache;
    private final ClassLoader loader;
    private final InjectedValue<DefaultAccessTimeoutService> defaultAccessTimeoutService = new InjectedValue();
    private final InterceptorFactory ejb2XRemoveMethod;
    private final Value<CacheFactory> cacheFactory;
    private final InjectedValue<CacheFactoryBuilder> cacheFactoryBuilder = new InjectedValue();
    private final Set<Object> serializableInterceptorContextKeys;
    final boolean passivationCapable;
    private final ModuleLoader moduleLoader;
    private final ServiceName deploymentUnitServiceName;
    private final ServiceName componentServiceName;

    public StatefulSessionComponentCreateService(ComponentConfiguration componentConfiguration, ApplicationExceptions ejbJarConfiguration, Value<CacheFactory> cacheFactory) {
        super(componentConfiguration, ejbJarConfiguration);
        StatefulComponentDescription componentDescription = (StatefulComponentDescription)componentConfiguration.getComponentDescription();
        ClassLoader classLoader = componentConfiguration.getModuleClassLoader();
        ImmediateInterceptorFactory tcclInterceptorFactory = new ImmediateInterceptorFactory((Interceptor)new ContextClassLoaderInterceptor(classLoader));
        InterceptorFactory namespaceContextInterceptorFactory = componentConfiguration.getNamespaceContextInterceptorFactory();
        this.afterBeginMethod = componentDescription.getAfterBegin();
        this.afterBegin = this.afterBeginMethod != null ? Interceptors.getChainedInterceptorFactory((InterceptorFactory[])new InterceptorFactory[]{tcclInterceptorFactory, namespaceContextInterceptorFactory, CurrentInvocationContextInterceptor.FACTORY, StatefulSessionComponentCreateService.invokeMethodOnTarget(this.afterBeginMethod)}) : null;
        this.afterCompletionMethod = componentDescription.getAfterCompletion();
        this.afterCompletion = this.afterCompletionMethod != null ? Interceptors.getChainedInterceptorFactory((InterceptorFactory[])new InterceptorFactory[]{tcclInterceptorFactory, namespaceContextInterceptorFactory, CurrentInvocationContextInterceptor.FACTORY, StatefulSessionComponentCreateService.invokeMethodOnTarget(this.afterCompletionMethod)}) : null;
        this.beforeCompletionMethod = componentDescription.getBeforeCompletion();
        this.beforeCompletion = this.beforeCompletionMethod != null ? Interceptors.getChainedInterceptorFactory((InterceptorFactory[])new InterceptorFactory[]{tcclInterceptorFactory, namespaceContextInterceptorFactory, CurrentInvocationContextInterceptor.FACTORY, StatefulSessionComponentCreateService.invokeMethodOnTarget(this.beforeCompletionMethod)}) : null;
        this.prePassivate = Interceptors.getChainedInterceptorFactory((Collection)componentConfiguration.getPrePassivateInterceptors());
        this.postActivate = Interceptors.getChainedInterceptorFactory((Collection)componentConfiguration.getPostActivateInterceptors());
        this.statefulTimeout = componentDescription.getStatefulTimeout();
        this.ejb2XRemoveMethod = Interceptors.getChainedInterceptorFactory((InterceptorFactory[])new InterceptorFactory[]{StatefulSessionSynchronizationInterceptor.factory(componentDescription.getTransactionManagementType()), new ImmediateInterceptorFactory((Interceptor)new StatefulRemoveInterceptor(false)), Interceptors.getTerminalInterceptorFactory()});
        this.cache = componentDescription.getCache();
        this.loader = componentConfiguration.getModuleClassLoader();
        this.moduleLoader = componentConfiguration.getModuleLoader();
        this.serializableInterceptorContextKeys = componentConfiguration.getInterceptorContextKeys();
        this.passivationCapable = componentDescription.isPassivationApplicable();
        this.deploymentUnitServiceName = componentDescription.getDeploymentUnitServiceName();
        this.componentServiceName = componentDescription.getServiceName();
        this.cacheFactory = cacheFactory;
    }

    private static InterceptorFactory invokeMethodOnTarget(Method method) {
        method.setAccessible(true);
        return InvokeMethodOnTargetInterceptor.factory(method);
    }

    public void start(StartContext context) throws StartException {
        super.start(context);
        ((CacheFactoryBuilder)this.cacheFactoryBuilder.getValue()).build(context.getChildTarget(), this.componentServiceName.append(new String[]{"cache"}), this, this.statefulTimeout).install();
    }

    public void stop(StopContext context) {
        super.stop(context);
    }

    protected BasicComponent createComponent() {
        return new StatefulSessionComponent(this);
    }

    public InterceptorFactory getAfterBegin() {
        return this.afterBegin;
    }

    public InterceptorFactory getAfterCompletion() {
        return this.afterCompletion;
    }

    public InterceptorFactory getBeforeCompletion() {
        return this.beforeCompletion;
    }

    public InterceptorFactory getPrePassivate() {
        return this.prePassivate;
    }

    public InterceptorFactory getPostActivate() {
        return this.postActivate;
    }

    public Method getAfterBeginMethod() {
        return this.afterBeginMethod;
    }

    public Method getAfterCompletionMethod() {
        return this.afterCompletionMethod;
    }

    public Method getBeforeCompletionMethod() {
        return this.beforeCompletionMethod;
    }

    public CacheInfo getCache() {
        return this.cache;
    }

    public DefaultAccessTimeoutService getDefaultAccessTimeoutService() {
        return (DefaultAccessTimeoutService)this.defaultAccessTimeoutService.getValue();
    }

    Injector<DefaultAccessTimeoutService> getDefaultAccessTimeoutInjector() {
        return this.defaultAccessTimeoutService;
    }

    public InterceptorFactory getEjb2XRemoveMethod() {
        return this.ejb2XRemoveMethod;
    }

    public Set<Object> getSerializableInterceptorContextKeys() {
        return this.serializableInterceptorContextKeys;
    }

    Injector<CacheFactoryBuilder> getCacheFactoryBuilderInjector() {
        return this.cacheFactoryBuilder;
    }

    Value<CacheFactory> getCacheFactory() {
        return this.cacheFactory;
    }

    boolean isPassivationCapable() {
        return this.passivationCapable;
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    public String getBeanName() {
        return this.getComponentName();
    }

    public ModuleLoader getModuleLoader() {
        return this.moduleLoader;
    }

    public ServiceName getDeploymentUnitServiceName() {
        return this.deploymentUnitServiceName;
    }

    public Time getTimeout() {
        return this.statefulTimeout != null ? new Time(this.statefulTimeout.getValue(), this.statefulTimeout.getTimeUnit()) : null;
    }
}

