/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors;

import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import javax.ejb.MessageDriven;
import javax.jms.MessageListener;
import org.jboss.as.ee.component.DeploymentDescriptorEnvironment;
import org.jboss.as.ee.metadata.MetadataCompleteMarker;
import org.jboss.as.ee.structure.EJBAnnotationPropertyReplacement;
import org.jboss.as.ejb3.component.messagedriven.DefaultResourceAdapterService;
import org.jboss.as.ejb3.component.messagedriven.MessageDrivenComponentDescription;
import org.jboss.as.ejb3.deployment.EjbJarDescription;
import org.jboss.as.ejb3.deployment.processors.AbstractDeploymentUnitProcessor;
import org.jboss.as.ejb3.deployment.processors.EJBComponentDescriptionFactory;
import org.jboss.as.ejb3.deployment.processors.ViewInterfaces;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.util.EjbValidationsUtil;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.EjbDeploymentMarker;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.metadata.ejb.jboss.ejb3.JBossGenericBeanMetaData;
import org.jboss.metadata.ejb.spec.ActivationConfigMetaData;
import org.jboss.metadata.ejb.spec.ActivationConfigPropertiesMetaData;
import org.jboss.metadata.ejb.spec.ActivationConfigPropertyMetaData;
import org.jboss.metadata.ejb.spec.EnterpriseBeanMetaData;
import org.jboss.metadata.ejb.spec.MessageDrivenBeanMetaData;
import org.jboss.metadata.javaee.spec.RemoteEnvironment;
import org.jboss.metadata.property.PropertyReplacer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;

public class MessageDrivenComponentDescriptionFactory
extends EJBComponentDescriptionFactory {
    private static final DotName MESSAGE_DRIVEN_ANNOTATION_NAME = DotName.createSimple((String)MessageDriven.class.getName());
    private final boolean defaultMdbPoolAvailable;

    public MessageDrivenComponentDescriptionFactory(boolean appclient, boolean defaultMdbPoolAvailable) {
        super(appclient);
        this.defaultMdbPoolAvailable = defaultMdbPoolAvailable;
    }

    @Override
    protected void processAnnotations(DeploymentUnit deploymentUnit, CompositeIndex compositeIndex) throws DeploymentUnitProcessingException {
        if (MetadataCompleteMarker.isMetadataComplete((DeploymentUnit)deploymentUnit)) {
            return;
        }
        this.processMessageBeans(deploymentUnit, compositeIndex.getAnnotations(MESSAGE_DRIVEN_ANNOTATION_NAME), compositeIndex);
    }

    @Override
    protected void processBeanMetaData(DeploymentUnit deploymentUnit, EnterpriseBeanMetaData enterpriseBeanMetaData) throws DeploymentUnitProcessingException {
        if (enterpriseBeanMetaData.isMessageDriven()) {
            assert (enterpriseBeanMetaData instanceof MessageDrivenBeanMetaData) : enterpriseBeanMetaData + " is not a MessageDrivenBeanMetaData";
            this.processMessageDrivenBeanMetaData(deploymentUnit, (MessageDrivenBeanMetaData)enterpriseBeanMetaData);
        }
    }

    private void processMessageBeans(DeploymentUnit deploymentUnit, Collection<AnnotationInstance> messageBeanAnnotations, CompositeIndex compositeIndex) throws DeploymentUnitProcessingException {
        if (messageBeanAnnotations.isEmpty()) {
            return;
        }
        EjbJarDescription ejbJarDescription = AbstractDeploymentUnitProcessor.getEjbJarDescription(deploymentUnit);
        PropertyReplacer propertyReplacer = EJBAnnotationPropertyReplacement.propertyReplacer((DeploymentUnit)deploymentUnit);
        ServiceName deploymentUnitServiceName = deploymentUnit.getServiceName();
        DeploymentDescriptorEnvironment deploymentDescriptorEnvironment = null;
        for (AnnotationInstance messageBeanAnnotation : messageBeanAnnotations) {
            String messageListenerInterfaceName;
            String beanClassName;
            AnnotationTarget target = messageBeanAnnotation.target();
            ClassInfo beanClassInfo = (ClassInfo)target;
            if (!EjbValidationsUtil.assertEjbClassValidity(beanClassInfo).isEmpty()) continue;
            String ejbName = beanClassInfo.name().local();
            AnnotationValue nameValue = messageBeanAnnotation.value("name");
            String beanName = nameValue == null || nameValue.asString().isEmpty() ? ejbName : propertyReplacer.replaceProperties(nameValue.asString());
            MessageDrivenBeanMetaData beanMetaData = MessageDrivenComponentDescriptionFactory.getEnterpriseBeanMetaData(deploymentUnit, beanName, MessageDrivenBeanMetaData.class);
            Properties activationConfigProperties = this.getActivationConfigProperties(messageBeanAnnotation, propertyReplacer);
            if (beanMetaData != null) {
                ActivationConfigPropertiesMetaData propertiesMetaData;
                ActivationConfigMetaData activationConfigMetaData;
                String messagingType;
                MessageDrivenBeanMetaData mdb;
                beanClassName = MessageDrivenComponentDescriptionFactory.override(beanClassInfo.name().toString(), beanMetaData.getEjbClass());
                deploymentDescriptorEnvironment = new DeploymentDescriptorEnvironment("java:comp/env/", (RemoteEnvironment)beanMetaData);
                if (beanMetaData instanceof MessageDrivenBeanMetaData) {
                    mdb = beanMetaData;
                    messagingType = mdb.getMessagingType();
                    activationConfigMetaData = mdb.getActivationConfig();
                    if (activationConfigMetaData != null && (propertiesMetaData = activationConfigMetaData.getActivationConfigProperties()) != null) {
                        for (ActivationConfigPropertyMetaData propertyMetaData : propertiesMetaData) {
                            activationConfigProperties.put(propertyMetaData.getKey(), propertyMetaData.getValue());
                        }
                    }
                } else if (beanMetaData instanceof JBossGenericBeanMetaData) {
                    mdb = (JBossGenericBeanMetaData)beanMetaData;
                    messagingType = mdb.getMessagingType();
                    activationConfigMetaData = mdb.getActivationConfig();
                    if (activationConfigMetaData != null && (propertiesMetaData = activationConfigMetaData.getActivationConfigProperties()) != null) {
                        for (ActivationConfigPropertyMetaData propertyMetaData : propertiesMetaData) {
                            activationConfigProperties.put(propertyMetaData.getKey(), propertyMetaData.getValue());
                        }
                    }
                } else {
                    messagingType = null;
                }
                messageListenerInterfaceName = messagingType != null ? messagingType : this.getMessageListenerInterface(compositeIndex, messageBeanAnnotation);
            } else {
                beanClassName = beanClassInfo.name().toString();
                messageListenerInterfaceName = this.getMessageListenerInterface(compositeIndex, messageBeanAnnotation);
            }
            String defaultResourceAdapterName = this.getDefaultResourceAdapterName(deploymentUnit.getServiceRegistry());
            MessageDrivenComponentDescription beanDescription = new MessageDrivenComponentDescription(beanName, beanClassName, ejbJarDescription, deploymentUnitServiceName, messageListenerInterfaceName, activationConfigProperties, defaultResourceAdapterName, beanMetaData, this.defaultMdbPoolAvailable);
            beanDescription.setDeploymentDescriptorEnvironment(deploymentDescriptorEnvironment);
            this.addComponent(deploymentUnit, beanDescription);
        }
        EjbDeploymentMarker.mark((DeploymentUnit)deploymentUnit);
    }

    private String getMessageListenerInterface(CompositeIndex compositeIndex, AnnotationInstance messageBeanAnnotation) throws DeploymentUnitProcessingException {
        ClassInfo superClass;
        AnnotationValue value = messageBeanAnnotation.value("messageListenerInterface");
        if (value != null) {
            return value.asClass().name().toString();
        }
        ClassInfo beanClass = (ClassInfo)messageBeanAnnotation.target();
        HashSet<DotName> interfaces = new HashSet<DotName>(ViewInterfaces.getPotentialViewInterfaces(beanClass));
        DotName superClassDotName = beanClass.superName();
        while (interfaces.isEmpty() && superClassDotName != null && !superClassDotName.toString().equals(Object.class.getName()) && (superClass = compositeIndex.getClassByName(superClassDotName)) != null) {
            interfaces.addAll(ViewInterfaces.getPotentialViewInterfaces(superClass));
            superClassDotName = superClass.superName();
        }
        if (interfaces.size() != 1) {
            throw EjbLogger.ROOT_LOGGER.mdbDoesNotImplementNorSpecifyMessageListener(beanClass);
        }
        return ((DotName)interfaces.iterator().next()).toString();
    }

    private Properties getActivationConfigProperties(ActivationConfigMetaData activationConfig) {
        Properties activationConfigProps = new Properties();
        if (activationConfig == null || activationConfig.getActivationConfigProperties() == null) {
            return activationConfigProps;
        }
        ActivationConfigPropertiesMetaData activationConfigPropertiesMetaData = activationConfig.getActivationConfigProperties();
        for (ActivationConfigPropertyMetaData activationConfigProp : activationConfigPropertiesMetaData) {
            if (activationConfigProp == null) continue;
            String propName = activationConfigProp.getActivationConfigPropertyName();
            String propValue = activationConfigProp.getValue();
            if (propName == null) continue;
            activationConfigProps.put(propName, propValue);
        }
        return activationConfigProps;
    }

    private void processMessageDrivenBeanMetaData(DeploymentUnit deploymentUnit, MessageDrivenBeanMetaData mdb) throws DeploymentUnitProcessingException {
        EjbJarDescription ejbJarDescription = AbstractDeploymentUnitProcessor.getEjbJarDescription(deploymentUnit);
        String beanName = mdb.getName();
        String beanClassName = mdb.getEjbClass();
        String messageListenerInterface = mdb.getMessagingType();
        if (messageListenerInterface == null || messageListenerInterface.trim().isEmpty()) {
            messageListenerInterface = MessageListener.class.getName();
        }
        Properties activationConfigProps = this.getActivationConfigProperties(mdb.getActivationConfig());
        String defaultResourceAdapterName = this.getDefaultResourceAdapterName(deploymentUnit.getServiceRegistry());
        MessageDrivenComponentDescription mdbComponentDescription = new MessageDrivenComponentDescription(beanName, beanClassName, ejbJarDescription, deploymentUnit.getServiceName(), messageListenerInterface, activationConfigProps, defaultResourceAdapterName, mdb, this.defaultMdbPoolAvailable);
        mdbComponentDescription.setDeploymentDescriptorEnvironment(new DeploymentDescriptorEnvironment("java:comp/env/", (RemoteEnvironment)mdb));
        this.addComponent(deploymentUnit, mdbComponentDescription);
    }

    private Properties getActivationConfigProperties(AnnotationInstance messageBeanAnnotation, PropertyReplacer propertyReplacer) {
        Properties props = new Properties();
        AnnotationValue activationConfig = messageBeanAnnotation.value("activationConfig");
        if (activationConfig == null) {
            return props;
        }
        for (AnnotationInstance propAnnotation : activationConfig.asNestedArray()) {
            String propertyName = propAnnotation.value("propertyName").asString();
            String propertyValue = propAnnotation.value("propertyValue").asString();
            props.put(propertyReplacer.replaceProperties(propertyName), propertyReplacer.replaceProperties(propertyValue));
        }
        return props;
    }

    private String getDefaultResourceAdapterName(ServiceRegistry serviceRegistry) {
        if (this.appclient) {
            return "n/a";
        }
        ServiceController serviceController = serviceRegistry.getRequiredService(DefaultResourceAdapterService.DEFAULT_RA_NAME_SERVICE_NAME);
        return ((DefaultResourceAdapterService)serviceController.getValue()).getDefaultResourceAdapterName();
    }
}

