/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.cache.simple;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.function.Consumer;
import org.jboss.as.clustering.controller.CapabilityServiceConfigurator;
import org.jboss.as.clustering.controller.ServiceConfiguratorAdapter;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ejb3.cache.CacheFactoryBuilder;
import org.jboss.as.ejb3.cache.CacheFactoryBuilderServiceNameProvider;
import org.jboss.as.ejb3.cache.Identifiable;
import org.jboss.as.ejb3.cache.simple.SimpleCache;
import org.jboss.as.ejb3.cache.simple.SimpleCacheFactoryServiceConfigurator;
import org.jboss.as.ejb3.component.stateful.StatefulComponentDescription;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.threads.JBossThreadFactory;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.clustering.service.ServiceSupplierDependency;
import org.wildfly.clustering.service.SupplierDependency;
import org.wildfly.clustering.service.concurrent.RemoveOnCancelScheduledExecutorServiceConfigurator;

public class SimpleCacheFactoryBuilderServiceConfigurator<K, V extends Identifiable<K>>
extends CacheFactoryBuilderServiceNameProvider
implements ServiceConfigurator,
CacheFactoryBuilder<K, V> {
    private static final ThreadFactory THREAD_FACTORY = (ThreadFactory)AccessController.doPrivileged(new PrivilegedAction<JBossThreadFactory>(){

        @Override
        public JBossThreadFactory run() {
            return new JBossThreadFactory(new ThreadGroup(SimpleCache.class.getSimpleName()), Boolean.FALSE, null, "%G - %t", null, null);
        }
    });
    private final String name;

    public SimpleCacheFactoryBuilderServiceConfigurator(String name) {
        super(name);
        this.name = name;
    }

    public ServiceBuilder<?> build(ServiceTarget target) {
        ServiceName name = this.getServiceName();
        ServiceBuilder builder = target.addService(name);
        Consumer cacheFactoryBuilder = builder.provides(new ServiceName[]{name});
        Service service = Service.newInstance((Consumer)cacheFactoryBuilder, (Object)this);
        return builder.setInstance(service).setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    @Override
    public Collection<CapabilityServiceConfigurator> getDeploymentServiceConfigurators(DeploymentUnit unit) {
        RemoveOnCancelScheduledExecutorServiceConfigurator configurator = new RemoveOnCancelScheduledExecutorServiceConfigurator(this.getExpirationSchedulerServiceName(unit.getServiceName()), THREAD_FACTORY);
        return Collections.singleton(new ServiceConfiguratorAdapter((ServiceConfigurator)configurator));
    }

    @Override
    public CapabilityServiceConfigurator getServiceConfigurator(ServiceName name, StatefulComponentDescription description, ComponentConfiguration configuration) {
        return new SimpleCacheFactoryServiceConfigurator(name, description, (SupplierDependency<ScheduledExecutorService>)new ServiceSupplierDependency(this.getExpirationSchedulerServiceName(description.getDeploymentUnitServiceName())));
    }

    private ServiceName getExpirationSchedulerServiceName(ServiceName deploymentUnitServiceName) {
        return deploymentUnitServiceName.append(new String[]{this.name, "expiration"});
    }

    @Override
    public boolean supportsPassivation() {
        return false;
    }
}

