/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.subsystem;

import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.ejb3.subsystem.EJB3Extension;
import org.jboss.as.ejb3.subsystem.EJB3IIOPAdd;
import org.jboss.as.ejb3.subsystem.EJB3SubsystemModel;
import org.jboss.as.ejb3.subsystem.IIOPSettingsService;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceRegistry;

public class EJB3IIOPResourceDefinition
extends SimpleResourceDefinition {
    static final SimpleAttributeDefinition USE_QUALIFIED_NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("use-qualified-name", ModelType.BOOLEAN).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_NONE})).setRequired(true)).build();
    static final SimpleAttributeDefinition ENABLE_BY_DEFAULT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("enable-by-default", ModelType.BOOLEAN).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_NONE})).setRequired(true)).build();
    private static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{ENABLE_BY_DEFAULT, USE_QUALIFIED_NAME};
    public static final EJB3IIOPResourceDefinition INSTANCE = new EJB3IIOPResourceDefinition();

    private EJB3IIOPResourceDefinition() {
        super(EJB3SubsystemModel.IIOP_PATH, EJB3Extension.getResourceDescriptionResolver("iiop"), (OperationStepHandler)new EJB3IIOPAdd(ATTRIBUTES), (OperationStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)USE_QUALIFIED_NAME, null, (OperationStepHandler)new AbstractIIOPSettingWriteHandler((AttributeDefinition)USE_QUALIFIED_NAME){

            @Override
            void applySetting(IIOPSettingsService service, OperationContext context, ModelNode model) throws OperationFailedException {
                boolean value = USE_QUALIFIED_NAME.resolveModelAttribute(context, model).asBoolean();
                service.setUseQualifiedName(value);
            }
        });
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)ENABLE_BY_DEFAULT, null, (OperationStepHandler)new AbstractIIOPSettingWriteHandler((AttributeDefinition)ENABLE_BY_DEFAULT){

            @Override
            void applySetting(IIOPSettingsService service, OperationContext context, ModelNode model) throws OperationFailedException {
                boolean value = ENABLE_BY_DEFAULT.resolveModelAttribute(context, model).asBoolean();
                service.setEnabledByDefault(value);
            }
        });
    }

    private static abstract class AbstractIIOPSettingWriteHandler
    extends AbstractWriteAttributeHandler<Void> {
        public AbstractIIOPSettingWriteHandler(AttributeDefinition attribute) {
            super(new AttributeDefinition[]{attribute});
        }

        protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Void> handbackHolder) throws OperationFailedException {
            ModelNode model = context.readResource(PathAddress.EMPTY_ADDRESS).getModel();
            this.applyModelToRuntime(context, model);
            return false;
        }

        protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, Void handback) throws OperationFailedException {
            ModelNode restored = context.readResource(PathAddress.EMPTY_ADDRESS).getModel().clone();
            restored.get(attributeName).set(valueToRestore);
            this.applyModelToRuntime(context, restored);
        }

        private void applyModelToRuntime(OperationContext context, ModelNode model) throws OperationFailedException {
            ServiceRegistry serviceRegistry = context.getServiceRegistry(true);
            ServiceController controller = serviceRegistry.getService(IIOPSettingsService.SERVICE_NAME);
            if (controller != null) {
                IIOPSettingsService service = (IIOPSettingsService)controller.getValue();
                this.applySetting(service, context, model);
            }
        }

        abstract void applySetting(IIOPSettingsService var1, OperationContext var2, ModelNode var3) throws OperationFailedException;
    }
}

