/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.subsystem;

import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.ejb3.component.pool.PoolConfig;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.subsystem.EJB3SubsystemRootResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ValueInjectionService;

public class EJB3SubsystemDefaultPoolWriteHandler
extends AbstractWriteAttributeHandler<Void> {
    private static final String STRICT_MAX_POOL_CONFIG_CAPABILITY_NAME = "org.wildfly.ejb3.pool-config";
    private static final String DEFAULT_SLSB_POOL_CONFIG_CAPABILITY_NAME = "org.wildfly.ejb3.pool-config.slsb-default";
    private static final String DEFAULT_MDB_POOL_CONFIG_CAPABILITY_NAME = "org.wildfly.ejb3.pool-config.mdb-default";
    private static final String DEFAULT_ENTITY_POOL_CONFIG_CAPABILITY_NAME = "org.wildfly.ejb3.pool-config.entity-default";
    public static final EJB3SubsystemDefaultPoolWriteHandler SLSB_POOL = new EJB3SubsystemDefaultPoolWriteHandler("org.wildfly.ejb3.pool-config.slsb-default", (AttributeDefinition)EJB3SubsystemRootResourceDefinition.DEFAULT_SLSB_INSTANCE_POOL);
    public static final EJB3SubsystemDefaultPoolWriteHandler MDB_POOL = new EJB3SubsystemDefaultPoolWriteHandler("org.wildfly.ejb3.pool-config.mdb-default", (AttributeDefinition)EJB3SubsystemRootResourceDefinition.DEFAULT_MDB_INSTANCE_POOL);
    public static final EJB3SubsystemDefaultPoolWriteHandler ENTITY_BEAN_POOL = new EJB3SubsystemDefaultPoolWriteHandler("org.wildfly.ejb3.pool-config.entity-default", (AttributeDefinition)EJB3SubsystemRootResourceDefinition.DEFAULT_ENTITY_BEAN_INSTANCE_POOL);
    private final String poolConfigCapabilityName;
    private final AttributeDefinition poolAttribute;

    public EJB3SubsystemDefaultPoolWriteHandler(String defaultPoolConfigCapabilityName, AttributeDefinition poolAttribute) {
        super(new AttributeDefinition[]{poolAttribute});
        this.poolConfigCapabilityName = defaultPoolConfigCapabilityName;
        this.poolAttribute = poolAttribute;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recordCapabilitiesAndRequirements(OperationContext context, AttributeDefinition attributeDefinition, ModelNode newValue, ModelNode oldValue) {
        ModelNode resolvedNewValue;
        Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS);
        ModelNode model = resource.getModel();
        if (this.poolAttribute.getName().equals("default-slsb-instance-pool") || model.hasDefined("default-slsb-instance-pool")) {
            resolvedNewValue = new ModelNode();
            try {
                resolvedNewValue = context.resolveExpressions(newValue);
                String newSLSBRequirementName = RuntimeCapability.buildDynamicCapabilityName((String)STRICT_MAX_POOL_CONFIG_CAPABILITY_NAME, (String)resolvedNewValue.asString());
                context.registerAdditionalCapabilityRequirement(newSLSBRequirementName, DEFAULT_SLSB_POOL_CONFIG_CAPABILITY_NAME, "default-slsb-instance-pool");
            }
            catch (OperationFailedException ofe) {
                EjbLogger.ROOT_LOGGER.defaultPoolExpressionCouldNotBeResolved("default-slsb-instance-pool", model.get("default-slsb-instance-pool").asString());
            }
            finally {
                String oldSLSBRequirementName = RuntimeCapability.buildDynamicCapabilityName((String)STRICT_MAX_POOL_CONFIG_CAPABILITY_NAME, (String)oldValue.asString());
                context.deregisterCapabilityRequirement(oldSLSBRequirementName, DEFAULT_SLSB_POOL_CONFIG_CAPABILITY_NAME, "default-slsb-instance-pool");
            }
        }
        if (this.poolAttribute.getName().equals("default-mdb-instance-pool") || model.hasDefined("default-mdb-instance-pool")) {
            resolvedNewValue = new ModelNode();
            try {
                resolvedNewValue = context.resolveExpressions(newValue);
                String newMDBRequirementName = RuntimeCapability.buildDynamicCapabilityName((String)STRICT_MAX_POOL_CONFIG_CAPABILITY_NAME, (String)resolvedNewValue.asString());
                context.registerAdditionalCapabilityRequirement(newMDBRequirementName, DEFAULT_MDB_POOL_CONFIG_CAPABILITY_NAME, "default-mdb-instance-pool");
            }
            catch (OperationFailedException ofe) {
                EjbLogger.ROOT_LOGGER.defaultPoolExpressionCouldNotBeResolved("default-mdb-instance-pool", model.get("default-mdb-instance-pool").asString());
            }
            finally {
                String oldMDBRequirementName = RuntimeCapability.buildDynamicCapabilityName((String)STRICT_MAX_POOL_CONFIG_CAPABILITY_NAME, (String)oldValue.asString());
                context.deregisterCapabilityRequirement(oldMDBRequirementName, DEFAULT_MDB_POOL_CONFIG_CAPABILITY_NAME, "default-mdb-instance-pool");
            }
        }
        super.recordCapabilitiesAndRequirements(context, attributeDefinition, newValue, oldValue);
    }

    protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Void> handbackHolder) throws OperationFailedException {
        ModelNode model = context.readResource(PathAddress.EMPTY_ADDRESS).getModel();
        this.updatePoolService(context, model);
        return false;
    }

    protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, Void handback) throws OperationFailedException {
        ModelNode restored = context.readResource(PathAddress.EMPTY_ADDRESS).getModel().clone();
        restored.get(attributeName).set(valueToRestore);
        this.updatePoolService(context, restored);
    }

    void updatePoolService(OperationContext context, ModelNode model) throws OperationFailedException {
        ModelNode poolName = this.poolAttribute.resolveModelAttribute(context, model);
        ServiceName poolConfigServiceName = context.getCapabilityServiceName(this.poolConfigCapabilityName, PoolConfig.class);
        ServiceRegistry serviceRegistry = context.getServiceRegistry(true);
        ServiceController existingDefaultPoolConfigService = serviceRegistry.getService(poolConfigServiceName);
        if (existingDefaultPoolConfigService != null) {
            context.removeService(existingDefaultPoolConfigService);
        }
        if (poolName.isDefined()) {
            ValueInjectionService newDefaultPoolConfigService = new ValueInjectionService();
            ServiceName poolConfigDependencyServiceName = context.getCapabilityServiceName(STRICT_MAX_POOL_CONFIG_CAPABILITY_NAME, PoolConfig.class, new String[]{poolName.asString()});
            ServiceController serviceController = context.getServiceTarget().addService(poolConfigServiceName, (Service)newDefaultPoolConfigService).addDependency(poolConfigDependencyServiceName, PoolConfig.class, newDefaultPoolConfigService.getInjector()).install();
        }
    }
}

