/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment;

import java.security.AccessController;
import java.util.function.BiFunction;
import org.jboss.as.ejb3.subsystem.ApplicationSecurityDomainService;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.manager.WildFlySecurityManager;

public class EJBSecurityDomainService
implements Service<Void> {
    public static final ServiceName SERVICE_NAME = ServiceName.of((String[])new String[]{"ejb3", "security-domain"});
    private final InjectedValue<ApplicationSecurityDomainService.ApplicationSecurityDomain> applicationSecurityDomain = new InjectedValue();
    private final InjectedValue<SecurityDomain> securityDomain = new InjectedValue();
    private final DeploymentUnit deploymentUnit;
    private volatile Runnable cleanUpTask;

    public EJBSecurityDomainService(DeploymentUnit deploymentUnit) {
        this.deploymentUnit = deploymentUnit;
    }

    public synchronized void start(StartContext context) throws StartException {
        String deploymentName = this.deploymentUnit.getParent() == null ? this.deploymentUnit.getName() : this.deploymentUnit.getParent().getName() + "." + this.deploymentUnit.getName();
        Module module = (Module)this.deploymentUnit.getAttachment(Attachments.MODULE);
        ModuleClassLoader classLoader = module.getClassLoader();
        ApplicationSecurityDomainService.ApplicationSecurityDomain applicationSecurityDomain = (ApplicationSecurityDomainService.ApplicationSecurityDomain)this.applicationSecurityDomain.getOptionalValue();
        if (applicationSecurityDomain != null) {
            BiFunction<String, ClassLoader, ApplicationSecurityDomainService.Registration> securityFunction = applicationSecurityDomain.getSecurityFunction();
            if (securityFunction != null) {
                ApplicationSecurityDomainService.Registration registration = securityFunction.apply(deploymentName, (ClassLoader)classLoader);
                this.cleanUpTask = registration::cancel;
            }
        } else {
            SecurityDomain securityDomain = (SecurityDomain)this.securityDomain.getValue();
            if (WildFlySecurityManager.isChecking()) {
                AccessController.doPrivileged(() -> EJBSecurityDomainService.lambda$start$0(securityDomain, (ClassLoader)classLoader));
            } else {
                securityDomain.registerWithClassLoader((ClassLoader)classLoader);
            }
            this.cleanUpTask = new Runnable((ClassLoader)classLoader){
                final /* synthetic */ ClassLoader val$classLoader;
                {
                    this.val$classLoader = classLoader;
                }

                @Override
                public void run() {
                    if (WildFlySecurityManager.isChecking()) {
                        AccessController.doPrivileged(() -> {
                            SecurityDomain.unregisterClassLoader((ClassLoader)this.val$classLoader);
                            return null;
                        });
                    } else {
                        SecurityDomain.unregisterClassLoader((ClassLoader)this.val$classLoader);
                    }
                }
            };
        }
    }

    public synchronized void stop(StopContext context) {
        if (this.cleanUpTask != null) {
            this.cleanUpTask.run();
        }
    }

    public Void getValue() throws IllegalStateException, IllegalArgumentException {
        return null;
    }

    public Injector<ApplicationSecurityDomainService.ApplicationSecurityDomain> getApplicationSecurityDomainInjector() {
        return this.applicationSecurityDomain;
    }

    public Injector<SecurityDomain> getSecurityDomainInjector() {
        return this.securityDomain;
    }

    private static /* synthetic */ Void lambda$start$0(SecurityDomain securityDomain, ClassLoader classLoader) {
        securityDomain.registerWithClassLoader(classLoader);
        return null;
    }
}

