/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.remote;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.security.AccessController;
import java.util.List;
import java.util.Properties;
import org.jboss.as.ejb3.remote.RemotingProfileService;
import org.jboss.as.ejb3.subsystem.EJBClientConfiguratorService;
import org.jboss.as.network.OutboundConnection;
import org.jboss.ejb.client.ClusterNodeSelector;
import org.jboss.ejb.client.DeploymentNodeSelector;
import org.jboss.ejb.client.EJBClientCluster;
import org.jboss.ejb.client.EJBClientConnection;
import org.jboss.ejb.client.EJBClientContext;
import org.jboss.ejb.client.EJBClientInterceptor;
import org.jboss.ejb.client.EJBTransportProvider;
import org.jboss.ejb.client.legacy.JBossEJBProperties;
import org.jboss.ejb.client.legacy.LegacyPropertiesConfiguration;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.common.context.Contextual;
import org.wildfly.security.auth.client.AuthenticationContext;

public final class EJBClientContextService
implements Service<EJBClientContextService> {
    public static final ServiceName APP_CLIENT_URI_SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"ejb3", "ejbClientContext", "appClientUri"});
    public static final ServiceName APP_CLIENT_EJB_PROPERTIES_SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"ejb3", "ejbClientContext", "appClientEjbProperties"});
    private static final ServiceName BASE_SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"ejb3", "ejbClientContext"});
    public static final ServiceName DEPLOYMENT_BASE_SERVICE_NAME = BASE_SERVICE_NAME.append(new String[]{"deployment"});
    public static final ServiceName DEFAULT_SERVICE_NAME = BASE_SERVICE_NAME.append(new String[]{"default"});
    private EJBClientContext clientContext;
    private final InjectedValue<EJBClientConfiguratorService> configuratorServiceInjector = new InjectedValue();
    private final InjectedValue<EJBTransportProvider> localProviderInjector = new InjectedValue();
    private final InjectedValue<RemotingProfileService> profileServiceInjector = new InjectedValue();
    private InjectedValue<URI> appClientUri = new InjectedValue();
    private InjectedValue<String> appClientEjbProperties = new InjectedValue();
    private final boolean makeGlobal;
    private long invocationTimeout;
    private DeploymentNodeSelector deploymentNodeSelector;
    private List<EJBClientCluster> clientClusters = null;
    private AuthenticationContext clustersAuthenticationContext = null;
    private List<EJBClientInterceptor> clientInterceptors = null;
    private int defaultCompression = -1;

    public EJBClientContextService(boolean makeGlobal) {
        this.makeGlobal = makeGlobal;
    }

    public EJBClientContextService() {
        this.makeGlobal = false;
    }

    public void start(StartContext context) throws StartException {
        RemotingProfileService profileService;
        EJBClientContext.Builder builder = new EJBClientContext.Builder();
        ((EJBClientConfiguratorService)this.configuratorServiceInjector.getValue()).accept(builder);
        builder.setInvocationTimeout(this.invocationTimeout);
        builder.setDefaultCompression(this.defaultCompression);
        EJBTransportProvider localTransport = (EJBTransportProvider)this.localProviderInjector.getOptionalValue();
        if (localTransport != null) {
            builder.addTransportProvider(localTransport);
        }
        if ((profileService = (RemotingProfileService)this.profileServiceInjector.getOptionalValue()) != null) {
            EJBClientConnection.Builder connBuilder;
            for (RemotingProfileService.RemotingConnectionSpec remotingConnectionSpec : profileService.getConnectionSpecs()) {
                connBuilder = new EJBClientConnection.Builder();
                connBuilder.setDestination(((OutboundConnection)remotingConnectionSpec.getInjector().getValue()).getDestinationUri());
                builder.addClientConnection(connBuilder.build());
            }
            for (RemotingProfileService.HttpConnectionSpec httpConnectionSpec : profileService.getHttpConnectionSpecs()) {
                connBuilder = new EJBClientConnection.Builder();
                connBuilder.setDestination(httpConnectionSpec.getUri());
                builder.addClientConnection(connBuilder.build());
            }
        }
        if (this.appClientUri.getOptionalValue() != null) {
            EJBClientConnection.Builder connBuilder = new EJBClientConnection.Builder();
            connBuilder.setDestination((URI)this.appClientUri.getOptionalValue());
            builder.addClientConnection(connBuilder.build());
        }
        if (this.clientClusters != null) {
            boolean firstSelector = true;
            for (EJBClientCluster clientCluster : this.clientClusters) {
                builder.addClientCluster(clientCluster);
                ClusterNodeSelector selector = clientCluster.getClusterNodeSelector();
                if (!firstSelector) continue;
                if (selector != null) {
                    builder.setClusterNodeSelector(selector);
                }
                int maximumConnectedClusterNodes = Long.valueOf(clientCluster.getMaximumConnectedNodes()).intValue();
                builder.setMaximumConnectedClusterNodes(maximumConnectedClusterNodes);
                firstSelector = false;
            }
        }
        if (this.deploymentNodeSelector != null) {
            builder.setDeploymentNodeSelector(this.deploymentNodeSelector);
        }
        if (this.appClientEjbProperties.getOptionalValue() != null) {
            this.setupEjbClientProps((String)this.appClientEjbProperties.getOptionalValue());
            LegacyPropertiesConfiguration.configure((EJBClientContext.Builder)builder);
        }
        if (this.clientInterceptors != null) {
            for (EJBClientInterceptor eJBClientInterceptor : this.clientInterceptors) {
                builder.addInterceptor(eJBClientInterceptor);
            }
        }
        this.clientContext = builder.build();
        if (this.makeGlobal) {
            AccessController.doPrivileged(() -> {
                EJBClientContext.getContextManager().setGlobalDefault((Contextual)this.clientContext);
                return null;
            });
        }
    }

    public void stop(StopContext context) {
        this.clientContext = null;
        if (this.makeGlobal) {
            AccessController.doPrivileged(() -> {
                EJBClientContext.getContextManager().setGlobalDefault(null);
                return null;
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupEjbClientProps(String connectionPropertiesUrl) throws StartException {
        try {
            File file = new File(connectionPropertiesUrl);
            URL url = file.exists() ? file.toURI().toURL() : new URL(connectionPropertiesUrl);
            Properties properties = new Properties();
            InputStream stream = null;
            try {
                stream = url.openStream();
                properties.load(stream);
            }
            finally {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            JBossEJBProperties ejbProps = JBossEJBProperties.fromProperties((String)connectionPropertiesUrl, (Properties)properties);
            JBossEJBProperties.getContextManager().setGlobalDefault((Contextual)ejbProps);
        }
        catch (Exception e) {
            throw new StartException((Throwable)e);
        }
    }

    public EJBClientContextService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public EJBClientContext getClientContext() {
        return this.clientContext;
    }

    public InjectedValue<EJBClientConfiguratorService> getConfiguratorServiceInjector() {
        return this.configuratorServiceInjector;
    }

    public InjectedValue<EJBTransportProvider> getLocalProviderInjector() {
        return this.localProviderInjector;
    }

    public InjectedValue<RemotingProfileService> getProfileServiceInjector() {
        return this.profileServiceInjector;
    }

    public InjectedValue<URI> getAppClientUri() {
        return this.appClientUri;
    }

    public InjectedValue<String> getAppClientEjbProperties() {
        return this.appClientEjbProperties;
    }

    public void setInvocationTimeout(long invocationTimeout) {
        this.invocationTimeout = invocationTimeout;
    }

    public void setDefaultCompression(int defaultCompression) {
        this.defaultCompression = defaultCompression;
    }

    public void setDeploymentNodeSelector(DeploymentNodeSelector deploymentNodeSelector) {
        this.deploymentNodeSelector = deploymentNodeSelector;
    }

    public void setClientClusters(List<EJBClientCluster> clientClusters) {
        this.clientClusters = clientClusters;
    }

    public void setClustersAuthenticationContext(AuthenticationContext clustersAuthenticationContext) {
        this.clustersAuthenticationContext = clustersAuthenticationContext;
    }

    public void setClientInterceptors(List<EJBClientInterceptor> clientInterceptors) {
        this.clientInterceptors = clientInterceptors;
    }

    public AuthenticationContext getClustersAuthenticationContext() {
        return this.clustersAuthenticationContext;
    }
}

