/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors;

import java.util.List;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.metadata.MetadataCompleteMarker;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.ejb3.deployment.EjbDeploymentAttachmentKeys;
import org.jboss.as.ejb3.deployment.EjbJarDescription;
import org.jboss.as.ejb3.deployment.processors.EJBComponentDescriptionFactory;
import org.jboss.as.ejb3.deployment.processors.MessageDrivenComponentDescriptionFactory;
import org.jboss.as.ejb3.deployment.processors.SessionBeanComponentDescriptionFactory;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.EjbDeploymentMarker;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.metadata.ejb.spec.EjbJarMetaData;
import org.jboss.metadata.ejb.spec.EnterpriseBeanMetaData;
import org.jboss.metadata.ejb.spec.EnterpriseBeansMetaData;

public class AnnotatedEJBComponentDescriptionDeploymentUnitProcessor
implements DeploymentUnitProcessor {
    private final boolean appclient;
    private final EJBComponentDescriptionFactory[] factories;

    public AnnotatedEJBComponentDescriptionDeploymentUnitProcessor(boolean appclient, boolean defaultMdbPoolAvailable, boolean defaultSlsbPoolAvailable) {
        this.appclient = appclient;
        this.factories = new EJBComponentDescriptionFactory[]{new MessageDrivenComponentDescriptionFactory(appclient, defaultMdbPoolAvailable), new SessionBeanComponentDescriptionFactory(appclient, defaultSlsbPoolAvailable)};
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (DeploymentTypeMarker.isType((DeploymentType)DeploymentType.EAR, (DeploymentUnit)deploymentUnit)) {
            return;
        }
        CompositeIndex compositeIndex = (CompositeIndex)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.COMPOSITE_ANNOTATION_INDEX);
        if (compositeIndex == null) {
            EjbLogger.DEPLOYMENT_LOGGER.tracef("Skipping EJB annotation processing since no composite annotation index found in unit: %s", deploymentUnit);
        } else if (MetadataCompleteMarker.isMetadataComplete((DeploymentUnit)deploymentUnit)) {
            EjbLogger.DEPLOYMENT_LOGGER.trace("Skipping EJB annotation processing due to deployment being metadata-complete. ");
        } else {
            this.processAnnotations(deploymentUnit, compositeIndex);
        }
        this.processDeploymentDescriptor(deploymentUnit);
    }

    public void undeploy(DeploymentUnit context) {
    }

    protected static EjbJarDescription getEjbJarDescription(DeploymentUnit deploymentUnit) {
        EjbJarDescription ejbJarDescription = (EjbJarDescription)deploymentUnit.getAttachment(EjbDeploymentAttachmentKeys.EJB_JAR_DESCRIPTION);
        if (ejbJarDescription == null) {
            EEModuleDescription moduleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
            ejbJarDescription = new EjbJarDescription(moduleDescription, deploymentUnit.getName().endsWith(".war"));
            deploymentUnit.putAttachment(EjbDeploymentAttachmentKeys.EJB_JAR_DESCRIPTION, (Object)ejbJarDescription);
        }
        return ejbJarDescription;
    }

    private void processDeploymentDescriptor(DeploymentUnit deploymentUnit) throws DeploymentUnitProcessingException {
        SimpleSet<String> annotatedEJBs;
        EjbJarMetaData ejbJarMetaData = (EjbJarMetaData)deploymentUnit.getAttachment(EjbDeploymentAttachmentKeys.EJB_JAR_METADATA);
        if (ejbJarMetaData == null) {
            return;
        }
        if (this.appclient) {
            final List additionalComponents = deploymentUnit.getAttachmentList(Attachments.ADDITIONAL_RESOLVABLE_COMPONENTS);
            annotatedEJBs = new SimpleSet<String>(){

                @Override
                public boolean contains(Object o) {
                    for (ComponentDescription component : additionalComponents) {
                        if (!component.getComponentName().equals(o)) continue;
                        return true;
                    }
                    return false;
                }
            };
        } else {
            final EjbJarDescription ejbJarDescription = AnnotatedEJBComponentDescriptionDeploymentUnitProcessor.getEjbJarDescription(deploymentUnit);
            annotatedEJBs = new SimpleSet<String>(){

                @Override
                public boolean contains(Object o) {
                    return ejbJarDescription.hasComponent((String)o);
                }
            };
        }
        EnterpriseBeansMetaData ejbs = ejbJarMetaData.getEnterpriseBeans();
        if (ejbs != null && !ejbs.isEmpty()) {
            for (EnterpriseBeanMetaData ejb : ejbs) {
                String beanName = ejb.getName();
                if (annotatedEJBs.contains(beanName)) continue;
                this.processBeanMetaData(deploymentUnit, ejb);
            }
        }
        EjbDeploymentMarker.mark((DeploymentUnit)deploymentUnit);
    }

    private void processAnnotations(DeploymentUnit deploymentUnit, CompositeIndex compositeIndex) throws DeploymentUnitProcessingException {
        for (EJBComponentDescriptionFactory factory : this.factories) {
            factory.processAnnotations(deploymentUnit, compositeIndex);
        }
    }

    private void processBeanMetaData(DeploymentUnit deploymentUnit, EnterpriseBeanMetaData ejb) throws DeploymentUnitProcessingException {
        for (EJBComponentDescriptionFactory factory : this.factories) {
            factory.processBeanMetaData(deploymentUnit, ejb);
        }
    }

    private static interface SimpleSet<E> {
        public boolean contains(Object var1);
    }
}

