/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.interceptors;

import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.EJBTransactionRequiredException;
import javax.ejb.EJBTransactionRolledbackException;
import javax.ejb.NoSuchEJBException;
import javax.ejb.NoSuchEntityException;
import javax.ejb.NoSuchObjectLocalException;
import javax.ejb.TransactionRequiredLocalException;
import javax.ejb.TransactionRolledbackLocalException;
import javax.transaction.TransactionRequiredException;
import javax.transaction.TransactionRolledbackException;
import org.jboss.as.ejb3.component.EJBComponentUnavailableException;
import org.jboss.invocation.ImmediateInterceptorFactory;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactory;

public class EjbExceptionTransformingInterceptorFactories {
    private static final ThreadLocal<CreateException> CREATE_EXCEPTION = new ThreadLocal();
    public static final InterceptorFactory REMOTE_INSTANCE = new ImmediateInterceptorFactory(new Interceptor(){

        public Object processInvocation(InterceptorContext context) throws Exception {
            try {
                return context.proceed();
            }
            catch (EJBTransactionRequiredException e) {
                throw EjbExceptionTransformingInterceptorFactories.copyStackTrace(new TransactionRequiredException(e.getMessage()), e);
            }
            catch (EJBTransactionRolledbackException e) {
                throw EjbExceptionTransformingInterceptorFactories.copyStackTrace(new TransactionRolledbackException(e.getMessage()), e);
            }
            catch (NoSuchEJBException e) {
                throw EjbExceptionTransformingInterceptorFactories.copyStackTrace(new NoSuchObjectException(e.getMessage()), e);
            }
            catch (NoSuchEntityException e) {
                throw EjbExceptionTransformingInterceptorFactories.copyStackTrace(new NoSuchObjectException(e.getMessage()), e);
            }
            catch (EJBComponentUnavailableException e) {
                throw e;
            }
            catch (EJBException e) {
                CreateException createException = EjbExceptionTransformingInterceptorFactories.popCreateException();
                if (createException != null) {
                    throw createException;
                }
                throw new RemoteException("Invocation failed", e);
            }
        }
    });
    public static final InterceptorFactory LOCAL_INSTANCE = new ImmediateInterceptorFactory(new Interceptor(){

        public Object processInvocation(InterceptorContext context) throws Exception {
            try {
                return context.proceed();
            }
            catch (EJBTransactionRequiredException e) {
                throw EjbExceptionTransformingInterceptorFactories.copyStackTrace(EjbExceptionTransformingInterceptorFactories.copyCause(new TransactionRequiredLocalException(e.getMessage()), e), e);
            }
            catch (EJBTransactionRolledbackException e) {
                throw EjbExceptionTransformingInterceptorFactories.copyStackTrace(new TransactionRolledbackLocalException(e.getMessage(), (Exception)((Object)e)), e);
            }
            catch (NoSuchEJBException e) {
                throw EjbExceptionTransformingInterceptorFactories.copyStackTrace(new NoSuchObjectLocalException(e.getMessage(), (Exception)((Object)e)), e);
            }
            catch (NoSuchEntityException e) {
                throw EjbExceptionTransformingInterceptorFactories.copyStackTrace(new NoSuchObjectLocalException(e.getMessage(), (Exception)((Object)e)), e);
            }
            catch (EJBException e) {
                CreateException createException = EjbExceptionTransformingInterceptorFactories.popCreateException();
                if (createException != null) {
                    throw createException;
                }
                throw e;
            }
        }
    });

    private static <T extends Throwable> T copyCause(T newThrowable, Throwable originalThrowable) {
        Throwable cause = originalThrowable.getCause();
        if (cause != null) {
            try {
                newThrowable.initCause(cause);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        return newThrowable;
    }

    private static <T extends Throwable> T copyStackTrace(T newThrowable, Throwable originalThrowable) {
        newThrowable.setStackTrace(originalThrowable.getStackTrace());
        return newThrowable;
    }

    public static void setCreateException(CreateException exception) {
        CREATE_EXCEPTION.set(exception);
    }

    public static CreateException popCreateException() {
        try {
            CreateException createException = CREATE_EXCEPTION.get();
            return createException;
        }
        finally {
            CREATE_EXCEPTION.remove();
        }
    }
}

