/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.timerservice;

import java.security.PrivilegedAction;
import javax.ejb.Timer;
import javax.ejb.TimerHandle;
import org.jboss.as.ejb3.component.EJBComponent;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.timerservice.spi.ManagedTimer;
import org.jboss.as.server.CurrentServiceContainer;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceName;
import org.wildfly.security.manager.WildFlySecurityManager;

public class TimerHandleImpl
implements TimerHandle {
    private static final long serialVersionUID = 1L;
    private final String timedObjectId;
    private final String serviceName;
    private final String id;
    private transient EJBComponent component;
    private transient ManagedTimer timer;

    public TimerHandleImpl(ManagedTimer timer, EJBComponent component) {
        this.timedObjectId = null;
        this.timer = timer;
        this.component = component;
        this.id = timer.getId();
        this.serviceName = component.getCreateServiceName().getCanonicalName();
    }

    public synchronized Timer getTimer() {
        if (this.component == null) {
            ServiceName serviceName = ServiceName.parse((String)this.serviceName);
            if (this.timedObjectId != null) {
                serviceName = serviceName.getParent().getParent().append(new String[]{"CREATE"});
            }
            this.component = (EJBComponent)((Object)((ServiceContainer)WildFlySecurityManager.doUnchecked((PrivilegedAction)CurrentServiceContainer.GET_ACTION)).getRequiredService(serviceName).getValue());
        }
        if (this.timer == null) {
            this.timer = this.component.getTimerService().findTimer(this.id);
        }
        if (this.timer == null || !this.timer.isActive()) {
            throw EjbLogger.EJB3_TIMER_LOGGER.timerHandleIsNotActive(this.id, this.component.getTimerService().getInvoker().getTimedObjectId());
        }
        return this.timer;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof TimerHandleImpl)) {
            return false;
        }
        TimerHandleImpl handle = (TimerHandleImpl)object;
        return this.id.equals(handle.id) && this.serviceName.equals(handle.serviceName);
    }

    public String toString() {
        return this.id;
    }
}

