/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.timerservice;

import java.io.Serializable;
import java.util.Date;
import java.util.concurrent.Semaphore;
import javax.ejb.EJBException;
import javax.ejb.ScheduleExpression;
import javax.ejb.TimerHandle;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.timerservice.TimerHandleImpl;
import org.jboss.as.ejb3.timerservice.TimerServiceImpl;
import org.jboss.as.ejb3.timerservice.TimerState;
import org.jboss.as.ejb3.timerservice.TimerTask;
import org.jboss.as.ejb3.timerservice.spi.ManagedTimer;
import org.jboss.as.ejb3.timerservice.spi.TimedObjectInvoker;

public class TimerImpl
implements ManagedTimer {
    private String toStringTemplate;
    protected final String id;
    protected volatile TimerState timerState;
    protected final TimerServiceImpl timerService;
    protected final TimedObjectInvoker timedObjectInvoker;
    protected Serializable info;
    protected final boolean persistent;
    protected final Date initialExpiration;
    protected final long intervalDuration;
    protected volatile Date nextExpiration;
    protected volatile Date previousRun;
    private final String timedObjectId;
    private final Semaphore inUseLock = new Semaphore(1);
    private volatile Thread executingThread;

    protected TimerImpl(Builder builder, TimerServiceImpl service) {
        assert (builder.id != null) : "id is null";
        this.id = builder.id;
        this.timedObjectId = builder.timedObjectId;
        this.info = builder.info;
        this.persistent = builder.persistent;
        this.initialExpiration = builder.initialDate;
        this.intervalDuration = builder.repeatInterval;
        this.nextExpiration = builder.newTimer && builder.nextDate == null ? this.initialExpiration : builder.nextDate;
        this.previousRun = builder.previousRun;
        this.timerState = builder.timerState;
        this.timerService = service;
        this.timedObjectInvoker = service.getInvoker();
    }

    public void cancel() throws IllegalStateException, EJBException {
        try {
            this.timerService.cancelTimer(this);
        }
        catch (InterruptedException e) {
            throw new EJBException((Exception)e);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    public boolean isCalendarTimer() throws IllegalStateException, EJBException {
        this.validateInvocationContext();
        return false;
    }

    public TimerHandle getHandle() throws IllegalStateException, EJBException {
        this.validateInvocationContext();
        if (!this.persistent) {
            throw EjbLogger.EJB3_TIMER_LOGGER.invalidTimerHandlersForPersistentTimers("Enterprise Beans 3.1 Spec 18.2.6");
        }
        return new TimerHandleImpl(this, this.timedObjectInvoker.getComponent());
    }

    public boolean isPersistent() throws IllegalStateException, EJBException {
        this.validateInvocationContext();
        return this.persistent;
    }

    public Serializable getInfo() throws IllegalStateException, EJBException {
        this.validateInvocationContext();
        return this.getTimerInfo();
    }

    public Serializable getTimerInfo() {
        if (this.info != Object.class) {
            return this.info;
        }
        return this.timerService.getPersistedTimerInfo(this);
    }

    public Serializable getCachedTimerInfo() {
        return this.info;
    }

    public void setCachedTimerInfo(Serializable newInfo) {
        this.info = newInfo;
    }

    public Date getNextTimeout() throws IllegalStateException, EJBException {
        this.validateInvocationContext();
        if (this.nextExpiration == null) {
            throw EjbLogger.EJB3_TIMER_LOGGER.noMoreTimeoutForTimer(this);
        }
        return this.nextExpiration;
    }

    public Date getNextExpiration() {
        return this.nextExpiration;
    }

    public void setNextTimeout(Date next) {
        if (next == null) {
            this.setTimerState(TimerState.EXPIRED, null);
        }
        this.nextExpiration = next;
    }

    public ScheduleExpression getSchedule() throws IllegalStateException, EJBException {
        this.validateInvocationContext();
        throw EjbLogger.EJB3_TIMER_LOGGER.invalidTimerNotCalendarBaseTimer(this);
    }

    public long getTimeRemaining() throws IllegalStateException, EJBException {
        this.validateInvocationContext();
        if (this.nextExpiration == null) {
            throw EjbLogger.EJB3_TIMER_LOGGER.noMoreTimeoutForTimer(this);
        }
        long currentTimeInMillis = System.currentTimeMillis();
        long nextTimeoutInMillis = this.nextExpiration.getTime();
        return nextTimeoutInMillis - currentTimeInMillis;
    }

    public boolean isAutoTimer() {
        return false;
    }

    public Date getInitialExpiration() {
        return this.initialExpiration;
    }

    public long getInterval() {
        return this.intervalDuration;
    }

    public String getTimedObjectId() {
        return this.timedObjectId;
    }

    public TimerServiceImpl getTimerService() {
        return this.timerService;
    }

    @Override
    public boolean isActive() {
        return this.timerService.isStarted() && !this.isCanceled() && !this.isExpired() && (this.timerState == TimerState.CREATED || this.timerService.isScheduled(this.getId()));
    }

    @Override
    public boolean isCanceled() {
        return this.timerState == TimerState.CANCELED;
    }

    @Override
    public boolean isExpired() {
        return this.timerState == TimerState.EXPIRED;
    }

    public boolean isInRetry() {
        return this.timerState == TimerState.RETRY_TIMEOUT;
    }

    public Date getPreviousRun() {
        return this.previousRun;
    }

    public void setPreviousRun(Date previousRun) {
        this.previousRun = previousRun;
    }

    public TimerState getState() {
        return this.timerState;
    }

    protected Thread getExecutingThread() {
        return this.executingThread;
    }

    public void setTimerState(TimerState state, Thread thread) {
        assert ((state == TimerState.IN_TIMEOUT || state == TimerState.RETRY_TIMEOUT) && thread != null || thread == null) : "Invalid to set timer state " + state + " with executing Thread " + thread;
        this.timerState = state;
        this.executingThread = thread;
    }

    @Override
    public void activate() {
        this.scheduleTimeout(true);
    }

    @Override
    public void suspend() {
        this.timerService.cancelTimeout(this);
    }

    @Override
    public void invoke() throws Exception {
        this.getTimerTask().invokeBeanMethod(this);
    }

    public void scheduleTimeout(boolean newTimer) {
        this.timerService.scheduleTimeout(this, newTimer);
    }

    protected TimerTask getTimerTask() {
        return new TimerTask(this);
    }

    public void lock() throws InterruptedException {
        this.inUseLock.acquire();
    }

    public void unlock() {
        this.inUseLock.release();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimerImpl otherTimer = (TimerImpl)o;
        if (!this.id.equals(otherTimer.id)) {
            return false;
        }
        return this.timedObjectId.equals(otherTimer.timedObjectId);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        StringBuilder sb;
        if (this.toStringTemplate == null) {
            sb = new StringBuilder();
            sb.append("[id=");
            sb.append(this.id);
            sb.append(" timedObjectId=");
            sb.append(this.timedObjectId);
            sb.append(" auto-timer?:");
            sb.append(this.isAutoTimer());
            sb.append(" persistent?:");
            sb.append(this.persistent);
            sb.append(" timerService=");
            sb.append(this.timerService);
            sb.append(" previousRun=");
            sb.append(this.previousRun);
            sb.append(" initialExpiration=");
            sb.append(this.initialExpiration);
            sb.append(" intervalDuration(in milli sec)=");
            sb.append(this.intervalDuration);
            this.toStringTemplate = sb.toString();
        }
        sb = new StringBuilder(this.toStringTemplate);
        sb.append(" nextExpiration=");
        sb.append(this.nextExpiration);
        sb.append(" timerState=");
        sb.append((Object)this.timerState);
        sb.append(" info=");
        sb.append(this.info);
        sb.append("]");
        return sb.toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        protected String id;
        protected String timedObjectId;
        protected Date initialDate;
        protected long repeatInterval;
        protected Date nextDate;
        protected Date previousRun;
        protected Serializable info;
        protected TimerState timerState;
        protected boolean persistent;
        protected boolean newTimer;

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public Builder setTimedObjectId(String timedObjectId) {
            this.timedObjectId = timedObjectId;
            return this;
        }

        public Builder setInitialDate(Date initialDate) {
            this.initialDate = initialDate;
            return this;
        }

        public Builder setRepeatInterval(long repeatInterval) {
            this.repeatInterval = repeatInterval;
            return this;
        }

        public Builder setNextDate(Date nextDate) {
            this.nextDate = nextDate;
            return this;
        }

        public Builder setPreviousRun(Date previousRun) {
            this.previousRun = previousRun;
            return this;
        }

        public Builder setInfo(Serializable info) {
            this.info = info;
            return this;
        }

        public Builder setTimerState(TimerState timerState) {
            this.timerState = timerState;
            return this;
        }

        public Builder setPersistent(boolean persistent) {
            this.persistent = persistent;
            return this;
        }

        public Builder setNewTimer(boolean newTimer) {
            this.newTimer = newTimer;
            return this;
        }

        public String getId() {
            return this.id;
        }

        public String getTimedObjectId() {
            return this.timedObjectId;
        }

        public TimerImpl build(TimerServiceImpl timerService) {
            return new TimerImpl(this, timerService);
        }
    }
}

