/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.timerservice;

import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ejb.Timer;
import javax.ejb.TimerService;
import org.jboss.as.ejb3.timerservice.spi.TimerServiceRegistry;

public class TimerServiceRegistryImpl
implements TimerServiceRegistry {
    private static final Function<TimerService, Collection<Timer>> GET_TIMERS = TimerService::getTimers;
    private static final Function<Collection<Timer>, Stream<Timer>> STREAM = Collection::stream;
    private final Set<TimerService> services = Collections.synchronizedSet(Collections.newSetFromMap(new IdentityHashMap()));

    @Override
    public void registerTimerService(TimerService service) {
        this.services.add(service);
    }

    @Override
    public void unregisterTimerService(TimerService service) {
        this.services.remove(service);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Timer> getAllTimers() {
        Set<TimerService> set = this.services;
        synchronized (set) {
            return Collections.unmodifiableCollection(this.services.stream().map(GET_TIMERS).flatMap(STREAM).collect(Collectors.toList()));
        }
    }
}

