/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.timerservice.distributable;

import java.util.function.Consumer;
import javax.transaction.Synchronization;
import org.jboss.as.ejb3.context.CurrentInvocationContext;
import org.jboss.as.ejb3.timerservice.distributable.TimerSynchronizationFactory;
import org.jboss.as.ejb3.timerservice.spi.ManagedTimer;
import org.jboss.invocation.InterceptorContext;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.ee.BatchContext;
import org.wildfly.clustering.ee.Batcher;
import org.wildfly.clustering.ejb.timer.Timer;
import org.wildfly.clustering.ejb.timer.TimerRegistry;

public class DistributableTimerSynchronizationFactory<I>
implements TimerSynchronizationFactory<I> {
    private final Consumer<Timer<I>> activateTask;
    private final Consumer<Timer<I>> cancelTask;

    public DistributableTimerSynchronizationFactory(final TimerRegistry<I> registry) {
        this.activateTask = new Consumer<Timer<I>>(){

            @Override
            public void accept(Timer<I> timer) {
                timer.activate();
                registry.register(timer.getId());
            }
        };
        this.cancelTask = new Consumer<Timer<I>>(){

            @Override
            public void accept(Timer<I> timer) {
                registry.unregister(timer.getId());
                timer.cancel();
            }
        };
    }

    @Override
    public Consumer<Timer<I>> getActivateTask() {
        return this.activateTask;
    }

    @Override
    public Consumer<Timer<I>> getCancelTask() {
        return this.cancelTask;
    }

    @Override
    public Synchronization createActivateSynchronization(Timer<I> timer, Batch batch, Batcher<Batch> batcher) {
        return new DistributableTimerSynchronization<I>(timer, batch, batcher, this.activateTask, this.cancelTask);
    }

    @Override
    public Synchronization createCancelSynchronization(Timer<I> timer, Batch batch, Batcher<Batch> batcher) {
        return new DistributableTimerSynchronization<I>(timer, batch, batcher, this.cancelTask, this.activateTask);
    }

    private static class DistributableTimerSynchronization<I>
    implements Synchronization {
        private final Batcher<Batch> batcher;
        private final Timer<I> timer;
        private final Batch batch;
        private final Consumer<Timer<I>> commitTask;
        private final Consumer<Timer<I>> rollbackTask;

        DistributableTimerSynchronization(Timer<I> timer, Batch batch, Batcher<Batch> batcher, Consumer<Timer<I>> commitTask, Consumer<Timer<I>> rollbackTask) {
            this.timer = timer;
            this.batch = batch;
            this.batcher = batcher;
            this.commitTask = commitTask;
            this.rollbackTask = rollbackTask;
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            InterceptorContext interceptorContext = CurrentInvocationContext.get();
            ManagedTimer currentTimer = interceptorContext != null ? (ManagedTimer)interceptorContext.getTimer() : null;
            try (BatchContext context = this.batcher.resumeBatch(this.batch);
                 Batch currentBatch = currentTimer != null && currentTimer.getId().equals(this.timer.getId().toString()) || this.batch.getState() != Batch.State.ACTIVE ? this.batcher.createBatch() : this.batch;){
                if (!this.timer.isCanceled()) {
                    if (status == 3) {
                        this.commitTask.accept(this.timer);
                    } else {
                        this.rollbackTask.accept(this.timer);
                    }
                }
            }
        }
    }
}

