/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.timerservice.distributable;

import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import java.util.function.Function;
import javax.ejb.EJBException;
import javax.ejb.ScheduleExpression;
import javax.ejb.TimerHandle;
import javax.transaction.Transaction;
import org.jboss.as.ejb3.context.CurrentInvocationContext;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.timerservice.distributable.DistributableTimer;
import org.jboss.as.ejb3.timerservice.distributable.TimerSynchronizationFactory;
import org.jboss.as.ejb3.timerservice.spi.ManagedTimer;
import org.jboss.as.ejb3.timerservice.spi.ManagedTimerService;
import org.jboss.as.ejb3.timerservice.spi.TimedObjectInvoker;
import org.jboss.invocation.InterceptorContext;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.ee.Batcher;
import org.wildfly.clustering.ejb.timer.Timer;
import org.wildfly.clustering.ejb.timer.TimerManager;
import org.wildfly.common.function.ExceptionConsumer;

public class OOBTimer<I>
implements ManagedTimer {
    private static final Function<ManagedTimer, TimerHandle> GET_HANDLE = javax.ejb.Timer::getHandle;
    private static final Function<ManagedTimer, Serializable> GET_INFO = javax.ejb.Timer::getInfo;
    private static final Function<ManagedTimer, Date> GET_NEXT_TIMEOUT = javax.ejb.Timer::getNextTimeout;
    private static final Function<ManagedTimer, ScheduleExpression> GET_SCHEDULE = javax.ejb.Timer::getSchedule;
    private static final Function<ManagedTimer, Long> GET_TIME_REMAINING = javax.ejb.Timer::getTimeRemaining;
    private static final Function<ManagedTimer, Boolean> IS_ACTIVE = ManagedTimer::isActive;
    private static final Function<ManagedTimer, Boolean> IS_CALENDAR = javax.ejb.Timer::isCalendarTimer;
    private static final Function<ManagedTimer, Boolean> IS_CANCELED = ManagedTimer::isCanceled;
    private static final Function<ManagedTimer, Boolean> IS_EXPIRED = ManagedTimer::isExpired;
    private static final Function<ManagedTimer, Boolean> IS_PERSISTENT = javax.ejb.Timer::isPersistent;
    private static final ExceptionConsumer<ManagedTimer, EJBException> ACTIVATE = ManagedTimer::activate;
    private static final ExceptionConsumer<ManagedTimer, EJBException> CANCEL = javax.ejb.Timer::cancel;
    private static final ExceptionConsumer<ManagedTimer, Exception> INVOKE = ManagedTimer::invoke;
    private static final ExceptionConsumer<ManagedTimer, EJBException> SUSPEND = ManagedTimer::suspend;
    private final TimerManager<I, Batch> manager;
    private final I id;
    private final TimedObjectInvoker invoker;
    private final TimerSynchronizationFactory<I> synchronizationFactory;

    public OOBTimer(TimerManager<I, Batch> manager, I id, TimedObjectInvoker invoker, TimerSynchronizationFactory<I> synchronizationFactory) {
        this.manager = manager;
        this.id = id;
        this.invoker = invoker;
        this.synchronizationFactory = synchronizationFactory;
    }

    public void cancel() {
        this.invoke(CANCEL);
    }

    public long getTimeRemaining() {
        return this.invoke(GET_TIME_REMAINING);
    }

    public Date getNextTimeout() {
        return this.invoke(GET_NEXT_TIMEOUT);
    }

    public ScheduleExpression getSchedule() {
        return this.invoke(GET_SCHEDULE);
    }

    public boolean isPersistent() {
        return this.invoke(IS_PERSISTENT);
    }

    public boolean isCalendarTimer() {
        return this.invoke(IS_CALENDAR);
    }

    public Serializable getInfo() {
        return this.invoke(GET_INFO);
    }

    public TimerHandle getHandle() {
        return this.invoke(GET_HANDLE);
    }

    @Override
    public String getId() {
        return this.id.toString();
    }

    @Override
    public void activate() {
        this.invoke(ACTIVATE);
    }

    @Override
    public void suspend() {
        this.invoke(SUSPEND);
    }

    @Override
    public void invoke() throws Exception {
        this.invoke(INVOKE);
    }

    @Override
    public boolean isActive() {
        return this.invoke(IS_ACTIVE);
    }

    @Override
    public boolean isCanceled() {
        return this.invoke(IS_CANCELED);
    }

    @Override
    public boolean isExpired() {
        return this.invoke(IS_EXPIRED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <R> R invoke(Function<ManagedTimer, R> function) {
        Map.Entry existing;
        ManagedTimer currentTimer;
        InterceptorContext interceptorContext = CurrentInvocationContext.get();
        ManagedTimer managedTimer = currentTimer = interceptorContext != null ? (ManagedTimer)interceptorContext.getTimer() : null;
        if (currentTimer != null && currentTimer.getId().equals(this.id.toString())) {
            return function.apply(currentTimer);
        }
        Transaction transaction = ManagedTimerService.getActiveTransaction();
        Map.Entry entry = existing = transaction != null ? (Map.Entry)this.invoker.getComponent().getTransactionSynchronizationRegistry().getResource(this.id) : null;
        if (existing != null) {
            Timer timer = (Timer)existing.getKey();
            Batch suspendedBatch = (Batch)existing.getValue();
            return function.apply(new DistributableTimer<I>(this.manager, timer, suspendedBatch, this.invoker, this.synchronizationFactory));
        }
        Batcher batcher = this.manager.getBatcher();
        try (Batch batch = batcher.createBatch();){
            R r;
            Timer timer = this.manager.getTimer(this.id);
            if (timer == null) {
                throw EjbLogger.ROOT_LOGGER.timerWasCanceled(this.id.toString());
            }
            Batch suspendedBatch = batcher.suspendBatch();
            try {
                r = function.apply(new DistributableTimer<I>(this.manager, timer, suspendedBatch, this.invoker, this.synchronizationFactory));
            }
            catch (Throwable throwable) {
                batcher.resumeBatch(suspendedBatch);
                throw throwable;
            }
            batcher.resumeBatch(suspendedBatch);
            return r;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <E extends Exception> void invoke(ExceptionConsumer<ManagedTimer, E> consumer) throws E {
        ManagedTimer currentTimer;
        InterceptorContext interceptorContext = CurrentInvocationContext.get();
        ManagedTimer managedTimer = currentTimer = interceptorContext != null ? (ManagedTimer)interceptorContext.getTimer() : null;
        if (currentTimer != null && currentTimer.getId().equals(this.id.toString())) {
            consumer.accept((Object)currentTimer);
        } else {
            Map.Entry existing;
            Transaction transaction = ManagedTimerService.getActiveTransaction();
            Map.Entry entry = existing = transaction != null ? (Map.Entry)this.invoker.getComponent().getTransactionSynchronizationRegistry().getResource(this.id) : null;
            if (existing != null) {
                Timer timer = (Timer)existing.getKey();
                Batch suspendedBatch = (Batch)existing.getValue();
                consumer.accept(new DistributableTimer<I>(this.manager, timer, suspendedBatch, this.invoker, this.synchronizationFactory));
            } else {
                Batcher batcher = this.manager.getBatcher();
                try (Batch batch = batcher.createBatch();){
                    Timer timer = this.manager.getTimer(this.id);
                    if (timer == null) {
                        throw EjbLogger.ROOT_LOGGER.timerWasCanceled(this.id.toString());
                    }
                    Batch suspendedBatch = batcher.suspendBatch();
                    try {
                        consumer.accept(new DistributableTimer<I>(this.manager, timer, suspendedBatch, this.invoker, this.synchronizationFactory));
                    }
                    finally {
                        batcher.resumeBatch(suspendedBatch);
                    }
                }
            }
        }
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof ManagedTimer)) {
            return false;
        }
        return this.getId().equals(((ManagedTimer)object).getId());
    }

    public String toString() {
        return this.getId();
    }
}

