/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.timerservice.distributable;

import java.time.DateTimeException;
import java.time.Instant;
import java.time.ZoneId;
import java.util.Date;
import javax.ejb.ScheduleExpression;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.wildfly.clustering.ejb.timer.ImmutableScheduleExpression;

public class SimpleImmutableScheduleExpression
implements ImmutableScheduleExpression {
    static final ZoneId DEFAULT_ZONE_ID = ZoneId.systemDefault();
    private final String second;
    private final String minute;
    private final String hour;
    private final String dayOfMonth;
    private final String month;
    private final String dayOfWeek;
    private final String year;
    private final ZoneId zone;
    private final Instant start;
    private final Instant end;

    public SimpleImmutableScheduleExpression(ScheduleExpression expression) {
        this.second = expression.getSecond();
        this.minute = expression.getMinute();
        this.hour = expression.getHour();
        this.dayOfMonth = expression.getDayOfMonth();
        this.month = expression.getMonth();
        this.dayOfWeek = expression.getDayOfWeek();
        this.year = expression.getYear();
        this.zone = SimpleImmutableScheduleExpression.createZoneId(expression.getTimezone());
        Date start = expression.getStart();
        Date end = expression.getEnd();
        this.start = start != null ? start.toInstant() : null;
        this.end = end != null ? end.toInstant() : null;
    }

    private static ZoneId createZoneId(String id) {
        if (id == null) {
            return DEFAULT_ZONE_ID;
        }
        try {
            return ZoneId.of(id.trim());
        }
        catch (DateTimeException e) {
            EjbLogger.EJB3_TIMER_LOGGER.unknownTimezoneId(id, DEFAULT_ZONE_ID.getId());
            return DEFAULT_ZONE_ID;
        }
    }

    public String getSecond() {
        return this.second;
    }

    public String getMinute() {
        return this.minute;
    }

    public String getHour() {
        return this.hour;
    }

    public String getDayOfMonth() {
        return this.dayOfMonth;
    }

    public String getMonth() {
        return this.month;
    }

    public String getDayOfWeek() {
        return this.dayOfWeek;
    }

    public String getYear() {
        return this.year;
    }

    public ZoneId getZone() {
        return this.zone;
    }

    public Instant getStart() {
        return this.start;
    }

    public Instant getEnd() {
        return this.end;
    }
}

