/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.timerservice.spi;

import javax.ejb.Timer;
import org.jboss.as.ejb3.component.allowedmethods.AllowedMethodsInformation;
import org.jboss.as.ejb3.component.allowedmethods.MethodType;
import org.jboss.as.ejb3.logging.EjbLogger;

public interface ManagedTimer
extends Timer {
    public String getId();

    public boolean isActive();

    public boolean isCanceled();

    public boolean isExpired();

    public void activate();

    public void suspend();

    public void invoke() throws Exception;

    default public void validateInvocationContext() {
        if (this.isCanceled()) {
            throw EjbLogger.EJB3_TIMER_LOGGER.timerWasCanceled(this.getId());
        }
        if (this.isExpired()) {
            throw EjbLogger.EJB3_TIMER_LOGGER.timerHasExpired(this.getId());
        }
        AllowedMethodsInformation.checkAllowed(MethodType.TIMER_SERVICE_METHOD);
    }
}

