/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.timerservice.spi;

import java.io.Serializable;
import java.util.Date;
import javax.ejb.EJBException;
import javax.ejb.ScheduleExpression;
import javax.ejb.Timer;
import javax.ejb.TimerConfig;
import javax.ejb.TimerService;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.jboss.as.ejb3.component.allowedmethods.AllowedMethodsInformation;
import org.jboss.as.ejb3.component.allowedmethods.MethodType;
import org.jboss.as.ejb3.component.stateful.CurrentSynchronizationCallback;
import org.jboss.as.ejb3.context.CurrentInvocationContext;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.timerservice.spi.ManagedTimer;
import org.jboss.as.ejb3.timerservice.spi.TimedObjectInvoker;
import org.jboss.invocation.InterceptorContext;
import org.wildfly.clustering.ee.Restartable;
import org.wildfly.transaction.client.AbstractTransaction;
import org.wildfly.transaction.client.ContextTransactionManager;

public interface ManagedTimerService
extends TimerService,
Restartable {
    public ManagedTimer findTimer(String var1);

    public TimedObjectInvoker getInvoker();

    default public Timer createCalendarTimer(ScheduleExpression schedule) {
        return this.createCalendarTimer(schedule, new TimerConfig());
    }

    default public Timer createIntervalTimer(long initialDuration, long intervalDuration, TimerConfig config) {
        if (initialDuration < 0L) {
            throw EjbLogger.EJB3_TIMER_LOGGER.invalidTimerParameter("initialDuration", Long.toString(initialDuration));
        }
        return this.createIntervalTimer(new Date(System.currentTimeMillis() + initialDuration), intervalDuration, config);
    }

    default public Timer createSingleActionTimer(long duration, TimerConfig config) {
        if (duration < 0L) {
            throw EjbLogger.EJB3_TIMER_LOGGER.invalidTimerParameter("duration", Long.toString(duration));
        }
        return this.createSingleActionTimer(new Date(System.currentTimeMillis() + duration), config);
    }

    default public Timer createTimer(long duration, Serializable info) throws EJBException {
        if (duration < 0L) {
            throw EjbLogger.EJB3_TIMER_LOGGER.invalidTimerParameter("duration", Long.toString(duration));
        }
        return this.createTimer(new Date(System.currentTimeMillis() + duration), info);
    }

    default public Timer createTimer(long initialDuration, long intervalDuration, Serializable info) {
        if (initialDuration < 0L) {
            throw EjbLogger.EJB3_TIMER_LOGGER.invalidTimerParameter("initialDuration", Long.toString(initialDuration));
        }
        return this.createTimer(new Date(System.currentTimeMillis() + initialDuration), intervalDuration, info);
    }

    default public Timer createTimer(Date expiration, Serializable info) {
        return this.createSingleActionTimer(expiration, new TimerConfig(info, true));
    }

    default public Timer createTimer(Date initialExpiration, long intervalDuration, Serializable info) {
        return this.createIntervalTimer(initialExpiration, intervalDuration, new TimerConfig(info, true));
    }

    default public void validateInvocationContext() {
        AllowedMethodsInformation.checkAllowed(MethodType.TIMER_SERVICE_METHOD);
        if (!this.getInvoker().getComponent().getComponentDescription().isSingleton() && ManagedTimerService.isLifecycleCallbackInvocation()) {
            throw EjbLogger.EJB3_TIMER_LOGGER.failToInvokeTimerServiceDoLifecycle();
        }
    }

    public static Transaction getActiveTransaction() {
        AbstractTransaction tx = ContextTransactionManager.getInstance().getTransaction();
        if (tx == null) {
            return null;
        }
        try {
            int status = tx.getStatus();
            switch (status) {
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 9: {
                    return null;
                }
            }
            return CurrentSynchronizationCallback.get() != CurrentSynchronizationCallback.CallbackType.BEFORE_COMPLETION ? tx : null;
        }
        catch (SystemException e) {
            throw new EJBException((Exception)((Object)e));
        }
    }

    public static boolean isLifecycleCallbackInvocation() {
        InterceptorContext currentInvocationContext = CurrentInvocationContext.get();
        return currentInvocationContext != null && currentInvocationContext.getMethod() == null;
    }
}

