/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors.merging;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ejb.Schedule;
import javax.ejb.ScheduleExpression;
import javax.ejb.TimedObject;
import javax.ejb.Timeout;
import javax.ejb.Timer;
import org.jboss.as.ee.component.EEApplicationClasses;
import org.jboss.as.ee.metadata.MethodAnnotationAggregator;
import org.jboss.as.ee.metadata.RuntimeAnnotationInformation;
import org.jboss.as.ejb3.component.EJBComponentDescription;
import org.jboss.as.ejb3.deployment.processors.dd.MethodResolutionUtils;
import org.jboss.as.ejb3.deployment.processors.merging.AbstractMergingProcessor;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.timerservice.spi.AutoTimer;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.reflect.ClassReflectionIndex;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.metadata.ejb.common.IScheduleTarget;
import org.jboss.metadata.ejb.common.ITimeoutTarget;
import org.jboss.metadata.ejb.spec.EnterpriseBeanMetaData;
import org.jboss.metadata.ejb.spec.NamedMethodMetaData;
import org.jboss.metadata.ejb.spec.ScheduleMetaData;
import org.jboss.metadata.ejb.spec.TimerMetaData;

public class TimerMethodMergingProcessor
extends AbstractMergingProcessor<EJBComponentDescription> {
    public TimerMethodMergingProcessor() {
        super(EJBComponentDescription.class);
    }

    @Override
    protected void handleAnnotations(DeploymentUnit deploymentUnit, EEApplicationClasses applicationClasses, DeploymentReflectionIndex deploymentReflectionIndex, Class<?> componentClass, EJBComponentDescription description) throws DeploymentUnitProcessingException {
        RuntimeAnnotationInformation scheduleAnnotationData = MethodAnnotationAggregator.runtimeAnnotationInformation(componentClass, (EEApplicationClasses)applicationClasses, (DeploymentReflectionIndex)deploymentReflectionIndex, Schedule.class);
        Set timerAnnotationData = MethodAnnotationAggregator.runtimeAnnotationPresent(componentClass, (EEApplicationClasses)applicationClasses, (DeploymentReflectionIndex)deploymentReflectionIndex, Timeout.class);
        if (timerAnnotationData.size() > 1) {
            throw EjbLogger.ROOT_LOGGER.componentClassHasMultipleTimeoutAnnotations(componentClass);
        }
        Method timeoutMethod = timerAnnotationData.size() == 1 ? (Method)timerAnnotationData.iterator().next() : null;
        description.setTimeoutMethod(timeoutMethod);
        for (Map.Entry entry : scheduleAnnotationData.getMethodAnnotations().entrySet()) {
            for (AutoTimer timer : (List)entry.getValue()) {
                description.addScheduleMethod((Method)entry.getKey(), timer);
            }
        }
    }

    @Override
    protected void handleDeploymentDescriptor(DeploymentUnit deploymentUnit, DeploymentReflectionIndex deploymentReflectionIndex, Class<?> componentClass, EJBComponentDescription description) throws DeploymentUnitProcessingException {
        EnterpriseBeanMetaData descriptorData = description.getDescriptorData();
        if (descriptorData != null && (description.isSession() || description.isMessageDriven())) {
            assert (descriptorData instanceof ITimeoutTarget) : descriptorData + " is not an ITimeoutTarget";
            ITimeoutTarget target = (ITimeoutTarget)descriptorData;
            if (target.getTimeoutMethod() != null) {
                this.parseTimeoutMethod(target, description, componentClass, deploymentReflectionIndex);
            }
            this.parseScheduleMethods(descriptorData, description, componentClass, deploymentReflectionIndex);
        }
        if (TimedObject.class.isAssignableFrom(componentClass)) {
            for (Class<?> c = componentClass; c != null && c != Object.class; c = c.getSuperclass()) {
                ClassReflectionIndex index = deploymentReflectionIndex.getClassIndex(c);
                Method method = index.getMethod(Void.TYPE, "ejbTimeout", new Class[]{Timer.class});
                if (method == null) continue;
                Method otherMethod = description.getTimeoutMethod();
                if (otherMethod != null && !otherMethod.equals(method)) {
                    throw EjbLogger.ROOT_LOGGER.invalidEjbEntityTimeout("3.1 18.2.5.3", componentClass);
                }
                description.setTimeoutMethod(method);
                break;
            }
        }
    }

    private void parseScheduleMethods(EnterpriseBeanMetaData beanMetaData, EJBComponentDescription sessionBean, Class<?> componentClass, DeploymentReflectionIndex deploymentReflectionIndex) throws DeploymentUnitProcessingException {
        IScheduleTarget md;
        if (beanMetaData instanceof IScheduleTarget && (md = (IScheduleTarget)beanMetaData).getTimers() != null) {
            for (TimerMetaData timer : md.getTimers()) {
                AutoTimer autoTimer = new AutoTimer();
                autoTimer.getTimerConfig().setInfo((Serializable)((Object)timer.getInfo()));
                autoTimer.getTimerConfig().setPersistent(timer.isPersistent());
                ScheduleExpression scheduleExpression = autoTimer.getScheduleExpression();
                ScheduleMetaData schedule = timer.getSchedule();
                if (schedule != null) {
                    scheduleExpression.dayOfMonth(schedule.getDayOfMonth());
                    scheduleExpression.dayOfWeek(schedule.getDayOfWeek());
                    scheduleExpression.hour(schedule.getHour());
                    scheduleExpression.minute(schedule.getMinute());
                    scheduleExpression.month(schedule.getMonth());
                    scheduleExpression.second(schedule.getSecond());
                    scheduleExpression.year(schedule.getYear());
                }
                if (timer.getEnd() != null) {
                    scheduleExpression.end(timer.getEnd().getTime());
                }
                if (timer.getStart() != null) {
                    scheduleExpression.start(timer.getStart().getTime());
                }
                scheduleExpression.timezone(timer.getTimezone());
                sessionBean.addScheduleMethod(MethodResolutionUtils.resolveMethod(timer.getTimeoutMethod(), componentClass, deploymentReflectionIndex), autoTimer);
            }
        }
    }

    private void parseTimeoutMethod(ITimeoutTarget beanMetaData, EJBComponentDescription sessionBean, Class<?> componentClass, DeploymentReflectionIndex deploymentReflectionIndex) throws DeploymentUnitProcessingException {
        NamedMethodMetaData methodData = beanMetaData.getTimeoutMethod();
        sessionBean.setTimeoutMethod(MethodResolutionUtils.resolveMethod(methodData, componentClass, deploymentReflectionIndex));
    }
}

