/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors;

import jakarta.ejb.TimerConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jboss.as.controller.RequirementServiceTarget;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ComponentConfigurator;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.DependencyConfigurator;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ejb3.component.EJBComponent;
import org.jboss.as.ejb3.component.EJBComponentCreateService;
import org.jboss.as.ejb3.component.EJBComponentDescription;
import org.jboss.as.ejb3.deployment.EjbDeploymentAttachmentKeys;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.subsystem.deployment.TimerServiceResource;
import org.jboss.as.ejb3.timerservice.NonFunctionalTimerServiceFactoryServiceConfigurator;
import org.jboss.as.ejb3.timerservice.TimedObjectInvokerFactoryImpl;
import org.jboss.as.ejb3.timerservice.TimerServiceFactoryServiceConfigurator;
import org.jboss.as.ejb3.timerservice.TimerServiceMetaData;
import org.jboss.as.ejb3.timerservice.TimerServiceRegistryImpl;
import org.jboss.as.ejb3.timerservice.composite.CompositeTimerServiceFactoryServiceConfigurator;
import org.jboss.as.ejb3.timerservice.distributable.DistributableTimeoutListener;
import org.jboss.as.ejb3.timerservice.distributable.DistributableTimerService;
import org.jboss.as.ejb3.timerservice.distributable.DistributableTimerServiceConfiguration;
import org.jboss.as.ejb3.timerservice.distributable.DistributableTimerSynchronizationFactory;
import org.jboss.as.ejb3.timerservice.distributable.TimerSynchronizationFactory;
import org.jboss.as.ejb3.timerservice.spi.ManagedTimerService;
import org.jboss.as.ejb3.timerservice.spi.ManagedTimerServiceConfiguration;
import org.jboss.as.ejb3.timerservice.spi.ManagedTimerServiceFactory;
import org.jboss.as.ejb3.timerservice.spi.ManagedTimerServiceFactoryConfiguration;
import org.jboss.as.ejb3.timerservice.spi.TimedObjectInvoker;
import org.jboss.as.ejb3.timerservice.spi.TimedObjectInvokerFactory;
import org.jboss.as.ejb3.timerservice.spi.TimerListener;
import org.jboss.as.ejb3.timerservice.spi.TimerServiceRegistry;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.EjbDeploymentMarker;
import org.jboss.metadata.ejb.spec.EjbJarMetaData;
import org.jboss.modules.Module;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.ejb.timer.TimeoutListener;
import org.wildfly.clustering.ejb.timer.TimerManagementProvider;
import org.wildfly.clustering.ejb.timer.TimerManager;
import org.wildfly.clustering.ejb.timer.TimerManagerConfiguration;
import org.wildfly.clustering.ejb.timer.TimerManagerFactory;
import org.wildfly.clustering.ejb.timer.TimerManagerFactoryConfiguration;
import org.wildfly.clustering.ejb.timer.TimerRegistry;
import org.wildfly.clustering.ejb.timer.TimerServiceConfiguration;
import org.wildfly.clustering.server.util.UUIDFactory;
import org.wildfly.service.descriptor.UnaryServiceDescriptor;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.ServiceInstaller;

public class TimerServiceDeploymentProcessor
implements DeploymentUnitProcessor {
    private final String threadPoolName;
    private final TimerServiceMetaData defaultMetaData;

    public TimerServiceDeploymentProcessor(String threadPoolName, TimerServiceMetaData defaultMetaData) {
        this.threadPoolName = threadPoolName;
        this.defaultMetaData = defaultMetaData;
    }

    public void deploy(final DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        List timerService;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (!EjbDeploymentMarker.isEjbDeployment((DeploymentUnit)deploymentUnit)) {
            return;
        }
        EEModuleDescription moduleDescription = (EEModuleDescription)deploymentUnit.getAttachment(org.jboss.as.ee.component.Attachments.EE_MODULE_DESCRIPTION);
        Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
        EjbJarMetaData ejbJarMetaData = (EjbJarMetaData)deploymentUnit.getAttachment(EjbDeploymentAttachmentKeys.EJB_JAR_METADATA);
        final CapabilityServiceSupport capabilityServiceSupport = (CapabilityServiceSupport)deploymentUnit.getAttachment(Attachments.CAPABILITY_SERVICE_SUPPORT);
        final TimerServiceRegistryImpl timerServiceRegistry = new TimerServiceRegistryImpl();
        final HashMap<String, TimerServiceMetaData> timerServiceMetaData = new HashMap<String, TimerServiceMetaData>();
        timerServiceMetaData.put(null, this.defaultMetaData);
        if (ejbJarMetaData != null && ejbJarMetaData.getAssemblyDescriptor() != null && (timerService = ejbJarMetaData.getAssemblyDescriptor().getAny(TimerServiceMetaData.class)) != null) {
            for (TimerServiceMetaData metaData : timerService) {
                if (metaData.getDataStoreName() == null && metaData.getPersistentTimerManagementProvider() == null) {
                    metaData.setDataStoreName(this.defaultMetaData.getDataStoreName());
                    metaData.setPersistentTimerManagementProvider(this.defaultMetaData.getPersistentTimerManagementProvider());
                }
                if (metaData.getTransientTimerManagementProvider() == null) {
                    metaData.setTransientTimerManagementProvider(this.defaultMetaData.getTransientTimerManagementProvider());
                }
                String name = metaData.getEjbName().equals("*") ? null : metaData.getEjbName();
                timerServiceMetaData.put(name, metaData);
            }
        }
        final String threadPoolName = this.threadPoolName;
        final TimerServiceMetaData defaultMetaData = (TimerServiceMetaData)((Object)timerServiceMetaData.get(null));
        StringBuilder deploymentNameBuilder = new StringBuilder();
        deploymentNameBuilder.append(moduleDescription.getApplicationName()).append('.').append(moduleDescription.getModuleName());
        String distinctName = moduleDescription.getDistinctName();
        if (distinctName != null && !distinctName.isEmpty()) {
            deploymentNameBuilder.append('.').append(distinctName);
        }
        String deploymentName = deploymentNameBuilder.toString();
        final TimedObjectInvokerFactoryImpl invokerFactory = new TimedObjectInvokerFactoryImpl(module, deploymentName);
        for (final ComponentDescription componentDescription : moduleDescription.getComponentDescriptions()) {
            if (!componentDescription.isTimerServiceApplicable()) continue;
            final ServiceName serviceName = componentDescription.getServiceName().append(new String[]{"timer-service-factory"});
            componentDescription.getConfigurators().add(new ComponentConfigurator(){

                public void configure(DeploymentPhaseContext context, ComponentDescription description, ComponentConfiguration configuration) {
                    EjbLogger.ROOT_LOGGER.debugf("Installing timer service factory for component %s", componentDescription.getComponentName());
                    EJBComponentDescription ejbComponentDescription = (EJBComponentDescription)description;
                    ServiceTarget target = context.getServiceTarget();
                    final TimerServiceResource resource = new TimerServiceResource();
                    ManagedTimerServiceFactoryConfiguration factoryConfiguration = new ManagedTimerServiceFactoryConfiguration(){

                        @Override
                        public TimerServiceRegistry getTimerServiceRegistry() {
                            return timerServiceRegistry;
                        }

                        @Override
                        public TimerListener getTimerListener() {
                            return resource;
                        }

                        @Override
                        public TimedObjectInvokerFactory getInvokerFactory() {
                            return invokerFactory;
                        }
                    };
                    if (componentDescription.isTimerServiceRequired()) {
                        ejbComponentDescription.setTimerServiceResource((Resource)resource);
                        TimerServiceMetaData componentMetaData = timerServiceMetaData.getOrDefault(ejbComponentDescription.getEJBName(), defaultMetaData);
                        if (threadPoolName != null && componentMetaData.getDataStoreName() != null) {
                            new TimerServiceFactoryServiceConfigurator(serviceName, factoryConfiguration, threadPoolName, componentMetaData.getDataStoreName()).configure(capabilityServiceSupport).build(target).install();
                        } else {
                            ServiceName transientServiceName = ManagedTimerServiceConfiguration.TimerFilter.TRANSIENT.apply(serviceName);
                            ServiceName persistentServiceName = ManagedTimerServiceConfiguration.TimerFilter.PERSISTENT.apply(serviceName);
                            if (componentMetaData.getTransientTimerManagementProvider() != null) {
                                TimerServiceDeploymentProcessor.installDistributableTimerServiceFactory(phaseContext, transientServiceName, componentMetaData.getTransientTimerManagementProvider(), factoryConfiguration, componentDescription, ManagedTimerServiceConfiguration.TimerFilter.TRANSIENT);
                            } else {
                                new TimerServiceFactoryServiceConfigurator(transientServiceName, factoryConfiguration, threadPoolName, null).filter(ManagedTimerServiceConfiguration.TimerFilter.TRANSIENT).configure(capabilityServiceSupport).build(target).install();
                            }
                            TimerServiceDeploymentProcessor.installDistributableTimerServiceFactory(phaseContext, persistentServiceName, componentMetaData.getPersistentTimerManagementProvider(), factoryConfiguration, componentDescription, ManagedTimerServiceConfiguration.TimerFilter.PERSISTENT);
                            new CompositeTimerServiceFactoryServiceConfigurator(serviceName, factoryConfiguration).build(target).install();
                        }
                    } else {
                        String message = ejbComponentDescription.isStateful() ? EjbLogger.ROOT_LOGGER.timerServiceMethodNotAllowedForSFSB(ejbComponentDescription.getComponentName()) : EjbLogger.ROOT_LOGGER.ejbHasNoTimerMethods();
                        new NonFunctionalTimerServiceFactoryServiceConfigurator(serviceName, message, factoryConfiguration).build(target).install();
                    }
                    configuration.getCreateDependencies().add(new DependencyConfigurator<EJBComponentCreateService>(){

                        public void configureDependency(ServiceBuilder<?> builder, EJBComponentCreateService service) {
                            builder.addDependency(serviceName, ManagedTimerServiceFactory.class, service.getTimerServiceFactoryInjector());
                        }
                    });
                }
            });
        }
    }

    static void installDistributableTimerServiceFactory(DeploymentPhaseContext context, ServiceName name, String providerName, ManagedTimerServiceFactoryConfiguration factoryConfiguration, ComponentDescription description, ManagedTimerServiceConfiguration.TimerFilter filter) {
        final DeploymentUnit unit = context.getDeploymentUnit();
        ArrayList<String> parts = new ArrayList<String>(3);
        if (unit.getParent() != null) {
            parts.add(unit.getParent().getName());
        }
        parts.add(unit.getName());
        parts.add(description.getComponentName());
        parts.add(filter.name());
        final String timerServiceName = String.join((CharSequence)".", parts);
        final TimerServiceConfiguration configuration = new TimerServiceConfiguration(){

            public String getName() {
                return timerServiceName;
            }

            public String getDeploymentName() {
                return unit.getName();
            }

            public ServiceName getDeploymentServiceName() {
                return unit.getServiceName();
            }

            public Module getModule() {
                return (Module)unit.getAttachment(Attachments.MODULE);
            }
        };
        final TimerListener timerListener = factoryConfiguration.getTimerListener();
        TimerRegistry<UUID> timerRegistry = new TimerRegistry<UUID>(){

            public void register(UUID id) {
                timerListener.timerAdded(id.toString());
            }

            public void unregister(UUID id) {
                timerListener.timerRemoved(id.toString());
            }
        };
        TimerManagerFactoryConfiguration<UUID> managerFactoryConfiguration = new TimerManagerFactoryConfiguration<UUID>((TimerRegistry)timerRegistry, filter){
            final /* synthetic */ TimerRegistry val$timerRegistry;
            final /* synthetic */ ManagedTimerServiceConfiguration.TimerFilter val$filter;
            {
                this.val$timerRegistry = timerRegistry;
                this.val$filter = timerFilter;
            }

            public Supplier<UUID> getIdentifierFactory() {
                return TimerIdentifierFactory.INSTANCE;
            }

            public TimerServiceConfiguration getTimerServiceConfiguration() {
                return configuration;
            }

            public TimerRegistry<UUID> getRegistry() {
                return this.val$timerRegistry;
            }

            public boolean isPersistent() {
                return this.val$filter.test(new TimerConfig(null, true));
            }
        };
        final ServiceName timerManagerFactoryName = ServiceName.JBOSS.append(new String[]{"clustering", "timer", timerServiceName});
        final TimedObjectInvokerFactory invokerFactory = factoryConfiguration.getInvokerFactory();
        TimerServiceRegistry registry = factoryConfiguration.getTimerServiceRegistry();
        ServiceDependency managerFactory = ServiceDependency.on((ServiceName)timerManagerFactoryName);
        ManagedTimerServiceFactory factory = new ManagedTimerServiceFactory(){
            final /* synthetic */ TimerRegistry val$timerRegistry;
            final /* synthetic */ ServiceDependency val$managerFactory;
            final /* synthetic */ TimerManagerFactoryConfiguration val$managerFactoryConfiguration;
            final /* synthetic */ TimerServiceRegistry val$registry;
            final /* synthetic */ TimerListener val$timerListener;
            final /* synthetic */ ManagedTimerServiceConfiguration.TimerFilter val$filter;
            {
                this.val$timerRegistry = timerRegistry;
                this.val$managerFactory = serviceDependency;
                this.val$managerFactoryConfiguration = timerManagerFactoryConfiguration;
                this.val$registry = timerServiceRegistry;
                this.val$timerListener = timerListener;
                this.val$filter = timerFilter;
            }

            @Override
            public ManagedTimerService createTimerService(EJBComponent component) {
                final TimedObjectInvoker invoker = invokerFactory.createInvoker(component);
                final DistributableTimerSynchronizationFactory synchronizationFactory = new DistributableTimerSynchronizationFactory(this.val$timerRegistry);
                final DistributableTimeoutListener timeoutListener = new DistributableTimeoutListener(invoker, synchronizationFactory);
                TimerManager manager = ((TimerManagerFactory)this.val$managerFactory.get()).createTimerManager((TimerManagerConfiguration)new TimerManagerConfiguration<UUID>(){

                    public TimerServiceConfiguration getTimerServiceConfiguration() {
                        return val$managerFactoryConfiguration.getTimerServiceConfiguration();
                    }

                    public Supplier<UUID> getIdentifierFactory() {
                        return val$managerFactoryConfiguration.getIdentifierFactory();
                    }

                    public TimerRegistry<UUID> getRegistry() {
                        return val$managerFactoryConfiguration.getRegistry();
                    }

                    public boolean isPersistent() {
                        return val$managerFactoryConfiguration.isPersistent();
                    }

                    public TimeoutListener<UUID> getListener() {
                        return timeoutListener;
                    }
                });
                DistributableTimerServiceConfiguration<UUID> serviceConfiguration = new DistributableTimerServiceConfiguration<UUID>(){

                    @Override
                    public TimedObjectInvoker getInvoker() {
                        return invoker;
                    }

                    @Override
                    public TimerServiceRegistry getTimerServiceRegistry() {
                        return val$registry;
                    }

                    @Override
                    public TimerListener getTimerListener() {
                        return val$timerListener;
                    }

                    @Override
                    public Function<String, UUID> getIdentifierParser() {
                        return TimerIdentifierFactory.INSTANCE;
                    }

                    @Override
                    public Predicate<TimerConfig> getTimerFilter() {
                        return val$filter;
                    }

                    @Override
                    public TimerSynchronizationFactory<UUID> getTimerSynchronizationFactory() {
                        return synchronizationFactory;
                    }
                };
                return new DistributableTimerService<UUID>(serviceConfiguration, manager);
            }
        };
        ((ServiceInstaller)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)ServiceInstaller.builder((Object)factory).provides(name)).requires((Consumer)managerFactory)).build()).install(context);
        final ServiceDependency provider = ServiceDependency.on((UnaryServiceDescriptor)TimerManagementProvider.SERVICE_DESCRIPTOR, (String)providerName);
        ServiceInstaller installer = new ServiceInstaller(){
            final /* synthetic */ TimerManagerFactoryConfiguration val$managerFactoryConfiguration;
            {
                this.val$managerFactoryConfiguration = timerManagerFactoryConfiguration;
            }

            public ServiceController<?> install(RequirementServiceTarget target) {
                for (ServiceInstaller installer : ((TimerManagementProvider)provider.get()).getTimerManagerFactoryServiceInstallers(timerManagerFactoryName, this.val$managerFactoryConfiguration)) {
                    installer.install((ServiceTarget)target);
                }
                return null;
            }
        };
        ((ServiceInstaller)((ServiceInstaller.Builder)ServiceInstaller.builder((ServiceInstaller)installer, (CapabilityServiceSupport)((CapabilityServiceSupport)unit.getAttachment(Attachments.CAPABILITY_SERVICE_SUPPORT))).requires((Consumer)provider)).build()).install(context);
    }

    static enum TimerIdentifierFactory implements Supplier<UUID>,
    Function<String, UUID>
    {
        INSTANCE;


        @Override
        public UUID get() {
            return (UUID)UUIDFactory.INSECURE.get();
        }

        @Override
        public UUID apply(String id) {
            return UUID.fromString(id);
        }
    }
}

