/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.cache.distributable;

import java.util.UUID;
import org.jboss.as.ejb3.cache.Cache;
import org.jboss.as.ejb3.cache.CacheFactory;
import org.jboss.as.ejb3.cache.Identifiable;
import org.jboss.as.ejb3.cache.StatefulObjectFactory;
import org.jboss.as.ejb3.cache.distributable.DistributableCache;
import org.jboss.as.ejb3.cache.distributable.GroupIdentifierFactory;
import org.jboss.as.ejb3.cache.distributable.RemoveListenerAdapter;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.ServerEnvironmentService;
import org.jboss.msc.service.AbstractService;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.clustering.ejb.BeanManager;
import org.wildfly.clustering.ejb.BeanManagerFactory;
import org.wildfly.clustering.ejb.IdentifierFactory;
import org.wildfly.clustering.ejb.PassivationListener;

public class DistributableCacheFactoryService<K, V extends Identifiable<K>>
extends AbstractService<CacheFactory<K, V>>
implements CacheFactory<K, V> {
    private final InjectedValue<BeanManagerFactory<UUID, K, V>> factory = new InjectedValue();
    private final InjectedValue<ServerEnvironment> environment = new InjectedValue();

    public static <K, V extends Identifiable<K>> ServiceBuilder<CacheFactory<K, V>> build(ServiceTarget target, ServiceName name, ServiceName factoryServiceName) {
        DistributableCacheFactoryService<K, V> service = new DistributableCacheFactoryService<K, V>();
        return target.addService(name, service).addDependency(factoryServiceName, BeanManagerFactory.class, service.factory).addDependency(ServerEnvironmentService.SERVICE_NAME, ServerEnvironment.class, service.environment);
    }

    private DistributableCacheFactoryService() {
    }

    public CacheFactory<K, V> getValue() {
        return this;
    }

    @Override
    public Cache<K, V> createCache(IdentifierFactory<K> identifierFactory, StatefulObjectFactory<V> factory, PassivationListener<V> passivationListener) {
        BeanManager manager = ((BeanManagerFactory)this.factory.getValue()).createBeanManager((IdentifierFactory)new GroupIdentifierFactory(), identifierFactory, passivationListener, new RemoveListenerAdapter(factory));
        return new DistributableCache(manager, factory, (ServerEnvironment)this.environment.getValue());
    }
}

