/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.singleton;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import java.util.Map;
import javax.ejb.LockType;
import org.jboss.as.ee.component.BasicComponentInstance;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ejb3.EjbLogger;
import org.jboss.as.ejb3.EjbMessages;
import org.jboss.as.ejb3.component.DefaultAccessTimeoutService;
import org.jboss.as.ejb3.component.EJBBusinessMethod;
import org.jboss.as.ejb3.component.allowedmethods.AllowedMethodsInformation;
import org.jboss.as.ejb3.component.session.SessionBeanComponent;
import org.jboss.as.ejb3.component.singleton.SingletonAllowedMethodsInformation;
import org.jboss.as.ejb3.component.singleton.SingletonComponentCreateService;
import org.jboss.as.ejb3.component.singleton.SingletonComponentInstance;
import org.jboss.as.ejb3.concurrency.AccessTimeoutDetails;
import org.jboss.as.ejb3.concurrency.LockableComponent;
import org.jboss.as.server.CurrentServiceContainer;
import org.jboss.invocation.Interceptor;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;

public class SingletonComponent
extends SessionBeanComponent
implements LockableComponent {
    private volatile SingletonComponentInstance singletonComponentInstance;
    private final boolean initOnStartup;
    private final Map<String, LockType> beanLevelLockType;
    private final Map<EJBBusinessMethod, LockType> methodLockTypes;
    private final Map<EJBBusinessMethod, AccessTimeoutDetails> methodAccessTimeouts;
    private final List<ServiceName> dependsOn;
    private final DefaultAccessTimeoutService defaultAccessTimeoutProvider;
    private final Object creationLock = new Object();

    public SingletonComponent(SingletonComponentCreateService singletonComponentCreateService, List<ServiceName> dependsOn) {
        super(singletonComponentCreateService);
        this.dependsOn = dependsOn;
        this.initOnStartup = singletonComponentCreateService.isInitOnStartup();
        this.beanLevelLockType = singletonComponentCreateService.getBeanLockType();
        this.methodLockTypes = singletonComponentCreateService.getMethodApplicableLockTypes();
        this.methodAccessTimeouts = singletonComponentCreateService.getMethodApplicableAccessTimeouts();
        this.defaultAccessTimeoutProvider = singletonComponentCreateService.getDefaultAccessTimeoutService();
    }

    protected BasicComponentInstance instantiateComponentInstance(Interceptor preDestroyInterceptor, Map<Method, Interceptor> methodInterceptors, Map<Object, Object> context) {
        assert (Thread.holdsLock(this.creationLock));
        if (this.dependsOn != null) {
            for (ServiceName serviceName : this.dependsOn) {
                ServiceController service = SingletonComponent.currentServiceContainer().getRequiredService(serviceName);
                Component component = (Component)service.getValue();
                if (!(component instanceof SingletonComponent)) continue;
                ((SingletonComponent)component).getComponentInstance();
            }
        }
        return new SingletonComponentInstance(this, preDestroyInterceptor, methodInterceptors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SingletonComponentInstance getComponentInstance() {
        if (this.singletonComponentInstance == null) {
            if (Thread.holdsLock(this.creationLock)) {
                throw EjbMessages.MESSAGES.reentrantSingletonCreation(this.getComponentName(), this.getComponentClass().getName());
            }
            Object object = this.creationLock;
            synchronized (object) {
                if (this.singletonComponentInstance == null) {
                    this.singletonComponentInstance = (SingletonComponentInstance)this.createInstance();
                }
            }
        }
        return this.singletonComponentInstance;
    }

    @Override
    public void start() {
        this.getShutDownInterceptorFactory().start();
        super.start();
        if (this.initOnStartup) {
            EjbLogger.ROOT_LOGGER.debug(this.getComponentName() + " bean is a @Startup (a.k.a init-on-startup) bean, creating/getting the singleton instance");
            this.getComponentInstance();
        }
    }

    @Override
    public void stop() {
        this.getShutDownInterceptorFactory().shutdown();
        this.destroySingletonInstance();
        super.stop();
    }

    @Override
    public LockType getLockType(Method method) {
        EJBBusinessMethod ejbMethod = new EJBBusinessMethod(method);
        LockType lockType = this.methodLockTypes.get(ejbMethod);
        if (lockType != null) {
            return lockType;
        }
        LockType type = this.beanLevelLockType.get(method.getDeclaringClass().getName());
        if (type != null) {
            return type;
        }
        return LockType.WRITE;
    }

    @Override
    public AccessTimeoutDetails getAccessTimeout(Method method) {
        EJBBusinessMethod ejbMethod = new EJBBusinessMethod(method);
        AccessTimeoutDetails accessTimeout = this.methodAccessTimeouts.get(ejbMethod);
        if (accessTimeout != null) {
            return accessTimeout;
        }
        AccessTimeoutDetails beanTimeout = (AccessTimeoutDetails)this.beanLevelAccessTimeout.get(method.getDeclaringClass().getName());
        if (beanTimeout != null) {
            return beanTimeout;
        }
        return this.getDefaultAccessTimeout();
    }

    @Override
    public AccessTimeoutDetails getDefaultAccessTimeout() {
        return this.defaultAccessTimeoutProvider.getDefaultAccessTimeout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroySingletonInstance() {
        Object object = this.creationLock;
        synchronized (object) {
            if (this.singletonComponentInstance != null) {
                this.singletonComponentInstance.destroy();
                this.singletonComponentInstance = null;
            }
        }
    }

    @Override
    public AllowedMethodsInformation getAllowedMethodsInformation() {
        return this.isBeanManagedTransaction() ? SingletonAllowedMethodsInformation.INSTANCE_BMT : SingletonAllowedMethodsInformation.INSTANCE_CMT;
    }

    private static ServiceContainer currentServiceContainer() {
        return AccessController.doPrivileged(new PrivilegedAction<ServiceContainer>(){

            @Override
            public ServiceContainer run() {
                return CurrentServiceContainer.getServiceContainer();
            }
        });
    }
}

