/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.remote;

import org.jboss.as.ejb3.EjbMessages;
import org.jboss.as.ejb3.remote.TCCLEJBClientContextSelectorService;
import org.jboss.ejb.client.ContextSelector;
import org.jboss.ejb.client.EJBClientContext;
import org.jboss.ejb.client.EJBClientContextIdentifier;
import org.jboss.ejb.client.IdentityEJBClientContextSelector;
import org.jboss.logging.Logger;
import org.wildfly.security.manager.WildFlySecurityManager;

class DefaultEJBClientContextSelector
implements ContextSelector<EJBClientContext>,
IdentityEJBClientContextSelector {
    private static final Logger logger = Logger.getLogger(DefaultEJBClientContextSelector.class);
    static final DefaultEJBClientContextSelector INSTANCE = new DefaultEJBClientContextSelector();
    private volatile TCCLEJBClientContextSelectorService tcclEJBClientContextService;
    private volatile EJBClientContext defaultEJBClientContext;

    DefaultEJBClientContextSelector() {
    }

    void setup(TCCLEJBClientContextSelectorService clientContextService, EJBClientContext defaultEJBClientContext) {
        this.tcclEJBClientContextService = clientContextService;
        this.defaultEJBClientContext = defaultEJBClientContext;
    }

    void destroy() {
        this.tcclEJBClientContextService = null;
        this.defaultEJBClientContext = null;
    }

    public EJBClientContext getCurrent() {
        if (this.tcclEJBClientContextService == null) {
            return null;
        }
        EJBClientContext ejbClientContext = this.tcclEJBClientContextService.getCurrent();
        if (ejbClientContext != null) {
            return ejbClientContext;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Returning default EJB client context " + this.defaultEJBClientContext + " since no EJB client context could be found for TCCL " + WildFlySecurityManager.getCurrentContextClassLoaderPrivileged()));
        }
        return this.defaultEJBClientContext;
    }

    public void registerContext(EJBClientContextIdentifier identifier, EJBClientContext context) {
        if (this.tcclEJBClientContextService == null) {
            throw EjbMessages.MESSAGES.ejbClientContextSelectorUnableToFunctionDueToMissingService(TCCLEJBClientContextSelectorService.TCCL_BASED_EJB_CLIENT_CONTEXT_SELECTOR_SERVICE_NAME);
        }
        this.tcclEJBClientContextService.registerContext(identifier, context);
    }

    public EJBClientContext unRegisterContext(EJBClientContextIdentifier identifier) {
        if (this.tcclEJBClientContextService == null) {
            throw EjbMessages.MESSAGES.ejbClientContextSelectorUnableToFunctionDueToMissingService(TCCLEJBClientContextSelectorService.TCCL_BASED_EJB_CLIENT_CONTEXT_SELECTOR_SERVICE_NAME);
        }
        return this.tcclEJBClientContextService.unRegisterContext(identifier);
    }

    public EJBClientContext getContext(EJBClientContextIdentifier identifier) {
        if (this.tcclEJBClientContextService == null) {
            throw EjbMessages.MESSAGES.ejbClientContextSelectorUnableToFunctionDueToMissingService(TCCLEJBClientContextSelectorService.TCCL_BASED_EJB_CLIENT_CONTEXT_SELECTOR_SERVICE_NAME);
        }
        return this.tcclEJBClientContextService.getContext(identifier);
    }
}

