/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.security.service;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import org.jboss.as.ejb3.security.EJBMethodSecurityAttribute;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

public class EJBViewMethodSecurityAttributesService
implements Service<EJBViewMethodSecurityAttributesService> {
    private static final ServiceName BASE_SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"ejb"}).append(new String[]{"view-method-security-attributes"});
    private final String viewClassName;
    private final Map<Method, EJBMethodSecurityAttribute> methodSecurityAttributes;

    public EJBViewMethodSecurityAttributesService(String viewClassName, Map<Method, EJBMethodSecurityAttribute> securityAttributes) {
        this.viewClassName = viewClassName;
        this.methodSecurityAttributes = Collections.unmodifiableMap(new HashMap<Method, EJBMethodSecurityAttribute>(securityAttributes));
    }

    public void start(StartContext startContext) throws StartException {
    }

    public void stop(StopContext stopContext) {
    }

    public EJBViewMethodSecurityAttributesService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public EJBMethodSecurityAttribute getSecurityAttributes(Method viewMethod) {
        return this.methodSecurityAttributes.get(viewMethod);
    }

    public static ServiceName getServiceName(String appName, String moduleName, String beanName, String viewClassName) {
        ServiceName serviceName = appName != null ? BASE_SERVICE_NAME.append(new String[]{appName}) : BASE_SERVICE_NAME;
        return serviceName.append(new String[]{moduleName}).append(new String[]{beanName}).append(new String[]{viewClassName});
    }

    public static class Builder {
        private final String viewClassName;
        private final Map<Method, EJBMethodSecurityAttribute> methodSecurityAttributes = new IdentityHashMap<Method, EJBMethodSecurityAttribute>();

        public Builder(String viewClassName) {
            this.viewClassName = viewClassName;
        }

        public void addMethodSecurityMetadata(Method viewMethod, EJBMethodSecurityAttribute securityAttribute) {
            this.methodSecurityAttributes.put(viewMethod, securityAttribute);
        }

        public EJBViewMethodSecurityAttributesService build() {
            return new EJBViewMethodSecurityAttributesService(this.viewClassName, this.methodSecurityAttributes);
        }
    }
}

