/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.pool;

import java.rmi.RemoteException;
import javax.ejb.ConcurrentAccessException;
import javax.ejb.ConcurrentAccessTimeoutException;
import org.jboss.as.ee.component.ComponentInstance;
import org.jboss.as.ejb3.component.EJBComponent;
import org.jboss.as.ejb3.component.interceptors.AbstractEJBInterceptor;
import org.jboss.as.ejb3.component.pool.PooledComponent;
import org.jboss.invocation.InterceptorContext;

public class PooledInstanceInterceptor
extends AbstractEJBInterceptor {
    public static final PooledInstanceInterceptor INSTANCE = new PooledInstanceInterceptor();

    private PooledInstanceInterceptor() {
    }

    public Object processInvocation(InterceptorContext context) throws Exception {
        PooledComponent component = (PooledComponent)((Object)PooledInstanceInterceptor.getComponent(context, EJBComponent.class));
        ComponentInstance instance = (ComponentInstance)component.getPool().get();
        context.putPrivateData(ComponentInstance.class, (Object)instance);
        boolean discarded = false;
        try {
            Object object = context.proceed();
            return object;
        }
        catch (Exception ex) {
            EJBComponent ejbComponent = (EJBComponent)((Object)component);
            if (ejbComponent.getApplicationException(ex.getClass(), context.getMethod()) != null) {
                throw ex;
            }
            if (ex instanceof ConcurrentAccessTimeoutException || ex instanceof ConcurrentAccessException) {
                throw ex;
            }
            if (ex instanceof RuntimeException || ex instanceof RemoteException) {
                discarded = true;
                component.getPool().discard(instance);
            }
            throw ex;
        }
        catch (Error e) {
            discarded = true;
            component.getPool().discard(instance);
            throw e;
        }
        catch (Throwable t) {
            discarded = true;
            component.getPool().discard(instance);
            throw new RuntimeException(t);
        }
        finally {
            if (!discarded) {
                component.getPool().release(instance);
            }
        }
    }
}

