/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors;

import java.util.ArrayList;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.EEModuleConfiguration;
import org.jboss.as.ejb3.component.EJBComponentDescription;
import org.jboss.as.ejb3.deployment.EjbDeploymentAttachmentKeys;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.subsystem.EJB3SubsystemModel;
import org.jboss.as.ejb3.subsystem.deployment.AbstractEJBComponentRuntimeHandler;
import org.jboss.as.ejb3.subsystem.deployment.EJBComponentType;
import org.jboss.as.ejb3.subsystem.deployment.InstalledComponent;
import org.jboss.as.ejb3.subsystem.deployment.TimerServiceResource;
import org.jboss.as.ejb3.timerservice.TimerServiceImpl;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;

public class EjbManagementDeploymentUnitProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        EEModuleConfiguration moduleDescription = (EEModuleConfiguration)deploymentUnit.getAttachment(Attachments.EE_MODULE_CONFIGURATION);
        if (moduleDescription == null) {
            return;
        }
        if (deploymentUnit.getParent() != null && deploymentUnit.getParent().getParent() != null) {
            return;
        }
        for (ComponentConfiguration configuration : moduleDescription.getComponentConfigurations()) {
            try {
                ComponentDescription componentDescription = configuration.getComponentDescription();
                if (!(componentDescription instanceof EJBComponentDescription)) continue;
                this.installManagementResource(configuration, deploymentUnit);
            }
            catch (RuntimeException e) {
                throw EjbLogger.ROOT_LOGGER.failedToInstallManagementResource(e, configuration.getComponentName());
            }
        }
    }

    public void undeploy(DeploymentUnit deploymentUnit) {
        if (deploymentUnit.getParent() != null && deploymentUnit.getParent().getParent() != null) {
            return;
        }
        for (InstalledComponent configuration : deploymentUnit.getAttachmentList(EjbDeploymentAttachmentKeys.MANAGED_COMPONENTS)) {
            try {
                this.uninstallManagementResource(configuration);
            }
            catch (RuntimeException e) {
                EjbLogger.ROOT_LOGGER.failedToRemoveManagementResources(configuration, e.getLocalizedMessage());
            }
        }
    }

    private void installManagementResource(ComponentConfiguration configuration, DeploymentUnit deploymentUnit) {
        EJBComponentType type = EJBComponentType.getComponentType(configuration);
        PathAddress addr = EjbManagementDeploymentUnitProcessor.getComponentAddress(type, configuration, deploymentUnit);
        AbstractEJBComponentRuntimeHandler<?> handler = type.getRuntimeHandler();
        handler.registerComponent(addr, configuration.getComponentDescription().getStartServiceName());
        deploymentUnit.addToAttachmentList(EjbDeploymentAttachmentKeys.MANAGED_COMPONENTS, (Object)new InstalledComponent(type, addr));
        deploymentUnit.createDeploymentSubModel("ejb3", addr.getLastElement());
        EJBComponentDescription description = (EJBComponentDescription)configuration.getComponentDescription();
        if (description.isTimerServiceRequired()) {
            PathAddress timerServiceAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{addr.getLastElement(), EJB3SubsystemModel.TIMER_SERVICE_PATH});
            TimerServiceResource timerServiceResource = ((TimerServiceImpl)description.getTimerService()).getResource();
            deploymentUnit.createDeploymentSubModel("ejb3", timerServiceAddress, (Resource)timerServiceResource);
        }
    }

    private void uninstallManagementResource(InstalledComponent component) {
        component.getType().getRuntimeHandler().unregisterComponent(component.getAddress());
    }

    private static PathAddress getComponentAddress(EJBComponentType type, ComponentConfiguration configuration, DeploymentUnit deploymentUnit) {
        ArrayList<PathElement> elements = new ArrayList<PathElement>();
        if (deploymentUnit.getParent() == null) {
            elements.add(PathElement.pathElement((String)"deployment", (String)deploymentUnit.getName()));
        } else {
            elements.add(PathElement.pathElement((String)"deployment", (String)deploymentUnit.getParent().getName()));
            elements.add(PathElement.pathElement((String)"subdeployment", (String)deploymentUnit.getName()));
        }
        elements.add(PathElement.pathElement((String)"subsystem", (String)"ejb3"));
        elements.add(PathElement.pathElement((String)type.getResourceType(), (String)configuration.getComponentName()));
        return PathAddress.pathAddress(elements);
    }
}

