/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.remote.protocol.versiontwo;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.concurrent.ExecutorService;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import org.jboss.as.ejb3.deployment.DeploymentRepository;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.remote.RemoteAsyncInvocationCancelStatusService;
import org.jboss.as.ejb3.remote.protocol.versionone.MethodInvocationMessageHandler;
import org.jboss.ejb.client.annotation.CompressionHint;
import org.jboss.marshalling.MarshallerFactory;
import org.jboss.remoting3.MessageOutputStream;

public class CompressedMethodInvocationMessageHandler
extends MethodInvocationMessageHandler {
    private static final byte HEADER_COMPRESSED_MESSAGE = 27;

    CompressedMethodInvocationMessageHandler(DeploymentRepository deploymentRepository, MarshallerFactory marshallerFactory, ExecutorService executorService, RemoteAsyncInvocationCancelStatusService asyncInvocationCancelStatus) {
        super(deploymentRepository, marshallerFactory, executorService, asyncInvocationCancelStatus);
    }

    @Override
    protected DataOutputStream wrapMessageOutputStream(MessageOutputStream messageOutputStream, Method invokedMethod) throws IOException {
        CompressionHint compressionHint = invokedMethod.getAnnotation(CompressionHint.class);
        if (compressionHint == null) {
            compressionHint = invokedMethod.getDeclaringClass().getAnnotation(CompressionHint.class);
        }
        if (compressionHint != null && compressionHint.compressResponse()) {
            int compressionLevel = compressionHint.compressionLevel();
            messageOutputStream.write(27);
            Deflater deflater = new Deflater(compressionLevel);
            DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream((OutputStream)messageOutputStream, deflater);
            if (EjbLogger.EJB3_INVOCATION_LOGGER.isTraceEnabled()) {
                EjbLogger.EJB3_INVOCATION_LOGGER.trace("Using a compressing stream with compression level = " + compressionLevel + " for response data for EJB invocation on method " + invokedMethod);
            }
            return new DataOutputStream(deflaterOutputStream);
        }
        return new DataOutputStream((OutputStream)messageOutputStream);
    }
}

